/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.slideshow;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JWindow;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.renderer.StaticRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class Main
extends JComponent {
    StaticRenderer renderer;
    UserAgent userAgent;
    DocumentLoader loader;
    BridgeContext ctx;
    BufferedImage image;
    BufferedImage display;
    File[] files;
    static int duration = 3000;
    static int frameDelay = duration + 7000;
    volatile boolean done = false;
    volatile Thread transitionThread = null;
    long startLastTransition = 0L;
    volatile boolean paused = false;

    public Main(File[] files, Dimension size) {
        this.setBackground(Color.black);
        this.files = files;
        UserAgentAdapter ua = new UserAgentAdapter();
        this.renderer = new StaticRenderer();
        this.userAgent = ua;
        this.loader = new DocumentLoader(this.userAgent);
        this.ctx = new BridgeContext(this.userAgent, this.loader);
        ua.setBridgeContext(this.ctx);
        if (size == null) {
            size = Toolkit.getDefaultToolkit().getScreenSize();
        }
        this.setPreferredSize(size);
        this.setDoubleBuffered(false);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                if (Main.this.done) {
                    System.exit(0);
                } else {
                    Main.this.togglePause();
                }
            }
        });
        size.width += 2;
        size.height += 2;
        this.display = new BufferedImage(size.width, size.height, 4);
        RenderThread t = new RenderThread();
        t.start();
        JWindow w = new JWindow();
        ((Component)w).setBackground(Color.black);
        w.getContentPane().setBackground(Color.black);
        w.getContentPane().add(this);
        w.pack();
        ((Component)w).setLocation(new Point(-1, -1));
        ((Component)w).setVisible(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTransition(BufferedImage newImg) {
        Main main = this;
        synchronized (main) {
            while (this.transitionThread != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.transitionThread = new TransitionThread(newImg);
            this.transitionThread.start();
            return;
        }
    }

    public void togglePause() {
        Main main = this;
        synchronized (main) {
            Cursor c;
            boolean bl = this.paused = !this.paused;
            if (this.paused) {
                c = new Cursor(3);
            } else {
                c = new Cursor(0);
                if (this.transitionThread != null) {
                    Thread thread = this.transitionThread;
                    synchronized (thread) {
                        this.transitionThread.notifyAll();
                    }
                }
            }
            this.setCursor(c);
        }
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.display == null) {
            return;
        }
        g2d.drawImage(this.display, null, 0, 0);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public static void readFileList(String file, List fileVec) {
        block14: {
            String line;
            BufferedReader br;
            try {
                br = new BufferedReader(new FileReader(file));
            }
            catch (FileNotFoundException fnfe) {
                System.err.println("Unable to open file-list: " + file);
                return;
            }
            URL flURL = new File(file).toURL();
            while ((line = br.readLine()) != null) {
                void var4_6;
                String str = var4_6;
                int idx = str.indexOf(35);
                if (idx != -1) {
                    str = str.substring(0, idx);
                }
                if ((str = str.trim()).length() == 0) continue;
                try {
                    URL imgURL = new URL(flURL, str);
                    fileVec.add(imgURL.getFile());
                }
                catch (MalformedURLException mue) {
                    System.err.println("Can't make sense of line:\n  " + (String)var4_6);
                }
            }
            Object var9_11 = null;
            try {
                br.close();
            }
            catch (IOException ioe2) {}
            break block14;
            {
                catch (IOException ioe) {
                    System.err.println("Error while reading file-list: " + file);
                    Object var9_12 = null;
                    try {
                        br.close();
                    }
                    catch (IOException ioe2) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                try {
                    br.close();
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static void main(String[] args) {
        ArrayList<String> fileVec = new ArrayList<String>();
        Dimension d = null;
        if (args.length == 0) {
            Main.showUsage();
            return;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-h") || args[i].equals("-help") || args[i].equals("--help")) {
                Main.showUsage();
                return;
            }
            if (args[i].equals("--")) {
                ++i;
                while (i < args.length) {
                    fileVec.add(args[i++]);
                }
                break;
            }
            if (args[i].equals("-fl") || args[i].equals("--file-list")) {
                if (i + 1 == args.length) {
                    System.err.println("Must provide name of file list file after " + args[i]);
                    break;
                }
                Main.readFileList(args[i + 1], fileVec);
                ++i;
            } else if (args[i].equals("-ft") || args[i].equals("--frame-time")) {
                if (i + 1 == args.length) {
                    System.err.println("Must provide time in millis after " + args[i]);
                    break;
                }
                try {
                    frameDelay = Integer.decode(args[i + 1]);
                    ++i;
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Can't parse frame time: " + args[i + 1]);
                }
            } else if (args[i].equals("-tt") || args[i].equals("--transition-time")) {
                if (i + 1 == args.length) {
                    System.err.println("Must provide time in millis after " + args[i]);
                    break;
                }
                try {
                    duration = Integer.decode(args[i + 1]);
                    ++i;
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Can't parse transition time: " + args[i + 1]);
                }
            } else if (args[i].equals("-ws") || args[i].equals("--window-size")) {
                if (i + 1 == args.length) {
                    System.err.println("Must provide window size [w,h] after " + args[i]);
                    break;
                }
                try {
                    int w;
                    int h;
                    int idx = args[i + 1].indexOf(44);
                    if (idx == -1) {
                        w = h = Integer.decode(args[i + 1]).intValue();
                    } else {
                        String wStr = args[i + 1].substring(0, idx);
                        String hStr = args[i + 1].substring(idx + 1);
                        w = Integer.decode(wStr);
                        h = Integer.decode(hStr);
                    }
                    d = new Dimension(w, h);
                    ++i;
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Can't parse window size: " + args[i + 1]);
                }
            } else {
                fileVec.add(args[i]);
            }
            ++i;
        }
        File[] files = new File[fileVec.size()];
        int i2 = 0;
        while (i2 < fileVec.size()) {
            try {
                files[i2] = new File((String)fileVec.get(i2));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++i2;
        }
        new Main(files, d);
    }

    public static void showUsage() {
        System.out.println("Options:\n                                 -- : Remaining args are file names\n                         -fl <file>\n                 --file-list <file> : file contains list of images to\n                                      show one per line\n             -ws <width>[,<height>]\n    -window-size <width>[,<height>] : Set the size of slideshow window\n                                      defaults to full screen\n                          -ft <int>\n                 --frame-time <int> : Amount of time in millisecs to\n                                      show each frame.\n                                      Includes transition time.\n                          -tt <int>\n            --transition-time <int> : Amount of time in millisecs to\n                                      transition between frames.\n                             <file> : SVG file to display");
    }

    class TransitionThread
    extends Thread {
        BufferedImage src;
        int blockw = 75;
        int blockh = 75;

        public TransitionThread(BufferedImage bi) {
            super("TransitionThread");
            this.setDaemon(true);
            this.src = bi;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            int xblocks = (Main.this.display.getWidth() + this.blockw - 1) / this.blockw;
            int yblocks = (Main.this.display.getHeight() + this.blockh - 1) / this.blockh;
            int nblocks = xblocks * yblocks;
            int tblock = duration / nblocks;
            Point[] rects = new Point[nblocks];
            int y = 0;
            while (y < yblocks) {
                int x = 0;
                while (x < xblocks) {
                    rects[y * xblocks + x] = new Point(x, y);
                    ++x;
                }
                ++y;
            }
            Graphics2D g2d = Main.this.display.createGraphics();
            g2d.setColor(Color.black);
            long currTrans = System.currentTimeMillis();
            while (currTrans - Main.this.startLastTransition < (long)frameDelay) {
                try {
                    long stime = (long)frameDelay - (currTrans - Main.this.startLastTransition);
                    if (stime > 500L) {
                        System.gc();
                        currTrans = System.currentTimeMillis();
                        stime = (long)frameDelay - (currTrans - Main.this.startLastTransition);
                    }
                    if (stime > 0L) {
                        Thread.sleep(stime);
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                currTrans = System.currentTimeMillis();
            }
            TransitionThread transitionThread = this;
            synchronized (transitionThread) {
                while (Main.this.paused) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
            long last = Main.this.startLastTransition = System.currentTimeMillis();
            int i = 0;
            while (i < rects.length) {
                int idx = (int)(Math.random() * (double)(rects.length - i));
                Point pt = rects[idx];
                System.arraycopy(rects, idx + 1, rects, idx + 1 - 1, rects.length - i - idx - 1);
                int x = pt.x * this.blockw;
                int y2 = pt.y * this.blockh;
                int w = this.blockw;
                int h = this.blockh;
                if (x + w > this.src.getWidth()) {
                    w = this.src.getWidth() - x;
                }
                if (y2 + h > this.src.getHeight()) {
                    h = this.src.getHeight() - y2;
                }
                BufferedImage bufferedImage = Main.this.display;
                synchronized (bufferedImage) {
                    g2d.fillRect(x, y2, w, h);
                    BufferedImage sub = this.src.getSubimage(x, y2, w, h);
                    g2d.drawImage(sub, null, x, y2);
                }
                Main.this.repaint(x, y2, w, h);
                long current = System.currentTimeMillis();
                try {
                    long dt = current - last;
                    if (dt < (long)tblock) {
                        Thread.sleep((long)tblock - dt);
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                last = current;
                ++i;
            }
            Main main = Main.this;
            synchronized (main) {
                Main.this.transitionThread = null;
                Main.this.notifyAll();
                return;
            }
        }
    }

    class RenderThread
    extends Thread {
        RenderThread() {
            super("RenderThread");
            this.setDaemon(true);
        }

        public void run() {
            Main.this.renderer.setDoubleBuffered(true);
            int i = 0;
            while (i < Main.this.files.length) {
                GraphicsNode gvtRoot = null;
                GVTBuilder builder = new GVTBuilder();
                try {
                    String fileName = Main.this.files[i].toURL().toString();
                    System.out.println("Reading: " + fileName);
                    Document svgDoc = Main.this.loader.loadDocument(fileName);
                    System.out.println("Building: " + fileName);
                    gvtRoot = builder.build(Main.this.ctx, svgDoc);
                    System.out.println("Rendering: " + fileName);
                    Main.this.renderer.setTree(gvtRoot);
                    SVGSVGElement elt = ((SVGDocument)svgDoc).getRootElement();
                    Main.this.renderer.setTransform(ViewBox.getViewTransform(null, elt, Main.this.display.getWidth(), Main.this.display.getHeight(), Main.this.ctx));
                    Main.this.renderer.updateOffScreen(Main.this.display.getWidth(), Main.this.display.getHeight());
                    Rectangle r = new Rectangle(0, 0, Main.this.display.getWidth(), Main.this.display.getHeight());
                    Main.this.renderer.repaint(r);
                    System.out.println("Painting: " + fileName);
                    Main.this.image = Main.this.renderer.getOffScreen();
                    Main.this.setTransition(Main.this.image);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ++i;
            }
            if (Main.this.transitionThread != null) {
                try {
                    Main.this.transitionThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Main.this.done = true;
                Main.this.setCursor(new Cursor(3));
            }
        }
    }
}

