/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.bootstrap.BootstrapCacheLoaderFactory;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.config.FactoryConfiguration;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.CacheManagerPeerListenerFactory;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CacheManagerPeerProviderFactory;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerFactory;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.event.CacheManagerEventListenerFactory;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.exceptionhandler.CacheExceptionHandler;
import net.sf.ehcache.exceptionhandler.CacheExceptionHandlerFactory;
import net.sf.ehcache.exceptionhandler.ExceptionHandlingDynamicCacheProxy;
import net.sf.ehcache.extension.CacheExtension;
import net.sf.ehcache.extension.CacheExtensionFactory;
import net.sf.ehcache.loader.CacheLoader;
import net.sf.ehcache.loader.CacheLoaderFactory;
import net.sf.ehcache.util.ClassLoaderUtil;
import net.sf.ehcache.util.PropertyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConfigurationHelper {
    private static final Log LOG = LogFactory.getLog((class$net$sf$ehcache$config$ConfigurationHelper == null ? (class$net$sf$ehcache$config$ConfigurationHelper = ConfigurationHelper.class$("net.sf.ehcache.config.ConfigurationHelper")) : class$net$sf$ehcache$config$ConfigurationHelper).getName());
    private Configuration configuration;
    private CacheManager cacheManager;
    static /* synthetic */ Class class$net$sf$ehcache$config$ConfigurationHelper;

    public ConfigurationHelper(CacheManager cacheManager, Configuration configuration) {
        if (cacheManager == null || configuration == null) {
            throw new IllegalArgumentException("Cannot have null parameters");
        }
        this.cacheManager = cacheManager;
        this.configuration = configuration;
    }

    protected static void registerCacheListeners(CacheConfiguration cacheConfiguration, RegisteredEventListeners registeredEventListeners) {
        List cacheEventListenerConfigurations = cacheConfiguration.getCacheEventListenerConfigurations();
        for (int i = 0; i < cacheEventListenerConfigurations.size(); ++i) {
            CacheConfiguration.CacheEventListenerFactoryConfiguration factoryConfiguration = (CacheConfiguration.CacheEventListenerFactoryConfiguration)cacheEventListenerConfigurations.get(i);
            CacheEventListener cacheEventListener = ConfigurationHelper.createCacheEventListener(factoryConfiguration);
            registeredEventListeners.registerListener(cacheEventListener);
        }
    }

    protected static void registerCacheExtensions(CacheConfiguration cacheConfiguration, Ehcache cache) {
        List cacheExtensionConfigurations = cacheConfiguration.getCacheExtensionConfigurations();
        for (int i = 0; i < cacheExtensionConfigurations.size(); ++i) {
            CacheConfiguration.CacheExtensionFactoryConfiguration factoryConfiguration = (CacheConfiguration.CacheExtensionFactoryConfiguration)cacheExtensionConfigurations.get(i);
            CacheExtension cacheExtension = ConfigurationHelper.createCacheExtension(factoryConfiguration, cache);
            cache.registerCacheExtension(cacheExtension);
        }
    }

    private static CacheEventListener createCacheEventListener(CacheConfiguration.CacheEventListenerFactoryConfiguration factoryConfiguration) {
        String className = null;
        CacheEventListener cacheEventListener = null;
        if (factoryConfiguration != null) {
            className = factoryConfiguration.getFullyQualifiedClassPath();
        }
        if (className == null) {
            LOG.debug("CacheEventListener factory not configured. Skipping...");
        } else {
            CacheEventListenerFactory factory = (CacheEventListenerFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
            cacheEventListener = factory.createCacheEventListener(properties);
        }
        return cacheEventListener;
    }

    private static CacheExtension createCacheExtension(CacheConfiguration.CacheExtensionFactoryConfiguration factoryConfiguration, Ehcache cache) {
        String className = null;
        CacheExtension cacheExtension = null;
        if (factoryConfiguration != null) {
            className = factoryConfiguration.getFullyQualifiedClassPath();
        }
        if (className == null) {
            LOG.debug("CacheExtension factory not configured. Skipping...");
        } else {
            CacheExtensionFactory factory = (CacheExtensionFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
            cacheExtension = factory.createCacheExtension(cache, properties);
        }
        return cacheExtension;
    }

    public final BootstrapCacheLoader createBootstrapCacheLoader(CacheConfiguration.BootstrapCacheLoaderFactoryConfiguration factoryConfiguration) throws CacheException {
        String className = null;
        BootstrapCacheLoader bootstrapCacheLoader = null;
        if (factoryConfiguration != null) {
            className = factoryConfiguration.getFullyQualifiedClassPath();
        }
        if (className != null && className.length() != 0) {
            BootstrapCacheLoaderFactory factory = (BootstrapCacheLoaderFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
            return factory.createBootstrapCacheLoader(properties);
        }
        LOG.debug("No BootstrapCacheLoaderFactory class specified. Skipping...");
        return bootstrapCacheLoader;
    }

    public final CacheLoader createCacheLoader(CacheConfiguration.CacheLoaderFactoryConfiguration factoryConfiguration) throws CacheException {
        String className = null;
        CacheLoader cacheLoader = null;
        if (factoryConfiguration != null) {
            className = factoryConfiguration.getFullyQualifiedClassPath();
        }
        if (className != null && className.length() != 0) {
            CacheLoaderFactory factory = (CacheLoaderFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
            return factory.createCacheLoader(properties);
        }
        LOG.debug("No CacheLoaderFactory class specified. Skipping...");
        return cacheLoader;
    }

    public final CacheExceptionHandler createCacheExceptionHandler(CacheConfiguration.CacheExceptionHandlerFactoryConfiguration factoryConfiguration) throws CacheException {
        String className = null;
        CacheExceptionHandler cacheExceptionHandler = null;
        if (factoryConfiguration != null) {
            className = factoryConfiguration.getFullyQualifiedClassPath();
        }
        if (className != null && className.length() != 0) {
            CacheExceptionHandlerFactory factory = (CacheExceptionHandlerFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
            return factory.createExceptionHandler(properties);
        }
        LOG.debug("No CacheExceptionHandlerFactory class specified. Skipping...");
        return cacheExceptionHandler;
    }

    public final CacheManagerPeerProvider createCachePeerProvider() {
        String className = null;
        FactoryConfiguration cachePeerProviderFactoryConfiguration = this.configuration.getCacheManagerPeerProviderFactoryConfiguration();
        if (cachePeerProviderFactoryConfiguration != null) {
            className = cachePeerProviderFactoryConfiguration.getFullyQualifiedClassPath();
        }
        if (className == null) {
            LOG.debug("No CachePeerProviderFactoryConfiguration specified. Not configuring a CacheManagerPeerProvider.");
            return null;
        }
        CacheManagerPeerProviderFactory cacheManagerPeerProviderFactory = (CacheManagerPeerProviderFactory)ClassLoaderUtil.createNewInstance(className);
        Properties properties = PropertyUtil.parseProperties(cachePeerProviderFactoryConfiguration.getProperties(), cachePeerProviderFactoryConfiguration.getPropertySeparator());
        return cacheManagerPeerProviderFactory.createCachePeerProvider(this.cacheManager, properties);
    }

    public final CacheManagerPeerListener createCachePeerListener() {
        String className = null;
        FactoryConfiguration cachePeerListenerFactoryConfiguration = this.configuration.getCacheManagerPeerListenerFactoryConfiguration();
        if (cachePeerListenerFactoryConfiguration != null) {
            className = cachePeerListenerFactoryConfiguration.getFullyQualifiedClassPath();
        }
        if (className == null) {
            LOG.debug("No CachePeerListenerFactoryConfiguration specified. Not configuring a CacheManagerPeerListener.");
            return null;
        }
        CacheManagerPeerListenerFactory cacheManagerPeerListenerFactory = (CacheManagerPeerListenerFactory)ClassLoaderUtil.createNewInstance(className);
        Properties properties = PropertyUtil.parseProperties(cachePeerListenerFactoryConfiguration.getProperties(), cachePeerListenerFactoryConfiguration.getPropertySeparator());
        return cacheManagerPeerListenerFactory.createCachePeerListener(this.cacheManager, properties);
    }

    public final CacheManagerEventListener createCacheManagerEventListener() throws CacheException {
        String className = null;
        FactoryConfiguration cacheManagerEventListenerFactoryConfiguration = this.configuration.getCacheManagerEventListenerFactoryConfiguration();
        if (cacheManagerEventListenerFactoryConfiguration != null) {
            className = cacheManagerEventListenerFactoryConfiguration.getFullyQualifiedClassPath();
        }
        if (className == null || className.length() == 0) {
            LOG.debug("No CacheManagerEventListenerFactory class specified. Skipping...");
            return null;
        }
        CacheManagerEventListenerFactory factory = (CacheManagerEventListenerFactory)ClassLoaderUtil.createNewInstance(className);
        Properties properties = PropertyUtil.parseProperties(cacheManagerEventListenerFactoryConfiguration.properties, cacheManagerEventListenerFactoryConfiguration.getPropertySeparator());
        return factory.createCacheManagerEventListener(properties);
    }

    public final String getDiskStorePath() {
        DiskStoreConfiguration diskStoreConfiguration = this.configuration.getDiskStoreConfiguration();
        if (diskStoreConfiguration == null) {
            return null;
        }
        return diskStoreConfiguration.getPath();
    }

    public final Ehcache createDefaultCache() throws CacheException {
        CacheConfiguration cacheConfiguration = this.configuration.getDefaultCacheConfiguration();
        if (cacheConfiguration == null) {
            throw new CacheException("Illegal configuration. No default cache is configured.");
        }
        cacheConfiguration.name = "default";
        return this.createCache(cacheConfiguration);
    }

    public final Set createCaches() {
        HashSet<Ehcache> caches = new HashSet<Ehcache>();
        Set cacheConfigurations = this.configuration.getCacheConfigurations().entrySet();
        Iterator iterator = cacheConfigurations.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            CacheConfiguration cacheConfiguration = (CacheConfiguration)entry.getValue();
            Ehcache cache = this.createCache(cacheConfiguration);
            caches.add(cache);
        }
        return caches;
    }

    public final Integer numberOfCachesThatOverflowToDisk() {
        int count = 0;
        Set cacheConfigurations = this.configuration.getCacheConfigurations().entrySet();
        Iterator iterator = cacheConfigurations.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            CacheConfiguration cacheConfiguration = (CacheConfiguration)entry.getValue();
            if (!cacheConfiguration.overflowToDisk) continue;
            ++count;
        }
        return new Integer(count);
    }

    public final Integer numberOfCachesThatAreDiskPersistent() {
        int count = 0;
        Set cacheConfigurations = this.configuration.getCacheConfigurations().entrySet();
        Iterator iterator = cacheConfigurations.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            CacheConfiguration cacheConfiguration = (CacheConfiguration)entry.getValue();
            if (!cacheConfiguration.isDiskPersistent()) continue;
            ++count;
        }
        return new Integer(count);
    }

    final Ehcache createCacheFromName(String name) {
        CacheConfiguration cacheConfiguration = null;
        Set cacheConfigurations = this.configuration.getCacheConfigurations().entrySet();
        Iterator iterator = cacheConfigurations.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            CacheConfiguration cacheConfigurationCandidate = (CacheConfiguration)entry.getValue();
            if (!cacheConfigurationCandidate.name.equals(name)) continue;
            cacheConfiguration = cacheConfigurationCandidate;
            break;
        }
        if (cacheConfiguration == null) {
            return null;
        }
        return this.createCache(cacheConfiguration);
    }

    final Ehcache createCache(CacheConfiguration cacheConfiguration) {
        Ehcache cache = new Cache(cacheConfiguration.name, cacheConfiguration.maxElementsInMemory, cacheConfiguration.memoryStoreEvictionPolicy, cacheConfiguration.overflowToDisk, this.getDiskStorePath(), cacheConfiguration.eternal, cacheConfiguration.timeToLiveSeconds, cacheConfiguration.timeToIdleSeconds, cacheConfiguration.diskPersistent, cacheConfiguration.diskExpiryThreadIntervalSeconds, null, null, cacheConfiguration.maxElementsOnDisk, cacheConfiguration.diskSpoolBufferSizeMB);
        RegisteredEventListeners listeners = cache.getCacheEventNotificationService();
        ConfigurationHelper.registerCacheListeners(cacheConfiguration, listeners);
        ConfigurationHelper.registerCacheExtensions(cacheConfiguration, cache);
        BootstrapCacheLoader bootstrapCacheLoader = this.createBootstrapCacheLoader(cacheConfiguration.getBootstrapCacheLoaderFactoryConfiguration());
        cache.setBootstrapCacheLoader(bootstrapCacheLoader);
        CacheLoader cacheLoader = this.createCacheLoader(cacheConfiguration.getCacheLoaderFactoryConfiguration());
        cache.setCacheLoader(cacheLoader);
        cache = this.applyCacheExceptionHandler(cacheConfiguration, cache);
        return cache;
    }

    private Ehcache applyCacheExceptionHandler(CacheConfiguration cacheConfiguration, Ehcache cache) {
        CacheExceptionHandler cacheExceptionHandler = this.createCacheExceptionHandler(cacheConfiguration.getCacheExceptionHandlerFactoryConfiguration());
        cache.setCacheExceptionHandler(cacheExceptionHandler);
        if (cache.getCacheExceptionHandler() != null) {
            return ExceptionHandlingDynamicCacheProxy.createProxy(cache);
        }
        return cache;
    }

    public final Configuration getConfigurationBean() {
        return this.configuration;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

