/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.blocking;

import java.util.Iterator;
import java.util.List;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.BlockingCache;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.LockTimeoutException;
import net.sf.ehcache.constructs.blocking.UpdatingCacheEntryFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelfPopulatingCache
extends BlockingCache {
    private static final Log LOG = LogFactory.getLog((class$net$sf$ehcache$constructs$blocking$SelfPopulatingCache == null ? (class$net$sf$ehcache$constructs$blocking$SelfPopulatingCache = SelfPopulatingCache.class$("net.sf.ehcache.constructs.blocking.SelfPopulatingCache")) : class$net$sf$ehcache$constructs$blocking$SelfPopulatingCache).getName());
    protected final CacheEntryFactory factory;
    static /* synthetic */ Class class$net$sf$ehcache$constructs$blocking$SelfPopulatingCache;

    public SelfPopulatingCache(Ehcache cache, CacheEntryFactory factory) throws CacheException {
        super(cache);
        this.factory = factory;
    }

    public Element get(Object key) throws LockTimeoutException {
        try {
            Element element = super.get(key);
            if (element == null) {
                Object value = this.factory.createEntry(key);
                element = new Element(key, value);
                this.put(element);
            }
            return element;
        }
        catch (LockTimeoutException e) {
            String message = "Timeout after " + this.timeoutMillis + " waiting on another thread " + "to fetch object for cache entry \"" + key + "\".";
            try {
                throw new LockTimeoutException(message, e);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                throw new LockTimeoutException(message);
            }
        }
        catch (Throwable throwable) {
            this.put(new Element(key, null));
            try {
                throw new CacheException("Could not fetch object for cache entry with key \"" + key + "\".", throwable);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                throw new CacheException("Could not fetch object for cache entry with key \"" + key + "\".");
            }
        }
    }

    public void refresh() throws CacheException {
        Throwable exception = null;
        Object keyWithException = null;
        List keys = this.getKeys();
        if (LOG.isTraceEnabled()) {
            LOG.trace(this.getName() + ": found " + keys.size() + " keys to refresh");
        }
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            try {
                Ehcache backingCache = this.getCache();
                Element element = backingCache.getQuiet(key);
                if (element == null) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace(this.getName() + ": entry with key " + key + " has been removed - skipping it");
                    continue;
                }
                this.refreshElement(element, backingCache);
            }
            catch (Exception e) {
                LOG.warn(this.getName() + "Could not refresh element " + key, e);
                exception = e;
            }
        }
        if (exception != null) {
            throw new CacheException(exception.getMessage() + " on refresh with key " + keyWithException);
        }
    }

    protected void refreshElement(Element element, Ehcache backingCache) throws Exception {
        Element replacementElement;
        Object key = element.getObjectKey();
        if (LOG.isTraceEnabled()) {
            LOG.trace(this.getName() + ": refreshing element with key " + key);
        }
        if (this.factory instanceof UpdatingCacheEntryFactory) {
            replacementElement = element;
            ((UpdatingCacheEntryFactory)this.factory).updateEntryValue(key, replacementElement.getValue());
        } else {
            Object value = this.factory.createEntry(key);
            replacementElement = new Element(key, value);
        }
        backingCache.putQuiet(replacementElement);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

