/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.PayloadUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MulticastKeepaliveHeartbeatSender {
    private static final Log LOG = LogFactory.getLog((class$net$sf$ehcache$distribution$MulticastKeepaliveHeartbeatSender == null ? (class$net$sf$ehcache$distribution$MulticastKeepaliveHeartbeatSender = MulticastKeepaliveHeartbeatSender.class$("net.sf.ehcache.distribution.MulticastKeepaliveHeartbeatSender")) : class$net$sf$ehcache$distribution$MulticastKeepaliveHeartbeatSender).getName());
    private static final int DEFAULT_HEARTBEAT_INTERVAL = 5000;
    private static final int MINIMUM_HEARTBEAT_INTERVAL = 1000;
    private static final int MAXIMUM_PEERS_PER_SEND = 150;
    private static long heartBeatInterval = 5000L;
    private final InetAddress groupMulticastAddress;
    private final Integer groupMulticastPort;
    private final Integer timeToLive;
    private MulticastServerThread serverThread;
    private boolean stopped;
    private final CacheManager cacheManager;
    static /* synthetic */ Class class$net$sf$ehcache$distribution$MulticastKeepaliveHeartbeatSender;

    public MulticastKeepaliveHeartbeatSender(CacheManager cacheManager, InetAddress multicastAddress, Integer multicastPort, Integer timeToLive) {
        this.cacheManager = cacheManager;
        this.groupMulticastAddress = multicastAddress;
        this.groupMulticastPort = multicastPort;
        this.timeToLive = timeToLive;
    }

    public final void init() {
        this.serverThread = new MulticastServerThread();
        this.serverThread.start();
    }

    public final synchronized void dispose() {
        this.stopped = true;
        this.notifyAll();
        this.serverThread.interrupt();
    }

    public static void setHeartBeatInterval(long heartBeatInterval) {
        if (heartBeatInterval < 1000L) {
            LOG.warn("Trying to set heartbeat interval too low. Using MINIMUM_HEARTBEAT_INTERVAL instead.");
            MulticastKeepaliveHeartbeatSender.heartBeatInterval = 1000L;
        } else {
            MulticastKeepaliveHeartbeatSender.heartBeatInterval = heartBeatInterval;
        }
    }

    public static long getHeartBeatInterval() {
        return heartBeatInterval;
    }

    public Integer getTimeToLive() {
        return this.timeToLive;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class MulticastServerThread
    extends Thread {
        private MulticastSocket socket;
        private List compressedUrlListList = new ArrayList();
        private int cachePeersHash;

        public MulticastServerThread() {
            super("Multicast Heartbeat Sender Thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            while (!MulticastKeepaliveHeartbeatSender.this.stopped) {
                try {
                    this.socket = new MulticastSocket(MulticastKeepaliveHeartbeatSender.this.groupMulticastPort);
                    this.socket.setTimeToLive(MulticastKeepaliveHeartbeatSender.this.timeToLive);
                    this.socket.joinGroup(MulticastKeepaliveHeartbeatSender.this.groupMulticastAddress);
                    while (!MulticastKeepaliveHeartbeatSender.this.stopped) {
                        List buffers = this.createCachePeersPayload();
                        Object iter = buffers.iterator();
                        while (iter.hasNext()) {
                            byte[] buffer = (byte[])iter.next();
                            DatagramPacket packet = new DatagramPacket(buffer, buffer.length, MulticastKeepaliveHeartbeatSender.this.groupMulticastAddress, MulticastKeepaliveHeartbeatSender.this.groupMulticastPort);
                            this.socket.send(packet);
                        }
                        try {
                            iter = this;
                            synchronized (iter) {
                                this.wait(heartBeatInterval);
                            }
                        }
                        catch (InterruptedException e) {
                            if (MulticastKeepaliveHeartbeatSender.this.stopped) continue;
                            LOG.error("Error receiving heartbeat. Initial cause was " + e.getMessage(), e);
                        }
                    }
                }
                catch (IOException e) {
                    LOG.debug("Error on multicast socket", e);
                }
                catch (Throwable e) {
                    LOG.info("Unexpected throwable in run thread. Continuing..." + e.getMessage(), e);
                }
                finally {
                    this.closeSocket();
                }
                if (MulticastKeepaliveHeartbeatSender.this.stopped) continue;
                try {
                    Thread.sleep(heartBeatInterval);
                }
                catch (InterruptedException e) {
                    LOG.error("Sleep after error interrupted. Initial cause was " + e.getMessage(), e);
                }
            }
        }

        private List createCachePeersPayload() {
            List localCachePeers = MulticastKeepaliveHeartbeatSender.this.cacheManager.getCachePeerListener().getBoundCachePeers();
            int newCachePeersHash = ((Object)localCachePeers).hashCode();
            if (this.cachePeersHash != newCachePeersHash) {
                this.cachePeersHash = newCachePeersHash;
                this.compressedUrlListList = new ArrayList();
                while (localCachePeers.size() > 0) {
                    int endIndex = Math.min(localCachePeers.size(), 150);
                    List localCachePeersSubList = localCachePeers.subList(0, endIndex);
                    localCachePeers = localCachePeers.subList(endIndex, localCachePeers.size());
                    byte[] uncompressedUrlList = PayloadUtil.assembleUrlList(localCachePeersSubList);
                    byte[] compressedUrlList = PayloadUtil.gzip(uncompressedUrlList);
                    if (compressedUrlList.length > 1500) {
                        LOG.fatal("Heartbeat is not working. Configure fewer caches for replication. Size is " + compressedUrlList.length + " but should be no greater than" + 1500);
                    }
                    this.compressedUrlListList.add(compressedUrlList);
                }
            }
            return this.compressedUrlListList;
        }

        public final void interrupt() {
            this.closeSocket();
            super.interrupt();
        }

        private void closeSocket() {
            block6: {
                try {
                    if (this.socket == null || this.socket.isClosed()) break block6;
                    try {
                        this.socket.leaveGroup(MulticastKeepaliveHeartbeatSender.this.groupMulticastAddress);
                    }
                    catch (IOException e) {
                        LOG.error("Error leaving multicast group. Message was " + e.getMessage());
                    }
                    this.socket.close();
                }
                catch (NoSuchMethodError e) {
                    LOG.debug("socket.isClosed is not supported by JDK1.3");
                    try {
                        this.socket.leaveGroup(MulticastKeepaliveHeartbeatSender.this.groupMulticastAddress);
                    }
                    catch (IOException ex) {
                        LOG.error("Error leaving multicast group. Message was " + ex.getMessage());
                    }
                    this.socket.close();
                }
            }
        }
    }
}

