/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Iterator;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.HibernateIterator;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.NonContextualLobCreator;
import org.hibernate.engine.jdbc.StreamUtils;
import org.hibernate.intercept.FieldInterceptionHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.AnyType;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.BigIntegerType;
import org.hibernate.type.BinaryType;
import org.hibernate.type.BlobType;
import org.hibernate.type.BooleanType;
import org.hibernate.type.ByteType;
import org.hibernate.type.CalendarDateType;
import org.hibernate.type.CalendarType;
import org.hibernate.type.CharArrayType;
import org.hibernate.type.CharacterArrayType;
import org.hibernate.type.CharacterType;
import org.hibernate.type.ClassType;
import org.hibernate.type.ClobType;
import org.hibernate.type.CurrencyType;
import org.hibernate.type.DateType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.FloatType;
import org.hibernate.type.ImageType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LocaleType;
import org.hibernate.type.LongType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.MaterializedBlobType;
import org.hibernate.type.MaterializedClobType;
import org.hibernate.type.ObjectType;
import org.hibernate.type.SerializableType;
import org.hibernate.type.ShortType;
import org.hibernate.type.StringType;
import org.hibernate.type.TextType;
import org.hibernate.type.TimeType;
import org.hibernate.type.TimeZoneType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.TrueFalseType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.type.WrapperBinaryType;
import org.hibernate.type.YesNoType;
import org.hibernate.usertype.CompositeUserType;

public final class Hibernate {
    public static final BooleanType BOOLEAN = BooleanType.INSTANCE;
    public static final TrueFalseType TRUE_FALSE = TrueFalseType.INSTANCE;
    public static final YesNoType YES_NO = YesNoType.INSTANCE;
    public static final ByteType BYTE = ByteType.INSTANCE;
    public static final ShortType SHORT = ShortType.INSTANCE;
    public static final IntegerType INTEGER = IntegerType.INSTANCE;
    public static final LongType LONG = LongType.INSTANCE;
    public static final FloatType FLOAT = FloatType.INSTANCE;
    public static final DoubleType DOUBLE = DoubleType.INSTANCE;
    public static final BigIntegerType BIG_INTEGER = BigIntegerType.INSTANCE;
    public static final BigDecimalType BIG_DECIMAL = BigDecimalType.INSTANCE;
    public static final CharacterType CHARACTER = CharacterType.INSTANCE;
    public static final StringType STRING = StringType.INSTANCE;
    public static final TimeType TIME = TimeType.INSTANCE;
    public static final DateType DATE = DateType.INSTANCE;
    public static final TimestampType TIMESTAMP = TimestampType.INSTANCE;
    public static final BinaryType BINARY = BinaryType.INSTANCE;
    public static final WrapperBinaryType WRAPPER_BINARY = WrapperBinaryType.INSTANCE;
    public static final CharArrayType CHAR_ARRAY = CharArrayType.INSTANCE;
    public static final CharacterArrayType CHARACTER_ARRAY = CharacterArrayType.INSTANCE;
    public static final ImageType IMAGE = ImageType.INSTANCE;
    public static final TextType TEXT = TextType.INSTANCE;
    public static final MaterializedBlobType MATERIALIZED_BLOB = MaterializedBlobType.INSTANCE;
    public static final MaterializedClobType MATERIALIZED_CLOB = MaterializedClobType.INSTANCE;
    public static final BlobType BLOB = BlobType.INSTANCE;
    public static final ClobType CLOB = ClobType.INSTANCE;
    public static final CalendarType CALENDAR = CalendarType.INSTANCE;
    public static final CalendarDateType CALENDAR_DATE = CalendarDateType.INSTANCE;
    public static final LocaleType LOCALE = LocaleType.INSTANCE;
    public static final CurrencyType CURRENCY = CurrencyType.INSTANCE;
    public static final TimeZoneType TIMEZONE = TimeZoneType.INSTANCE;
    public static final ClassType CLASS = ClassType.INSTANCE;
    public static final SerializableType SERIALIZABLE = SerializableType.INSTANCE;
    public static final ObjectType OBJECT = ObjectType.INSTANCE;

    private Hibernate() {
        throw new UnsupportedOperationException();
    }

    public static Type serializable(Class clazz) {
        return new SerializableType(clazz);
    }

    public static Type any(Type type, Type type2) {
        return new AnyType(type, type2);
    }

    public static Type entity(Class clazz) {
        return Hibernate.entity(clazz.getName());
    }

    public static Type entity(String string) {
        return new ManyToOneType(NoScope.INSTANCE, string);
    }

    public static Type custom(Class clazz) {
        return Hibernate.custom(clazz, null);
    }

    public static Type custom(Class clazz, String[] stringArray, String[] stringArray2) {
        return Hibernate.custom(clazz, Hibernate.toProperties(stringArray, stringArray2));
    }

    private static Properties toProperties(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            properties.put(stringArray[i], stringArray2[i]);
        }
        return properties;
    }

    public static Type custom(Class clazz, Properties properties) {
        if (CompositeUserType.class.isAssignableFrom(clazz)) {
            return TypeFactory.customComponent(clazz, properties, NoScope.INSTANCE);
        }
        return TypeFactory.custom(clazz, properties, NoScope.INSTANCE);
    }

    public static void initialize(Object object) throws HibernateException {
        if (object == null) {
            return;
        }
        if (object instanceof HibernateProxy) {
            ((HibernateProxy)object).getHibernateLazyInitializer().initialize();
        } else if (object instanceof PersistentCollection) {
            ((PersistentCollection)object).forceInitialization();
        }
    }

    public static boolean isInitialized(Object object) {
        if (object instanceof HibernateProxy) {
            return !((HibernateProxy)object).getHibernateLazyInitializer().isUninitialized();
        }
        if (object instanceof PersistentCollection) {
            return ((PersistentCollection)object).wasInitialized();
        }
        return true;
    }

    public static Class getClass(Object object) {
        if (object instanceof HibernateProxy) {
            return ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation().getClass();
        }
        return object.getClass();
    }

    public static Blob createBlob(byte[] byArray) {
        return NonContextualLobCreator.INSTANCE.wrap(NonContextualLobCreator.INSTANCE.createBlob(byArray));
    }

    public static Blob createBlob(byte[] byArray, Session session) {
        return Hibernate.getLobCreator(session).createBlob(byArray);
    }

    public static LobCreator getLobCreator(Session session) {
        return Hibernate.getLobCreator((SessionImplementor)((Object)session));
    }

    public static LobCreator getLobCreator(SessionImplementor sessionImplementor) {
        return sessionImplementor.getFactory().getSettings().getJdbcSupport().getLobCreator((LobCreationContext)((Object)sessionImplementor));
    }

    @Deprecated
    public static Blob createBlob(InputStream inputStream, int n) {
        return NonContextualLobCreator.INSTANCE.wrap(NonContextualLobCreator.INSTANCE.createBlob(inputStream, n));
    }

    @Deprecated
    public static Blob createBlob(InputStream inputStream, long l) {
        return NonContextualLobCreator.INSTANCE.wrap(NonContextualLobCreator.INSTANCE.createBlob(inputStream, l));
    }

    @Deprecated
    public static Blob createBlob(InputStream inputStream, long l, Session session) {
        return Hibernate.getLobCreator(session).createBlob(inputStream, l);
    }

    @Deprecated
    public static Blob createBlob(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(inputStream.available());
        StreamUtils.copy(inputStream, byteArrayOutputStream);
        return Hibernate.createBlob(byteArrayOutputStream.toByteArray());
    }

    @Deprecated
    public static Clob createClob(String string) {
        return NonContextualLobCreator.INSTANCE.wrap(NonContextualLobCreator.INSTANCE.createClob(string));
    }

    @Deprecated
    public static Clob createClob(String string, Session session) {
        return Hibernate.getLobCreator(session).createClob(string);
    }

    @Deprecated
    public static Clob createClob(Reader reader, int n) {
        return NonContextualLobCreator.INSTANCE.wrap(NonContextualLobCreator.INSTANCE.createClob(reader, n));
    }

    @Deprecated
    public static Clob createClob(Reader reader, long l) {
        return NonContextualLobCreator.INSTANCE.wrap(NonContextualLobCreator.INSTANCE.createClob(reader, l));
    }

    @Deprecated
    public static Clob createClob(Reader reader, long l, Session session) {
        return Hibernate.getLobCreator(session).createClob(reader, l);
    }

    public static void close(Iterator iterator) throws HibernateException {
        if (!(iterator instanceof HibernateIterator)) {
            throw new IllegalArgumentException("not a Hibernate iterator");
        }
        ((HibernateIterator)iterator).close();
    }

    public static boolean isPropertyInitialized(Object object, String string) {
        Object object2;
        Object object3;
        if (object instanceof HibernateProxy) {
            object3 = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (object3.isUninitialized()) {
                return false;
            }
            object2 = object3.getImplementation();
        } else {
            object2 = object;
        }
        if (FieldInterceptionHelper.isInstrumented(object2)) {
            object3 = FieldInterceptionHelper.extractFieldInterceptor(object2);
            return object3 == null || object3.isInitialized(string);
        }
        return true;
    }

    private static class NoScope
    implements TypeFactory.TypeScope {
        public static final NoScope INSTANCE = new NoScope();

        private NoScope() {
        }

        public SessionFactoryImplementor resolveFactory() {
            throw new HibernateException("Cannot access SessionFactory from here");
        }
    }
}

