/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.LockMode;

public class LockOptions
implements Serializable {
    public static final LockOptions NONE = new LockOptions(LockMode.NONE);
    public static final LockOptions READ = new LockOptions(LockMode.READ);
    public static final LockOptions UPGRADE = new LockOptions(LockMode.UPGRADE);
    private LockMode lockMode = LockMode.NONE;
    private Map aliasSpecificLockModes = new HashMap();
    public static final int NO_WAIT = 0;
    public static final int WAIT_FOREVER = -1;
    private int timeout = -1;
    private boolean scope = false;

    public LockOptions() {
    }

    public LockOptions(LockMode lockMode) {
        this.lockMode = lockMode;
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public LockOptions setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
        return this;
    }

    public LockOptions setAliasSpecificLockMode(String string, LockMode lockMode) {
        this.aliasSpecificLockModes.put(string, lockMode);
        return this;
    }

    public LockMode getAliasSpecificLockMode(String string) {
        return (LockMode)this.aliasSpecificLockModes.get(string);
    }

    public LockMode getEffectiveLockMode(String string) {
        LockMode lockMode = this.getAliasSpecificLockMode(string);
        if (lockMode == null) {
            lockMode = this.lockMode;
        }
        return lockMode == null ? LockMode.NONE : lockMode;
    }

    public int getAliasLockCount() {
        return this.aliasSpecificLockModes.size();
    }

    public Iterator getAliasLockIterator() {
        return this.aliasSpecificLockModes.entrySet().iterator();
    }

    public int getTimeOut() {
        return this.timeout;
    }

    public LockOptions setTimeOut(int n) {
        this.timeout = n;
        return this;
    }

    public boolean getScope() {
        return this.scope;
    }

    public LockOptions setScope(boolean bl) {
        this.scope = bl;
        return this;
    }

    public static LockOptions copy(LockOptions lockOptions, LockOptions lockOptions2) {
        lockOptions2.setLockMode(lockOptions.getLockMode());
        lockOptions2.setScope(lockOptions.getScope());
        lockOptions2.setTimeOut(lockOptions.getTimeOut());
        lockOptions2.aliasSpecificLockModes = new HashMap(lockOptions.aliasSpecificLockModes);
        return lockOptions2;
    }
}

