/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.action.AfterTransactionCompletionProcess;
import org.hibernate.action.BeforeTransactionCompletionProcess;
import org.hibernate.action.Executable;
import org.hibernate.cache.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.access.EntityRegionAccessStrategy;
import org.hibernate.cache.access.SoftLock;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Queryable;

public class BulkOperationCleanupAction
implements Executable,
Serializable {
    private final Serializable[] affectedTableSpaces;
    private final Set<EntityCleanup> entityCleanups = new HashSet<EntityCleanup>();
    private final Set<CollectionCleanup> collectionCleanups = new HashSet<CollectionCleanup>();

    public BulkOperationCleanupAction(SessionImplementor sessionImplementor, Queryable[] queryableArray) {
        SessionFactoryImplementor sessionFactoryImplementor = sessionImplementor.getFactory();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Queryable queryable : queryableArray) {
            Set<String> set;
            linkedHashSet.addAll(Arrays.asList((String[])queryable.getQuerySpaces()));
            if (queryable.hasCache()) {
                this.entityCleanups.add(new EntityCleanup(queryable.getCacheAccessStrategy()));
            }
            if ((set = sessionFactoryImplementor.getCollectionRolesByEntityParticipant(queryable.getEntityName())) == null) continue;
            for (String string : set) {
                CollectionPersister collectionPersister = sessionFactoryImplementor.getCollectionPersister(string);
                if (!collectionPersister.hasCache()) continue;
                this.collectionCleanups.add(new CollectionCleanup(collectionPersister.getCacheAccessStrategy()));
            }
        }
        this.affectedTableSpaces = (Serializable[])linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    public BulkOperationCleanupAction(SessionImplementor sessionImplementor, Set set) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.addAll(set);
        SessionFactoryImplementor sessionFactoryImplementor = sessionImplementor.getFactory();
        for (String string : sessionFactoryImplementor.getAllClassMetadata().keySet()) {
            Set<String> set2;
            EntityPersister entityPersister = sessionFactoryImplementor.getEntityPersister(string);
            String[] stringArray = (String[])entityPersister.getQuerySpaces();
            if (!this.affectedEntity(set, (Serializable[])stringArray)) continue;
            linkedHashSet.addAll(Arrays.asList(stringArray));
            if (entityPersister.hasCache()) {
                this.entityCleanups.add(new EntityCleanup(entityPersister.getCacheAccessStrategy()));
            }
            if ((set2 = sessionImplementor.getFactory().getCollectionRolesByEntityParticipant(entityPersister.getEntityName())) == null) continue;
            for (String string2 : set2) {
                CollectionPersister collectionPersister = sessionFactoryImplementor.getCollectionPersister(string2);
                if (!collectionPersister.hasCache()) continue;
                this.collectionCleanups.add(new CollectionCleanup(collectionPersister.getCacheAccessStrategy()));
            }
        }
        this.affectedTableSpaces = (Serializable[])linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    private boolean affectedEntity(Set set, Serializable[] serializableArray) {
        if (set == null || set.isEmpty()) {
            return true;
        }
        for (Serializable serializable : serializableArray) {
            if (!set.contains(serializable)) continue;
            return true;
        }
        return false;
    }

    public Serializable[] getPropertySpaces() {
        return this.affectedTableSpaces;
    }

    public BeforeTransactionCompletionProcess getBeforeTransactionCompletionProcess() {
        return null;
    }

    public AfterTransactionCompletionProcess getAfterTransactionCompletionProcess() {
        return new AfterTransactionCompletionProcess(){

            public void doAfterTransactionCompletion(boolean bl, SessionImplementor sessionImplementor) {
                for (Object object : BulkOperationCleanupAction.this.entityCleanups) {
                    ((EntityCleanup)object).release();
                }
                for (Object object : BulkOperationCleanupAction.this.collectionCleanups) {
                    ((CollectionCleanup)object).release();
                }
            }
        };
    }

    public void beforeExecutions() throws HibernateException {
    }

    public void execute() throws HibernateException {
    }

    private static class CollectionCleanup {
        private final CollectionRegionAccessStrategy cacheAccess;
        private final SoftLock cacheLock;

        private CollectionCleanup(CollectionRegionAccessStrategy collectionRegionAccessStrategy) {
            this.cacheAccess = collectionRegionAccessStrategy;
            this.cacheLock = collectionRegionAccessStrategy.lockRegion();
            collectionRegionAccessStrategy.removeAll();
        }

        private void release() {
            this.cacheAccess.unlockRegion(this.cacheLock);
        }
    }

    private static class EntityCleanup {
        private final EntityRegionAccessStrategy cacheAccess;
        private final SoftLock cacheLock;

        private EntityCleanup(EntityRegionAccessStrategy entityRegionAccessStrategy) {
            this.cacheAccess = entityRegionAccessStrategy;
            this.cacheLock = entityRegionAccessStrategy.lockRegion();
            entityRegionAccessStrategy.removeAll();
        }

        private void release() {
            this.cacheAccess.unlockRegion(this.cacheLock);
        }
    }
}

