/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.hibernate.action.AfterTransactionCompletionProcess;
import org.hibernate.action.BeforeTransactionCompletionProcess;
import org.hibernate.action.DelayedPostInsertIdentifier;
import org.hibernate.action.Executable;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.access.SoftLock;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.util.StringHelper;

public abstract class CollectionAction
implements Executable,
Serializable,
Comparable {
    private transient CollectionPersister persister;
    private final Serializable key;
    private final SessionImplementor session;
    private final String collectionRole;
    private final PersistentCollection collection;
    private AfterTransactionCompletionProcess afterTransactionProcess;

    public CollectionAction(CollectionPersister collectionPersister, PersistentCollection persistentCollection, Serializable serializable, SessionImplementor sessionImplementor) throws CacheException {
        this.persister = collectionPersister;
        this.session = sessionImplementor;
        this.key = serializable;
        this.collectionRole = collectionPersister.getRole();
        this.collection = persistentCollection;
    }

    protected PersistentCollection getCollection() {
        return this.collection;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.persister = this.session.getFactory().getCollectionPersister(this.collectionRole);
    }

    public final void beforeExecutions() throws CacheException {
        if (this.persister.hasCache()) {
            CacheKey cacheKey = new CacheKey(this.key, this.persister.getKeyType(), this.persister.getRole(), this.session.getEntityMode(), this.session.getFactory());
            SoftLock softLock = this.persister.getCacheAccessStrategy().lockItem(cacheKey, null);
            this.afterTransactionProcess = new CacheCleanupProcess(this.key, this.persister, softLock);
        }
    }

    public BeforeTransactionCompletionProcess getBeforeTransactionCompletionProcess() {
        return null;
    }

    public AfterTransactionCompletionProcess getAfterTransactionCompletionProcess() {
        return this.afterTransactionProcess;
    }

    public Serializable[] getPropertySpaces() {
        return this.persister.getCollectionSpaces();
    }

    protected final CollectionPersister getPersister() {
        return this.persister;
    }

    protected final Serializable getKey() {
        Serializable serializable = this.key;
        if (!(this.key instanceof DelayedPostInsertIdentifier) || (serializable = this.session.getPersistenceContext().getEntry(this.collection.getOwner()).getId()) == this.key) {
            // empty if block
        }
        return serializable;
    }

    protected final SessionImplementor getSession() {
        return this.session;
    }

    protected final void evict() throws CacheException {
        if (this.persister.hasCache()) {
            CacheKey cacheKey = new CacheKey(this.key, this.persister.getKeyType(), this.persister.getRole(), this.session.getEntityMode(), this.session.getFactory());
            this.persister.getCacheAccessStrategy().remove(cacheKey);
        }
    }

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + MessageHelper.infoString(this.collectionRole, this.key);
    }

    public int compareTo(Object object) {
        CollectionAction collectionAction = (CollectionAction)object;
        int n = this.collectionRole.compareTo(collectionAction.collectionRole);
        if (n != 0) {
            return n;
        }
        return this.persister.getKeyType().compare(this.key, collectionAction.key, this.session.getEntityMode());
    }

    private static class CacheCleanupProcess
    implements AfterTransactionCompletionProcess {
        private final Serializable key;
        private final CollectionPersister persister;
        private final SoftLock lock;

        private CacheCleanupProcess(Serializable serializable, CollectionPersister collectionPersister, SoftLock softLock) {
            this.key = serializable;
            this.persister = collectionPersister;
            this.lock = softLock;
        }

        public void doAfterTransactionCompletion(boolean bl, SessionImplementor sessionImplementor) {
            CacheKey cacheKey = new CacheKey(this.key, this.persister.getKeyType(), this.persister.getRole(), sessionImplementor.getEntityMode(), sessionImplementor.getFactory());
            this.persister.getCacheAccessStrategy().unlockItem(cacheKey, this.lock);
        }
    }
}

