/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.action.CollectionAction;
import org.hibernate.cache.CacheException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.PostCollectionRecreateEvent;
import org.hibernate.event.PostCollectionRecreateEventListener;
import org.hibernate.event.PreCollectionRecreateEvent;
import org.hibernate.event.PreCollectionRecreateEventListener;
import org.hibernate.persister.collection.CollectionPersister;

public final class CollectionRecreateAction
extends CollectionAction {
    public CollectionRecreateAction(PersistentCollection persistentCollection, CollectionPersister collectionPersister, Serializable serializable, SessionImplementor sessionImplementor) throws CacheException {
        super(collectionPersister, persistentCollection, serializable, sessionImplementor);
    }

    public void execute() throws HibernateException {
        PersistentCollection persistentCollection = this.getCollection();
        this.preRecreate();
        this.getPersister().recreate(persistentCollection, this.getKey(), this.getSession());
        this.getSession().getPersistenceContext().getCollectionEntry(persistentCollection).afterAction(persistentCollection);
        this.evict();
        this.postRecreate();
        if (this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
            this.getSession().getFactory().getStatisticsImplementor().recreateCollection(this.getPersister().getRole());
        }
    }

    private void preRecreate() {
        PreCollectionRecreateEventListener[] preCollectionRecreateEventListenerArray = this.getSession().getListeners().getPreCollectionRecreateEventListeners();
        if (preCollectionRecreateEventListenerArray.length > 0) {
            PreCollectionRecreateEvent preCollectionRecreateEvent = new PreCollectionRecreateEvent(this.getPersister(), this.getCollection(), (EventSource)this.getSession());
            for (int i = 0; i < preCollectionRecreateEventListenerArray.length; ++i) {
                preCollectionRecreateEventListenerArray[i].onPreRecreateCollection(preCollectionRecreateEvent);
            }
        }
    }

    private void postRecreate() {
        PostCollectionRecreateEventListener[] postCollectionRecreateEventListenerArray = this.getSession().getListeners().getPostCollectionRecreateEventListeners();
        if (postCollectionRecreateEventListenerArray.length > 0) {
            PostCollectionRecreateEvent postCollectionRecreateEvent = new PostCollectionRecreateEvent(this.getPersister(), this.getCollection(), (EventSource)this.getSession());
            for (int i = 0; i < postCollectionRecreateEventListenerArray.length; ++i) {
                postCollectionRecreateEventListenerArray[i].onPostRecreateCollection(postCollectionRecreateEvent);
            }
        }
    }
}

