/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.CollectionAction;
import org.hibernate.cache.CacheException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.PostCollectionRemoveEvent;
import org.hibernate.event.PostCollectionRemoveEventListener;
import org.hibernate.event.PreCollectionRemoveEvent;
import org.hibernate.event.PreCollectionRemoveEventListener;
import org.hibernate.persister.collection.CollectionPersister;

public final class CollectionRemoveAction
extends CollectionAction {
    private boolean emptySnapshot;
    private final Object affectedOwner;

    public CollectionRemoveAction(PersistentCollection persistentCollection, CollectionPersister collectionPersister, Serializable serializable, boolean bl, SessionImplementor sessionImplementor) throws CacheException {
        super(collectionPersister, persistentCollection, serializable, sessionImplementor);
        if (persistentCollection == null) {
            throw new AssertionFailure("collection == null");
        }
        this.emptySnapshot = bl;
        this.affectedOwner = sessionImplementor.getPersistenceContext().getLoadedCollectionOwnerOrNull(persistentCollection);
    }

    public CollectionRemoveAction(Object object, CollectionPersister collectionPersister, Serializable serializable, boolean bl, SessionImplementor sessionImplementor) throws CacheException {
        super(collectionPersister, null, serializable, sessionImplementor);
        if (object == null) {
            throw new AssertionFailure("affectedOwner == null");
        }
        this.emptySnapshot = bl;
        this.affectedOwner = object;
    }

    public void execute() throws HibernateException {
        PersistentCollection persistentCollection;
        this.preRemove();
        if (!this.emptySnapshot) {
            this.getPersister().remove(this.getKey(), this.getSession());
        }
        if ((persistentCollection = this.getCollection()) != null) {
            this.getSession().getPersistenceContext().getCollectionEntry(persistentCollection).afterAction(persistentCollection);
        }
        this.evict();
        this.postRemove();
        if (this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
            this.getSession().getFactory().getStatisticsImplementor().removeCollection(this.getPersister().getRole());
        }
    }

    private void preRemove() {
        PreCollectionRemoveEventListener[] preCollectionRemoveEventListenerArray = this.getSession().getListeners().getPreCollectionRemoveEventListeners();
        if (preCollectionRemoveEventListenerArray.length > 0) {
            PreCollectionRemoveEvent preCollectionRemoveEvent = new PreCollectionRemoveEvent(this.getPersister(), this.getCollection(), (EventSource)this.getSession(), this.affectedOwner);
            for (int i = 0; i < preCollectionRemoveEventListenerArray.length; ++i) {
                preCollectionRemoveEventListenerArray[i].onPreRemoveCollection(preCollectionRemoveEvent);
            }
        }
    }

    private void postRemove() {
        PostCollectionRemoveEventListener[] postCollectionRemoveEventListenerArray = this.getSession().getListeners().getPostCollectionRemoveEventListeners();
        if (postCollectionRemoveEventListenerArray.length > 0) {
            PostCollectionRemoveEvent postCollectionRemoveEvent = new PostCollectionRemoveEvent(this.getPersister(), this.getCollection(), (EventSource)this.getSession(), this.affectedOwner);
            for (int i = 0; i < postCollectionRemoveEventListenerArray.length; ++i) {
                postCollectionRemoveEventListenerArray[i].onPostRemoveCollection(postCollectionRemoveEvent);
            }
        }
    }
}

