/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.DelayedPostInsertIdentifier;
import org.hibernate.action.EntityAction;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PreInsertEvent;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.persister.entity.EntityPersister;

public final class EntityIdentityInsertAction
extends EntityAction {
    private final Object[] state;
    private final boolean isDelayed;
    private final EntityKey delayedEntityKey;
    private Serializable generatedId;

    public EntityIdentityInsertAction(Object[] objectArray, Object object, EntityPersister entityPersister, SessionImplementor sessionImplementor, boolean bl) throws HibernateException {
        super(sessionImplementor, null, object, entityPersister);
        this.state = objectArray;
        this.isDelayed = bl;
        this.delayedEntityKey = bl ? this.generateDelayedEntityKey() : null;
    }

    public void execute() throws HibernateException {
        EntityPersister entityPersister = this.getPersister();
        SessionImplementor sessionImplementor = this.getSession();
        Object object = this.getInstance();
        boolean bl = this.preInsert();
        if (!bl) {
            this.generatedId = entityPersister.insert(this.state, object, sessionImplementor);
            if (entityPersister.hasInsertGeneratedProperties()) {
                entityPersister.processInsertGeneratedProperties(this.generatedId, object, this.state, sessionImplementor);
            }
            entityPersister.setIdentifier(object, this.generatedId, sessionImplementor);
            this.getSession().getPersistenceContext().registerInsertedKey(this.getPersister(), this.generatedId);
        }
        this.postInsert();
        if (sessionImplementor.getFactory().getStatistics().isStatisticsEnabled() && !bl) {
            sessionImplementor.getFactory().getStatisticsImplementor().insertEntity(this.getPersister().getEntityName());
        }
    }

    public boolean needsAfterTransactionCompletion() {
        return this.hasPostCommitEventListeners();
    }

    protected boolean hasPostCommitEventListeners() {
        return this.getSession().getListeners().getPostCommitInsertEventListeners().length > 0;
    }

    public void doAfterTransactionCompletion(boolean bl, SessionImplementor sessionImplementor) {
        this.postCommitInsert();
    }

    private void postInsert() {
        PostInsertEventListener[] postInsertEventListenerArray;
        if (this.isDelayed) {
            this.getSession().getPersistenceContext().replaceDelayedEntityIdentityInsertKeys(this.delayedEntityKey, this.generatedId);
        }
        if ((postInsertEventListenerArray = this.getSession().getListeners().getPostInsertEventListeners()).length > 0) {
            PostInsertEvent postInsertEvent = new PostInsertEvent(this.getInstance(), this.generatedId, this.state, this.getPersister(), (EventSource)this.getSession());
            for (int i = 0; i < postInsertEventListenerArray.length; ++i) {
                postInsertEventListenerArray[i].onPostInsert(postInsertEvent);
            }
        }
    }

    private void postCommitInsert() {
        PostInsertEventListener[] postInsertEventListenerArray = this.getSession().getListeners().getPostCommitInsertEventListeners();
        if (postInsertEventListenerArray.length > 0) {
            PostInsertEvent postInsertEvent = new PostInsertEvent(this.getInstance(), this.generatedId, this.state, this.getPersister(), (EventSource)this.getSession());
            for (int i = 0; i < postInsertEventListenerArray.length; ++i) {
                postInsertEventListenerArray[i].onPostInsert(postInsertEvent);
            }
        }
    }

    private boolean preInsert() {
        PreInsertEventListener[] preInsertEventListenerArray = this.getSession().getListeners().getPreInsertEventListeners();
        boolean bl = false;
        if (preInsertEventListenerArray.length > 0) {
            PreInsertEvent preInsertEvent = new PreInsertEvent(this.getInstance(), null, this.state, this.getPersister(), (EventSource)this.getSession());
            for (int i = 0; i < preInsertEventListenerArray.length; ++i) {
                bl = preInsertEventListenerArray[i].onPreInsert(preInsertEvent) || bl;
            }
        }
        return bl;
    }

    public final Serializable getGeneratedId() {
        return this.generatedId;
    }

    public EntityKey getDelayedEntityKey() {
        return this.delayedEntityKey;
    }

    private synchronized EntityKey generateDelayedEntityKey() {
        if (!this.isDelayed) {
            throw new AssertionFailure("cannot request delayed entity-key for non-delayed post-insert-id generation");
        }
        return new EntityKey(new DelayedPostInsertIdentifier(), this.getPersister(), this.getSession().getEntityMode());
    }
}

