/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.buildtime;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.hibernate.bytecode.ClassTransformer;
import org.hibernate.bytecode.buildtime.ExecutionException;
import org.hibernate.bytecode.buildtime.Instrumenter;
import org.hibernate.bytecode.buildtime.Logger;
import org.hibernate.bytecode.util.ByteCodeHelper;
import org.hibernate.bytecode.util.ClassDescriptor;
import org.hibernate.bytecode.util.FieldFilter;

public abstract class AbstractInstrumenter
implements Instrumenter {
    private static final int ZIP_MAGIC = 1347093252;
    private static final int CLASS_MAGIC = -889275714;
    protected final Logger logger;
    protected final Instrumenter.Options options;

    public AbstractInstrumenter(Logger logger, Instrumenter.Options options) {
        this.logger = logger;
        this.options = options;
    }

    protected abstract ClassDescriptor getClassDescriptor(byte[] var1) throws Exception;

    protected abstract ClassTransformer getClassTransformer(ClassDescriptor var1, Set var2);

    public void execute(Set set) {
        HashSet hashSet = new HashSet();
        if (this.options.performExtendedInstrumentation()) {
            this.logger.debug("collecting class names for extended instrumentation determination");
            try {
                for (File file : set) {
                    this.collectClassNames(file, hashSet);
                }
            }
            catch (ExecutionException executionException) {
                throw executionException;
            }
            catch (Exception exception) {
                throw new ExecutionException(exception);
            }
        }
        this.logger.info("starting instrumentation");
        try {
            for (File file : set) {
                this.processFile(file, hashSet);
            }
        }
        catch (ExecutionException executionException) {
            throw executionException;
        }
        catch (Exception exception) {
            throw new ExecutionException(exception);
        }
    }

    private void collectClassNames(File file, final Set set) throws Exception {
        if (this.isClassFile(file)) {
            byte[] byArray = ByteCodeHelper.readByteCode(file);
            ClassDescriptor classDescriptor = this.getClassDescriptor(byArray);
            set.add(classDescriptor.getName());
        } else if (this.isJarFile(file)) {
            ZipEntryHandler zipEntryHandler = new ZipEntryHandler(){

                public void handleEntry(ZipEntry zipEntry, byte[] byArray) throws Exception {
                    DataInputStream dataInputStream;
                    if (!zipEntry.isDirectory() && (dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray))).readInt() == -889275714) {
                        set.add(AbstractInstrumenter.this.getClassDescriptor(byArray).getName());
                    }
                }
            };
            ZipFileProcessor zipFileProcessor = new ZipFileProcessor(zipEntryHandler);
            zipFileProcessor.process(file);
        }
    }

    protected final boolean isClassFile(File file) throws IOException {
        return this.checkMagic(file, -889275714L);
    }

    protected final boolean isJarFile(File file) throws IOException {
        return this.checkMagic(file, 1347093252L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean checkMagic(File file, long l) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        try {
            int n = dataInputStream.readInt();
            boolean bl = l == (long)n;
            return bl;
        }
        finally {
            dataInputStream.close();
        }
    }

    protected void processFile(File file, Set set) throws Exception {
        if (this.isClassFile(file)) {
            this.logger.debug("processing class file : " + file.getAbsolutePath());
            this.processClassFile(file, set);
        } else if (this.isJarFile(file)) {
            this.logger.debug("processing jar file : " + file.getAbsolutePath());
            this.processJarFile(file, set);
        } else {
            this.logger.debug("ignoring file : " + file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processClassFile(File file, Set set) throws Exception {
        byte[] byArray = ByteCodeHelper.readByteCode(file);
        ClassDescriptor classDescriptor = this.getClassDescriptor(byArray);
        ClassTransformer classTransformer = this.getClassTransformer(classDescriptor, set);
        if (classTransformer == null) {
            this.logger.debug("no trasformer for class file : " + file.getAbsolutePath());
            return;
        }
        this.logger.info("processing class : " + classDescriptor.getName() + ";  file = " + file.getAbsolutePath());
        byte[] byArray2 = classTransformer.transform(this.getClass().getClassLoader(), classDescriptor.getName(), null, null, classDescriptor.getBytes());
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            ((OutputStream)fileOutputStream).write(byArray2);
            fileOutputStream.flush();
        }
        finally {
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processJarFile(final File file, final Set set) throws Exception {
        block10: {
            File file2 = File.createTempFile(file.getName(), null, new File(file.getAbsoluteFile().getParent()));
            try {
                Object object;
                FileOutputStream fileOutputStream = new FileOutputStream(file2, false);
                try {
                    object = new ZipOutputStream(fileOutputStream);
                    ZipEntryHandler zipEntryHandler = new ZipEntryHandler((ZipOutputStream)object){
                        final /* synthetic */ ZipOutputStream val$out;
                        {
                            this.val$out = zipOutputStream;
                        }

                        public void handleEntry(ZipEntry zipEntry, byte[] byArray) throws Exception {
                            Object object;
                            Object object2;
                            AbstractInstrumenter.this.logger.debug("starting zip entry : " + zipEntry.toString());
                            if (!zipEntry.isDirectory()) {
                                object2 = new DataInputStream(new ByteArrayInputStream(byArray));
                                if (((DataInputStream)object2).readInt() == -889275714) {
                                    object = AbstractInstrumenter.this.getClassDescriptor(byArray);
                                    ClassTransformer classTransformer = AbstractInstrumenter.this.getClassTransformer((ClassDescriptor)object, set);
                                    if (classTransformer == null) {
                                        AbstractInstrumenter.this.logger.debug("no transformer for zip entry :  " + zipEntry.toString());
                                    } else {
                                        AbstractInstrumenter.this.logger.info("processing class : " + object.getName() + ";  entry = " + file.getAbsolutePath());
                                        byArray = classTransformer.transform(this.getClass().getClassLoader(), object.getName(), null, null, object.getBytes());
                                    }
                                } else {
                                    AbstractInstrumenter.this.logger.debug("ignoring zip entry : " + zipEntry.toString());
                                }
                            }
                            object2 = new ZipEntry(zipEntry.getName());
                            ((ZipEntry)object2).setMethod(zipEntry.getMethod());
                            ((ZipEntry)object2).setComment(zipEntry.getComment());
                            ((ZipEntry)object2).setSize(byArray.length);
                            if (((ZipEntry)object2).getMethod() == 0) {
                                object = new CRC32();
                                object.update(byArray);
                                ((ZipEntry)object2).setCrc(((CRC32)object).getValue());
                                ((ZipEntry)object2).setCompressedSize(byArray.length);
                            }
                            this.val$out.putNextEntry((ZipEntry)object2);
                            this.val$out.write(byArray);
                            this.val$out.closeEntry();
                        }
                    };
                    ZipFileProcessor zipFileProcessor = new ZipFileProcessor(zipEntryHandler);
                    zipFileProcessor.process(file);
                    ((ZipOutputStream)object).close();
                }
                finally {
                    fileOutputStream.close();
                }
                if (file.delete()) {
                    object = new File(file2.getAbsolutePath());
                    if (!((File)object).renameTo(file)) {
                        throw new IOException("can not rename " + file2 + " to " + file);
                    }
                    break block10;
                }
                throw new IOException("can not delete " + file);
            }
            finally {
                if (!file2.delete()) {
                    this.logger.info("Unable to cleanup temporary jar file : " + file2.getAbsolutePath());
                }
            }
        }
    }

    private static class ZipFileProcessor {
        private final ZipEntryHandler entryHandler;

        public ZipFileProcessor(ZipEntryHandler zipEntryHandler) {
            this.entryHandler = zipEntryHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(File file) throws Exception {
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
            try {
                ZipEntry zipEntry;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    byte[] byArray = ByteCodeHelper.readByteCode(zipInputStream);
                    this.entryHandler.handleEntry(zipEntry, byArray);
                    zipInputStream.closeEntry();
                }
            }
            finally {
                zipInputStream.close();
            }
        }
    }

    private static interface ZipEntryHandler {
        public void handleEntry(ZipEntry var1, byte[] var2) throws Exception;
    }

    protected class CustomFieldFilter
    implements FieldFilter {
        private final ClassDescriptor descriptor;
        private final Set classNames;

        public CustomFieldFilter(ClassDescriptor classDescriptor, Set set) {
            this.descriptor = classDescriptor;
            this.classNames = set;
        }

        public boolean shouldInstrumentField(String string, String string2) {
            if (this.descriptor.getName().equals(string)) {
                AbstractInstrumenter.this.logger.trace("accepting transformation of field [" + string + "." + string2 + "]");
                return true;
            }
            AbstractInstrumenter.this.logger.trace("rejecting transformation of field [" + string + "." + string2 + "]");
            return false;
        }

        public boolean shouldTransformFieldAccess(String string, String string2, String string3) {
            if (this.descriptor.getName().equals(string2)) {
                AbstractInstrumenter.this.logger.trace("accepting transformation of field access [" + string2 + "." + string3 + "]");
                return true;
            }
            if (AbstractInstrumenter.this.options.performExtendedInstrumentation() && this.classNames.contains(string2)) {
                AbstractInstrumenter.this.logger.trace("accepting extended transformation of field access [" + string2 + "." + string3 + "]");
                return true;
            }
            AbstractInstrumenter.this.logger.trace("rejecting transformation of field access [" + string2 + "." + string3 + "]; caller = " + string);
            return false;
        }
    }
}

