/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.buildtime;

import java.io.ByteArrayInputStream;
import java.util.Set;
import net.sf.cglib.core.ClassNameReader;
import net.sf.cglib.transform.impl.InterceptFieldEnabled;
import org.hibernate.bytecode.ClassTransformer;
import org.hibernate.bytecode.buildtime.AbstractInstrumenter;
import org.hibernate.bytecode.buildtime.Instrumenter;
import org.hibernate.bytecode.buildtime.Logger;
import org.hibernate.bytecode.cglib.BytecodeProviderImpl;
import org.hibernate.bytecode.util.BasicClassFilter;
import org.hibernate.bytecode.util.ClassDescriptor;
import org.objectweb.asm.ClassReader;

public class CGLIBInstrumenter
extends AbstractInstrumenter {
    private static final BasicClassFilter CLASS_FILTER = new BasicClassFilter();
    private final BytecodeProviderImpl provider = new BytecodeProviderImpl();

    public CGLIBInstrumenter(Logger logger, Instrumenter.Options options) {
        super(logger, options);
    }

    protected ClassDescriptor getClassDescriptor(byte[] byArray) throws Exception {
        return new CustomClassDescriptor(byArray);
    }

    protected ClassTransformer getClassTransformer(ClassDescriptor classDescriptor, Set set) {
        if (classDescriptor.isInstrumented()) {
            this.logger.debug("class [" + classDescriptor.getName() + "] already instrumented");
            return null;
        }
        return this.provider.getTransformer(CLASS_FILTER, new AbstractInstrumenter.CustomFieldFilter(classDescriptor, set));
    }

    private static class CustomClassDescriptor
    implements ClassDescriptor {
        private final byte[] bytecode;
        private final String name;
        private final boolean isInstrumented;

        public CustomClassDescriptor(byte[] byArray) throws Exception {
            this.bytecode = byArray;
            ClassReader classReader = new ClassReader(new ByteArrayInputStream(byArray));
            String[] stringArray = ClassNameReader.getClassInfo(classReader);
            this.name = stringArray[0];
            boolean bl = false;
            for (int i = 1; i < stringArray.length; ++i) {
                if (!InterceptFieldEnabled.class.getName().equals(stringArray[i])) continue;
                bl = true;
                break;
            }
            this.isInstrumented = bl;
        }

        public String getName() {
            return this.name;
        }

        public boolean isInstrumented() {
            return this.isInstrumented;
        }

        public byte[] getBytes() {
            return this.bytecode;
        }
    }
}

