/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.buildtime;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Set;
import javassist.bytecode.ClassFile;
import org.hibernate.bytecode.ClassTransformer;
import org.hibernate.bytecode.buildtime.AbstractInstrumenter;
import org.hibernate.bytecode.buildtime.Instrumenter;
import org.hibernate.bytecode.buildtime.Logger;
import org.hibernate.bytecode.javassist.BytecodeProviderImpl;
import org.hibernate.bytecode.javassist.FieldHandled;
import org.hibernate.bytecode.util.BasicClassFilter;
import org.hibernate.bytecode.util.ClassDescriptor;

public class JavassistInstrumenter
extends AbstractInstrumenter {
    private static final BasicClassFilter CLASS_FILTER = new BasicClassFilter();
    private final BytecodeProviderImpl provider = new BytecodeProviderImpl();

    public JavassistInstrumenter(Logger logger, Instrumenter.Options options) {
        super(logger, options);
    }

    protected ClassDescriptor getClassDescriptor(byte[] byArray) throws IOException {
        return new CustomClassDescriptor(byArray);
    }

    protected ClassTransformer getClassTransformer(ClassDescriptor classDescriptor, Set set) {
        if (classDescriptor.isInstrumented()) {
            this.logger.debug("class [" + classDescriptor.getName() + "] already instrumented");
            return null;
        }
        return this.provider.getTransformer(CLASS_FILTER, new AbstractInstrumenter.CustomFieldFilter(classDescriptor, set));
    }

    private static class CustomClassDescriptor
    implements ClassDescriptor {
        private final byte[] bytes;
        private final ClassFile classFile;

        public CustomClassDescriptor(byte[] byArray) throws IOException {
            this.bytes = byArray;
            this.classFile = new ClassFile(new DataInputStream(new ByteArrayInputStream(byArray)));
        }

        public String getName() {
            return this.classFile.getName();
        }

        public boolean isInstrumented() {
            String[] stringArray = this.classFile.getInterfaces();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!FieldHandled.class.getName().equals(stringArray[i])) continue;
                return true;
            }
            return false;
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }
}

