/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.cglib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.ProtectionDomain;
import net.sf.cglib.core.ClassNameReader;
import net.sf.cglib.core.DebuggingClassWriter;
import net.sf.cglib.transform.ClassReaderGenerator;
import net.sf.cglib.transform.ClassTransformer;
import net.sf.cglib.transform.TransformingClassGenerator;
import net.sf.cglib.transform.impl.InterceptFieldEnabled;
import net.sf.cglib.transform.impl.InterceptFieldFilter;
import net.sf.cglib.transform.impl.InterceptFieldTransformer;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.AbstractClassTransformerImpl;
import org.hibernate.bytecode.util.ClassFilter;
import org.hibernate.bytecode.util.FieldFilter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CglibClassTransformer
extends AbstractClassTransformerImpl {
    private static Logger log = LoggerFactory.getLogger(CglibClassTransformer.class.getName());

    public CglibClassTransformer(ClassFilter classFilter, FieldFilter fieldFilter) {
        super(classFilter, fieldFilter);
    }

    protected byte[] doTransform(ClassLoader classLoader, String string, Class clazz, ProtectionDomain protectionDomain, byte[] byArray) {
        ClassReader classReader;
        try {
            classReader = new ClassReader(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            log.error("Unable to read class", iOException);
            throw new HibernateException("Unable to read class: " + iOException.getMessage());
        }
        String[] stringArray = ClassNameReader.getClassInfo(classReader);
        DebuggingClassWriter debuggingClassWriter = new DebuggingClassWriter(1);
        ClassTransformer classTransformer = this.getClassTransformer(stringArray);
        if (classTransformer != null) {
            byte[] byArray2;
            if (log.isDebugEnabled()) {
                log.debug("Enhancing " + string);
            }
            try {
                classReader = new ClassReader(new ByteArrayInputStream(byArray));
                new TransformingClassGenerator(new ClassReaderGenerator(classReader, this.skipDebug()), classTransformer).generateClass(debuggingClassWriter);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write(((ClassWriter)debuggingClassWriter).toByteArray());
                byArray2 = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {
                log.error("Unable to transform class", exception);
                throw new HibernateException("Unable to transform class: " + exception.getMessage());
            }
            return byArray2;
        }
        return byArray;
    }

    private int skipDebug() {
        return 2;
    }

    private ClassTransformer getClassTransformer(final String[] stringArray) {
        if (this.isAlreadyInstrumented(stringArray)) {
            return null;
        }
        return new InterceptFieldTransformer(new InterceptFieldFilter(){

            public boolean acceptRead(Type type, String string) {
                return CglibClassTransformer.this.fieldFilter.shouldTransformFieldAccess(stringArray[0], type.getClassName(), string);
            }

            public boolean acceptWrite(Type type, String string) {
                return CglibClassTransformer.this.fieldFilter.shouldTransformFieldAccess(stringArray[0], type.getClassName(), string);
            }
        });
    }

    private boolean isAlreadyInstrumented(String[] stringArray) {
        for (int i = 1; i < stringArray.length; ++i) {
            if (!InterceptFieldEnabled.class.getName().equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }
}

