/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.javassist;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import javassist.CannotCompileException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import org.hibernate.bytecode.javassist.FieldFilter;
import org.hibernate.bytecode.javassist.FieldHandled;
import org.hibernate.bytecode.javassist.FieldHandler;

public class FieldTransformer {
    private static final String EACH_READ_METHOD_PREFIX = "$javassist_read_";
    private static final String EACH_WRITE_METHOD_PREFIX = "$javassist_write_";
    private static final String FIELD_HANDLED_TYPE_NAME = FieldHandled.class.getName();
    private static final String HANDLER_FIELD_NAME = "$JAVASSIST_READ_WRITE_HANDLER";
    private static final String FIELD_HANDLER_TYPE_NAME = FieldHandler.class.getName();
    private static final String HANDLER_FIELD_DESCRIPTOR = 'L' + FIELD_HANDLER_TYPE_NAME.replace('.', '/') + ';';
    private static final String GETFIELDHANDLER_METHOD_NAME = "getFieldHandler";
    private static final String SETFIELDHANDLER_METHOD_NAME = "setFieldHandler";
    private static final String GETFIELDHANDLER_METHOD_DESCRIPTOR = "()" + HANDLER_FIELD_DESCRIPTOR;
    private static final String SETFIELDHANDLER_METHOD_DESCRIPTOR = "(" + HANDLER_FIELD_DESCRIPTOR + ")V";
    private FieldFilter filter;

    public FieldTransformer() {
        this(null);
    }

    public FieldTransformer(FieldFilter fieldFilter) {
        this.filter = fieldFilter;
    }

    public void setFieldFilter(FieldFilter fieldFilter) {
        this.filter = fieldFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(File file) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        ClassFile classFile = new ClassFile(dataInputStream);
        this.transform(classFile);
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
        try {
            classFile.write(dataOutputStream);
        }
        finally {
            dataOutputStream.close();
        }
    }

    public void transform(ClassFile classFile) throws Exception {
        if (classFile.isInterface()) {
            return;
        }
        try {
            this.addFieldHandlerField(classFile);
            this.addGetFieldHandlerMethod(classFile);
            this.addSetFieldHandlerMethod(classFile);
            this.addFieldHandledInterface(classFile);
            this.addReadWriteMethods(classFile);
            this.transformInvokevirtualsIntoPutAndGetfields(classFile);
        }
        catch (CannotCompileException cannotCompileException) {
            throw new RuntimeException(cannotCompileException.getMessage(), cannotCompileException);
        }
    }

    private void addFieldHandlerField(ClassFile classFile) throws CannotCompileException {
        ConstPool constPool = classFile.getConstPool();
        FieldInfo fieldInfo = new FieldInfo(constPool, HANDLER_FIELD_NAME, HANDLER_FIELD_DESCRIPTOR);
        fieldInfo.setAccessFlags(130);
        classFile.addField(fieldInfo);
    }

    private void addGetFieldHandlerMethod(ClassFile classFile) throws CannotCompileException {
        ConstPool constPool = classFile.getConstPool();
        int n = constPool.getThisClassInfo();
        MethodInfo methodInfo = new MethodInfo(constPool, GETFIELDHANDLER_METHOD_NAME, GETFIELDHANDLER_METHOD_DESCRIPTOR);
        Bytecode bytecode = new Bytecode(constPool, 2, 1);
        bytecode.addAload(0);
        bytecode.addOpcode(180);
        int n2 = constPool.addFieldrefInfo(n, HANDLER_FIELD_NAME, HANDLER_FIELD_DESCRIPTOR);
        bytecode.addIndex(n2);
        bytecode.addOpcode(176);
        methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
        methodInfo.setAccessFlags(1);
        classFile.addMethod(methodInfo);
    }

    private void addSetFieldHandlerMethod(ClassFile classFile) throws CannotCompileException {
        ConstPool constPool = classFile.getConstPool();
        int n = constPool.getThisClassInfo();
        MethodInfo methodInfo = new MethodInfo(constPool, SETFIELDHANDLER_METHOD_NAME, SETFIELDHANDLER_METHOD_DESCRIPTOR);
        Bytecode bytecode = new Bytecode(constPool, 3, 3);
        bytecode.addAload(0);
        bytecode.addAload(1);
        bytecode.addOpcode(181);
        int n2 = constPool.addFieldrefInfo(n, HANDLER_FIELD_NAME, HANDLER_FIELD_DESCRIPTOR);
        bytecode.addIndex(n2);
        bytecode.addOpcode(177);
        methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
        methodInfo.setAccessFlags(1);
        classFile.addMethod(methodInfo);
    }

    private void addFieldHandledInterface(ClassFile classFile) {
        String[] stringArray = classFile.getInterfaces();
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray2.length - 1] = FIELD_HANDLED_TYPE_NAME;
        classFile.setInterfaces(stringArray2);
    }

    private void addReadWriteMethods(ClassFile classFile) throws CannotCompileException {
        List list = classFile.getFields();
        for (FieldInfo fieldInfo : list) {
            if ((fieldInfo.getAccessFlags() & 8) != 0 || fieldInfo.getName().equals(HANDLER_FIELD_NAME)) continue;
            if (this.filter.handleRead(fieldInfo.getDescriptor(), fieldInfo.getName())) {
                this.addReadMethod(classFile, fieldInfo);
            }
            if (!this.filter.handleWrite(fieldInfo.getDescriptor(), fieldInfo.getName())) continue;
            this.addWriteMethod(classFile, fieldInfo);
        }
    }

    private void addReadMethod(ClassFile classFile, FieldInfo fieldInfo) throws CannotCompileException {
        ConstPool constPool = classFile.getConstPool();
        int n = constPool.getThisClassInfo();
        String string = "()" + fieldInfo.getDescriptor();
        MethodInfo methodInfo = new MethodInfo(constPool, EACH_READ_METHOD_PREFIX + fieldInfo.getName(), string);
        Bytecode bytecode = new Bytecode(constPool, 5, 3);
        bytecode.addAload(0);
        bytecode.addOpcode(180);
        int n2 = constPool.addFieldrefInfo(n, fieldInfo.getName(), fieldInfo.getDescriptor());
        bytecode.addIndex(n2);
        bytecode.addAload(0);
        int n3 = constPool.addClassInfo(FIELD_HANDLED_TYPE_NAME);
        bytecode.addInvokeinterface(n3, GETFIELDHANDLER_METHOD_NAME, GETFIELDHANDLER_METHOD_DESCRIPTOR, 1);
        bytecode.addOpcode(199);
        bytecode.addIndex(4);
        FieldTransformer.addTypeDependDataReturn(bytecode, fieldInfo.getDescriptor());
        FieldTransformer.addTypeDependDataStore(bytecode, fieldInfo.getDescriptor(), 1);
        bytecode.addAload(0);
        bytecode.addInvokeinterface(n3, GETFIELDHANDLER_METHOD_NAME, GETFIELDHANDLER_METHOD_DESCRIPTOR, 1);
        bytecode.addAload(0);
        bytecode.addLdc(fieldInfo.getName());
        FieldTransformer.addTypeDependDataLoad(bytecode, fieldInfo.getDescriptor(), 1);
        FieldTransformer.addInvokeFieldHandlerMethod(classFile, bytecode, fieldInfo.getDescriptor(), true);
        FieldTransformer.addTypeDependDataReturn(bytecode, fieldInfo.getDescriptor());
        methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
        methodInfo.setAccessFlags(1);
        classFile.addMethod(methodInfo);
    }

    private void addWriteMethod(ClassFile classFile, FieldInfo fieldInfo) throws CannotCompileException {
        ConstPool constPool = classFile.getConstPool();
        int n = constPool.getThisClassInfo();
        String string = "(" + fieldInfo.getDescriptor() + ")V";
        MethodInfo methodInfo = new MethodInfo(constPool, EACH_WRITE_METHOD_PREFIX + fieldInfo.getName(), string);
        Bytecode bytecode = new Bytecode(constPool, 6, 3);
        bytecode.addAload(0);
        int n2 = constPool.addClassInfo(FIELD_HANDLED_TYPE_NAME);
        bytecode.addInvokeinterface(n2, GETFIELDHANDLER_METHOD_NAME, GETFIELDHANDLER_METHOD_DESCRIPTOR, 1);
        bytecode.addOpcode(199);
        bytecode.addIndex(9);
        bytecode.addAload(0);
        FieldTransformer.addTypeDependDataLoad(bytecode, fieldInfo.getDescriptor(), 1);
        bytecode.addOpcode(181);
        int n3 = constPool.addFieldrefInfo(n, fieldInfo.getName(), fieldInfo.getDescriptor());
        bytecode.addIndex(n3);
        bytecode.growStack(-Descriptor.dataSize((String)fieldInfo.getDescriptor()));
        bytecode.addOpcode(177);
        bytecode.addAload(0);
        bytecode.addOpcode(89);
        bytecode.addInvokeinterface(n2, GETFIELDHANDLER_METHOD_NAME, GETFIELDHANDLER_METHOD_DESCRIPTOR, 1);
        bytecode.addAload(0);
        bytecode.addLdc(fieldInfo.getName());
        bytecode.addAload(0);
        bytecode.addOpcode(180);
        bytecode.addIndex(n3);
        bytecode.growStack(Descriptor.dataSize((String)fieldInfo.getDescriptor()) - 1);
        FieldTransformer.addTypeDependDataLoad(bytecode, fieldInfo.getDescriptor(), 1);
        FieldTransformer.addInvokeFieldHandlerMethod(classFile, bytecode, fieldInfo.getDescriptor(), false);
        bytecode.addOpcode(181);
        bytecode.addIndex(n3);
        bytecode.growStack(-Descriptor.dataSize((String)fieldInfo.getDescriptor()));
        bytecode.addOpcode(177);
        methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
        methodInfo.setAccessFlags(1);
        classFile.addMethod(methodInfo);
    }

    private void transformInvokevirtualsIntoPutAndGetfields(ClassFile classFile) throws CannotCompileException {
        List list = classFile.getMethods();
        for (MethodInfo methodInfo : list) {
            CodeAttribute codeAttribute;
            String string = methodInfo.getName();
            if (string.startsWith(EACH_READ_METHOD_PREFIX) || string.startsWith(EACH_WRITE_METHOD_PREFIX) || string.equals(GETFIELDHANDLER_METHOD_NAME) || string.equals(SETFIELDHANDLER_METHOD_NAME) || (codeAttribute = methodInfo.getCodeAttribute()) == null) continue;
            CodeIterator codeIterator = codeAttribute.iterator();
            while (codeIterator.hasNext()) {
                try {
                    int n = codeIterator.next();
                    n = this.transformInvokevirtualsIntoGetfields(classFile, codeIterator, n);
                    n = this.transformInvokevirtualsIntoPutfields(classFile, codeIterator, n);
                }
                catch (BadBytecode badBytecode) {
                    throw new CannotCompileException((Throwable)badBytecode);
                }
            }
        }
    }

    private int transformInvokevirtualsIntoGetfields(ClassFile classFile, CodeIterator codeIterator, int n) {
        ConstPool constPool = classFile.getConstPool();
        int n2 = codeIterator.byteAt(n);
        if (n2 != 180) {
            return n;
        }
        int n3 = codeIterator.u16bitAt(n + 1);
        String string = constPool.getFieldrefName(n3);
        String string2 = constPool.getFieldrefClassName(n3);
        if (!this.filter.handleReadAccess(string2, string)) {
            return n;
        }
        String string3 = "()" + constPool.getFieldrefType(n3);
        int n4 = constPool.addMethodrefInfo(constPool.getThisClassInfo(), EACH_READ_METHOD_PREFIX + string, string3);
        codeIterator.writeByte(182, n);
        codeIterator.write16bit(n4, n + 1);
        return n;
    }

    private int transformInvokevirtualsIntoPutfields(ClassFile classFile, CodeIterator codeIterator, int n) {
        ConstPool constPool = classFile.getConstPool();
        int n2 = codeIterator.byteAt(n);
        if (n2 != 181) {
            return n;
        }
        int n3 = codeIterator.u16bitAt(n + 1);
        String string = constPool.getFieldrefName(n3);
        String string2 = constPool.getFieldrefClassName(n3);
        if (!this.filter.handleWriteAccess(string2, string)) {
            return n;
        }
        String string3 = "(" + constPool.getFieldrefType(n3) + ")V";
        int n4 = constPool.addMethodrefInfo(constPool.getThisClassInfo(), EACH_WRITE_METHOD_PREFIX + string, string3);
        codeIterator.writeByte(182, n);
        codeIterator.write16bit(n4, n + 1);
        return n;
    }

    private static void addInvokeFieldHandlerMethod(ClassFile classFile, Bytecode bytecode, String string, boolean bl) {
        ConstPool constPool = classFile.getConstPool();
        int n = constPool.addClassInfo(FIELD_HANDLER_TYPE_NAME);
        if (string.charAt(0) == 'L' && string.charAt(string.length() - 1) == ';' || string.charAt(0) == '[') {
            String string2;
            int n2 = string.indexOf(76);
            if (n2 == 0) {
                string2 = string.substring(1, string.length() - 1);
                string2 = string2.replace('/', '.');
            } else {
                string2 = n2 == -1 ? string : string.replace('/', '.');
            }
            if (bl) {
                bytecode.addInvokeinterface(n, "readObject", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", 4);
                bytecode.addCheckcast(string2);
            } else {
                bytecode.addInvokeinterface(n, "writeObject", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", 5);
                bytecode.addCheckcast(string2);
            }
        } else if (string.equals("Z")) {
            if (bl) {
                bytecode.addInvokeinterface(n, "readBoolean", "(Ljava/lang/Object;Ljava/lang/String;Z)Z", 4);
            } else {
                bytecode.addInvokeinterface(n, "writeBoolean", "(Ljava/lang/Object;Ljava/lang/String;ZZ)Z", 5);
            }
        } else if (string.equals("B")) {
            if (bl) {
                bytecode.addInvokeinterface(n, "readByte", "(Ljava/lang/Object;Ljava/lang/String;B)B", 4);
            } else {
                bytecode.addInvokeinterface(n, "writeByte", "(Ljava/lang/Object;Ljava/lang/String;BB)B", 5);
            }
        } else if (string.equals("C")) {
            if (bl) {
                bytecode.addInvokeinterface(n, "readChar", "(Ljava/lang/Object;Ljava/lang/String;C)C", 4);
            } else {
                bytecode.addInvokeinterface(n, "writeChar", "(Ljava/lang/Object;Ljava/lang/String;CC)C", 5);
            }
        } else if (string.equals("I")) {
            if (bl) {
                bytecode.addInvokeinterface(n, "readInt", "(Ljava/lang/Object;Ljava/lang/String;I)I", 4);
            } else {
                bytecode.addInvokeinterface(n, "writeInt", "(Ljava/lang/Object;Ljava/lang/String;II)I", 5);
            }
        } else if (string.equals("S")) {
            if (bl) {
                bytecode.addInvokeinterface(n, "readShort", "(Ljava/lang/Object;Ljava/lang/String;S)S", 4);
            } else {
                bytecode.addInvokeinterface(n, "writeShort", "(Ljava/lang/Object;Ljava/lang/String;SS)S", 5);
            }
        } else if (string.equals("D")) {
            if (bl) {
                bytecode.addInvokeinterface(n, "readDouble", "(Ljava/lang/Object;Ljava/lang/String;D)D", 5);
            } else {
                bytecode.addInvokeinterface(n, "writeDouble", "(Ljava/lang/Object;Ljava/lang/String;DD)D", 7);
            }
        } else if (string.equals("F")) {
            if (bl) {
                bytecode.addInvokeinterface(n, "readFloat", "(Ljava/lang/Object;Ljava/lang/String;F)F", 4);
            } else {
                bytecode.addInvokeinterface(n, "writeFloat", "(Ljava/lang/Object;Ljava/lang/String;FF)F", 5);
            }
        } else if (string.equals("J")) {
            if (bl) {
                bytecode.addInvokeinterface(n, "readLong", "(Ljava/lang/Object;Ljava/lang/String;J)J", 5);
            } else {
                bytecode.addInvokeinterface(n, "writeLong", "(Ljava/lang/Object;Ljava/lang/String;JJ)J", 7);
            }
        } else {
            throw new RuntimeException("bad type: " + string);
        }
    }

    private static void addTypeDependDataLoad(Bytecode bytecode, String string, int n) {
        if (string.charAt(0) == 'L' && string.charAt(string.length() - 1) == ';' || string.charAt(0) == '[') {
            bytecode.addAload(n);
        } else if (string.equals("Z") || string.equals("B") || string.equals("C") || string.equals("I") || string.equals("S")) {
            bytecode.addIload(n);
        } else if (string.equals("D")) {
            bytecode.addDload(n);
        } else if (string.equals("F")) {
            bytecode.addFload(n);
        } else if (string.equals("J")) {
            bytecode.addLload(n);
        } else {
            throw new RuntimeException("bad type: " + string);
        }
    }

    private static void addTypeDependDataStore(Bytecode bytecode, String string, int n) {
        if (string.charAt(0) == 'L' && string.charAt(string.length() - 1) == ';' || string.charAt(0) == '[') {
            bytecode.addAstore(n);
        } else if (string.equals("Z") || string.equals("B") || string.equals("C") || string.equals("I") || string.equals("S")) {
            bytecode.addIstore(n);
        } else if (string.equals("D")) {
            bytecode.addDstore(n);
        } else if (string.equals("F")) {
            bytecode.addFstore(n);
        } else if (string.equals("J")) {
            bytecode.addLstore(n);
        } else {
            throw new RuntimeException("bad type: " + string);
        }
    }

    private static void addTypeDependDataReturn(Bytecode bytecode, String string) {
        if (string.charAt(0) == 'L' && string.charAt(string.length() - 1) == ';' || string.charAt(0) == '[') {
            bytecode.addOpcode(176);
        } else if (string.equals("Z") || string.equals("B") || string.equals("C") || string.equals("I") || string.equals("S")) {
            bytecode.addOpcode(172);
        } else if (string.equals("D")) {
            bytecode.addOpcode(175);
        } else if (string.equals("F")) {
            bytecode.addOpcode(174);
        } else if (string.equals("J")) {
            bytecode.addOpcode(173);
        } else {
            throw new RuntimeException("bad type: " + string);
        }
    }
}

