/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.javassist;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.ProtectionDomain;
import javassist.bytecode.ClassFile;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.AbstractClassTransformerImpl;
import org.hibernate.bytecode.javassist.FieldFilter;
import org.hibernate.bytecode.javassist.FieldHandled;
import org.hibernate.bytecode.javassist.FieldTransformer;
import org.hibernate.bytecode.util.ClassFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavassistClassTransformer
extends AbstractClassTransformerImpl {
    private static Logger log = LoggerFactory.getLogger(JavassistClassTransformer.class.getName());

    public JavassistClassTransformer(ClassFilter classFilter, org.hibernate.bytecode.util.FieldFilter fieldFilter) {
        super(classFilter, fieldFilter);
    }

    protected byte[] doTransform(ClassLoader classLoader, String string, Class clazz, ProtectionDomain protectionDomain, byte[] byArray) {
        ClassFile classFile;
        try {
            classFile = new ClassFile(new DataInputStream(new ByteArrayInputStream(byArray)));
        }
        catch (IOException iOException) {
            log.error("Unable to build enhancement metamodel for " + string);
            return byArray;
        }
        FieldTransformer fieldTransformer = this.getFieldTransformer(classFile);
        if (fieldTransformer != null) {
            if (log.isDebugEnabled()) {
                log.debug("Enhancing " + string);
            }
            FilterOutputStream filterOutputStream = null;
            try {
                fieldTransformer.transform(classFile);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                filterOutputStream = new DataOutputStream(byteArrayOutputStream);
                classFile.write((DataOutputStream)filterOutputStream);
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                return byArray2;
            }
            catch (Exception exception) {
                log.error("Unable to transform class", exception);
                throw new HibernateException("Unable to transform class: " + exception.getMessage());
            }
            finally {
                try {
                    if (filterOutputStream != null) {
                        filterOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return byArray;
    }

    protected FieldTransformer getFieldTransformer(final ClassFile classFile) {
        if (this.alreadyInstrumented(classFile)) {
            return null;
        }
        return new FieldTransformer(new FieldFilter(){

            public boolean handleRead(String string, String string2) {
                return JavassistClassTransformer.this.fieldFilter.shouldInstrumentField(classFile.getName(), string2);
            }

            public boolean handleWrite(String string, String string2) {
                return JavassistClassTransformer.this.fieldFilter.shouldInstrumentField(classFile.getName(), string2);
            }

            public boolean handleReadAccess(String string, String string2) {
                return JavassistClassTransformer.this.fieldFilter.shouldTransformFieldAccess(classFile.getName(), string, string2);
            }

            public boolean handleWriteAccess(String string, String string2) {
                return JavassistClassTransformer.this.fieldFilter.shouldTransformFieldAccess(classFile.getName(), string, string2);
            }
        });
    }

    private boolean alreadyInstrumented(ClassFile classFile) {
        String[] stringArray = classFile.getInterfaces();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!FieldHandled.class.getName().equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }
}

