/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.javassist;

import java.lang.reflect.Method;
import java.util.HashMap;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyObject;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.BasicProxyFactory;
import org.hibernate.bytecode.ProxyFactoryFactory;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.proxy.pojo.javassist.JavassistProxyFactory;

public class ProxyFactoryFactoryImpl
implements ProxyFactoryFactory {
    private static final MethodFilter FINALIZE_FILTER = new MethodFilter(){

        public boolean isHandled(Method method) {
            return method.getParameterTypes().length != 0 || !method.getName().equals("finalize");
        }
    };

    public ProxyFactory buildProxyFactory() {
        return new JavassistProxyFactory();
    }

    public BasicProxyFactory buildBasicProxyFactory(Class clazz, Class[] classArray) {
        return new BasicProxyFactoryImpl(clazz, classArray);
    }

    private static class PassThroughHandler
    implements MethodHandler {
        private HashMap data = new HashMap();
        private final Object proxiedObject;
        private final String proxiedClassName;

        public PassThroughHandler(Object object, String string) {
            this.proxiedObject = object;
            this.proxiedClassName = string;
        }

        public Object invoke(Object object, Method method, Method method2, Object[] objectArray) throws Exception {
            boolean bl;
            String string = method.getName();
            if ("toString".equals(string)) {
                return this.proxiedClassName + "@" + System.identityHashCode(object);
            }
            if ("equals".equals(string)) {
                return this.proxiedObject == object ? Boolean.TRUE : Boolean.FALSE;
            }
            if ("hashCode".equals(string)) {
                return new Integer(System.identityHashCode(object));
            }
            boolean bl2 = method.getParameterTypes().length == 0 && method.getReturnType() != null;
            boolean bl3 = bl = method.getParameterTypes().length == 1 && (method.getReturnType() == null || method.getReturnType() == Void.TYPE);
            if (string.startsWith("get") && bl2) {
                String string2 = string.substring(3);
                return this.data.get(string2);
            }
            if (string.startsWith("is") && bl2) {
                String string3 = string.substring(2);
                return this.data.get(string3);
            }
            if (string.startsWith("set") && bl) {
                String string4 = string.substring(3);
                this.data.put(string4, objectArray[0]);
                return null;
            }
            return null;
        }
    }

    private static class BasicProxyFactoryImpl
    implements BasicProxyFactory {
        private final Class proxyClass;

        public BasicProxyFactoryImpl(Class clazz, Class[] classArray) {
            if (clazz == null && (classArray == null || classArray.length < 1)) {
                throw new AssertionFailure("attempting to build proxy without any superclass or interfaces");
            }
            javassist.util.proxy.ProxyFactory proxyFactory = new javassist.util.proxy.ProxyFactory();
            proxyFactory.setFilter(FINALIZE_FILTER);
            if (clazz != null) {
                proxyFactory.setSuperclass(clazz);
            }
            if (classArray != null && classArray.length > 0) {
                proxyFactory.setInterfaces(classArray);
            }
            this.proxyClass = proxyFactory.createClass();
        }

        public Object getProxy() {
            try {
                ProxyObject proxyObject = (ProxyObject)this.proxyClass.newInstance();
                proxyObject.setHandler((MethodHandler)new PassThroughHandler(proxyObject, this.proxyClass.getName()));
                return proxyObject;
            }
            catch (Throwable throwable) {
                throw new HibernateException("Unable to instantiated proxy instance");
            }
        }

        public boolean isInstance(Object object) {
            return this.proxyClass.isInstance(object);
        }
    }
}

