/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.util.NamingHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJndiBoundCacheProvider
implements CacheProvider {
    private static final Logger log = LoggerFactory.getLogger(AbstractJndiBoundCacheProvider.class);
    private Object cache;

    protected void prepare(Properties properties) {
    }

    protected void release() {
    }

    public final void start(Properties properties) throws CacheException {
        String string = properties.getProperty("hibernate.cache.jndi");
        if (StringHelper.isEmpty(string)) {
            throw new CacheException("No JNDI namespace specified for cache");
        }
        this.cache = this.locateCache(string, NamingHelper.getJndiProperties(properties));
        this.prepare(properties);
    }

    public final void stop() {
        this.release();
        this.cache = null;
    }

    private Object locateCache(String string, Properties properties) {
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext(properties);
            Object object = initialContext.lookup(string);
            return object;
        }
        catch (NamingException namingException) {
            String string2 = "Unable to retreive Cache from JNDI [" + string + "]";
            log.info(string2, namingException);
            throw new CacheException(string2);
        }
        finally {
            if (initialContext != null) {
                try {
                    initialContext.close();
                }
                catch (NamingException namingException) {
                    log.info("Unable to release initial context", namingException);
                }
            }
        }
    }

    public Object getCache() {
        return this.cache;
    }
}

