/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.Timestamper;

public class HashtableCache
implements Cache {
    private final Map hashtable = new Hashtable();
    private final String regionName;

    public HashtableCache(String string) {
        this.regionName = string;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public Object read(Object object) throws CacheException {
        return this.hashtable.get(object);
    }

    public Object get(Object object) throws CacheException {
        return this.hashtable.get(object);
    }

    public void update(Object object, Object object2) throws CacheException {
        this.put(object, object2);
    }

    public void put(Object object, Object object2) throws CacheException {
        this.hashtable.put(object, object2);
    }

    public void remove(Object object) throws CacheException {
        this.hashtable.remove(object);
    }

    public void clear() throws CacheException {
        this.hashtable.clear();
    }

    public void destroy() throws CacheException {
    }

    public void lock(Object object) throws CacheException {
    }

    public void unlock(Object object) throws CacheException {
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public int getTimeout() {
        return 245760000;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        return this.hashtable.size();
    }

    public long getElementCountOnDisk() {
        return 0L;
    }

    public Map toMap() {
        return Collections.unmodifiableMap(this.hashtable);
    }

    public String toString() {
        return "HashtableCache(" + this.regionName + ')';
    }
}

