/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Comparator;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.access.SoftLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonstrictReadWriteCache
implements CacheConcurrencyStrategy {
    private Cache cache;
    private static final Logger log = LoggerFactory.getLogger(NonstrictReadWriteCache.class);

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    public Object get(Object object, long l) throws CacheException {
        Object object2;
        if (log.isDebugEnabled()) {
            log.debug("Cache lookup: " + object);
        }
        if ((object2 = this.cache.get(object)) != null) {
            log.debug("Cache hit");
        } else {
            log.debug("Cache miss");
        }
        return object2;
    }

    public boolean put(Object object, Object object2, long l, Object object3, Comparator comparator, boolean bl) throws CacheException {
        if (bl && this.cache.get(object) != null) {
            if (log.isDebugEnabled()) {
                log.debug("item already cached: " + object);
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Caching: " + object);
        }
        this.cache.put(object, object2);
        return true;
    }

    public SoftLock lock(Object object, Object object2) throws CacheException {
        return null;
    }

    public void remove(Object object) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("Removing: " + object);
        }
        this.cache.remove(object);
    }

    public void clear() throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("Clearing");
        }
        this.cache.clear();
    }

    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception exception) {
            log.warn("could not destroy cache", exception);
        }
    }

    public void evict(Object object) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("Invalidating: " + object);
        }
        this.cache.remove(object);
    }

    public boolean insert(Object object, Object object2, Object object3) {
        return false;
    }

    public boolean update(Object object, Object object2, Object object3, Object object4) {
        this.evict(object);
        return false;
    }

    public void release(Object object, SoftLock softLock) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("Invalidating (again): " + object);
        }
        this.cache.remove(object);
    }

    public boolean afterUpdate(Object object, Object object2, Object object3, SoftLock softLock) throws CacheException {
        this.release(object, softLock);
        return false;
    }

    public boolean afterInsert(Object object, Object object2, Object object3) throws CacheException {
        return false;
    }

    public String getRegionName() {
        return this.cache.getRegionName();
    }

    public String toString() {
        return this.cache + "(nonstrict-read-write)";
    }
}

