/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.hibernate.EntityMode;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.RowSelection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.EqualsHelper;

public class QueryKey
implements Serializable {
    private final String sqlQueryString;
    private final Type[] positionalParameterTypes;
    private final Object[] positionalParameterValues;
    private final Map namedParameters;
    private final Integer firstRow;
    private final Integer maxRows;
    private final EntityMode entityMode;
    private final Set filterKeys;
    private final ResultTransformer customTransformer;
    private transient int hashCode;

    /*
     * WARNING - void declaration
     */
    public static QueryKey generateQueryKey(String string, QueryParameters queryParameters, Set set, SessionImplementor sessionImplementor, ResultTransformer resultTransformer) {
        void var10_14;
        Serializable serializable;
        Map map;
        int n = queryParameters.getPositionalParameterTypes().length;
        Type[] typeArray = new Type[n];
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            typeArray[i] = queryParameters.getPositionalParameterTypes()[i];
            objectArray[i] = typeArray[i].disassemble(queryParameters.getPositionalParameterValues()[i], sessionImplementor, null);
        }
        if (queryParameters.getNamedParameters() == null) {
            map = null;
        } else {
            map = CollectionHelper.mapOfSize(queryParameters.getNamedParameters().size());
            for (Map.Entry object2 : queryParameters.getNamedParameters().entrySet()) {
                serializable = (TypedValue)object2.getValue();
                map.put(object2.getKey(), new TypedValue(((TypedValue)serializable).getType(), ((TypedValue)serializable).getType().disassemble(((TypedValue)serializable).getValue(), sessionImplementor, null), sessionImplementor.getEntityMode()));
            }
        }
        RowSelection rowSelection = queryParameters.getRowSelection();
        if (rowSelection != null) {
            Integer n2 = rowSelection.getFirstRow();
            serializable = rowSelection.getMaxRows();
        } else {
            Object var10_13 = null;
            serializable = null;
        }
        return new QueryKey(string, typeArray, objectArray, map, (Integer)var10_14, (Integer)serializable, set, sessionImplementor.getEntityMode(), resultTransformer);
    }

    QueryKey(String string, Type[] typeArray, Object[] objectArray, Map map, Integer n, Integer n2, Set set, EntityMode entityMode, ResultTransformer resultTransformer) {
        this.sqlQueryString = string;
        this.positionalParameterTypes = typeArray;
        this.positionalParameterValues = objectArray;
        this.namedParameters = map;
        this.firstRow = n;
        this.maxRows = n2;
        this.entityMode = entityMode;
        this.filterKeys = set;
        this.customTransformer = resultTransformer;
        this.hashCode = this.generateHashCode();
    }

    public ResultTransformer getResultTransformer() {
        return this.customTransformer;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.hashCode = this.generateHashCode();
    }

    private int generateHashCode() {
        int n = 13;
        n = 37 * n + (this.firstRow == null ? 0 : this.firstRow.hashCode());
        n = 37 * n + (this.maxRows == null ? 0 : this.maxRows.hashCode());
        for (int i = 0; i < this.positionalParameterValues.length; ++i) {
            n = 37 * n + (this.positionalParameterValues[i] == null ? 0 : this.positionalParameterTypes[i].getHashCode(this.positionalParameterValues[i], this.entityMode));
        }
        n = 37 * n + (this.namedParameters == null ? 0 : ((Object)this.namedParameters).hashCode());
        n = 37 * n + (this.filterKeys == null ? 0 : ((Object)this.filterKeys).hashCode());
        n = 37 * n + (this.customTransformer == null ? 0 : this.customTransformer.hashCode());
        n = 37 * n + this.sqlQueryString.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof QueryKey)) {
            return false;
        }
        QueryKey queryKey = (QueryKey)object;
        if (!this.sqlQueryString.equals(queryKey.sqlQueryString)) {
            return false;
        }
        if (!EqualsHelper.equals(this.firstRow, queryKey.firstRow) || !EqualsHelper.equals(this.maxRows, queryKey.maxRows)) {
            return false;
        }
        if (!EqualsHelper.equals(this.customTransformer, queryKey.customTransformer)) {
            return false;
        }
        if (this.positionalParameterTypes == null) {
            if (queryKey.positionalParameterTypes != null) {
                return false;
            }
        } else {
            if (queryKey.positionalParameterTypes == null) {
                return false;
            }
            if (this.positionalParameterTypes.length != queryKey.positionalParameterTypes.length) {
                return false;
            }
            for (int i = 0; i < this.positionalParameterTypes.length; ++i) {
                if (this.positionalParameterTypes[i].getReturnedClass() != queryKey.positionalParameterTypes[i].getReturnedClass()) {
                    return false;
                }
                if (this.positionalParameterTypes[i].isEqual(this.positionalParameterValues[i], queryKey.positionalParameterValues[i], this.entityMode)) continue;
                return false;
            }
        }
        return EqualsHelper.equals(this.filterKeys, queryKey.filterKeys) && EqualsHelper.equals(this.namedParameters, queryKey.namedParameters);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append("sql: ").append(this.sqlQueryString);
        if (this.positionalParameterValues != null) {
            stringBuffer.append("; parameters: ");
            for (int i = 0; i < this.positionalParameterValues.length; ++i) {
                stringBuffer.append(this.positionalParameterValues[i]).append(", ");
            }
        }
        if (this.namedParameters != null) {
            stringBuffer.append("; named parameters: ").append(this.namedParameters);
        }
        if (this.filterKeys != null) {
            stringBuffer.append("; filterKeys: ").append(this.filterKeys);
        }
        if (this.firstRow != null) {
            stringBuffer.append("; first row: ").append(this.firstRow);
        }
        if (this.maxRows != null) {
            stringBuffer.append("; max rows: ").append(this.maxRows);
        }
        if (this.customTransformer != null) {
            stringBuffer.append("; transformer: ").append(this.customTransformer);
        }
        return stringBuffer.toString();
    }
}

