/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Comparator;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.access.SoftLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyCache
implements CacheConcurrencyStrategy {
    private Cache cache;
    private static final Logger log = LoggerFactory.getLogger(ReadOnlyCache.class);

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    public String getRegionName() {
        return this.cache.getRegionName();
    }

    public synchronized Object get(Object object, long l) throws CacheException {
        Object object2 = this.cache.get(object);
        if (object2 != null && log.isDebugEnabled()) {
            log.debug("Cache hit: " + object);
        }
        return object2;
    }

    public SoftLock lock(Object object, Object object2) {
        log.error("Application attempted to edit read only item: " + object);
        throw new UnsupportedOperationException("Can't write to a readonly object");
    }

    public synchronized boolean put(Object object, Object object2, long l, Object object3, Comparator comparator, boolean bl) throws CacheException {
        if (bl && this.cache.get(object) != null) {
            if (log.isDebugEnabled()) {
                log.debug("item already cached: " + object);
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Caching: " + object);
        }
        this.cache.put(object, object2);
        return true;
    }

    public void release(Object object, SoftLock softLock) {
        log.error("Application attempted to edit read only item: " + object);
    }

    public void clear() throws CacheException {
        this.cache.clear();
    }

    public void remove(Object object) throws CacheException {
        this.cache.remove(object);
    }

    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception exception) {
            log.warn("could not destroy cache", exception);
        }
    }

    public boolean afterUpdate(Object object, Object object2, Object object3, SoftLock softLock) throws CacheException {
        log.error("Application attempted to edit read only item: " + object);
        throw new UnsupportedOperationException("Can't write to a readonly object");
    }

    public boolean afterInsert(Object object, Object object2, Object object3) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("Caching after insert: " + object);
        }
        this.cache.update(object, object2);
        return true;
    }

    public void evict(Object object) throws CacheException {
    }

    public boolean insert(Object object, Object object2, Object object3) {
        return false;
    }

    public boolean update(Object object, Object object2, Object object3, Object object4) {
        log.error("Application attempted to edit read only item: " + object);
        throw new UnsupportedOperationException("Can't write to a readonly object");
    }

    public String toString() {
        return this.cache + "(read-only)";
    }
}

