/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.Serializable;
import java.util.Comparator;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.access.SoftLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadWriteCache
implements CacheConcurrencyStrategy {
    private static final Logger log = LoggerFactory.getLogger(ReadWriteCache.class);
    private Cache cache;
    private int nextLockId;

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    public String getRegionName() {
        return this.cache.getRegionName();
    }

    private int nextLockId() {
        if (this.nextLockId == Integer.MAX_VALUE) {
            this.nextLockId = Integer.MIN_VALUE;
        }
        return this.nextLockId++;
    }

    public synchronized Object get(Object object, long l) throws CacheException {
        Lockable lockable;
        boolean bl;
        if (log.isTraceEnabled()) {
            log.trace("Cache lookup: " + object);
        }
        boolean bl2 = bl = (lockable = (Lockable)this.cache.get(object)) != null && lockable.isGettable(l);
        if (bl) {
            if (log.isTraceEnabled()) {
                log.trace("Cache hit: " + object);
            }
            return ((Item)lockable).getValue();
        }
        if (log.isTraceEnabled()) {
            if (lockable == null) {
                log.trace("Cache miss: " + object);
            } else {
                log.trace("Cached item was locked: " + object);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SoftLock lock(Object object, Object object2) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace("Invalidating: " + object);
        }
        try {
            this.cache.lock(object);
            Lockable lockable = (Lockable)this.cache.get(object);
            long l = this.cache.nextTimestamp() + (long)this.cache.getTimeout();
            Lock lock = lockable == null ? new Lock(l, this.nextLockId(), object2) : lockable.lock(l, this.nextLockId());
            this.cache.update(object, lock);
            Lock lock2 = lock;
            return lock2;
        }
        finally {
            this.cache.unlock(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean put(Object object, Object object2, long l, Object object3, Comparator comparator, boolean bl) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace("Caching: " + object);
        }
        try {
            boolean bl2;
            this.cache.lock(object);
            Lockable lockable = (Lockable)this.cache.get(object);
            boolean bl3 = bl2 = lockable == null || lockable.isPuttable(l, object3, comparator);
            if (bl2) {
                this.cache.put(object, new Item(object2, object3, this.cache.nextTimestamp()));
                if (log.isTraceEnabled()) {
                    log.trace("Cached: " + object);
                }
                boolean bl4 = true;
                return bl4;
            }
            if (log.isTraceEnabled()) {
                if (lockable.isLock()) {
                    log.trace("Item was locked: " + object);
                } else {
                    log.trace("Item was already cached: " + object);
                }
            }
            boolean bl5 = false;
            return bl5;
        }
        finally {
            this.cache.unlock(object);
        }
    }

    private void decrementLock(Object object, Lock lock) throws CacheException {
        lock.unlock(this.cache.nextTimestamp());
        this.cache.update(object, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release(Object object, SoftLock softLock) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace("Releasing: " + object);
        }
        try {
            this.cache.lock(object);
            Lockable lockable = (Lockable)this.cache.get(object);
            if (this.isUnlockable(softLock, lockable)) {
                this.decrementLock(object, (Lock)lockable);
            } else {
                this.handleLockExpiry(object);
            }
        }
        finally {
            this.cache.unlock(object);
        }
    }

    void handleLockExpiry(Object object) throws CacheException {
        log.warn("An item was expired by the cache while it was locked (increase your cache timeout): " + object);
        long l = this.cache.nextTimestamp() + (long)this.cache.getTimeout();
        Lock lock = new Lock(l, this.nextLockId(), null);
        lock.unlock(l);
        this.cache.update(object, lock);
    }

    public void clear() throws CacheException {
        this.cache.clear();
    }

    public void remove(Object object) throws CacheException {
        this.cache.remove(object);
    }

    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception exception) {
            log.warn("could not destroy cache", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean afterUpdate(Object object, Object object2, Object object3, SoftLock softLock) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace("Updating: " + object);
        }
        try {
            this.cache.lock(object);
            Lockable lockable = (Lockable)this.cache.get(object);
            if (this.isUnlockable(softLock, lockable)) {
                Lock lock = (Lock)lockable;
                if (lock.wasLockedConcurrently()) {
                    this.decrementLock(object, lock);
                    boolean bl = false;
                    return bl;
                }
                this.cache.update(object, new Item(object2, object3, this.cache.nextTimestamp()));
                if (log.isTraceEnabled()) {
                    log.trace("Updated: " + object);
                }
                boolean bl = true;
                return bl;
            }
            this.handleLockExpiry(object);
            boolean bl = false;
            return bl;
        }
        finally {
            this.cache.unlock(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean afterInsert(Object object, Object object2, Object object3) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace("Inserting: " + object);
        }
        try {
            this.cache.lock(object);
            Lockable lockable = (Lockable)this.cache.get(object);
            if (lockable == null) {
                this.cache.update(object, new Item(object2, object3, this.cache.nextTimestamp()));
                if (log.isTraceEnabled()) {
                    log.trace("Inserted: " + object);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.cache.unlock(object);
        }
    }

    public void evict(Object object) throws CacheException {
    }

    public boolean insert(Object object, Object object2, Object object3) {
        return false;
    }

    public boolean update(Object object, Object object2, Object object3, Object object4) {
        return false;
    }

    private boolean isUnlockable(SoftLock softLock, Lockable lockable) throws CacheException {
        return lockable != null && lockable.isLock() && softLock != null && ((Lock)softLock).getId() == ((Lock)lockable).getId();
    }

    public String toString() {
        return this.cache + "(read-write)";
    }

    public static final class Lock
    implements Serializable,
    Lockable,
    SoftLock {
        private long unlockTimestamp = -1L;
        private int multiplicity = 1;
        private boolean concurrentLock = false;
        private long timeout;
        private final int id;
        private final Object version;

        public Lock(long l, int n, Object object) {
            this.timeout = l;
            this.id = n;
            this.version = object;
        }

        public long getUnlockTimestamp() {
            return this.unlockTimestamp;
        }

        public Lock lock(long l, int n) {
            this.concurrentLock = true;
            ++this.multiplicity;
            this.timeout = l;
            return this;
        }

        public void unlock(long l) {
            if (--this.multiplicity == 0) {
                this.unlockTimestamp = l;
            }
        }

        public boolean isPuttable(long l, Object object, Comparator comparator) {
            if (this.timeout < l) {
                return true;
            }
            if (this.multiplicity > 0) {
                return false;
            }
            return this.version == null ? this.unlockTimestamp < l : comparator.compare(this.version, object) < 0;
        }

        public boolean wasLockedConcurrently() {
            return this.concurrentLock;
        }

        public boolean isLock() {
            return true;
        }

        public boolean isGettable(long l) {
            return false;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return "Lock{id=" + this.id + ",version=" + this.version + ",multiplicity=" + this.multiplicity + ",unlockTimestamp=" + this.unlockTimestamp;
        }
    }

    public static final class Item
    implements Serializable,
    Lockable {
        private final long freshTimestamp;
        private final Object value;
        private final Object version;

        public Item(Object object, Object object2, long l) {
            this.value = object;
            this.version = object2;
            this.freshTimestamp = l;
        }

        public long getFreshTimestamp() {
            return this.freshTimestamp;
        }

        public Object getValue() {
            return this.value;
        }

        public Lock lock(long l, int n) {
            return new Lock(l, n, this.version);
        }

        public boolean isLock() {
            return false;
        }

        public boolean isGettable(long l) {
            return this.freshTimestamp < l;
        }

        public boolean isPuttable(long l, Object object, Comparator comparator) {
            return this.version != null && comparator.compare(this.version, object) < 0;
        }

        public String toString() {
            return "Item{version=" + this.version + ",freshTimestamp=" + this.freshTimestamp;
        }
    }

    public static interface Lockable {
        public Lock lock(long var1, int var3);

        public boolean isLock();

        public boolean isGettable(long var1);

        public boolean isPuttable(long var1, Object var3, Comparator var4);
    }
}

