/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.persistence.EntityNotFoundException;
import org.hibernate.HibernateException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.QueryCache;
import org.hibernate.cache.QueryKey;
import org.hibernate.cache.QueryResultsRegion;
import org.hibernate.cache.UpdateTimestampsCache;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardQueryCache
implements QueryCache {
    private static final Logger log = LoggerFactory.getLogger(StandardQueryCache.class);
    private QueryResultsRegion cacheRegion;
    private UpdateTimestampsCache updateTimestampsCache;

    public void clear() throws CacheException {
        this.cacheRegion.evictAll();
    }

    public StandardQueryCache(Settings settings, Properties properties, UpdateTimestampsCache updateTimestampsCache, String string) throws HibernateException {
        String string2;
        if (string == null) {
            string = StandardQueryCache.class.getName();
        }
        if ((string2 = settings.getCacheRegionPrefix()) != null) {
            string = string2 + '.' + string;
        }
        log.info("starting query cache at region: " + string);
        this.cacheRegion = settings.getRegionFactory().buildQueryResultsRegion(string, properties);
        this.updateTimestampsCache = updateTimestampsCache;
    }

    public boolean put(QueryKey queryKey, Type[] typeArray, List list, boolean bl, SessionImplementor sessionImplementor) throws HibernateException {
        if (bl && list.size() == 0) {
            return false;
        }
        Long l = new Long(sessionImplementor.getFactory().getSettings().getRegionFactory().nextTimestamp());
        if (log.isDebugEnabled()) {
            log.debug("caching query results in region: " + this.cacheRegion.getName() + "; timestamp=" + l);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size() + 1);
        arrayList.add(l);
        for (Object e : list) {
            if (typeArray.length == 1) {
                arrayList.add(typeArray[0].disassemble(e, sessionImplementor, null));
                continue;
            }
            arrayList.add(TypeHelper.disassemble((Object[])e, typeArray, null, sessionImplementor, null));
        }
        this.cacheRegion.put(queryKey, arrayList);
        return true;
    }

    public List get(QueryKey queryKey, Type[] typeArray, boolean bl, Set set, SessionImplementor sessionImplementor) throws HibernateException {
        List list;
        if (log.isDebugEnabled()) {
            log.debug("checking cached query results in region: " + this.cacheRegion.getName());
        }
        if ((list = (List)this.cacheRegion.get(queryKey)) == null) {
            log.debug("query results were not found in cache");
            return null;
        }
        Long l = (Long)list.get(0);
        if (!bl && !this.isUpToDate(set, l)) {
            log.debug("cached query results were not up to date");
            return null;
        }
        log.debug("returning cached query results");
        for (int i = 1; i < list.size(); ++i) {
            if (typeArray.length == 1) {
                typeArray[0].beforeAssemble((Serializable)list.get(i), sessionImplementor);
                continue;
            }
            TypeHelper.beforeAssemble((Serializable[])list.get(i), typeArray, sessionImplementor);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size() - 1);
        for (int i = 1; i < list.size(); ++i) {
            try {
                if (typeArray.length == 1) {
                    arrayList.add(typeArray[0].assemble((Serializable)list.get(i), sessionImplementor, null));
                    continue;
                }
                arrayList.add(TypeHelper.assemble((Serializable[])list.get(i), typeArray, sessionImplementor, null));
                continue;
            }
            catch (RuntimeException runtimeException) {
                if (bl && (UnresolvableObjectException.class.isInstance(runtimeException) || EntityNotFoundException.class.isInstance(runtimeException))) {
                    log.debug("could not reassemble cached result set");
                    this.cacheRegion.evict(queryKey);
                    return null;
                }
                throw runtimeException;
            }
        }
        return arrayList;
    }

    protected boolean isUpToDate(Set set, Long l) {
        if (log.isDebugEnabled()) {
            log.debug("Checking query spaces for up-to-dateness: " + set);
        }
        return this.updateTimestampsCache.isUpToDate(set, l);
    }

    public void destroy() {
        try {
            this.cacheRegion.destroy();
        }
        catch (Exception exception) {
            log.warn("could not destroy query cache: " + this.cacheRegion.getName(), exception);
        }
    }

    public QueryResultsRegion getRegion() {
        return this.cacheRegion;
    }

    public String toString() {
        return "StandardQueryCache(" + this.cacheRegion.getName() + ')';
    }
}

