/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Comparator;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.OptimisticCache;
import org.hibernate.cache.access.SoftLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalCache
implements CacheConcurrencyStrategy {
    private static final Logger log = LoggerFactory.getLogger(TransactionalCache.class);
    private Cache cache;

    public String getRegionName() {
        return this.cache.getRegionName();
    }

    public Object get(Object object, long l) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("cache lookup: " + object);
        }
        Object object2 = this.cache.read(object);
        if (log.isDebugEnabled()) {
            log.debug(object2 == null ? "cache miss" : "cache hit");
        }
        return object2;
    }

    public boolean put(Object object, Object object2, long l, Object object3, Comparator comparator, boolean bl) throws CacheException {
        if (bl && this.cache.read(object) != null) {
            if (log.isDebugEnabled()) {
                log.debug("item already cached: " + object);
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("caching: " + object);
        }
        if (this.cache instanceof OptimisticCache) {
            ((OptimisticCache)this.cache).writeLoad(object, object2, object3);
        } else {
            this.cache.put(object, object2);
        }
        return true;
    }

    public SoftLock lock(Object object, Object object2) throws CacheException {
        return null;
    }

    public void release(Object object, SoftLock softLock) throws CacheException {
    }

    public boolean update(Object object, Object object2, Object object3, Object object4) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("updating: " + object);
        }
        if (this.cache instanceof OptimisticCache) {
            ((OptimisticCache)this.cache).writeUpdate(object, object2, object3, object4);
        } else {
            this.cache.update(object, object2);
        }
        return true;
    }

    public boolean insert(Object object, Object object2, Object object3) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("inserting: " + object);
        }
        if (this.cache instanceof OptimisticCache) {
            ((OptimisticCache)this.cache).writeInsert(object, object2, object3);
        } else {
            this.cache.update(object, object2);
        }
        return true;
    }

    public void evict(Object object) throws CacheException {
        this.cache.remove(object);
    }

    public void remove(Object object) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("removing: " + object);
        }
        this.cache.remove(object);
    }

    public void clear() throws CacheException {
        log.debug("clearing");
        this.cache.clear();
    }

    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception exception) {
            log.warn("could not destroy cache", exception);
        }
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    public boolean afterInsert(Object object, Object object2, Object object3) throws CacheException {
        return false;
    }

    public boolean afterUpdate(Object object, Object object2, Object object3, SoftLock softLock) throws CacheException {
        return false;
    }

    public String toString() {
        return this.cache + "(transactional)";
    }
}

