/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.Serializable;
import java.util.Properties;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.TimestampsRegion;
import org.hibernate.cfg.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateTimestampsCache {
    public static final String REGION_NAME = UpdateTimestampsCache.class.getName();
    private static final Logger log = LoggerFactory.getLogger(UpdateTimestampsCache.class);
    private final TimestampsRegion region;

    public UpdateTimestampsCache(Settings settings, Properties properties) throws HibernateException {
        String string = settings.getCacheRegionPrefix();
        String string2 = string == null ? REGION_NAME : string + '.' + REGION_NAME;
        log.info("starting update timestamps cache at region: " + string2);
        this.region = settings.getRegionFactory().buildTimestampsRegion(string2, properties);
    }

    public synchronized void preinvalidate(Serializable[] serializableArray) throws CacheException {
        Long l = new Long(this.region.nextTimestamp() + (long)this.region.getTimeout());
        for (int i = 0; i < serializableArray.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug("Pre-invalidating space [" + serializableArray[i] + "]");
            }
            this.region.put(serializableArray[i], l);
        }
    }

    public synchronized void invalidate(Serializable[] serializableArray) throws CacheException {
        Long l = new Long(this.region.nextTimestamp());
        for (int i = 0; i < serializableArray.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug("Invalidating space [" + serializableArray[i] + "], timestamp: " + l);
            }
            this.region.put(serializableArray[i], l);
        }
    }

    public synchronized boolean isUpToDate(Set set, Long l) throws HibernateException {
        for (Serializable serializable : set) {
            Long l2 = (Long)this.region.get(serializable);
            if (l2 == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("[" + serializable + "] last update timestamp: " + l2 + ", result set timestamp: " + l);
            }
            if (l2 < l) continue;
            return false;
        }
        return true;
    }

    public void clear() throws CacheException {
        this.region.evictAll();
    }

    public void destroy() {
        try {
            this.region.destroy();
        }
        catch (Exception exception) {
            log.warn("could not destroy UpdateTimestamps cache", exception);
        }
    }

    public TimestampsRegion getRegion() {
        return this.region;
    }

    public String toString() {
        return "UpdateTimestampeCache";
    }
}

