/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.impl.bridge;

import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CollectionRegion;
import org.hibernate.cache.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.access.SoftLock;
import org.hibernate.cfg.Settings;

public class CollectionAccessStrategyAdapter
implements CollectionRegionAccessStrategy {
    private final CollectionRegion region;
    private final CacheConcurrencyStrategy ccs;
    private final Settings settings;

    public CollectionAccessStrategyAdapter(CollectionRegion collectionRegion, CacheConcurrencyStrategy cacheConcurrencyStrategy, Settings settings) {
        this.region = collectionRegion;
        this.ccs = cacheConcurrencyStrategy;
        this.settings = settings;
    }

    public CollectionRegion getRegion() {
        return this.region;
    }

    public Object get(Object object, long l) throws CacheException {
        return this.ccs.get(object, l);
    }

    public boolean putFromLoad(Object object, Object object2, long l, Object object3) throws CacheException {
        return this.putFromLoad(object, object2, l, object3, this.settings.isMinimalPutsEnabled());
    }

    public boolean putFromLoad(Object object, Object object2, long l, Object object3, boolean bl) throws CacheException {
        return this.ccs.put(object, object2, l, object3, this.region.getCacheDataDescription().getVersionComparator(), bl);
    }

    public SoftLock lockItem(Object object, Object object2) throws CacheException {
        return this.ccs.lock(object, object2);
    }

    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    public void unlockItem(Object object, SoftLock softLock) throws CacheException {
        this.ccs.release(object, softLock);
    }

    public void unlockRegion(SoftLock softLock) throws CacheException {
        if (!this.region.isTransactionAware()) {
            this.ccs.clear();
        }
    }

    public void remove(Object object) throws CacheException {
        this.ccs.evict(object);
    }

    public void removeAll() throws CacheException {
        this.ccs.clear();
    }

    public void evict(Object object) throws CacheException {
        this.ccs.remove(object);
    }

    public void evictAll() throws CacheException {
        this.ccs.clear();
    }

    public void destroy() {
        this.ccs.destroy();
    }
}

