/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.impl.bridge;

import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheDataDescription;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CollectionRegion;
import org.hibernate.cache.NonstrictReadWriteCache;
import org.hibernate.cache.OptimisticCache;
import org.hibernate.cache.ReadOnlyCache;
import org.hibernate.cache.ReadWriteCache;
import org.hibernate.cache.TransactionalCache;
import org.hibernate.cache.access.AccessType;
import org.hibernate.cache.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.impl.bridge.BaseTransactionalDataRegionAdapter;
import org.hibernate.cache.impl.bridge.CollectionAccessStrategyAdapter;
import org.hibernate.cache.impl.bridge.OptimisticCacheSourceAdapter;
import org.hibernate.cfg.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionRegionAdapter
extends BaseTransactionalDataRegionAdapter
implements CollectionRegion {
    private static final Logger log = LoggerFactory.getLogger(CollectionRegionAdapter.class);

    public CollectionRegionAdapter(Cache cache, Settings settings, CacheDataDescription cacheDataDescription) {
        super(cache, settings, cacheDataDescription);
        if (cache instanceof OptimisticCache) {
            ((OptimisticCache)cache).setSource(new OptimisticCacheSourceAdapter(cacheDataDescription));
        }
    }

    public CollectionRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        CacheConcurrencyStrategy cacheConcurrencyStrategy;
        if (AccessType.READ_ONLY.equals(accessType)) {
            if (this.metadata.isMutable()) {
                log.warn("read-only cache configured for mutable collection [" + this.getName() + "]");
            }
            cacheConcurrencyStrategy = new ReadOnlyCache();
        } else if (AccessType.READ_WRITE.equals(accessType)) {
            cacheConcurrencyStrategy = new ReadWriteCache();
        } else if (AccessType.NONSTRICT_READ_WRITE.equals(accessType)) {
            cacheConcurrencyStrategy = new NonstrictReadWriteCache();
        } else if (AccessType.TRANSACTIONAL.equals(accessType)) {
            cacheConcurrencyStrategy = new TransactionalCache();
        } else {
            throw new IllegalArgumentException("unrecognized access strategy type [" + accessType + "]");
        }
        cacheConcurrencyStrategy.setCache(this.underlyingCache);
        return new CollectionAccessStrategyAdapter(this, cacheConcurrencyStrategy, this.settings);
    }
}

