/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.impl.bridge;

import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.EntityRegion;
import org.hibernate.cache.access.EntityRegionAccessStrategy;
import org.hibernate.cache.access.SoftLock;
import org.hibernate.cfg.Settings;

public class EntityAccessStrategyAdapter
implements EntityRegionAccessStrategy {
    private final EntityRegion region;
    private final CacheConcurrencyStrategy ccs;
    private final Settings settings;

    public EntityAccessStrategyAdapter(EntityRegion entityRegion, CacheConcurrencyStrategy cacheConcurrencyStrategy, Settings settings) {
        this.region = entityRegion;
        this.ccs = cacheConcurrencyStrategy;
        this.settings = settings;
    }

    public EntityRegion getRegion() {
        return this.region;
    }

    public Object get(Object object, long l) throws CacheException {
        return this.ccs.get(object, l);
    }

    public boolean putFromLoad(Object object, Object object2, long l, Object object3) throws CacheException {
        return this.putFromLoad(object, object2, l, object3, this.settings.isMinimalPutsEnabled());
    }

    public boolean putFromLoad(Object object, Object object2, long l, Object object3, boolean bl) throws CacheException {
        return this.ccs.put(object, object2, l, object3, this.region.getCacheDataDescription().getVersionComparator(), bl);
    }

    public SoftLock lockItem(Object object, Object object2) throws CacheException {
        return this.ccs.lock(object, object2);
    }

    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    public void unlockItem(Object object, SoftLock softLock) throws CacheException {
        this.ccs.release(object, softLock);
    }

    public void unlockRegion(SoftLock softLock) throws CacheException {
        if (!this.region.isTransactionAware()) {
            this.ccs.clear();
        }
    }

    public boolean insert(Object object, Object object2, Object object3) throws CacheException {
        return this.ccs.insert(object, object2, object3);
    }

    public boolean afterInsert(Object object, Object object2, Object object3) throws CacheException {
        return this.ccs.afterInsert(object, object2, object3);
    }

    public boolean update(Object object, Object object2, Object object3, Object object4) throws CacheException {
        return this.ccs.update(object, object2, object3, object4);
    }

    public boolean afterUpdate(Object object, Object object2, Object object3, Object object4, SoftLock softLock) throws CacheException {
        return this.ccs.afterUpdate(object, object2, object3, softLock);
    }

    public void remove(Object object) throws CacheException {
        this.ccs.evict(object);
    }

    public void removeAll() throws CacheException {
        this.ccs.clear();
    }

    public void evict(Object object) throws CacheException {
        this.ccs.remove(object);
    }

    public void evictAll() throws CacheException {
        this.ccs.clear();
    }

    public void destroy() {
        this.ccs.destroy();
    }
}

