/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.impl.bridge;

import java.util.Properties;
import org.hibernate.cache.CacheDataDescription;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.CollectionRegion;
import org.hibernate.cache.EntityRegion;
import org.hibernate.cache.NoCacheProvider;
import org.hibernate.cache.QueryResultsRegion;
import org.hibernate.cache.RegionFactory;
import org.hibernate.cache.TimestampsRegion;
import org.hibernate.cache.access.AccessType;
import org.hibernate.cache.impl.bridge.CollectionRegionAdapter;
import org.hibernate.cache.impl.bridge.EntityRegionAdapter;
import org.hibernate.cache.impl.bridge.QueryResultsRegionAdapter;
import org.hibernate.cache.impl.bridge.TimestampsRegionAdapter;
import org.hibernate.cfg.Settings;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionFactoryCacheProviderBridge
implements RegionFactory {
    public static final String DEF_PROVIDER = NoCacheProvider.class.getName();
    private static final Logger log = LoggerFactory.getLogger(RegionFactoryCacheProviderBridge.class);
    private CacheProvider cacheProvider;
    private Settings settings;

    public RegionFactoryCacheProviderBridge(Properties properties) {
        String string = PropertiesHelper.getString("hibernate.cache.provider_class", properties, DEF_PROVIDER);
        log.info("Cache provider: " + string);
        try {
            this.cacheProvider = (CacheProvider)ReflectHelper.classForName(string).newInstance();
        }
        catch (Exception exception) {
            throw new CacheException("could not instantiate CacheProvider [" + string + "]", exception);
        }
    }

    public void start(Settings settings, Properties properties) throws CacheException {
        this.settings = settings;
        this.cacheProvider.start(properties);
    }

    public void stop() {
        this.cacheProvider.stop();
        this.cacheProvider = null;
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return this.cacheProvider.isMinimalPutsEnabledByDefault();
    }

    public AccessType getDefaultAccessType() {
        return null;
    }

    public long nextTimestamp() {
        return this.cacheProvider.nextTimestamp();
    }

    public CacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    public EntityRegion buildEntityRegion(String string, Properties properties, CacheDataDescription cacheDataDescription) throws CacheException {
        return new EntityRegionAdapter(this.cacheProvider.buildCache(string, properties), this.settings, cacheDataDescription);
    }

    public CollectionRegion buildCollectionRegion(String string, Properties properties, CacheDataDescription cacheDataDescription) throws CacheException {
        return new CollectionRegionAdapter(this.cacheProvider.buildCache(string, properties), this.settings, cacheDataDescription);
    }

    public QueryResultsRegion buildQueryResultsRegion(String string, Properties properties) throws CacheException {
        return new QueryResultsRegionAdapter(this.cacheProvider.buildCache(string, properties), this.settings);
    }

    public TimestampsRegion buildTimestampsRegion(String string, Properties properties) throws CacheException {
        return new TimestampsRegionAdapter(this.cacheProvider.buildCache(string, properties), this.settings);
    }
}

