/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.AnyMetaDefs;
import org.hibernate.annotations.MetaValue;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XPackage;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.Nullability;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.id.MultipleHiLoPerTableGenerator;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.IdGenerator;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SyntheticProperty;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinderHelper {
    public static final String ANNOTATION_STRING_DEFAULT = "";
    private static Logger log = LoggerFactory.getLogger(BinderHelper.class);
    public static final Set<String> PRIMITIVE_NAMES;

    private BinderHelper() {
    }

    public static Property shallowCopy(Property property) {
        Property property2 = new Property();
        property2.setCascade(property.getCascade());
        property2.setInsertable(property.isInsertable());
        property2.setLazy(property.isLazy());
        property2.setName(property.getName());
        property2.setNodeName(property.getNodeName());
        property2.setNaturalIdentifier(property.isNaturalIdentifier());
        property2.setOptimisticLocked(property.isOptimisticLocked());
        property2.setOptional(property.isOptional());
        property2.setPersistentClass(property.getPersistentClass());
        property2.setPropertyAccessorName(property.getPropertyAccessorName());
        property2.setSelectable(property.isSelectable());
        property2.setUpdateable(property.isUpdateable());
        property2.setValue(property.getValue());
        return property2;
    }

    public static void createSyntheticPropertyReference(Ejb3JoinColumn[] ejb3JoinColumnArray, PersistentClass persistentClass, PersistentClass persistentClass2, Value value, boolean bl, Mappings mappings) {
        PersistentClass persistentClass3;
        if (ejb3JoinColumnArray[0].isImplicit() || StringHelper.isNotEmpty(ejb3JoinColumnArray[0].getMappedBy())) {
            return;
        }
        int n = Ejb3JoinColumn.checkReferencedColumnsType(ejb3JoinColumnArray, persistentClass, mappings);
        PersistentClass persistentClass4 = persistentClass3 = ejb3JoinColumnArray[0].getPropertyHolder() != null ? ejb3JoinColumnArray[0].getPropertyHolder().getPersistentClass() : null;
        if (2 == n) {
            Component component;
            StringBuilder stringBuilder = new StringBuilder("_");
            stringBuilder.append(persistentClass3.getEntityName().replace('.', '_'));
            stringBuilder.append("_").append(ejb3JoinColumnArray[0].getPropertyName());
            String string = stringBuilder.toString();
            Object object = BinderHelper.findColumnOwner(persistentClass, ejb3JoinColumnArray[0].getReferencedColumn(), mappings);
            List<Property> list = BinderHelper.findPropertiesByColumns(object, ejb3JoinColumnArray, mappings);
            SyntheticProperty syntheticProperty = null;
            if (list != null) {
                component = object instanceof PersistentClass ? new Component(mappings, (PersistentClass)object) : new Component(mappings, (Join)object);
                component.setEmbedded(true);
                component.setNodeName(string);
                component.setComponentClassName(component.getOwner().getClassName());
                for (Property property : list) {
                    Property property2 = BinderHelper.shallowCopy(property);
                    property2.setInsertable(false);
                    property2.setUpdateable(false);
                    property2.setNaturalIdentifier(false);
                    property2.setGeneration(property.getGeneration());
                    component.addProperty(property2);
                }
            } else {
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append("referencedColumnNames(");
                for (Ejb3JoinColumn ejb3JoinColumn : ejb3JoinColumnArray) {
                    stringBuilder2.append(ejb3JoinColumn.getReferencedColumn()).append(", ");
                }
                stringBuilder2.setLength(stringBuilder2.length() - 2);
                stringBuilder2.append(") ");
                if (persistentClass2 != null) {
                    stringBuilder2.append("of ").append(persistentClass2.getEntityName()).append(".").append(ejb3JoinColumnArray[0].getPropertyName()).append(" ");
                } else if (ejb3JoinColumnArray[0].getPropertyHolder() != null) {
                    stringBuilder2.append("of ").append(ejb3JoinColumnArray[0].getPropertyHolder().getEntityName()).append(".").append(ejb3JoinColumnArray[0].getPropertyName()).append(" ");
                }
                stringBuilder2.append("referencing ").append(persistentClass.getEntityName()).append(" not mapped to a single property");
                throw new AnnotationException(stringBuilder2.toString());
            }
            syntheticProperty = new SyntheticProperty();
            syntheticProperty.setName(string);
            syntheticProperty.setNodeName(string);
            syntheticProperty.setPersistentClass(persistentClass);
            syntheticProperty.setUpdateable(false);
            syntheticProperty.setInsertable(false);
            syntheticProperty.setValue(component);
            syntheticProperty.setPropertyAccessorName("embedded");
            persistentClass.addProperty(syntheticProperty);
            TableBinder.createUniqueConstraint(component);
            if (value instanceof ToOne) {
                ((ToOne)value).setReferencedPropertyName(string);
                mappings.addUniquePropertyReference(persistentClass.getEntityName(), string);
            } else if (value instanceof Collection) {
                ((Collection)value).setReferencedPropertyName(string);
                mappings.addPropertyReference(persistentClass.getEntityName(), string);
            } else {
                throw new AssertionFailure("Do a property ref on an unexpected Value type: " + value.getClass().getName());
            }
            mappings.addPropertyReferencedAssociation((bl ? "inverse__" : ANNOTATION_STRING_DEFAULT) + persistentClass3.getEntityName(), ejb3JoinColumnArray[0].getPropertyName(), string);
        }
    }

    private static List<Property> findPropertiesByColumns(Object object, Ejb3JoinColumn[] ejb3JoinColumnArray, Mappings mappings) {
        Iterator iterator;
        HashMap<Column, Set<Property>> hashMap = new HashMap<Column, Set<Property>>();
        ArrayList<Column> arrayList = new ArrayList<Column>(ejb3JoinColumnArray.length);
        Table table = null;
        if (object instanceof PersistentClass) {
            table = ((PersistentClass)object).getTable();
        } else if (object instanceof Join) {
            table = ((Join)object).getTable();
        } else {
            throw new AssertionFailure(object == null ? "columnOwner is null" : "columnOwner neither PersistentClass nor Join: " + object.getClass());
        }
        for (Ejb3JoinColumn ejb3JoinColumn : ejb3JoinColumnArray) {
            Column column = new Column(mappings.getPhysicalColumnName(ejb3JoinColumn.getReferencedColumn(), table));
            arrayList.add(column);
            hashMap.put(column, new HashSet());
        }
        boolean bl = object instanceof PersistentClass;
        Iterator iterator2 = iterator = bl ? ((PersistentClass)object).getPropertyIterator() : ((Join)object).getPropertyIterator();
        while (iterator.hasNext()) {
            BinderHelper.matchColumnsByProperty((Property)iterator.next(), hashMap);
        }
        if (bl) {
            BinderHelper.matchColumnsByProperty(((PersistentClass)object).getIdentifierProperty(), hashMap);
        }
        ArrayList<Property> arrayList2 = new ArrayList<Property>();
        for (Column column : arrayList) {
            boolean bl2 = false;
            for (Property property : (Set)hashMap.get(column)) {
                if (property.getColumnSpan() != 1) continue;
                arrayList2.add(property);
                bl2 = true;
                break;
            }
            if (bl2) continue;
            return null;
        }
        return arrayList2;
    }

    private static void matchColumnsByProperty(Property property, Map<Column, Set<Property>> map) {
        if (property == null) {
            return;
        }
        if ("noop".equals(property.getPropertyAccessorName()) || "embedded".equals(property.getPropertyAccessorName())) {
            return;
        }
        Iterator iterator = property.getColumnIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!map.containsKey(e)) continue;
            map.get(e).add(property);
        }
    }

    public static Property findPropertyByName(PersistentClass persistentClass, String string) {
        Property property = null;
        Property property2 = persistentClass.getIdentifierProperty();
        String string2 = property2 != null ? property2.getName() : null;
        try {
            if (string == null || string.length() == 0 || string.equals(string2)) {
                property = property2;
            } else {
                if (string.indexOf(string2 + ".") == 0) {
                    property = property2;
                    string = string.substring(string2.length() + 1);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
                while (stringTokenizer.hasMoreElements()) {
                    String string3 = (String)stringTokenizer.nextElement();
                    if (property == null) {
                        property = persistentClass.getProperty(string3);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(string3);
                }
            }
        }
        catch (MappingException mappingException) {
            try {
                if (persistentClass.getIdentifierMapper() == null) {
                    return null;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
                while (stringTokenizer.hasMoreElements()) {
                    String string4 = (String)stringTokenizer.nextElement();
                    if (property == null) {
                        property = persistentClass.getIdentifierMapper().getProperty(string4);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(string4);
                }
            }
            catch (MappingException mappingException2) {
                return null;
            }
        }
        return property;
    }

    public static Property findPropertyByName(Component component, String string) {
        Property property = null;
        try {
            if (string == null || string.length() == 0) {
                return null;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
            while (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                if (property == null) {
                    property = component.getProperty(string2);
                    continue;
                }
                if (!property.isComposite()) {
                    return null;
                }
                property = ((Component)property.getValue()).getProperty(string2);
            }
        }
        catch (MappingException mappingException) {
            try {
                if (component.getOwner().getIdentifierMapper() == null) {
                    return null;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
                while (stringTokenizer.hasMoreElements()) {
                    String string3 = (String)stringTokenizer.nextElement();
                    if (property == null) {
                        property = component.getOwner().getIdentifierMapper().getProperty(string3);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(string3);
                }
            }
            catch (MappingException mappingException2) {
                return null;
            }
        }
        return property;
    }

    public static String getRelativePath(PropertyHolder propertyHolder, String string) {
        if (propertyHolder == null) {
            return string;
        }
        String string2 = propertyHolder.getPath();
        String string3 = propertyHolder.getPersistentClass().getEntityName();
        if (string2.length() == string3.length()) {
            return string;
        }
        return StringHelper.qualify(string2.substring(string3.length() + 1), string);
    }

    public static Object findColumnOwner(PersistentClass persistentClass, String string, Mappings mappings) {
        PersistentClass persistentClass2;
        if (StringHelper.isEmpty(string)) {
            return persistentClass;
        }
        PersistentClass persistentClass3 = persistentClass;
        boolean bl = false;
        do {
            persistentClass2 = persistentClass3;
            Table table = persistentClass3.getTable();
            try {
                mappings.getPhysicalColumnName(string, table);
                bl = true;
            }
            catch (MappingException mappingException) {
                // empty catch block
            }
            Iterator iterator = persistentClass3.getJoinIterator();
            while (!bl && iterator.hasNext()) {
                persistentClass2 = iterator.next();
                table = ((Join)((Object)persistentClass2)).getTable();
                try {
                    mappings.getPhysicalColumnName(string, table);
                    bl = true;
                }
                catch (MappingException mappingException) {}
            }
            persistentClass3 = persistentClass3.getSuperclass();
        } while (!bl && persistentClass3 != null);
        return bl ? persistentClass2 : null;
    }

    public static void makeIdGenerator(SimpleValue simpleValue, String string, String string2, Mappings mappings, Map<String, IdGenerator> map) {
        Table table = simpleValue.getTable();
        table.setIdentifierValue(simpleValue);
        simpleValue.setIdentifierGeneratorStrategy(string);
        Properties properties = new Properties();
        properties.setProperty("target_table", table.getName());
        if (simpleValue.getColumnSpan() == 1) {
            properties.setProperty("target_column", ((Column)simpleValue.getColumnIterator().next()).getName());
        }
        properties.put("identifier_normalizer", mappings.getObjectNameNormalizer());
        if (!BinderHelper.isEmptyAnnotationValue(string2)) {
            boolean bl;
            IdGenerator idGenerator = mappings.getGenerator(string2, map);
            if (idGenerator == null) {
                throw new AnnotationException("Unknown Id.generator: " + string2);
            }
            String string3 = idGenerator.getIdentifierGeneratorStrategy();
            boolean bl2 = bl = string3.equals("identity") || string3.equals("seqhilo") || string3.equals(MultipleHiLoPerTableGenerator.class.getName());
            if (string == null || !bl) {
                simpleValue.setIdentifierGeneratorStrategy(string3);
            }
            for (Map.Entry<Object, Object> entry : idGenerator.getParams().entrySet()) {
                properties.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if ("assigned".equals(string)) {
            simpleValue.setNullValue("undefined");
        }
        simpleValue.setIdentifierGeneratorProperties(properties);
    }

    public static boolean isEmptyAnnotationValue(String string) {
        return string != null && string.length() == 0;
    }

    public static Any buildAnyValue(String string, Ejb3JoinColumn[] ejb3JoinColumnArray, javax.persistence.Column column, PropertyData propertyData, boolean bl, Nullability nullability, PropertyHolder propertyHolder, EntityBinder entityBinder, boolean bl2, Mappings mappings) {
        Ejb3Column[] ejb3ColumnArray;
        Any any = new Any(mappings, ejb3JoinColumnArray[0].getTable());
        AnyMetaDef anyMetaDef = propertyData.getProperty().getAnnotation(AnyMetaDef.class);
        if (anyMetaDef != null) {
            BinderHelper.bindAnyMetaDefs(propertyData.getProperty(), mappings);
        } else {
            anyMetaDef = mappings.getAnyMetaDef(string);
        }
        if (anyMetaDef != null) {
            any.setIdentifierType(anyMetaDef.idType());
            any.setMetaType(anyMetaDef.metaType());
            ejb3ColumnArray = new HashMap();
            Type object = mappings.getTypeResolver().heuristicType(any.getMetaType());
            MetaValue[] metaValueArray = anyMetaDef.metaValues();
            int n = metaValueArray.length;
            for (int i = 0; i < n; ++i) {
                MetaValue metaValue = metaValueArray[i];
                try {
                    Object t = ((DiscriminatorType)object).stringToObject(metaValue.value());
                    String string2 = metaValue.targetEntity().getName();
                    ejb3ColumnArray.put(t, string2);
                    continue;
                }
                catch (ClassCastException classCastException) {
                    throw new MappingException("metaType was not a DiscriminatorType: " + object.getName());
                }
                catch (Exception exception) {
                    throw new MappingException("could not interpret metaValue", exception);
                }
            }
            if (!ejb3ColumnArray.isEmpty()) {
                any.setMetaValues((Map)ejb3ColumnArray);
            }
        } else {
            throw new AnnotationException("Unable to find @AnyMetaDef for an @(ManyTo)Any mapping: " + StringHelper.qualify(propertyHolder.getPath(), propertyData.getPropertyName()));
        }
        any.setCascadeDeleteEnabled(bl);
        if (!bl2) {
            ejb3ColumnArray = ejb3JoinColumnArray;
            int n = ejb3ColumnArray.length;
            for (int i = 0; i < n; ++i) {
                Ejb3JoinColumn ejb3JoinColumn = ejb3ColumnArray[i];
                ejb3JoinColumn.setNullable(false);
            }
        }
        for (Ejb3Column ejb3Column : ejb3ColumnArray = Ejb3Column.buildColumnFromAnnotation(new javax.persistence.Column[]{column}, null, nullability, propertyHolder, propertyData, entityBinder.getSecondaryTables(), mappings)) {
            ejb3Column.setTable(any.getTable());
        }
        for (Ejb3Column ejb3Column : ejb3ColumnArray) {
            ejb3Column.linkWithValue(any);
        }
        String string3 = propertyData.getPropertyName();
        Ejb3Column.checkPropertyConsistency(ejb3JoinColumnArray, propertyHolder.getEntityName() + string3);
        for (Ejb3JoinColumn ejb3JoinColumn : ejb3JoinColumnArray) {
            ejb3JoinColumn.linkWithValue(any);
        }
        return any;
    }

    public static void bindAnyMetaDefs(XAnnotatedElement xAnnotatedElement, Mappings mappings) {
        boolean bl;
        AnyMetaDef anyMetaDef = xAnnotatedElement.getAnnotation(AnyMetaDef.class);
        AnyMetaDefs anyMetaDefs = xAnnotatedElement.getAnnotation(AnyMetaDefs.class);
        boolean bl2 = bl = XClass.class.isAssignableFrom(xAnnotatedElement.getClass()) || XPackage.class.isAssignableFrom(xAnnotatedElement.getClass());
        if (anyMetaDef != null) {
            BinderHelper.checkAnyMetaDefValidity(bl, anyMetaDef, xAnnotatedElement);
            BinderHelper.bindAnyMetaDef(anyMetaDef, mappings);
        }
        if (anyMetaDefs != null) {
            for (AnyMetaDef anyMetaDef2 : anyMetaDefs.value()) {
                BinderHelper.checkAnyMetaDefValidity(bl, anyMetaDef2, xAnnotatedElement);
                BinderHelper.bindAnyMetaDef(anyMetaDef2, mappings);
            }
        }
    }

    private static void checkAnyMetaDefValidity(boolean bl, AnyMetaDef anyMetaDef, XAnnotatedElement xAnnotatedElement) {
        if (bl && BinderHelper.isEmptyAnnotationValue(anyMetaDef.name())) {
            String string = XClass.class.isAssignableFrom(xAnnotatedElement.getClass()) ? ((XClass)xAnnotatedElement).getName() : ((XPackage)xAnnotatedElement).getName();
            throw new AnnotationException("@AnyMetaDef.name cannot be null on an entity or a package: " + string);
        }
    }

    private static void bindAnyMetaDef(AnyMetaDef anyMetaDef, Mappings mappings) {
        if (BinderHelper.isEmptyAnnotationValue(anyMetaDef.name())) {
            return;
        }
        log.info("Binding Any Meta definition: {}", (Object)anyMetaDef.name());
        mappings.addAnyMetaDef(anyMetaDef);
    }

    public static MappedSuperclass getMappedSuperclassOrNull(XClass xClass, Map<XClass, InheritanceState> map, Mappings mappings) {
        boolean bl = false;
        if (xClass != null) {
            InheritanceState inheritanceState = map.get(xClass);
            if (inheritanceState == null) {
                throw new org.hibernate.annotations.common.AssertionFailure("Declaring class is not found in the inheritance state hierarchy: " + xClass);
            }
            if (inheritanceState.isEmbeddableSuperclass()) {
                bl = true;
            }
        }
        return bl ? mappings.getMappedSuperclass(mappings.getReflectionManager().toClass(xClass)) : null;
    }

    public static String getPath(PropertyHolder propertyHolder, PropertyData propertyData) {
        return StringHelper.qualify(propertyHolder.getPath(), propertyData.getPropertyName());
    }

    static PropertyData getPropertyOverriddenByMapperOrMapsId(boolean bl, PropertyHolder propertyHolder, String string, Mappings mappings) {
        XClass xClass;
        try {
            xClass = mappings.getReflectionManager().classForName(propertyHolder.getPersistentClass().getClassName(), AnnotationBinder.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionFailure("PersistentClass name cannot be converted into a Class", classNotFoundException);
        }
        if (propertyHolder.isInIdClass()) {
            PropertyData propertyData = mappings.getPropertyAnnotatedWithIdAndToOne(xClass, string);
            if (propertyData == null && mappings.isSpecjProprietarySyntaxEnabled()) {
                propertyData = mappings.getPropertyAnnotatedWithMapsId(xClass, string);
            }
            return propertyData;
        }
        String string2 = bl ? ANNOTATION_STRING_DEFAULT : string;
        return mappings.getPropertyAnnotatedWithMapsId(xClass, string2);
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(Byte.TYPE.getName());
        hashSet.add(Short.TYPE.getName());
        hashSet.add(Integer.TYPE.getName());
        hashSet.add(Long.TYPE.getName());
        hashSet.add(Float.TYPE.getName());
        hashSet.add(Double.TYPE.getName());
        hashSet.add(Character.TYPE.getName());
        hashSet.add(Boolean.TYPE.getName());
        PRIMITIVE_NAMES = Collections.unmodifiableSet(hashSet);
    }
}

