/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.SecondPass;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CollectionSecondPass
implements SecondPass {
    private static Logger log = LoggerFactory.getLogger(CollectionSecondPass.class);
    Mappings mappings;
    Collection collection;
    private Map localInheritedMetas;

    public CollectionSecondPass(Mappings mappings, Collection collection, Map map) {
        this.collection = collection;
        this.mappings = mappings;
        this.localInheritedMetas = map;
    }

    public CollectionSecondPass(Mappings mappings, Collection collection) {
        this(mappings, collection, Collections.EMPTY_MAP);
    }

    public void doSecondPass(Map map) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug("Second pass for collection: " + this.collection.getRole());
        }
        this.secondPass(map, this.localInheritedMetas);
        this.collection.createAllKeys();
        if (log.isDebugEnabled()) {
            String string = "Mapped collection key: " + CollectionSecondPass.columns(this.collection.getKey());
            if (this.collection.isIndexed()) {
                string = string + ", index: " + CollectionSecondPass.columns(((IndexedCollection)this.collection).getIndex());
            }
            string = this.collection.isOneToMany() ? string + ", one-to-many: " + ((OneToMany)this.collection.getElement()).getReferencedEntityName() : string + ", element: " + CollectionSecondPass.columns(this.collection.getElement());
            log.debug(string);
        }
    }

    public abstract void secondPass(Map var1, Map var2) throws MappingException;

    private static String columns(Value value) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = value.getColumnIterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Selectable)iterator.next()).getText());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }
}

