/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.MapsId;
import org.dom4j.Attribute;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.hibernate.AnnotationException;
import org.hibernate.DuplicateMappingException;
import org.hibernate.EmptyInterceptor;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.InvalidMappingException;
import org.hibernate.MappingException;
import org.hibernate.MappingNotFoundException;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.common.reflection.MetadataProvider;
import org.hibernate.annotations.common.reflection.MetadataProviderInjector;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.CopyIdentifierComponentSecondPass;
import org.hibernate.cfg.CreateKeySecondPass;
import org.hibernate.cfg.EJB3DTDEntityResolver;
import org.hibernate.cfg.EJB3NamingStrategy;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.ExtendsQueueEntry;
import org.hibernate.cfg.FkSecondPass;
import org.hibernate.cfg.HbmBinder;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.MetadataSourceType;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.cfg.PkDrivenByDefaultMapsIdSecondPass;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.QuerySecondPass;
import org.hibernate.cfg.RecoverableException;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.SecondaryTableSecondPass;
import org.hibernate.cfg.SetSimpleValueTypeSecondPass;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.cfg.UniqueConstraintHolder;
import org.hibernate.cfg.annotations.reflection.JPAMetadataProvider;
import org.hibernate.cfg.beanvalidation.BeanValidationActivator;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.event.AutoFlushEventListener;
import org.hibernate.event.DeleteEventListener;
import org.hibernate.event.DirtyCheckEventListener;
import org.hibernate.event.EventListeners;
import org.hibernate.event.EvictEventListener;
import org.hibernate.event.FlushEntityEventListener;
import org.hibernate.event.FlushEventListener;
import org.hibernate.event.InitializeCollectionEventListener;
import org.hibernate.event.LoadEventListener;
import org.hibernate.event.LockEventListener;
import org.hibernate.event.MergeEventListener;
import org.hibernate.event.PersistEventListener;
import org.hibernate.event.PostCollectionRecreateEventListener;
import org.hibernate.event.PostCollectionRemoveEventListener;
import org.hibernate.event.PostCollectionUpdateEventListener;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreCollectionRecreateEventListener;
import org.hibernate.event.PreCollectionRemoveEventListener;
import org.hibernate.event.PreCollectionUpdateEventListener;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.event.PreLoadEventListener;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.event.RefreshEventListener;
import org.hibernate.event.ReplicateEventListener;
import org.hibernate.event.SaveOrUpdateEventListener;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentifierGeneratorAggregator;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.factory.DefaultIdentifierGeneratorFactory;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.mapping.AuxiliaryDatabaseObject;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.DenormalizedTable;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.Filterable;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.IdGenerator;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.MetadataSource;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RelationalModel;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.TypeDef;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.secure.JACCConfiguration;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.IndexMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.hibernate.tuple.entity.EntityTuplizerFactory;
import org.hibernate.type.BasicType;
import org.hibernate.type.SerializationException;
import org.hibernate.type.Type;
import org.hibernate.type.TypeResolver;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserType;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.ConfigHelper;
import org.hibernate.util.JoinedIterator;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.SerializationHelper;
import org.hibernate.util.StringHelper;
import org.hibernate.util.XMLHelper;
import org.hibernate.util.xml.MappingReader;
import org.hibernate.util.xml.Origin;
import org.hibernate.util.xml.OriginImpl;
import org.hibernate.util.xml.XmlDocument;
import org.hibernate.util.xml.XmlDocumentImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements Serializable {
    private static Logger log = LoggerFactory.getLogger(Configuration.class);
    public static final String DEFAULT_CACHE_CONCURRENCY_STRATEGY = "hibernate.cache.default_cache_concurrency_strategy";
    public static final String USE_NEW_ID_GENERATOR_MAPPINGS = "hibernate.id.new_generator_mappings";
    public static final String ARTEFACT_PROCESSING_ORDER = "hibernate.mapping.precedence";
    private static final String SEARCH_STARTUP_CLASS = "org.hibernate.search.event.EventListenerRegister";
    private static final String SEARCH_STARTUP_METHOD = "enableHibernateSearch";
    protected MetadataSourceQueue metadataSourceQueue;
    private transient ReflectionManager reflectionManager;
    protected Map<String, PersistentClass> classes;
    protected Map<String, String> imports;
    protected Map<String, Collection> collections;
    protected Map<String, Table> tables;
    protected List<AuxiliaryDatabaseObject> auxiliaryDatabaseObjects;
    protected Map<String, NamedQueryDefinition> namedQueries;
    protected Map<String, NamedSQLQueryDefinition> namedSqlQueries;
    protected Map<String, ResultSetMappingDefinition> sqlResultSetMappings;
    protected Map<String, TypeDef> typeDefs;
    protected Map<String, FilterDefinition> filterDefinitions;
    protected Map<String, FetchProfile> fetchProfiles;
    protected Map tableNameBinding;
    protected Map columnNameBindingPerTable;
    protected List<SecondPass> secondPasses;
    protected List<Mappings.PropertyReference> propertyReferences;
    protected Map<ExtendsQueueEntry, ?> extendsQueue;
    protected Map<String, SQLFunction> sqlFunctions;
    private TypeResolver typeResolver = new TypeResolver();
    private EntityTuplizerFactory entityTuplizerFactory;
    private Interceptor interceptor;
    private Properties properties;
    private EntityResolver entityResolver;
    private EntityNotFoundDelegate entityNotFoundDelegate;
    protected transient XMLHelper xmlHelper;
    protected NamingStrategy namingStrategy;
    private SessionFactoryObserver sessionFactoryObserver;
    private EventListeners eventListeners;
    protected final SettingsFactory settingsFactory;
    private transient Mapping mapping = this.buildMapping();
    private DefaultIdentifierGeneratorFactory identifierGeneratorFactory;
    private Map<Class<?>, org.hibernate.mapping.MappedSuperclass> mappedSuperClasses;
    private Map<String, IdGenerator> namedGenerators;
    private Map<String, Map<String, Join>> joins;
    private Map<String, AnnotatedClassType> classTypes;
    private Set<String> defaultNamedQueryNames;
    private Set<String> defaultNamedNativeQueryNames;
    private Set<String> defaultSqlResultSetMappingNames;
    private Set<String> defaultNamedGenerators;
    private Map<String, Properties> generatorTables;
    private Map<Table, List<UniqueConstraintHolder>> uniqueConstraintHoldersByTable;
    private Map<String, String> mappedByResolver;
    private Map<String, String> propertyRefResolver;
    private Map<String, AnyMetaDef> anyMetaDefs;
    private List<CacheHolder> caches;
    private boolean inSecondPass = false;
    private boolean isDefaultProcessed = false;
    private boolean isValidatorNotPresentLogged;
    private Map<XClass, Map<String, PropertyData>> propertiesAnnotatedWithMapsId;
    private Map<XClass, Map<String, PropertyData>> propertiesAnnotatedWithIdAndToOne;
    private boolean specjProprietarySyntaxEnabled;
    private static final String LEGACY_VALIDATOR_EVENT_LISTENER = "org.hibernate.validator.event.ValidateEventListener";
    private static final String SEARCH_EVENT_LISTENER_REGISTERER_CLASS = "org.hibernate.cfg.search.HibernateSearchEventListenerRegister";
    final ObjectNameNormalizer normalizer = new ObjectNameNormalizerImpl();
    public static final MetadataSourceType[] DEFAULT_ARTEFACT_PROCESSING_ORDER = new MetadataSourceType[]{MetadataSourceType.HBM, MetadataSourceType.CLASS};
    private List<MetadataSourceType> metadataSourcePrecedence;

    protected Configuration(SettingsFactory settingsFactory) {
        this.settingsFactory = settingsFactory;
        this.reset();
    }

    public Configuration() {
        this(new SettingsFactory());
    }

    protected void reset() {
        this.metadataSourceQueue = new MetadataSourceQueue();
        this.createReflectionManager();
        this.classes = new HashMap<String, PersistentClass>();
        this.imports = new HashMap<String, String>();
        this.collections = new HashMap<String, Collection>();
        this.tables = new TreeMap<String, Table>();
        this.namedQueries = new HashMap<String, NamedQueryDefinition>();
        this.namedSqlQueries = new HashMap<String, NamedSQLQueryDefinition>();
        this.sqlResultSetMappings = new HashMap<String, ResultSetMappingDefinition>();
        this.typeDefs = new HashMap<String, TypeDef>();
        this.filterDefinitions = new HashMap<String, FilterDefinition>();
        this.fetchProfiles = new HashMap<String, FetchProfile>();
        this.auxiliaryDatabaseObjects = new ArrayList<AuxiliaryDatabaseObject>();
        this.tableNameBinding = new HashMap();
        this.columnNameBindingPerTable = new HashMap();
        this.secondPasses = new ArrayList<SecondPass>();
        this.propertyReferences = new ArrayList<Mappings.PropertyReference>();
        this.extendsQueue = new HashMap();
        this.xmlHelper = new XMLHelper();
        this.interceptor = EmptyInterceptor.INSTANCE;
        this.properties = Environment.getProperties();
        this.entityResolver = XMLHelper.DEFAULT_DTD_RESOLVER;
        this.eventListeners = new EventListeners();
        this.sqlFunctions = new HashMap<String, SQLFunction>();
        this.entityTuplizerFactory = new EntityTuplizerFactory();
        this.identifierGeneratorFactory = new DefaultIdentifierGeneratorFactory();
        this.mappedSuperClasses = new HashMap();
        this.metadataSourcePrecedence = Collections.emptyList();
        this.namedGenerators = new HashMap<String, IdGenerator>();
        this.joins = new HashMap<String, Map<String, Join>>();
        this.classTypes = new HashMap<String, AnnotatedClassType>();
        this.generatorTables = new HashMap<String, Properties>();
        this.defaultNamedQueryNames = new HashSet<String>();
        this.defaultNamedNativeQueryNames = new HashSet<String>();
        this.defaultSqlResultSetMappingNames = new HashSet<String>();
        this.defaultNamedGenerators = new HashSet<String>();
        this.uniqueConstraintHoldersByTable = new HashMap<Table, List<UniqueConstraintHolder>>();
        this.mappedByResolver = new HashMap<String, String>();
        this.propertyRefResolver = new HashMap<String, String>();
        this.caches = new ArrayList<CacheHolder>();
        this.namingStrategy = EJB3NamingStrategy.INSTANCE;
        this.setEntityResolver(new EJB3DTDEntityResolver());
        this.anyMetaDefs = new HashMap<String, AnyMetaDef>();
        this.propertiesAnnotatedWithMapsId = new HashMap<XClass, Map<String, PropertyData>>();
        this.propertiesAnnotatedWithIdAndToOne = new HashMap<XClass, Map<String, PropertyData>>();
        this.specjProprietarySyntaxEnabled = System.getProperty("hibernate.enable_specj_proprietary_syntax") != null;
    }

    public EntityTuplizerFactory getEntityTuplizerFactory() {
        return this.entityTuplizerFactory;
    }

    public ReflectionManager getReflectionManager() {
        return this.reflectionManager;
    }

    public Iterator<PersistentClass> getClassMappings() {
        return this.classes.values().iterator();
    }

    public Iterator getCollectionMappings() {
        return this.collections.values().iterator();
    }

    public Iterator<Table> getTableMappings() {
        return this.tables.values().iterator();
    }

    public Iterator<org.hibernate.mapping.MappedSuperclass> getMappedSuperclassMappings() {
        return this.mappedSuperClasses.values().iterator();
    }

    public PersistentClass getClassMapping(String string) {
        return this.classes.get(string);
    }

    public Collection getCollectionMapping(String string) {
        return this.collections.get(string);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.entityNotFoundDelegate;
    }

    public void setEntityNotFoundDelegate(EntityNotFoundDelegate entityNotFoundDelegate) {
        this.entityNotFoundDelegate = entityNotFoundDelegate;
    }

    public Configuration addFile(String string) throws MappingException {
        return this.addFile(new File(string));
    }

    public Configuration addFile(File file) throws MappingException {
        InputSource inputSource;
        log.info("Reading mappings from file: " + file.getPath());
        String string = file.getAbsolutePath();
        try {
            inputSource = new InputSource(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MappingNotFoundException("file", file.toString());
        }
        this.add(inputSource, "file", string);
        return this;
    }

    private XmlDocument add(InputSource inputSource, String string, String string2) {
        return this.add(inputSource, new OriginImpl(string, string2));
    }

    private XmlDocument add(InputSource inputSource, Origin origin) {
        XmlDocument xmlDocument = MappingReader.INSTANCE.readMappingDocument(this.entityResolver, inputSource, origin);
        this.add(xmlDocument);
        return xmlDocument;
    }

    public void add(XmlDocument xmlDocument) {
        if (this.inSecondPass || !Configuration.isOrmXml(xmlDocument)) {
            this.metadataSourceQueue.add(xmlDocument);
        } else {
            MetadataProvider metadataProvider = ((MetadataProviderInjector)((Object)this.reflectionManager)).getMetadataProvider();
            JPAMetadataProvider jPAMetadataProvider = (JPAMetadataProvider)metadataProvider;
            List<String> list = jPAMetadataProvider.getXMLContext().addDocument(xmlDocument.getDocumentTree());
            for (String string : list) {
                try {
                    this.metadataSourceQueue.add(this.reflectionManager.classForName(string, this.getClass()));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AnnotationException("Unable to load class defined in XML: " + string, classNotFoundException);
                }
            }
        }
    }

    private static boolean isOrmXml(XmlDocument xmlDocument) {
        return "entity-mappings".equals(xmlDocument.getDocumentTree().getRootElement().getName());
    }

    public Configuration addCacheableFile(File file) throws MappingException {
        InputSource inputSource;
        File file2 = this.determineCachedDomFile(file);
        try {
            return this.addCacheableFileStrictly(file);
        }
        catch (SerializationException serializationException) {
            log.warn("Could not deserialize cache file: " + file2.getPath() + " : " + serializationException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.warn("I/O reported cached file could not be found : " + file2.getPath() + " : " + fileNotFoundException);
        }
        String string = file.getAbsolutePath();
        try {
            inputSource = new InputSource(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MappingNotFoundException("file", file.toString());
        }
        log.info("Reading mappings from file: " + file);
        XmlDocument xmlDocument = this.add(inputSource, "file", string);
        try {
            log.debug("Writing cache file for: " + file + " to: " + file2);
            SerializationHelper.serialize((Serializable)((Object)xmlDocument.getDocumentTree()), new FileOutputStream(file2));
        }
        catch (SerializationException serializationException) {
            log.warn("Could not write cached file: " + file2, serializationException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.warn("I/O reported error writing cached file : " + file2.getPath(), fileNotFoundException);
        }
        return this;
    }

    private File determineCachedDomFile(File file) {
        return new File(file.getAbsolutePath() + ".bin");
    }

    public Configuration addCacheableFileStrictly(File file) throws SerializationException, FileNotFoundException {
        boolean bl;
        File file2 = this.determineCachedDomFile(file);
        boolean bl2 = bl = file.exists() && file2.exists() && file.lastModified() < file2.lastModified();
        if (!bl) {
            throw new FileNotFoundException("Cached file could not be found or could not be used");
        }
        log.info("Reading mappings from cache file: " + file2);
        org.dom4j.Document document = (org.dom4j.Document)SerializationHelper.deserialize(new FileInputStream(file2));
        this.add(new XmlDocumentImpl(document, "file", file.getAbsolutePath()));
        return this;
    }

    public Configuration addCacheableFile(String string) throws MappingException {
        return this.addCacheableFile(new File(string));
    }

    public Configuration addXML(String string) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug("Mapping XML:\n" + string);
        }
        InputSource inputSource = new InputSource(new StringReader(string));
        this.add(inputSource, "string", "XML String");
        return this;
    }

    public Configuration addURL(URL uRL) throws MappingException {
        String string = uRL.toExternalForm();
        if (log.isDebugEnabled()) {
            log.debug("Reading mapping document from URL : {}", (Object)string);
        }
        try {
            this.add(uRL.openStream(), "URL", string);
        }
        catch (IOException iOException) {
            throw new InvalidMappingException("Unable to open url stream [" + string + "]", "URL", string, iOException);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlDocument add(InputStream inputStream, String string, String string2) {
        InputSource inputSource = new InputSource(inputStream);
        try {
            XmlDocument xmlDocument = this.add(inputSource, string, string2);
            return xmlDocument;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                log.trace("Was unable to close input stream");
            }
        }
    }

    public Configuration addDocument(Document document) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug("Mapping document:\n" + document);
        }
        org.dom4j.Document document2 = this.xmlHelper.createDOMReader().read(document);
        this.add(new XmlDocumentImpl(document2, "unknown", null));
        return this;
    }

    public Configuration addInputStream(InputStream inputStream) throws MappingException {
        this.add(inputStream, "input stream", null);
        return this;
    }

    public Configuration addResource(String string, ClassLoader classLoader) throws MappingException {
        log.info("Reading mappings from resource: " + string);
        InputStream inputStream = classLoader.getResourceAsStream(string);
        if (inputStream == null) {
            throw new MappingNotFoundException("resource", string);
        }
        this.add(inputStream, "resource", string);
        return this;
    }

    public Configuration addResource(String string) throws MappingException {
        log.info("Reading mappings from resource : " + string);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = null;
        if (classLoader != null) {
            inputStream = classLoader.getResourceAsStream(string);
        }
        if (inputStream == null) {
            inputStream = Environment.class.getClassLoader().getResourceAsStream(string);
        }
        if (inputStream == null) {
            throw new MappingNotFoundException("resource", string);
        }
        this.add(inputStream, "resource", string);
        return this;
    }

    public Configuration addClass(Class clazz) throws MappingException {
        String string = clazz.getName().replace('.', '/') + ".hbm.xml";
        log.info("Reading mappings from resource: " + string);
        return this.addResource(string, clazz.getClassLoader());
    }

    public Configuration addAnnotatedClass(Class clazz) {
        XClass xClass = this.reflectionManager.toXClass(clazz);
        this.metadataSourceQueue.add(xClass);
        return this;
    }

    public Configuration addPackage(String string) throws MappingException {
        log.info("Mapping package {}", (Object)string);
        try {
            AnnotationBinder.bindPackage(string, this.createMappings());
            return this;
        }
        catch (MappingException mappingException) {
            log.error("Could not parse the package-level metadata [" + string + "]");
            throw mappingException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Configuration addJar(File file) throws MappingException {
        log.info("Searching for mapping documents in jar: " + file.getName());
        JarFile jarFile = null;
        try {
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException iOException) {
                throw new InvalidMappingException("Could not read mapping documents from jar: " + file.getName(), "jar", file.getName(), iOException);
            }
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!zipEntry.getName().endsWith(".hbm.xml")) continue;
                log.info("Found mapping document in jar: " + zipEntry.getName());
                try {
                    this.addInputStream(jarFile.getInputStream(zipEntry));
                }
                catch (Exception exception) {
                    throw new InvalidMappingException("Could not read mapping documents from jar: " + file.getName(), "jar", file.getName(), exception);
                    return this;
                }
            }
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {
                log.error("could not close jar", iOException);
            }
        }
    }

    public Configuration addDirectory(File file) throws MappingException {
        File[] fileArray;
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isDirectory()) {
                this.addDirectory(file2);
                continue;
            }
            if (!file2.getName().endsWith(".hbm.xml")) continue;
            this.addFile(file2);
        }
        return this;
    }

    public Mappings createMappings() {
        return new MappingsImpl();
    }

    private Iterator<IdentifierGenerator> iterateGenerators(Dialect dialect) throws MappingException {
        IdentifierGenerator identifierGenerator;
        TreeMap<Object, IdentifierGenerator> treeMap = new TreeMap<Object, IdentifierGenerator>();
        String string = this.properties.getProperty("hibernate.default_catalog");
        String string2 = this.properties.getProperty("hibernate.default_schema");
        for (PersistentClass filterable : this.classes.values()) {
            if (filterable.isInherited()) continue;
            identifierGenerator = filterable.getIdentifier().createIdentifierGenerator(this.getIdentifierGeneratorFactory(), dialect, string, string2, (RootClass)filterable);
            if (identifierGenerator instanceof PersistentIdentifierGenerator) {
                treeMap.put(((PersistentIdentifierGenerator)identifierGenerator).generatorKey(), identifierGenerator);
                continue;
            }
            if (!(identifierGenerator instanceof IdentifierGeneratorAggregator)) continue;
            ((IdentifierGeneratorAggregator)((Object)identifierGenerator)).registerPersistentGenerators(treeMap);
        }
        for (Collection collection : this.collections.values()) {
            if (!collection.isIdentified() || !((identifierGenerator = ((IdentifierCollection)collection).getIdentifier().createIdentifierGenerator(this.getIdentifierGeneratorFactory(), dialect, string, string2, null)) instanceof PersistentIdentifierGenerator)) continue;
            treeMap.put(((PersistentIdentifierGenerator)identifierGenerator).generatorKey(), identifierGenerator);
        }
        return treeMap.values().iterator();
    }

    public String[] generateDropSchemaScript(Dialect dialect) throws HibernateException {
        RelationalModel relationalModel;
        this.secondPassCompile();
        String string = this.properties.getProperty("hibernate.default_catalog");
        String string2 = this.properties.getProperty("hibernate.default_schema");
        ArrayList<String> arrayList = new ArrayList<String>(50);
        Iterator<Object> iterator = this.auxiliaryDatabaseObjects.listIterator(this.auxiliaryDatabaseObjects.size());
        while (iterator.hasPrevious()) {
            relationalModel = iterator.previous();
            if (!relationalModel.appliesToDialect(dialect)) continue;
            arrayList.add(relationalModel.sqlDropString(dialect, string, string2));
        }
        if (dialect.dropConstraints()) {
            iterator = this.getTableMappings();
            while (iterator.hasNext()) {
                relationalModel = (Table)iterator.next();
                if (!((Table)relationalModel).isPhysicalTable()) continue;
                Iterator iterator2 = ((Table)relationalModel).getForeignKeyIterator();
                while (iterator2.hasNext()) {
                    ForeignKey foreignKey = (ForeignKey)iterator2.next();
                    if (!foreignKey.isPhysicalConstraint()) continue;
                    arrayList.add(foreignKey.sqlDropString(dialect, string, string2));
                }
            }
        }
        iterator = this.getTableMappings();
        while (iterator.hasNext()) {
            relationalModel = (Table)iterator.next();
            if (!((Table)relationalModel).isPhysicalTable()) continue;
            arrayList.add(((Table)relationalModel).sqlDropString(dialect, string, string2));
        }
        iterator = this.iterateGenerators(dialect);
        while (iterator.hasNext()) {
            relationalModel = ((PersistentIdentifierGenerator)iterator.next()).sqlDropStrings(dialect);
            arrayList.addAll(Arrays.asList(relationalModel));
        }
        return ArrayHelper.toStringArray(arrayList);
    }

    public String[] generateSchemaCreationScript(Dialect dialect) throws HibernateException {
        Object object2;
        this.secondPassCompile();
        ArrayList<String> arrayList = new ArrayList<String>(50);
        String string = this.properties.getProperty("hibernate.default_catalog");
        String string2 = this.properties.getProperty("hibernate.default_schema");
        Iterator<Object> iterator = this.getTableMappings();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (!object2.isPhysicalTable()) continue;
            arrayList.add(object2.sqlCreateString(dialect, this.mapping, string, string2));
            Iterator object3 = object2.sqlCommentStrings(dialect, string, string2);
            while (object3.hasNext()) {
                arrayList.add((String)object3.next());
            }
        }
        iterator = this.getTableMappings();
        while (iterator.hasNext()) {
            RelationalModel relationalModel;
            object2 = iterator.next();
            if (!object2.isPhysicalTable()) continue;
            if (!dialect.supportsUniqueConstraintInCreateAlterTable()) {
                Iterator iterator2 = object2.getUniqueKeyIterator();
                while (iterator2.hasNext()) {
                    relationalModel = (UniqueKey)iterator2.next();
                    String string3 = ((UniqueKey)relationalModel).sqlCreateString(dialect, this.mapping, string, string2);
                    if (string3 == null) continue;
                    arrayList.add(string3);
                }
            }
            Iterator iterator3 = object2.getIndexIterator();
            while (iterator3.hasNext()) {
                relationalModel = (Index)iterator3.next();
                arrayList.add(((Index)relationalModel).sqlCreateString(dialect, this.mapping, string, string2));
            }
            if (!dialect.hasAlterTable()) continue;
            Iterator iterator4 = object2.getForeignKeyIterator();
            while (iterator4.hasNext()) {
                relationalModel = (ForeignKey)iterator4.next();
                if (!((ForeignKey)relationalModel).isPhysicalConstraint()) continue;
                arrayList.add(((Constraint)relationalModel).sqlCreateString(dialect, this.mapping, string, string2));
            }
        }
        iterator = this.iterateGenerators(dialect);
        while (iterator.hasNext()) {
            object2 = ((PersistentIdentifierGenerator)iterator.next()).sqlCreateStrings(dialect);
            arrayList.addAll(Arrays.asList(object2));
        }
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : this.auxiliaryDatabaseObjects) {
            if (!auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            arrayList.add(auxiliaryDatabaseObject.sqlCreateString(dialect, this.mapping, string, string2));
        }
        return ArrayHelper.toStringArray(arrayList);
    }

    public String[] generateSchemaUpdateScript(Dialect dialect, DatabaseMetadata databaseMetadata) throws HibernateException {
        Object object;
        Object object2;
        Object object3;
        this.secondPassCompile();
        String string = this.properties.getProperty("hibernate.default_catalog");
        String string2 = this.properties.getProperty("hibernate.default_schema");
        ArrayList<String> arrayList = new ArrayList<String>(50);
        Iterator<Object> iterator = this.getTableMappings();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            if (!((Table)object3).isPhysicalTable()) continue;
            object2 = databaseMetadata.getTableMetadata(((Table)object3).getName(), ((Table)object3).getSchema() == null ? string2 : ((Table)object3).getSchema(), ((Table)object3).getCatalog() == null ? string : ((Table)object3).getCatalog(), ((Table)object3).isQuoted());
            if (object2 == null) {
                arrayList.add(((Table)object3).sqlCreateString(dialect, this.mapping, string, string2));
            } else {
                object = ((Table)object3).sqlAlterStrings(dialect, this.mapping, (TableMetadata)object2, string, string2);
                while (object.hasNext()) {
                    arrayList.add((String)object.next());
                }
            }
            object = ((Table)object3).sqlCommentStrings(dialect, string, string2);
            while (object.hasNext()) {
                arrayList.add((String)object.next());
            }
        }
        iterator = this.getTableMappings();
        while (iterator.hasNext()) {
            RelationalModel relationalModel;
            object3 = iterator.next();
            if (!((Table)object3).isPhysicalTable()) continue;
            object2 = databaseMetadata.getTableMetadata(((Table)object3).getName(), ((Table)object3).getSchema(), ((Table)object3).getCatalog(), ((Table)object3).isQuoted());
            if (dialect.hasAlterTable()) {
                object = ((Table)object3).getForeignKeyIterator();
                while (object.hasNext()) {
                    boolean bl;
                    relationalModel = (ForeignKey)object.next();
                    if (!((ForeignKey)relationalModel).isPhysicalConstraint() || !(bl = object2 == null || ((TableMetadata)object2).getForeignKeyMetadata((ForeignKey)relationalModel) == null && (!(dialect instanceof MySQLDialect) || ((TableMetadata)object2).getIndexMetadata(((Constraint)relationalModel).getName()) == null))) continue;
                    arrayList.add(((Constraint)relationalModel).sqlCreateString(dialect, this.mapping, string, string2));
                }
            }
            object = ((Table)object3).getIndexIterator();
            while (object.hasNext()) {
                IndexMetadata indexMetadata;
                relationalModel = (Index)object.next();
                if (object2 != null && StringHelper.isNotEmpty(((Index)relationalModel).getName()) && (indexMetadata = ((TableMetadata)object2).getIndexMetadata(((Index)relationalModel).getName())) != null) continue;
                arrayList.add(((Index)relationalModel).sqlCreateString(dialect, this.mapping, string, string2));
            }
        }
        iterator = this.iterateGenerators(dialect);
        while (iterator.hasNext()) {
            object3 = (PersistentIdentifierGenerator)iterator.next();
            object2 = object3.generatorKey();
            if (databaseMetadata.isSequence(object2) || databaseMetadata.isTable(object2)) continue;
            object = object3.sqlCreateStrings(dialect);
            arrayList.addAll(Arrays.asList(object));
        }
        return ArrayHelper.toStringArray(arrayList);
    }

    public void validateSchema(Dialect dialect, DatabaseMetadata databaseMetadata) throws HibernateException {
        Object object;
        Object object2;
        this.secondPassCompile();
        String string = this.properties.getProperty("hibernate.default_catalog");
        String string2 = this.properties.getProperty("hibernate.default_schema");
        Iterator<Object> iterator = this.getTableMappings();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (!((Table)object2).isPhysicalTable()) continue;
            object = databaseMetadata.getTableMetadata(((Table)object2).getName(), ((Table)object2).getSchema() == null ? string2 : ((Table)object2).getSchema(), ((Table)object2).getCatalog() == null ? string : ((Table)object2).getCatalog(), ((Table)object2).isQuoted());
            if (object == null) {
                throw new HibernateException("Missing table: " + ((Table)object2).getName());
            }
            ((Table)object2).validateColumns(dialect, this.mapping, (TableMetadata)object);
        }
        iterator = this.iterateGenerators(dialect);
        while (iterator.hasNext()) {
            object2 = (PersistentIdentifierGenerator)iterator.next();
            object = object2.generatorKey();
            if (databaseMetadata.isSequence(object) || databaseMetadata.isTable(object)) continue;
            throw new HibernateException("Missing sequence or table: " + object);
        }
    }

    private void validate() throws MappingException {
        Iterator<Filterable> iterator = this.classes.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().validate(this.mapping);
        }
        iterator = this.collections.values().iterator();
        while (iterator.hasNext()) {
            ((Collection)iterator.next()).validate(this.mapping);
        }
    }

    public void buildMappings() {
        this.secondPassCompile();
    }

    protected void secondPassCompile() throws MappingException {
        log.trace("Starting secondPassCompile() processing");
        if (!this.isDefaultProcessed) {
            Object object = this.reflectionManager.getDefaults().get("delimited-identifier");
            if (object != null && object == Boolean.TRUE) {
                this.getProperties().put("hibernate.globally_quoted_identifiers", "true");
            }
            AnnotationBinder.bindDefaults(this.createMappings());
            this.isDefaultProcessed = true;
        }
        this.metadataSourceQueue.syncAnnotatedClasses();
        this.metadataSourceQueue.processMetadata(this.determineMetadataSourcePrecedence());
        for (CacheHolder object : this.caches) {
            if (object.isClass) {
                this.applyCacheConcurrencyStrategy(object);
                continue;
            }
            this.applyCollectionCacheConcurrencyStrategy(object);
        }
        this.caches.clear();
        try {
            this.inSecondPass = true;
            this.processSecondPassesOfType(PkDrivenByDefaultMapsIdSecondPass.class);
            this.processSecondPassesOfType(SetSimpleValueTypeSecondPass.class);
            this.processSecondPassesOfType(CopyIdentifierComponentSecondPass.class);
            this.processFkSecondPassInOrder();
            this.processSecondPassesOfType(CreateKeySecondPass.class);
            this.processSecondPassesOfType(SecondaryTableSecondPass.class);
            this.originalSecondPassCompile();
            this.inSecondPass = false;
        }
        catch (RecoverableException recoverableException) {
            throw (RuntimeException)recoverableException.getCause();
        }
        for (Map.Entry entry : this.uniqueConstraintHoldersByTable.entrySet()) {
            Table table = (Table)entry.getKey();
            List list = (List)entry.getValue();
            int n = 0;
            for (UniqueConstraintHolder uniqueConstraintHolder : list) {
                String string = StringHelper.isEmpty(uniqueConstraintHolder.getName()) ? "key" + ++n : uniqueConstraintHolder.getName();
                this.buildUniqueKeyFromColumnNames(table, string, uniqueConstraintHolder.getColumns());
            }
        }
        this.applyConstraintsToDDL();
    }

    private void processSecondPassesOfType(Class<? extends SecondPass> clazz) {
        Iterator<SecondPass> iterator = this.secondPasses.iterator();
        while (iterator.hasNext()) {
            SecondPass secondPass = iterator.next();
            if (!clazz.isInstance(secondPass)) continue;
            secondPass.doSecondPass(this.classes);
            iterator.remove();
        }
    }

    private void processFkSecondPassInOrder() {
        Object object2;
        log.debug("processing fk mappings (*ToOne and JoinedSubclass)");
        List<FkSecondPass> list = this.getFKSecondPassesOnly();
        if (list.size() == 0) {
            return;
        }
        HashMap<String, Set<FkSecondPass>> hashMap = new HashMap<String, Set<FkSecondPass>>();
        ArrayList<FkSecondPass> arrayList = new ArrayList<FkSecondPass>(list.size());
        for (FkSecondPass object22 : list) {
            if (object22.isInPrimaryKey()) {
                object2 = object22.getReferencedEntityName();
                PersistentClass persistentClass = this.getClassMapping((String)object2);
                String string = persistentClass.getTable().getQuotedName();
                if (!hashMap.containsKey(string)) {
                    hashMap.put(string, new HashSet());
                }
                ((Set)hashMap.get(string)).add(object22);
                continue;
            }
            arrayList.add(object22);
        }
        ArrayList arrayList2 = new ArrayList(list.size());
        for (Object object2 : hashMap.keySet()) {
            this.buildRecursiveOrderedFkSecondPasses(arrayList2, hashMap, (String)object2, (String)object2);
        }
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            object2 = (FkSecondPass)iterator.next();
            object2.doSecondPass(this.classes);
        }
        this.processEndOfQueue(arrayList);
    }

    private List<FkSecondPass> getFKSecondPassesOnly() {
        Iterator<SecondPass> iterator = this.secondPasses.iterator();
        ArrayList<FkSecondPass> arrayList = new ArrayList<FkSecondPass>(this.secondPasses.size());
        while (iterator.hasNext()) {
            SecondPass secondPass = iterator.next();
            if (!(secondPass instanceof FkSecondPass)) continue;
            arrayList.add((FkSecondPass)secondPass);
            iterator.remove();
        }
        return arrayList;
    }

    private void buildRecursiveOrderedFkSecondPasses(List<FkSecondPass> list, Map<String, Set<FkSecondPass>> map, String string, String string2) {
        Set<FkSecondPass> set = map.get(string2);
        if (set == null || set.size() == 0) {
            return;
        }
        for (FkSecondPass fkSecondPass : set) {
            String string3 = fkSecondPass.getValue().getTable().getQuotedName();
            if (string3.compareTo(string) == 0) {
                StringBuilder stringBuilder = new StringBuilder("Foreign key circularity dependency involving the following tables: ");
                throw new AnnotationException(stringBuilder.toString());
            }
            this.buildRecursiveOrderedFkSecondPasses(list, map, string, string3);
            if (list.contains(fkSecondPass)) continue;
            list.add(0, fkSecondPass);
        }
    }

    private void processEndOfQueue(List<FkSecondPass> list) {
        boolean bl = false;
        RuntimeException runtimeException = null;
        while (!bl) {
            ArrayList<FkSecondPass> arrayList = new ArrayList<FkSecondPass>();
            ListIterator<FkSecondPass> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                FkSecondPass fkSecondPass = (FkSecondPass)listIterator.next();
                try {
                    fkSecondPass.doSecondPass(this.classes);
                }
                catch (RecoverableException recoverableException) {
                    arrayList.add(fkSecondPass);
                    if (runtimeException != null) continue;
                    runtimeException = (RuntimeException)recoverableException.getCause();
                }
            }
            bl = arrayList.size() == 0 || arrayList.size() == list.size();
            list = arrayList;
        }
        if (list.size() > 0) {
            throw runtimeException;
        }
    }

    private void buildUniqueKeyFromColumnNames(Table table, String string, String[] stringArray) {
        string = this.normalizer.normalizeIdentifierQuoting(string);
        int n = stringArray.length;
        Column[] columnArray = new Column[n];
        HashSet<Column> hashSet = new HashSet<Column>();
        HashSet<Column> hashSet2 = new HashSet<Column>();
        for (int i = 0; i < n; ++i) {
            String string2 = this.normalizer.normalizeIdentifierQuoting(stringArray[i]);
            try {
                String string3 = this.createMappings().getPhysicalColumnName(string2, table);
                columnArray[i] = new Column(string3);
                hashSet.add(columnArray[i]);
                continue;
            }
            catch (MappingException mappingException) {
                hashSet2.add(new Column(string2));
            }
        }
        for (Column column : columnArray) {
            if (!table.containsColumn(column)) continue;
            UniqueKey uniqueKey = table.getOrCreateUniqueKey(string);
            uniqueKey.addColumn(table.getColumn(column));
            hashSet.remove(column);
        }
        if (hashSet.size() > 0 || hashSet2.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder("Unable to create unique key constraint (");
            for (String string4 : stringArray) {
                stringBuilder.append(string4).append(", ");
            }
            stringBuilder.setLength(stringBuilder.length() - 2);
            stringBuilder.append(") on table ").append(table.getName()).append(": ");
            for (Column column : hashSet) {
                stringBuilder.append(column.getName()).append(", ");
            }
            for (Column column : hashSet2) {
                stringBuilder.append(column.getName()).append(", ");
            }
            stringBuilder.setLength(stringBuilder.length() - 2);
            stringBuilder.append(" not found");
            throw new AnnotationException(stringBuilder.toString());
        }
    }

    private void applyConstraintsToDDL() {
        boolean bl = this.getProperties().getProperty("hibernate.validator.apply_to_ddl", "true").equalsIgnoreCase("true");
        if (!bl) {
            return;
        }
        this.applyHibernateValidatorLegacyConstraintsOnDDL();
        this.applyBeanValidationConstraintsOnDDL();
    }

    private void applyHibernateValidatorLegacyConstraintsOnDDL() {
        Constructor constructor = null;
        Method method = null;
        try {
            Class clazz = ReflectHelper.classForName("org.hibernate.validator.ClassValidator", this.getClass());
            Class serializable = ReflectHelper.classForName("org.hibernate.validator.MessageInterpolator", this.getClass());
            constructor = clazz.getDeclaredConstructor(Class.class, ResourceBundle.class, serializable, Map.class, ReflectionManager.class);
            method = clazz.getMethod("apply", PersistentClass.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (!this.isValidatorNotPresentLogged) {
                log.info("Hibernate Validator not found: ignoring");
            }
            this.isValidatorNotPresentLogged = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AnnotationException(noSuchMethodException);
        }
        if (method != null) {
            for (PersistentClass persistentClass : this.classes.values()) {
                String string = persistentClass.getClassName();
                if (!StringHelper.isNotEmpty(string)) continue;
                try {
                    Object t = constructor.newInstance(ReflectHelper.classForName(string), null, null, null, this.reflectionManager);
                    method.invoke(t, persistentClass);
                }
                catch (Exception exception) {
                    log.warn("Unable to apply constraints on DDL for " + string, exception);
                }
            }
        }
    }

    private void applyBeanValidationConstraintsOnDDL() {
        BeanValidationActivator.applyDDL(this.classes.values(), this.getProperties());
    }

    private void originalSecondPassCompile() throws MappingException {
        log.debug("processing extends queue");
        this.processExtendsQueue();
        log.debug("processing collection mappings");
        Iterator<Serializable> iterator = this.secondPasses.iterator();
        while (iterator.hasNext()) {
            SecondPass serializable2 = iterator.next();
            if (serializable2 instanceof QuerySecondPass) continue;
            serializable2.doSecondPass(this.classes);
            iterator.remove();
        }
        log.debug("processing native query and ResultSetMapping mappings");
        iterator = this.secondPasses.iterator();
        while (iterator.hasNext()) {
            SecondPass secondPass = iterator.next();
            secondPass.doSecondPass(this.classes);
            iterator.remove();
        }
        log.debug("processing association property references");
        for (Mappings.PropertyReference propertyReference : this.propertyReferences) {
            PersistentClass persistentClass = this.getClassMapping(propertyReference.referencedClass);
            if (persistentClass == null) {
                throw new MappingException("property-ref to unmapped class: " + propertyReference.referencedClass);
            }
            Property property = persistentClass.getReferencedProperty(propertyReference.propertyName);
            if (!propertyReference.unique) continue;
            ((SimpleValue)property.getValue()).setAlternateUniqueKey(true);
        }
        log.debug("processing foreign key constraints");
        iterator = this.getTableMappings();
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            this.secondPassCompileForeignKeys((Table)iterator.next(), hashSet);
        }
    }

    private int processExtendsQueue() {
        log.debug("processing extends queue");
        int n = 0;
        ExtendsQueueEntry extendsQueueEntry = this.findPossibleExtends();
        while (extendsQueueEntry != null) {
            this.metadataSourceQueue.processHbmXml(extendsQueueEntry.getMetadataXml(), extendsQueueEntry.getEntityNames());
            extendsQueueEntry = this.findPossibleExtends();
        }
        if (this.extendsQueue.size() > 0) {
            Iterator<ExtendsQueueEntry> iterator = this.extendsQueue.keySet().iterator();
            StringBuffer stringBuffer = new StringBuffer("Following super classes referenced in extends not found: ");
            while (iterator.hasNext()) {
                ExtendsQueueEntry extendsQueueEntry2 = iterator.next();
                stringBuffer.append(extendsQueueEntry2.getExplicitName());
                if (extendsQueueEntry2.getMappingPackage() != null) {
                    stringBuffer.append("[").append(extendsQueueEntry2.getMappingPackage()).append("]");
                }
                if (!iterator.hasNext()) continue;
                stringBuffer.append(",");
            }
            throw new MappingException(stringBuffer.toString());
        }
        return n;
    }

    protected ExtendsQueueEntry findPossibleExtends() {
        Iterator<ExtendsQueueEntry> iterator = this.extendsQueue.keySet().iterator();
        while (iterator.hasNext()) {
            ExtendsQueueEntry extendsQueueEntry = iterator.next();
            boolean bl = this.getClassMapping(extendsQueueEntry.getExplicitName()) != null || this.getClassMapping(HbmBinder.getClassName(extendsQueueEntry.getExplicitName(), extendsQueueEntry.getMappingPackage())) != null;
            if (!bl) continue;
            iterator.remove();
            return extendsQueueEntry;
        }
        return null;
    }

    protected void secondPassCompileForeignKeys(Table table, Set set) throws MappingException {
        table.createForeignKeys();
        Iterator iterator = table.getForeignKeyIterator();
        while (iterator.hasNext()) {
            PersistentClass persistentClass;
            ForeignKey foreignKey = (ForeignKey)iterator.next();
            if (set.contains(foreignKey)) continue;
            set.add(foreignKey);
            String string = foreignKey.getReferencedEntityName();
            if (string == null) {
                throw new MappingException("An association from the table " + foreignKey.getTable().getName() + " does not specify the referenced entity");
            }
            if (log.isDebugEnabled()) {
                log.debug("resolving reference to class: " + string);
            }
            if ((persistentClass = this.classes.get(string)) == null) {
                throw new MappingException("An association from the table " + foreignKey.getTable().getName() + " refers to an unmapped class: " + string);
            }
            if (persistentClass.isJoinedSubclass()) {
                this.secondPassCompileForeignKeys(persistentClass.getSuperclass().getTable(), set);
            }
            foreignKey.setReferencedTable(persistentClass.getTable());
            foreignKey.alignColumns();
        }
    }

    public Map<String, NamedQueryDefinition> getNamedQueries() {
        return this.namedQueries;
    }

    public SessionFactory buildSessionFactory() throws HibernateException {
        log.debug("Preparing to build session factory with filters : " + this.filterDefinitions);
        this.secondPassCompile();
        if (!this.metadataSourceQueue.isEmpty()) {
            log.warn("mapping metadata cache was not completely processed");
        }
        this.enableLegacyHibernateValidator();
        this.enableBeanValidation();
        this.enableHibernateSearch();
        this.validate();
        Environment.verifyProperties(this.properties);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.properties);
        PropertiesHelper.resolvePlaceHolders(properties);
        Settings settings = this.buildSettings(properties);
        return new SessionFactoryImpl(this, this.mapping, settings, this.getInitializedEventListeners(), this.sessionFactoryObserver);
    }

    private void enableLegacyHibernateValidator() {
        boolean bl = !"false".equalsIgnoreCase(this.getProperty("hibernate.validator.autoregister_listeners"));
        Class clazz = null;
        try {
            clazz = ReflectHelper.classForName(LEGACY_VALIDATOR_EVENT_LISTENER, Configuration.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.debug("Legacy Validator not present in classpath, ignoring event listener registration");
        }
        if (bl && clazz != null) {
            Object t;
            try {
                t = clazz.newInstance();
            }
            catch (Exception exception) {
                throw new AnnotationException("Unable to load Validator event listener", exception);
            }
            boolean bl2 = false;
            Serializable[] serializableArray = this.getEventListeners().getPreInsertEventListeners();
            if (serializableArray != null) {
                for (Serializable serializable : serializableArray) {
                    bl2 = bl2 || clazz == serializable.getClass();
                }
                if (!bl2) {
                    int n = serializableArray.length + 1;
                    PreInsertEventListener[] preInsertEventListenerArray = new PreInsertEventListener[n];
                    System.arraycopy(serializableArray, 0, preInsertEventListenerArray, 0, n - 1);
                    preInsertEventListenerArray[n - 1] = (PreInsertEventListener)t;
                    this.getEventListeners().setPreInsertEventListeners(preInsertEventListenerArray);
                }
            } else {
                this.getEventListeners().setPreInsertEventListeners(new PreInsertEventListener[]{(PreInsertEventListener)t});
            }
            bl2 = false;
            serializableArray = this.getEventListeners().getPreUpdateEventListeners();
            if (serializableArray != null) {
                for (Serializable serializable : serializableArray) {
                    bl2 = bl2 || clazz == serializable.getClass();
                }
                if (!bl2) {
                    int n = serializableArray.length + 1;
                    PreUpdateEventListener[] preUpdateEventListenerArray = new PreUpdateEventListener[n];
                    System.arraycopy(serializableArray, 0, preUpdateEventListenerArray, 0, n - 1);
                    preUpdateEventListenerArray[n - 1] = (PreUpdateEventListener)t;
                    this.getEventListeners().setPreUpdateEventListeners(preUpdateEventListenerArray);
                }
            } else {
                this.getEventListeners().setPreUpdateEventListeners(new PreUpdateEventListener[]{(PreUpdateEventListener)t});
            }
        }
    }

    private void enableBeanValidation() {
        BeanValidationActivator.activateBeanValidation(this.getEventListeners(), this.getProperties());
    }

    private void enableHibernateSearch() {
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(SEARCH_STARTUP_CLASS, this.getClass());
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = ReflectHelper.classForName(SEARCH_EVENT_LISTENER_REGISTERER_CLASS, this.getClass());
            }
            catch (ClassNotFoundException classNotFoundException2) {
                log.debug("Search not present in classpath, ignoring event listener registration.");
                return;
            }
        }
        try {
            Object t = clazz.newInstance();
            Method method = clazz.getDeclaredMethod(SEARCH_STARTUP_METHOD, EventListeners.class, Properties.class);
            method.invoke(t, this.getEventListeners(), this.getProperties());
        }
        catch (InstantiationException instantiationException) {
            log.debug("Unable to instantiate {}, ignoring event listener registration.", (Object)SEARCH_STARTUP_CLASS);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.debug("Unable to instantiate {}, ignoring event listener registration.", (Object)SEARCH_STARTUP_CLASS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            log.debug("Method enableHibernateSearch() not found in {}.", (Object)SEARCH_STARTUP_CLASS);
        }
        catch (InvocationTargetException invocationTargetException) {
            log.debug("Unable to execute {}, ignoring event listener registration.", (Object)SEARCH_STARTUP_METHOD);
        }
    }

    private EventListeners getInitializedEventListeners() {
        EventListeners eventListeners = (EventListeners)this.eventListeners.shallowCopy();
        eventListeners.initializeListeners(this);
        return eventListeners;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public Configuration setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public Configuration setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public Configuration addProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public Configuration mergeProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (this.properties.containsKey(entry.getKey())) continue;
            this.properties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    public Configuration setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
        return this;
    }

    private void addProperties(Element element) {
        Iterator iterator = element.elementIterator("property");
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            String string = element2.attributeValue("name");
            String string2 = element2.getText().trim();
            log.debug(string + "=" + string2);
            this.properties.setProperty(string, string2);
            if (string.startsWith("hibernate")) continue;
            this.properties.setProperty("hibernate." + string, string2);
        }
        Environment.verifyProperties(this.properties);
    }

    public Configuration configure() throws HibernateException {
        this.configure("/hibernate.cfg.xml");
        return this;
    }

    public Configuration configure(String string) throws HibernateException {
        log.info("configuring from resource: " + string);
        InputStream inputStream = this.getConfigurationInputStream(string);
        return this.doConfigure(inputStream, string);
    }

    protected InputStream getConfigurationInputStream(String string) throws HibernateException {
        log.info("Configuration resource: " + string);
        return ConfigHelper.getResourceAsStream(string);
    }

    public Configuration configure(URL uRL) throws HibernateException {
        log.info("configuring from url: " + uRL.toString());
        try {
            return this.doConfigure(uRL.openStream(), uRL.toString());
        }
        catch (IOException iOException) {
            throw new HibernateException("could not configure from URL: " + uRL, iOException);
        }
    }

    public Configuration configure(File file) throws HibernateException {
        log.info("configuring from file: " + file.getName());
        try {
            return this.doConfigure(new FileInputStream(file), file.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new HibernateException("could not find file: " + file, fileNotFoundException);
        }
    }

    protected Configuration doConfigure(InputStream inputStream, String string) throws HibernateException {
        try {
            ArrayList arrayList = new ArrayList();
            org.dom4j.Document document = this.xmlHelper.createSAXReader(string, arrayList, this.entityResolver).read(new InputSource(inputStream));
            if (arrayList.size() != 0) {
                throw new MappingException("invalid configuration", (Throwable)arrayList.get(0));
            }
            this.doConfigure(document);
        }
        catch (DocumentException documentException) {
            throw new HibernateException("Could not parse configuration: " + string, documentException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                log.warn("could not close input stream for: " + string, iOException);
            }
        }
        return this;
    }

    public Configuration configure(Document document) throws HibernateException {
        log.info("configuring from XML document");
        return this.doConfigure(this.xmlHelper.createDOMReader().read(document));
    }

    protected Configuration doConfigure(org.dom4j.Document document) throws HibernateException {
        Element element = document.getRootElement().element("session-factory");
        String string = element.attributeValue("name");
        if (string != null) {
            this.properties.setProperty("hibernate.session_factory_name", string);
        }
        this.addProperties(element);
        this.parseSessionFactory(element, string);
        Element element2 = document.getRootElement().element("security");
        if (element2 != null) {
            this.parseSecurity(element2);
        }
        log.info("Configured SessionFactory: " + string);
        log.debug("properties: " + this.properties);
        return this;
    }

    private void parseSessionFactory(Element element, String string) {
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            String string2;
            Attribute attribute;
            String string3;
            Element element2 = (Element)iterator.next();
            String string4 = element2.getName();
            if ("mapping".equals(string4)) {
                this.parseMappingElement(element2, string);
                continue;
            }
            if ("class-cache".equals(string4)) {
                string3 = element2.attributeValue("class");
                attribute = element2.attribute("region");
                string2 = attribute == null ? string3 : attribute.getValue();
                boolean bl = !"non-lazy".equals(element2.attributeValue("include"));
                this.setCacheConcurrencyStrategy(string3, element2.attributeValue("usage"), string2, bl);
                continue;
            }
            if ("collection-cache".equals(string4)) {
                string3 = element2.attributeValue("collection");
                attribute = element2.attribute("region");
                string2 = attribute == null ? string3 : attribute.getValue();
                this.setCollectionCacheConcurrencyStrategy(string3, element2.attributeValue("usage"), string2);
                continue;
            }
            if ("listener".equals(string4)) {
                this.parseListener(element2);
                continue;
            }
            if (!"event".equals(string4)) continue;
            this.parseEvent(element2);
        }
    }

    private void parseMappingElement(Element element, String string) {
        Attribute attribute = element.attribute("resource");
        Attribute attribute2 = element.attribute("file");
        Attribute attribute3 = element.attribute("jar");
        Attribute attribute4 = element.attribute("package");
        Attribute attribute5 = element.attribute("class");
        if (attribute != null) {
            String string2 = attribute.getValue();
            log.debug("session-factory config [{}] named resource [{}] for mapping", (Object)string, (Object)string2);
            this.addResource(string2);
        } else if (attribute2 != null) {
            String string3 = attribute2.getValue();
            log.debug("session-factory config [{}] named file [{}] for mapping", (Object)string, (Object)string3);
            this.addFile(string3);
        } else if (attribute3 != null) {
            String string4 = attribute3.getValue();
            log.debug("session-factory config [{}] named jar file [{}] for mapping", (Object)string, (Object)string4);
            this.addJar(new File(string4));
        } else if (attribute4 != null) {
            String string5 = attribute4.getValue();
            log.debug("session-factory config [{}] named package [{}] for mapping", (Object)string, (Object)string5);
            this.addPackage(string5);
        } else if (attribute5 != null) {
            String string6 = attribute5.getValue();
            log.debug("session-factory config [{}] named class [{}] for mapping", (Object)string, (Object)string6);
            try {
                this.addAnnotatedClass(ReflectHelper.classForName(string6));
            }
            catch (Exception exception) {
                throw new MappingException("Unable to load class [ " + string6 + "] declared in Hibernate configuration <mapping/> entry", exception);
            }
        } else {
            throw new MappingException("<mapping> element in configuration specifies no known attributes");
        }
    }

    private void parseSecurity(Element element) {
        String string = element.attributeValue("context");
        this.setProperty("hibernate.jacc_context_id", string);
        log.info("JACC contextID: " + string);
        JACCConfiguration jACCConfiguration = new JACCConfiguration(string);
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            String string2 = element2.getName();
            if (!"grant".equals(string2)) continue;
            jACCConfiguration.addPermission(element2.attributeValue("role"), element2.attributeValue("entity-name"), element2.attributeValue("actions"));
        }
    }

    private void parseEvent(Element element) {
        String string = element.attributeValue("type");
        List list = element.elements();
        Object[] objectArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            objectArray[i] = ((Element)list.get(i)).attributeValue("class");
        }
        log.debug("Event listeners: " + string + "=" + StringHelper.toString(objectArray));
        this.setListeners(string, (String[])objectArray);
    }

    private void parseListener(Element element) {
        String string = element.attributeValue("type");
        if (string == null) {
            throw new MappingException("No type specified for listener");
        }
        String string2 = element.attributeValue("class");
        log.debug("Event listener: " + string + "=" + string2);
        this.setListeners(string, new String[]{string2});
    }

    public void setListener(String string, String string2) {
        String[] stringArray = null;
        if (string2 != null) {
            stringArray = (String[])Array.newInstance(String.class, 1);
            stringArray[0] = string2;
        }
        this.setListeners(string, stringArray);
    }

    public void setListeners(String string, String[] stringArray) {
        Object[] objectArray = null;
        if (stringArray != null) {
            objectArray = (Object[])Array.newInstance(this.eventListeners.getListenerClassFor(string), stringArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                try {
                    objectArray[i] = ReflectHelper.classForName(stringArray[i]).newInstance();
                    continue;
                }
                catch (Exception exception) {
                    throw new MappingException("Unable to instantiate specified event (" + string + ") listener class: " + stringArray[i], exception);
                }
            }
        }
        this.setListeners(string, objectArray);
    }

    public void setListener(String string, Object object) {
        Object[] objectArray = null;
        if (object != null) {
            objectArray = (Object[])Array.newInstance(this.eventListeners.getListenerClassFor(string), 1);
            objectArray[0] = object;
        }
        this.setListeners(string, objectArray);
    }

    public void setListeners(String string, Object[] objectArray) {
        if ("auto-flush".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setAutoFlushEventListeners(new AutoFlushEventListener[0]);
            } else {
                this.eventListeners.setAutoFlushEventListeners((AutoFlushEventListener[])objectArray);
            }
        } else if ("merge".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setMergeEventListeners(new MergeEventListener[0]);
            } else {
                this.eventListeners.setMergeEventListeners((MergeEventListener[])objectArray);
            }
        } else if ("create".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPersistEventListeners(new PersistEventListener[0]);
            } else {
                this.eventListeners.setPersistEventListeners((PersistEventListener[])objectArray);
            }
        } else if ("create-onflush".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPersistOnFlushEventListeners(new PersistEventListener[0]);
            } else {
                this.eventListeners.setPersistOnFlushEventListeners((PersistEventListener[])objectArray);
            }
        } else if ("delete".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setDeleteEventListeners(new DeleteEventListener[0]);
            } else {
                this.eventListeners.setDeleteEventListeners((DeleteEventListener[])objectArray);
            }
        } else if ("dirty-check".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setDirtyCheckEventListeners(new DirtyCheckEventListener[0]);
            } else {
                this.eventListeners.setDirtyCheckEventListeners((DirtyCheckEventListener[])objectArray);
            }
        } else if ("evict".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setEvictEventListeners(new EvictEventListener[0]);
            } else {
                this.eventListeners.setEvictEventListeners((EvictEventListener[])objectArray);
            }
        } else if ("flush".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setFlushEventListeners(new FlushEventListener[0]);
            } else {
                this.eventListeners.setFlushEventListeners((FlushEventListener[])objectArray);
            }
        } else if ("flush-entity".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setFlushEntityEventListeners(new FlushEntityEventListener[0]);
            } else {
                this.eventListeners.setFlushEntityEventListeners((FlushEntityEventListener[])objectArray);
            }
        } else if ("load".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setLoadEventListeners(new LoadEventListener[0]);
            } else {
                this.eventListeners.setLoadEventListeners((LoadEventListener[])objectArray);
            }
        } else if ("load-collection".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setInitializeCollectionEventListeners(new InitializeCollectionEventListener[0]);
            } else {
                this.eventListeners.setInitializeCollectionEventListeners((InitializeCollectionEventListener[])objectArray);
            }
        } else if ("lock".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setLockEventListeners(new LockEventListener[0]);
            } else {
                this.eventListeners.setLockEventListeners((LockEventListener[])objectArray);
            }
        } else if ("refresh".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setRefreshEventListeners(new RefreshEventListener[0]);
            } else {
                this.eventListeners.setRefreshEventListeners((RefreshEventListener[])objectArray);
            }
        } else if ("replicate".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setReplicateEventListeners(new ReplicateEventListener[0]);
            } else {
                this.eventListeners.setReplicateEventListeners((ReplicateEventListener[])objectArray);
            }
        } else if ("save-update".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setSaveOrUpdateEventListeners(new SaveOrUpdateEventListener[0]);
            } else {
                this.eventListeners.setSaveOrUpdateEventListeners((SaveOrUpdateEventListener[])objectArray);
            }
        } else if ("save".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setSaveEventListeners(new SaveOrUpdateEventListener[0]);
            } else {
                this.eventListeners.setSaveEventListeners((SaveOrUpdateEventListener[])objectArray);
            }
        } else if ("update".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setUpdateEventListeners(new SaveOrUpdateEventListener[0]);
            } else {
                this.eventListeners.setUpdateEventListeners((SaveOrUpdateEventListener[])objectArray);
            }
        } else if ("pre-load".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPreLoadEventListeners(new PreLoadEventListener[0]);
            } else {
                this.eventListeners.setPreLoadEventListeners((PreLoadEventListener[])objectArray);
            }
        } else if ("pre-update".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPreUpdateEventListeners(new PreUpdateEventListener[0]);
            } else {
                this.eventListeners.setPreUpdateEventListeners((PreUpdateEventListener[])objectArray);
            }
        } else if ("pre-delete".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPreDeleteEventListeners(new PreDeleteEventListener[0]);
            } else {
                this.eventListeners.setPreDeleteEventListeners((PreDeleteEventListener[])objectArray);
            }
        } else if ("pre-insert".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPreInsertEventListeners(new PreInsertEventListener[0]);
            } else {
                this.eventListeners.setPreInsertEventListeners((PreInsertEventListener[])objectArray);
            }
        } else if ("pre-collection-recreate".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPreCollectionRecreateEventListeners(new PreCollectionRecreateEventListener[0]);
            } else {
                this.eventListeners.setPreCollectionRecreateEventListeners((PreCollectionRecreateEventListener[])objectArray);
            }
        } else if ("pre-collection-remove".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPreCollectionRemoveEventListeners(new PreCollectionRemoveEventListener[0]);
            } else {
                this.eventListeners.setPreCollectionRemoveEventListeners((PreCollectionRemoveEventListener[])objectArray);
            }
        } else if ("pre-collection-update".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPreCollectionUpdateEventListeners(new PreCollectionUpdateEventListener[0]);
            } else {
                this.eventListeners.setPreCollectionUpdateEventListeners((PreCollectionUpdateEventListener[])objectArray);
            }
        } else if ("post-load".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPostLoadEventListeners(new PostLoadEventListener[0]);
            } else {
                this.eventListeners.setPostLoadEventListeners((PostLoadEventListener[])objectArray);
            }
        } else if ("post-update".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPostUpdateEventListeners(new PostUpdateEventListener[0]);
            } else {
                this.eventListeners.setPostUpdateEventListeners((PostUpdateEventListener[])objectArray);
            }
        } else if ("post-delete".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPostDeleteEventListeners(new PostDeleteEventListener[0]);
            } else {
                this.eventListeners.setPostDeleteEventListeners((PostDeleteEventListener[])objectArray);
            }
        } else if ("post-insert".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPostInsertEventListeners(new PostInsertEventListener[0]);
            } else {
                this.eventListeners.setPostInsertEventListeners((PostInsertEventListener[])objectArray);
            }
        } else if ("post-commit-update".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPostCommitUpdateEventListeners(new PostUpdateEventListener[0]);
            } else {
                this.eventListeners.setPostCommitUpdateEventListeners((PostUpdateEventListener[])objectArray);
            }
        } else if ("post-commit-delete".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPostCommitDeleteEventListeners(new PostDeleteEventListener[0]);
            } else {
                this.eventListeners.setPostCommitDeleteEventListeners((PostDeleteEventListener[])objectArray);
            }
        } else if ("post-commit-insert".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPostCommitInsertEventListeners(new PostInsertEventListener[0]);
            } else {
                this.eventListeners.setPostCommitInsertEventListeners((PostInsertEventListener[])objectArray);
            }
        } else if ("post-collection-recreate".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPostCollectionRecreateEventListeners(new PostCollectionRecreateEventListener[0]);
            } else {
                this.eventListeners.setPostCollectionRecreateEventListeners((PostCollectionRecreateEventListener[])objectArray);
            }
        } else if ("post-collection-remove".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPostCollectionRemoveEventListeners(new PostCollectionRemoveEventListener[0]);
            } else {
                this.eventListeners.setPostCollectionRemoveEventListeners((PostCollectionRemoveEventListener[])objectArray);
            }
        } else if ("post-collection-update".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPostCollectionUpdateEventListeners(new PostCollectionUpdateEventListener[0]);
            } else {
                this.eventListeners.setPostCollectionUpdateEventListeners((PostCollectionUpdateEventListener[])objectArray);
            }
        } else {
            throw new MappingException("Unrecognized listener type [" + string + "]");
        }
    }

    public EventListeners getEventListeners() {
        return this.eventListeners;
    }

    RootClass getRootClassMapping(String string) throws MappingException {
        try {
            return (RootClass)this.getClassMapping(string);
        }
        catch (ClassCastException classCastException) {
            throw new MappingException("You may only specify a cache for root <class> mappings");
        }
    }

    public Configuration setCacheConcurrencyStrategy(String string, String string2) {
        this.setCacheConcurrencyStrategy(string, string2, string);
        return this;
    }

    public Configuration setCacheConcurrencyStrategy(String string, String string2, String string3) {
        this.setCacheConcurrencyStrategy(string, string2, string3, true);
        return this;
    }

    public void setCacheConcurrencyStrategy(String string, String string2, String string3, boolean bl) throws MappingException {
        this.caches.add(new CacheHolder(string, string2, string3, true, bl));
    }

    private void applyCacheConcurrencyStrategy(CacheHolder cacheHolder) {
        RootClass rootClass = this.getRootClassMapping(cacheHolder.role);
        if (rootClass == null) {
            throw new MappingException("Cannot cache an unknown entity: " + cacheHolder.role);
        }
        rootClass.setCacheConcurrencyStrategy(cacheHolder.usage);
        rootClass.setCacheRegionName(cacheHolder.region);
        rootClass.setLazyPropertiesCacheable(cacheHolder.cacheLazy);
    }

    public Configuration setCollectionCacheConcurrencyStrategy(String string, String string2) {
        this.setCollectionCacheConcurrencyStrategy(string, string2, string);
        return this;
    }

    public void setCollectionCacheConcurrencyStrategy(String string, String string2, String string3) {
        this.caches.add(new CacheHolder(string, string2, string3, false, false));
    }

    private void applyCollectionCacheConcurrencyStrategy(CacheHolder cacheHolder) {
        Collection collection = this.getCollectionMapping(cacheHolder.role);
        if (collection == null) {
            throw new MappingException("Cannot cache an unknown collection: " + cacheHolder.role);
        }
        collection.setCacheConcurrencyStrategy(cacheHolder.usage);
        collection.setCacheRegionName(cacheHolder.region);
    }

    public Map<String, String> getImports() {
        return this.imports;
    }

    public Settings buildSettings() {
        Properties properties = (Properties)this.properties.clone();
        PropertiesHelper.resolvePlaceHolders(properties);
        return this.buildSettingsInternal(properties);
    }

    public Settings buildSettings(Properties properties) throws HibernateException {
        return this.buildSettingsInternal(properties);
    }

    private Settings buildSettingsInternal(Properties properties) {
        Settings settings = this.settingsFactory.buildSettings(properties);
        settings.setEntityTuplizerFactory(this.getEntityTuplizerFactory());
        return settings;
    }

    public Map getNamedSQLQueries() {
        return this.namedSqlQueries;
    }

    public Map getSqlResultSetMappings() {
        return this.sqlResultSetMappings;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public Configuration setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
        return this;
    }

    public DefaultIdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return this.identifierGeneratorFactory;
    }

    public Mapping buildMapping() {
        return new Mapping(){

            public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
                return Configuration.this.identifierGeneratorFactory;
            }

            public Type getIdentifierType(String string) throws MappingException {
                PersistentClass persistentClass = Configuration.this.classes.get(string);
                if (persistentClass == null) {
                    throw new MappingException("persistent class not known: " + string);
                }
                return persistentClass.getIdentifier().getType();
            }

            public String getIdentifierPropertyName(String string) throws MappingException {
                PersistentClass persistentClass = Configuration.this.classes.get(string);
                if (persistentClass == null) {
                    throw new MappingException("persistent class not known: " + string);
                }
                if (!persistentClass.hasIdentifierProperty()) {
                    return null;
                }
                return persistentClass.getIdentifierProperty().getName();
            }

            public Type getReferencedPropertyType(String string, String string2) throws MappingException {
                PersistentClass persistentClass = Configuration.this.classes.get(string);
                if (persistentClass == null) {
                    throw new MappingException("persistent class not known: " + string);
                }
                Property property = persistentClass.getReferencedProperty(string2);
                if (property == null) {
                    throw new MappingException("property not known: " + string + '.' + string2);
                }
                return property.getType();
            }
        };
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        MetadataProvider metadataProvider = (MetadataProvider)objectInputStream.readObject();
        this.mapping = this.buildMapping();
        this.xmlHelper = new XMLHelper();
        this.createReflectionManager(metadataProvider);
        objectInputStream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        MetadataProvider metadataProvider = ((MetadataProviderInjector)((Object)this.reflectionManager)).getMetadataProvider();
        objectOutputStream.writeObject(metadataProvider);
        objectOutputStream.defaultWriteObject();
    }

    private void createReflectionManager() {
        this.createReflectionManager(new JPAMetadataProvider());
    }

    private void createReflectionManager(MetadataProvider metadataProvider) {
        this.reflectionManager = new JavaReflectionManager();
        ((MetadataProviderInjector)((Object)this.reflectionManager)).setMetadataProvider(metadataProvider);
    }

    public Map getFilterDefinitions() {
        return this.filterDefinitions;
    }

    public void addFilterDefinition(FilterDefinition filterDefinition) {
        this.filterDefinitions.put(filterDefinition.getFilterName(), filterDefinition);
    }

    public Iterator iterateFetchProfiles() {
        return this.fetchProfiles.values().iterator();
    }

    public void addFetchProfile(FetchProfile fetchProfile) {
        this.fetchProfiles.put(fetchProfile.getName(), fetchProfile);
    }

    public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject auxiliaryDatabaseObject) {
        this.auxiliaryDatabaseObjects.add(auxiliaryDatabaseObject);
    }

    public Map getSqlFunctions() {
        return this.sqlFunctions;
    }

    public void addSqlFunction(String string, SQLFunction sQLFunction) {
        this.sqlFunctions.put(string, sQLFunction);
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public void registerTypeOverride(BasicType basicType) {
        this.getTypeResolver().registerTypeOverride(basicType);
    }

    public void registerTypeOverride(UserType userType, String[] stringArray) {
        this.getTypeResolver().registerTypeOverride(userType, stringArray);
    }

    public void registerTypeOverride(CompositeUserType compositeUserType, String[] stringArray) {
        this.getTypeResolver().registerTypeOverride(compositeUserType, stringArray);
    }

    public SessionFactoryObserver getSessionFactoryObserver() {
        return this.sessionFactoryObserver;
    }

    public void setSessionFactoryObserver(SessionFactoryObserver sessionFactoryObserver) {
        this.sessionFactoryObserver = sessionFactoryObserver;
    }

    private List<MetadataSourceType> determineMetadataSourcePrecedence() {
        if (this.metadataSourcePrecedence.isEmpty() && StringHelper.isNotEmpty(this.getProperties().getProperty(ARTEFACT_PROCESSING_ORDER))) {
            this.metadataSourcePrecedence = this.parsePrecedence(this.getProperties().getProperty(ARTEFACT_PROCESSING_ORDER));
        }
        if (this.metadataSourcePrecedence.isEmpty()) {
            this.metadataSourcePrecedence = Arrays.asList(DEFAULT_ARTEFACT_PROCESSING_ORDER);
        }
        this.metadataSourcePrecedence = Collections.unmodifiableList(this.metadataSourcePrecedence);
        return this.metadataSourcePrecedence;
    }

    public void setPrecedence(String string) {
        this.metadataSourcePrecedence = this.parsePrecedence(string);
    }

    private List<MetadataSourceType> parsePrecedence(String string) {
        if (StringHelper.isEmpty(string)) {
            return Collections.emptyList();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",; ", false);
        ArrayList<MetadataSourceType> arrayList = new ArrayList<MetadataSourceType>();
        while (stringTokenizer.hasMoreElements()) {
            arrayList.add(MetadataSourceType.parsePrecedence((String)stringTokenizer.nextElement()));
        }
        return arrayList;
    }

    private static class CacheHolder {
        public String role;
        public String usage;
        public String region;
        public boolean isClass;
        public boolean cacheLazy;

        public CacheHolder(String string, String string2, String string3, boolean bl, boolean bl2) {
            this.role = string;
            this.usage = string2;
            this.region = string3;
            this.isClass = bl;
            this.cacheLazy = bl2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MetadataSourceQueue
    implements Serializable {
        private LinkedHashMap<XmlDocument, Set<String>> hbmMetadataToEntityNamesMap = new LinkedHashMap();
        private Map<String, XmlDocument> hbmMetadataByEntityNameXRef = new HashMap<String, XmlDocument>();
        private transient List<XClass> annotatedClasses = new ArrayList<XClass>();
        private transient Map<String, XClass> annotatedClassesByEntityNameMap = new HashMap<String, XClass>();

        protected MetadataSourceQueue() {
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.annotatedClassesByEntityNameMap = new HashMap<String, XClass>();
            List list = (List)objectInputStream.readObject();
            this.annotatedClasses = new ArrayList<XClass>(list.size());
            for (Class clazz : list) {
                this.annotatedClasses.add(Configuration.this.reflectionManager.toXClass(clazz));
            }
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            ArrayList<Class> arrayList = new ArrayList<Class>(this.annotatedClasses.size());
            for (XClass xClass : this.annotatedClasses) {
                arrayList.add(Configuration.this.reflectionManager.toClass(xClass));
            }
            objectOutputStream.writeObject(arrayList);
        }

        public void add(XmlDocument xmlDocument) {
            org.dom4j.Document document = xmlDocument.getDocumentTree();
            Element element = document.getRootElement();
            Attribute attribute = element.attribute("package");
            String string = attribute != null ? attribute.getValue() : "";
            HashSet<String> hashSet = new HashSet<String>();
            this.findClassNames(string, element, hashSet);
            for (String string2 : hashSet) {
                this.hbmMetadataByEntityNameXRef.put(string2, xmlDocument);
            }
            this.hbmMetadataToEntityNamesMap.put(xmlDocument, hashSet);
        }

        private void findClassNames(String string, Element element, Set<String> set) {
            Iterator[] iteratorArray = new Iterator[]{element.elementIterator("class"), element.elementIterator("subclass"), element.elementIterator("joined-subclass"), element.elementIterator("union-subclass")};
            JoinedIterator joinedIterator = new JoinedIterator(iteratorArray);
            while (joinedIterator.hasNext()) {
                Element element2 = (Element)joinedIterator.next();
                String string2 = element2.attributeValue("entity-name");
                if (string2 == null) {
                    string2 = this.getClassName(element2.attribute("name"), string);
                }
                set.add(string2);
                this.findClassNames(string, element2, set);
            }
        }

        private String getClassName(Attribute attribute, String string) {
            if (attribute == null) {
                return null;
            }
            String string2 = attribute.getValue();
            if (string2 == null) {
                return null;
            }
            if (string2.indexOf(46) < 0 && string != null) {
                return string + '.' + string2;
            }
            return string2;
        }

        public void add(XClass xClass) {
            this.annotatedClasses.add(xClass);
        }

        protected void syncAnnotatedClasses() {
            Iterator<XClass> iterator = this.annotatedClasses.iterator();
            while (iterator.hasNext()) {
                XClass xClass = iterator.next();
                if (xClass.isAnnotationPresent(Entity.class)) {
                    this.annotatedClassesByEntityNameMap.put(xClass.getName(), xClass);
                    continue;
                }
                if (xClass.isAnnotationPresent(MappedSuperclass.class)) continue;
                iterator.remove();
            }
        }

        protected void processMetadata(List<MetadataSourceType> list) {
            this.syncAnnotatedClasses();
            for (MetadataSourceType metadataSourceType : list) {
                if (MetadataSourceType.HBM.equals((Object)metadataSourceType)) {
                    this.processHbmXmlQueue();
                    continue;
                }
                if (!MetadataSourceType.CLASS.equals((Object)metadataSourceType)) continue;
                this.processAnnotatedClassesQueue();
            }
        }

        private void processHbmXmlQueue() {
            log.debug("Processing hbm.xml files");
            for (Map.Entry<XmlDocument, Set<String>> entry : this.hbmMetadataToEntityNamesMap.entrySet()) {
                this.processHbmXml(entry.getKey(), entry.getValue());
            }
            this.hbmMetadataToEntityNamesMap.clear();
            this.hbmMetadataByEntityNameXRef.clear();
        }

        private void processHbmXml(XmlDocument xmlDocument, Set<String> set) {
            try {
                HbmBinder.bindRoot(xmlDocument, Configuration.this.createMappings(), CollectionHelper.EMPTY_MAP, set);
            }
            catch (MappingException mappingException) {
                throw new InvalidMappingException(xmlDocument.getOrigin().getType(), xmlDocument.getOrigin().getName(), mappingException);
            }
            for (String string : set) {
                if (!this.annotatedClassesByEntityNameMap.containsKey(string)) continue;
                this.annotatedClasses.remove(this.annotatedClassesByEntityNameMap.get(string));
                this.annotatedClassesByEntityNameMap.remove(string);
            }
        }

        private void processAnnotatedClassesQueue() {
            log.debug("Process annotated classes");
            List<XClass> list = this.orderAndFillHierarchy(this.annotatedClasses);
            Mappings mappings = Configuration.this.createMappings();
            Map<XClass, InheritanceState> map = AnnotationBinder.buildInheritanceStates(list, mappings);
            for (XClass xClass : list) {
                AnnotationBinder.bindClass(xClass, map, mappings);
                String string = xClass.getName();
                if (!this.hbmMetadataByEntityNameXRef.containsKey(string)) continue;
                this.hbmMetadataToEntityNamesMap.remove(this.hbmMetadataByEntityNameXRef.get(string));
                this.hbmMetadataByEntityNameXRef.remove(string);
            }
            this.annotatedClasses.clear();
            this.annotatedClassesByEntityNameMap.clear();
        }

        private List<XClass> orderAndFillHierarchy(List<XClass> list) {
            ArrayList<XClass> arrayList = new ArrayList<XClass>(list);
            this.insertMappedSuperclasses(list, arrayList);
            ArrayList<XClass> arrayList2 = new ArrayList<XClass>(arrayList);
            ArrayList<XClass> arrayList3 = new ArrayList<XClass>(arrayList.size());
            while (arrayList2.size() > 0) {
                XClass xClass = (XClass)arrayList2.get(0);
                this.orderHierarchy(arrayList2, arrayList3, arrayList, xClass);
            }
            return arrayList3;
        }

        private void insertMappedSuperclasses(List<XClass> list, List<XClass> list2) {
            for (XClass xClass : list) {
                for (XClass xClass2 = xClass.getSuperclass(); xClass2 != null && !Configuration.this.reflectionManager.equals(xClass2, Object.class) && !list2.contains(xClass2); xClass2 = xClass2.getSuperclass()) {
                    if (!xClass2.isAnnotationPresent(Entity.class) && !xClass2.isAnnotationPresent(MappedSuperclass.class)) continue;
                    list2.add(xClass2);
                }
            }
        }

        private void orderHierarchy(List<XClass> list, List<XClass> list2, List<XClass> list3, XClass xClass) {
            if (xClass == null || Configuration.this.reflectionManager.equals(xClass, Object.class)) {
                return;
            }
            this.orderHierarchy(list, list2, list3, xClass.getSuperclass());
            if (list3.contains(xClass)) {
                if (!list2.contains(xClass)) {
                    list2.add(xClass);
                }
                list.remove(xClass);
            }
        }

        public boolean isEmpty() {
            return this.hbmMetadataToEntityNamesMap.isEmpty() && this.annotatedClasses.isEmpty();
        }
    }

    final class ObjectNameNormalizerImpl
    extends ObjectNameNormalizer
    implements Serializable {
        ObjectNameNormalizerImpl() {
        }

        public boolean isUseQuotedIdentifiersGlobally() {
            String string = (String)Configuration.this.properties.get("hibernate.globally_quoted_identifiers");
            return string != null && Boolean.valueOf(string) != false;
        }

        public NamingStrategy getNamingStrategy() {
            return Configuration.this.namingStrategy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MappingsImpl
    implements ExtendedMappings,
    Serializable {
        private String schemaName;
        private String catalogName;
        private String defaultPackage;
        private boolean autoImport;
        private boolean defaultLazy;
        private String defaultCascade;
        private String defaultAccess;
        private Boolean useNewGeneratorMappings;

        protected MappingsImpl() {
        }

        @Override
        public String getSchemaName() {
            return this.schemaName;
        }

        @Override
        public void setSchemaName(String string) {
            this.schemaName = string;
        }

        @Override
        public String getCatalogName() {
            return this.catalogName;
        }

        @Override
        public void setCatalogName(String string) {
            this.catalogName = string;
        }

        @Override
        public String getDefaultPackage() {
            return this.defaultPackage;
        }

        @Override
        public void setDefaultPackage(String string) {
            this.defaultPackage = string;
        }

        @Override
        public boolean isAutoImport() {
            return this.autoImport;
        }

        @Override
        public void setAutoImport(boolean bl) {
            this.autoImport = bl;
        }

        @Override
        public boolean isDefaultLazy() {
            return this.defaultLazy;
        }

        @Override
        public void setDefaultLazy(boolean bl) {
            this.defaultLazy = bl;
        }

        @Override
        public String getDefaultCascade() {
            return this.defaultCascade;
        }

        @Override
        public void setDefaultCascade(String string) {
            this.defaultCascade = string;
        }

        @Override
        public String getDefaultAccess() {
            return this.defaultAccess;
        }

        @Override
        public void setDefaultAccess(String string) {
            this.defaultAccess = string;
        }

        @Override
        public NamingStrategy getNamingStrategy() {
            return Configuration.this.namingStrategy;
        }

        @Override
        public void setNamingStrategy(NamingStrategy namingStrategy) {
            Configuration.this.namingStrategy = namingStrategy;
        }

        @Override
        public TypeResolver getTypeResolver() {
            return Configuration.this.typeResolver;
        }

        @Override
        public Iterator<PersistentClass> iterateClasses() {
            return Configuration.this.classes.values().iterator();
        }

        @Override
        public PersistentClass getClass(String string) {
            return Configuration.this.classes.get(string);
        }

        @Override
        public PersistentClass locatePersistentClassByEntityName(String string) {
            String string2;
            PersistentClass persistentClass = Configuration.this.classes.get(string);
            if (persistentClass == null && StringHelper.isNotEmpty(string2 = Configuration.this.imports.get(string))) {
                persistentClass = Configuration.this.classes.get(string2);
            }
            return persistentClass;
        }

        @Override
        public void addClass(PersistentClass persistentClass) throws DuplicateMappingException {
            PersistentClass persistentClass2 = Configuration.this.classes.put(persistentClass.getEntityName(), persistentClass);
            if (persistentClass2 != null) {
                throw new DuplicateMappingException("class/entity", persistentClass.getEntityName());
            }
        }

        @Override
        public void addImport(String string, String string2) throws DuplicateMappingException {
            String string3 = Configuration.this.imports.put(string2, string);
            if (string3 != null) {
                if (string3.equals(string)) {
                    log.info("duplicate import: {} -> {}", (Object)string, (Object)string2);
                } else {
                    throw new DuplicateMappingException("duplicate import: " + string2 + " refers to both " + string + " and " + string3 + " (try using auto-import=\"false\")", "import", string2);
                }
            }
        }

        @Override
        public Collection getCollection(String string) {
            return Configuration.this.collections.get(string);
        }

        @Override
        public Iterator<Collection> iterateCollections() {
            return Configuration.this.collections.values().iterator();
        }

        @Override
        public void addCollection(Collection collection) throws DuplicateMappingException {
            Collection collection2 = Configuration.this.collections.put(collection.getRole(), collection);
            if (collection2 != null) {
                throw new DuplicateMappingException("collection role", collection.getRole());
            }
        }

        @Override
        public Table getTable(String string, String string2, String string3) {
            String string4 = Table.qualify(string2, string, string3);
            return Configuration.this.tables.get(string4);
        }

        @Override
        public Iterator<Table> iterateTables() {
            return Configuration.this.tables.values().iterator();
        }

        @Override
        public Table addTable(String string, String string2, String string3, String string4, boolean bl) {
            string3 = this.getObjectNameNormalizer().normalizeIdentifierQuoting(string3);
            string = this.getObjectNameNormalizer().normalizeIdentifierQuoting(string);
            string2 = this.getObjectNameNormalizer().normalizeIdentifierQuoting(string2);
            String string5 = string4 == null ? Table.qualify(string2, string, string3) : string4;
            Table table = Configuration.this.tables.get(string5);
            if (table == null) {
                table = new Table();
                table.setAbstract(bl);
                table.setName(string3);
                table.setSchema(string);
                table.setCatalog(string2);
                table.setSubselect(string4);
                Configuration.this.tables.put(string5, table);
            } else if (!bl) {
                table.setAbstract(false);
            }
            return table;
        }

        @Override
        public Table addDenormalizedTable(String string, String string2, String string3, boolean bl, String string4, Table table) throws DuplicateMappingException {
            String string5;
            string3 = this.getObjectNameNormalizer().normalizeIdentifierQuoting(string3);
            string = this.getObjectNameNormalizer().normalizeIdentifierQuoting(string);
            string2 = this.getObjectNameNormalizer().normalizeIdentifierQuoting(string2);
            String string6 = string5 = string4 == null ? Table.qualify(string2, string, string3) : string4;
            if (Configuration.this.tables.containsKey(string5)) {
                throw new DuplicateMappingException("table", string3);
            }
            DenormalizedTable denormalizedTable = new DenormalizedTable(table);
            denormalizedTable.setAbstract(bl);
            denormalizedTable.setName(string3);
            denormalizedTable.setSchema(string);
            denormalizedTable.setCatalog(string2);
            denormalizedTable.setSubselect(string4);
            Configuration.this.tables.put(string5, denormalizedTable);
            return denormalizedTable;
        }

        @Override
        public NamedQueryDefinition getQuery(String string) {
            return Configuration.this.namedQueries.get(string);
        }

        @Override
        public void addQuery(String string, NamedQueryDefinition namedQueryDefinition) throws DuplicateMappingException {
            if (!Configuration.this.defaultNamedQueryNames.contains(string)) {
                this.applyQuery(string, namedQueryDefinition);
            }
        }

        private void applyQuery(String string, NamedQueryDefinition namedQueryDefinition) {
            this.checkQueryName(string);
            Configuration.this.namedQueries.put(string.intern(), namedQueryDefinition);
        }

        private void checkQueryName(String string) throws DuplicateMappingException {
            if (Configuration.this.namedQueries.containsKey(string) || Configuration.this.namedSqlQueries.containsKey(string)) {
                throw new DuplicateMappingException("query", string);
            }
        }

        @Override
        public void addDefaultQuery(String string, NamedQueryDefinition namedQueryDefinition) {
            this.applyQuery(string, namedQueryDefinition);
            Configuration.this.defaultNamedQueryNames.add(string);
        }

        @Override
        public NamedSQLQueryDefinition getSQLQuery(String string) {
            return Configuration.this.namedSqlQueries.get(string);
        }

        @Override
        public void addSQLQuery(String string, NamedSQLQueryDefinition namedSQLQueryDefinition) throws DuplicateMappingException {
            if (!Configuration.this.defaultNamedNativeQueryNames.contains(string)) {
                this.applySQLQuery(string, namedSQLQueryDefinition);
            }
        }

        private void applySQLQuery(String string, NamedSQLQueryDefinition namedSQLQueryDefinition) throws DuplicateMappingException {
            this.checkQueryName(string);
            Configuration.this.namedSqlQueries.put(string.intern(), namedSQLQueryDefinition);
        }

        @Override
        public void addDefaultSQLQuery(String string, NamedSQLQueryDefinition namedSQLQueryDefinition) {
            this.applySQLQuery(string, namedSQLQueryDefinition);
            Configuration.this.defaultNamedNativeQueryNames.add(string);
        }

        @Override
        public ResultSetMappingDefinition getResultSetMapping(String string) {
            return Configuration.this.sqlResultSetMappings.get(string);
        }

        @Override
        public void addResultSetMapping(ResultSetMappingDefinition resultSetMappingDefinition) throws DuplicateMappingException {
            if (!Configuration.this.defaultSqlResultSetMappingNames.contains(resultSetMappingDefinition.getName())) {
                this.applyResultSetMapping(resultSetMappingDefinition);
            }
        }

        public void applyResultSetMapping(ResultSetMappingDefinition resultSetMappingDefinition) throws DuplicateMappingException {
            ResultSetMappingDefinition resultSetMappingDefinition2 = Configuration.this.sqlResultSetMappings.put(resultSetMappingDefinition.getName(), resultSetMappingDefinition);
            if (resultSetMappingDefinition2 != null) {
                throw new DuplicateMappingException("resultSet", resultSetMappingDefinition.getName());
            }
        }

        @Override
        public void addDefaultResultSetMapping(ResultSetMappingDefinition resultSetMappingDefinition) {
            String string = resultSetMappingDefinition.getName();
            if (!Configuration.this.defaultSqlResultSetMappingNames.contains(string) && this.getResultSetMapping(string) != null) {
                this.removeResultSetMapping(string);
            }
            this.applyResultSetMapping(resultSetMappingDefinition);
            Configuration.this.defaultSqlResultSetMappingNames.add(string);
        }

        protected void removeResultSetMapping(String string) {
            Configuration.this.sqlResultSetMappings.remove(string);
        }

        @Override
        public TypeDef getTypeDef(String string) {
            return Configuration.this.typeDefs.get(string);
        }

        @Override
        public void addTypeDef(String string, String string2, Properties properties) {
            TypeDef typeDef = new TypeDef(string2, properties);
            Configuration.this.typeDefs.put(string, typeDef);
            log.debug("Added " + string + " with class " + string2);
        }

        @Override
        public Map getFilterDefinitions() {
            return Configuration.this.filterDefinitions;
        }

        @Override
        public FilterDefinition getFilterDefinition(String string) {
            return Configuration.this.filterDefinitions.get(string);
        }

        @Override
        public void addFilterDefinition(FilterDefinition filterDefinition) {
            Configuration.this.filterDefinitions.put(filterDefinition.getFilterName(), filterDefinition);
        }

        @Override
        public FetchProfile findOrCreateFetchProfile(String string, MetadataSource metadataSource) {
            FetchProfile fetchProfile = Configuration.this.fetchProfiles.get(string);
            if (fetchProfile == null) {
                fetchProfile = new FetchProfile(string, metadataSource);
                Configuration.this.fetchProfiles.put(string, fetchProfile);
            }
            return fetchProfile;
        }

        @Override
        public Iterator<AuxiliaryDatabaseObject> iterateAuxliaryDatabaseObjects() {
            return this.iterateAuxiliaryDatabaseObjects();
        }

        @Override
        public Iterator<AuxiliaryDatabaseObject> iterateAuxiliaryDatabaseObjects() {
            return Configuration.this.auxiliaryDatabaseObjects.iterator();
        }

        @Override
        public ListIterator<AuxiliaryDatabaseObject> iterateAuxliaryDatabaseObjectsInReverse() {
            return this.iterateAuxiliaryDatabaseObjectsInReverse();
        }

        @Override
        public ListIterator<AuxiliaryDatabaseObject> iterateAuxiliaryDatabaseObjectsInReverse() {
            return Configuration.this.auxiliaryDatabaseObjects.listIterator(Configuration.this.auxiliaryDatabaseObjects.size());
        }

        @Override
        public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject auxiliaryDatabaseObject) {
            Configuration.this.auxiliaryDatabaseObjects.add(auxiliaryDatabaseObject);
        }

        @Override
        public String getLogicalTableName(Table table) throws MappingException {
            return this.getLogicalTableName(table.getQuotedSchema(), table.getCatalog(), table.getQuotedName());
        }

        private String getLogicalTableName(String string, String string2, String string3) throws MappingException {
            String string4 = this.buildTableNameKey(string, string2, string3);
            TableDescription tableDescription = (TableDescription)Configuration.this.tableNameBinding.get(string4);
            if (tableDescription == null) {
                throw new MappingException("Unable to find physical table: " + string3);
            }
            return tableDescription.logicalName;
        }

        @Override
        public void addTableBinding(String string, String string2, String string3, String string4, Table table) throws DuplicateMappingException {
            TableDescription tableDescription;
            String string5 = this.buildTableNameKey(string, string2, string4);
            TableDescription tableDescription2 = Configuration.this.tableNameBinding.put(string5, tableDescription = new TableDescription(string3, table));
            if (tableDescription2 != null && !tableDescription2.logicalName.equals(string3)) {
                throw new DuplicateMappingException("Same physical table name [" + string4 + "] references several logical table names: [" + tableDescription2.logicalName + "], [" + string3 + ']', "table", string4);
            }
        }

        private String buildTableNameKey(String string, String string2, String string3) {
            StringBuffer stringBuffer = new StringBuffer();
            if (string != null) {
                stringBuffer.append(string);
            }
            stringBuffer.append(".");
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            stringBuffer.append(".");
            stringBuffer.append(string3);
            return stringBuffer.toString();
        }

        @Override
        public void addColumnBinding(String string, Column column, Table table) throws DuplicateMappingException {
            TableColumnNameBinding tableColumnNameBinding = (TableColumnNameBinding)Configuration.this.columnNameBindingPerTable.get(table);
            if (tableColumnNameBinding == null) {
                tableColumnNameBinding = new TableColumnNameBinding(table.getName());
                Configuration.this.columnNameBindingPerTable.put(table, tableColumnNameBinding);
            }
            tableColumnNameBinding.addBinding(string, column);
        }

        @Override
        public String getPhysicalColumnName(String string, Table table) throws MappingException {
            string = string.toLowerCase();
            String string2 = null;
            Table table2 = table;
            do {
                String string3;
                TableDescription tableDescription;
                TableColumnNameBinding tableColumnNameBinding;
                if ((tableColumnNameBinding = (TableColumnNameBinding)Configuration.this.columnNameBindingPerTable.get(table2)) != null) {
                    string2 = (String)tableColumnNameBinding.logicalToPhysical.get(string);
                }
                table2 = (tableDescription = (TableDescription)Configuration.this.tableNameBinding.get(string3 = this.buildTableNameKey(table2.getQuotedSchema(), table2.getCatalog(), table2.getQuotedName()))) != null ? tableDescription.denormalizedSupertable : null;
            } while (string2 == null && table2 != null);
            if (string2 == null) {
                throw new MappingException("Unable to find column with logical name " + string + " in table " + table.getName());
            }
            return string2;
        }

        @Override
        public String getLogicalColumnName(String string, Table table) throws MappingException {
            String string2 = null;
            Table table2 = table;
            TableDescription tableDescription = null;
            do {
                String string3;
                TableColumnNameBinding tableColumnNameBinding;
                if ((tableColumnNameBinding = (TableColumnNameBinding)Configuration.this.columnNameBindingPerTable.get(table2)) != null) {
                    string2 = (String)tableColumnNameBinding.physicalToLogical.get(string);
                }
                table2 = (tableDescription = (TableDescription)Configuration.this.tableNameBinding.get(string3 = this.buildTableNameKey(table2.getQuotedSchema(), table2.getCatalog(), table2.getQuotedName()))) != null ? tableDescription.denormalizedSupertable : null;
            } while (string2 == null && table2 != null && tableDescription != null);
            if (string2 == null) {
                throw new MappingException("Unable to find logical column name from physical name " + string + " in table " + table.getName());
            }
            return string2;
        }

        @Override
        public void addSecondPass(SecondPass secondPass) {
            this.addSecondPass(secondPass, false);
        }

        @Override
        public void addSecondPass(SecondPass secondPass, boolean bl) {
            if (bl) {
                Configuration.this.secondPasses.add(0, secondPass);
            } else {
                Configuration.this.secondPasses.add(secondPass);
            }
        }

        @Override
        public void addPropertyReference(String string, String string2) {
            Configuration.this.propertyReferences.add(new Mappings.PropertyReference(string, string2, false));
        }

        @Override
        public void addUniquePropertyReference(String string, String string2) {
            Configuration.this.propertyReferences.add(new Mappings.PropertyReference(string, string2, true));
        }

        @Override
        public void addToExtendsQueue(ExtendsQueueEntry extendsQueueEntry) {
            Configuration.this.extendsQueue.put(extendsQueueEntry, null);
        }

        @Override
        public DefaultIdentifierGeneratorFactory getIdentifierGeneratorFactory() {
            return Configuration.this.identifierGeneratorFactory;
        }

        @Override
        public void addMappedSuperclass(Class clazz, org.hibernate.mapping.MappedSuperclass mappedSuperclass) {
            Configuration.this.mappedSuperClasses.put(clazz, mappedSuperclass);
        }

        @Override
        public org.hibernate.mapping.MappedSuperclass getMappedSuperclass(Class clazz) {
            return (org.hibernate.mapping.MappedSuperclass)Configuration.this.mappedSuperClasses.get(clazz);
        }

        @Override
        public ObjectNameNormalizer getObjectNameNormalizer() {
            return Configuration.this.normalizer;
        }

        @Override
        public Properties getConfigurationProperties() {
            return Configuration.this.properties;
        }

        @Override
        public void addDefaultGenerator(IdGenerator idGenerator) {
            this.addGenerator(idGenerator);
            Configuration.this.defaultNamedGenerators.add(idGenerator.getName());
        }

        @Override
        public boolean isInSecondPass() {
            return Configuration.this.inSecondPass;
        }

        @Override
        public PropertyData getPropertyAnnotatedWithMapsId(XClass xClass, String string) {
            Map map = (Map)Configuration.this.propertiesAnnotatedWithMapsId.get(xClass);
            return map == null ? null : (PropertyData)map.get(string);
        }

        @Override
        public void addPropertyAnnotatedWithMapsId(XClass xClass, PropertyData propertyData) {
            HashMap<String, PropertyData> hashMap = (HashMap<String, PropertyData>)Configuration.this.propertiesAnnotatedWithMapsId.get(xClass);
            if (hashMap == null) {
                hashMap = new HashMap<String, PropertyData>();
                Configuration.this.propertiesAnnotatedWithMapsId.put(xClass, hashMap);
            }
            hashMap.put(propertyData.getProperty().getAnnotation(MapsId.class).value(), propertyData);
        }

        @Override
        public boolean isSpecjProprietarySyntaxEnabled() {
            return Configuration.this.specjProprietarySyntaxEnabled;
        }

        @Override
        public void addPropertyAnnotatedWithMapsIdSpecj(XClass xClass, PropertyData propertyData, String string) {
            HashMap<String, PropertyData> hashMap = (HashMap<String, PropertyData>)Configuration.this.propertiesAnnotatedWithMapsId.get(xClass);
            if (hashMap == null) {
                hashMap = new HashMap<String, PropertyData>();
                Configuration.this.propertiesAnnotatedWithMapsId.put(xClass, hashMap);
            }
            hashMap.put(string, propertyData);
        }

        @Override
        public PropertyData getPropertyAnnotatedWithIdAndToOne(XClass xClass, String string) {
            Map map = (Map)Configuration.this.propertiesAnnotatedWithIdAndToOne.get(xClass);
            return map == null ? null : (PropertyData)map.get(string);
        }

        @Override
        public void addToOneAndIdProperty(XClass xClass, PropertyData propertyData) {
            HashMap<String, PropertyData> hashMap = (HashMap<String, PropertyData>)Configuration.this.propertiesAnnotatedWithIdAndToOne.get(xClass);
            if (hashMap == null) {
                hashMap = new HashMap<String, PropertyData>();
                Configuration.this.propertiesAnnotatedWithIdAndToOne.put(xClass, hashMap);
            }
            hashMap.put(propertyData.getPropertyName(), propertyData);
        }

        @Override
        public boolean useNewGeneratorMappings() {
            if (this.useNewGeneratorMappings == null) {
                String string = this.getConfigurationProperties().getProperty(Configuration.USE_NEW_ID_GENERATOR_MAPPINGS);
                this.useNewGeneratorMappings = Boolean.valueOf(string);
            }
            return this.useNewGeneratorMappings;
        }

        @Override
        public IdGenerator getGenerator(String string) {
            return this.getGenerator(string, null);
        }

        @Override
        public IdGenerator getGenerator(String string, Map<String, IdGenerator> map) {
            IdGenerator idGenerator;
            if (map != null && (idGenerator = map.get(string)) != null) {
                return idGenerator;
            }
            return (IdGenerator)Configuration.this.namedGenerators.get(string);
        }

        @Override
        public void addGenerator(IdGenerator idGenerator) {
            IdGenerator idGenerator2;
            if (!Configuration.this.defaultNamedGenerators.contains(idGenerator.getName()) && (idGenerator2 = Configuration.this.namedGenerators.put(idGenerator.getName(), idGenerator)) != null) {
                log.warn("duplicate generator name {}", (Object)idGenerator2.getName());
            }
        }

        @Override
        public void addGeneratorTable(String string, Properties properties) {
            Properties properties2 = Configuration.this.generatorTables.put(string, properties);
            if (properties2 != null) {
                log.warn("duplicate generator table: {}", (Object)string);
            }
        }

        @Override
        public Properties getGeneratorTableProperties(String string, Map<String, Properties> map) {
            Properties properties;
            if (map != null && (properties = map.get(string)) != null) {
                return properties;
            }
            return (Properties)Configuration.this.generatorTables.get(string);
        }

        @Override
        public Map<String, Join> getJoins(String string) {
            return (Map)Configuration.this.joins.get(string);
        }

        @Override
        public void addJoins(PersistentClass persistentClass, Map<String, Join> map) {
            Map<String, Join> map2 = Configuration.this.joins.put(persistentClass.getEntityName(), map);
            if (map2 != null) {
                log.warn("duplicate joins for class: {}", (Object)persistentClass.getEntityName());
            }
        }

        @Override
        public AnnotatedClassType getClassType(XClass xClass) {
            AnnotatedClassType annotatedClassType = (AnnotatedClassType)((Object)Configuration.this.classTypes.get(xClass.getName()));
            if (annotatedClassType == null) {
                return this.addClassType(xClass);
            }
            return annotatedClassType;
        }

        @Override
        public AnnotatedClassType addClassType(XClass xClass) {
            AnnotatedClassType annotatedClassType = xClass.isAnnotationPresent(Entity.class) ? AnnotatedClassType.ENTITY : (xClass.isAnnotationPresent(Embeddable.class) ? AnnotatedClassType.EMBEDDABLE : (xClass.isAnnotationPresent(MappedSuperclass.class) ? AnnotatedClassType.EMBEDDABLE_SUPERCLASS : AnnotatedClassType.NONE));
            Configuration.this.classTypes.put(xClass.getName(), annotatedClassType);
            return annotatedClassType;
        }

        @Override
        public Map<Table, List<String[]>> getTableUniqueConstraints() {
            HashMap<Table, List<String[]>> hashMap = new HashMap<Table, List<String[]>>(CollectionHelper.determineProperSizing(this.getUniqueConstraintHoldersByTable()), 0.75f);
            for (Map.Entry<Table, List<UniqueConstraintHolder>> entry : this.getUniqueConstraintHoldersByTable().entrySet()) {
                ArrayList<String[]> arrayList = new ArrayList<String[]>(CollectionHelper.determineProperSizing(entry.getValue().size()));
                hashMap.put(entry.getKey(), arrayList);
                for (UniqueConstraintHolder uniqueConstraintHolder : entry.getValue()) {
                    arrayList.add(uniqueConstraintHolder.getColumns());
                }
            }
            return hashMap;
        }

        @Override
        public Map<Table, List<UniqueConstraintHolder>> getUniqueConstraintHoldersByTable() {
            return Configuration.this.uniqueConstraintHoldersByTable;
        }

        @Override
        public void addUniqueConstraints(Table table, List list) {
            ArrayList<UniqueConstraintHolder> arrayList = new ArrayList<UniqueConstraintHolder>(CollectionHelper.determineProperSizing(list.size()));
            int n = this.determineCurrentNumberOfUniqueConstraintHolders(table);
            for (String[] stringArray : list) {
                String string = "key" + n++;
                arrayList.add(new UniqueConstraintHolder().setName(string).setColumns(stringArray));
            }
            this.addUniqueConstraintHolders(table, arrayList);
        }

        private int determineCurrentNumberOfUniqueConstraintHolders(Table table) {
            List<UniqueConstraintHolder> list = this.getUniqueConstraintHoldersByTable().get(table);
            return list == null ? 0 : list.size();
        }

        @Override
        public void addUniqueConstraintHolders(Table table, List<UniqueConstraintHolder> list) {
            List<UniqueConstraintHolder> list2 = this.getUniqueConstraintHoldersByTable().get(table);
            if (list2 == null) {
                list2 = new ArrayList<UniqueConstraintHolder>();
                this.getUniqueConstraintHoldersByTable().put(table, list2);
            }
            list2.addAll(list);
        }

        @Override
        public void addMappedBy(String string, String string2, String string3) {
            Configuration.this.mappedByResolver.put(string + "." + string2, string3);
        }

        @Override
        public String getFromMappedBy(String string, String string2) {
            return (String)Configuration.this.mappedByResolver.get(string + "." + string2);
        }

        @Override
        public void addPropertyReferencedAssociation(String string, String string2, String string3) {
            Configuration.this.propertyRefResolver.put(string + "." + string2, string3);
        }

        @Override
        public String getPropertyReferencedAssociation(String string, String string2) {
            return (String)Configuration.this.propertyRefResolver.get(string + "." + string2);
        }

        @Override
        public ReflectionManager getReflectionManager() {
            return Configuration.this.reflectionManager;
        }

        @Override
        public Map getClasses() {
            return Configuration.this.classes;
        }

        @Override
        public void addAnyMetaDef(AnyMetaDef anyMetaDef) throws AnnotationException {
            if (Configuration.this.anyMetaDefs.containsKey(anyMetaDef.name())) {
                throw new AnnotationException("Two @AnyMetaDef with the same name defined: " + anyMetaDef.name());
            }
            Configuration.this.anyMetaDefs.put(anyMetaDef.name(), anyMetaDef);
        }

        @Override
        public AnyMetaDef getAnyMetaDef(String string) {
            return (AnyMetaDef)Configuration.this.anyMetaDefs.get(string);
        }

        private class TableColumnNameBinding
        implements Serializable {
            private final String tableName;
            private Map logicalToPhysical = new HashMap();
            private Map physicalToLogical = new HashMap();

            private TableColumnNameBinding(String string) {
                this.tableName = string;
            }

            public void addBinding(String string, Column column) {
                this.bindLogicalToPhysical(string, column);
                this.bindPhysicalToLogical(string, column);
            }

            private void bindLogicalToPhysical(String string, Column column) throws DuplicateMappingException {
                String string2;
                String string3 = string.toLowerCase();
                String string4 = this.logicalToPhysical.put(string3, string2 = column.getQuotedName());
                if (string4 != null) {
                    boolean bl;
                    boolean bl2 = bl = column.isQuoted() ? string4.equals(string2) : string4.equalsIgnoreCase(string2);
                    if (!bl) {
                        throw new DuplicateMappingException(" Table [" + this.tableName + "] contains logical column name [" + string + "] referenced by multiple physical column names: [" + string4 + "], [" + string2 + "]", "column-binding", this.tableName + "." + string);
                    }
                }
            }

            private void bindPhysicalToLogical(String string, Column column) throws DuplicateMappingException {
                String string2 = column.getQuotedName();
                String string3 = this.physicalToLogical.put(string2, string);
                if (string3 != null && !string3.equals(string)) {
                    throw new DuplicateMappingException(" Table [" + this.tableName + "] contains phyical column name [" + string2 + "] represented by different logical column names: [" + string3 + "], [" + string + "]", "column-binding", this.tableName + "." + string2);
                }
            }
        }

        private class TableDescription
        implements Serializable {
            final String logicalName;
            final Table denormalizedSupertable;

            TableDescription(String string, Table table) {
                this.logicalName = string;
                this.denormalizedSupertable = table;
            }
        }
    }
}

