/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.SecondPass;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;

public class CopyIdentifierComponentSecondPass
implements SecondPass {
    private final String referencedEntityName;
    private final Component component;
    private final Mappings mappings;
    private final Ejb3JoinColumn[] joinColumns;

    public CopyIdentifierComponentSecondPass(Component component, String string, Ejb3JoinColumn[] ejb3JoinColumnArray, Mappings mappings) {
        this.component = component;
        this.referencedEntityName = string;
        this.mappings = mappings;
        this.joinColumns = ejb3JoinColumnArray;
    }

    public void doSecondPass(Map map) throws MappingException {
        Object object;
        String object22;
        PersistentClass persistentClass = (PersistentClass)map.get(this.referencedEntityName);
        if (persistentClass == null) {
            throw new AnnotationException("Unknown entity name: " + this.referencedEntityName);
        }
        if (!(persistentClass.getIdentifier() instanceof Component)) {
            throw new AssertionFailure("Unexpected identifier type on the referenced entity when mapping a @MapsId: " + this.referencedEntityName);
        }
        Component component = (Component)persistentClass.getIdentifier();
        Iterator iterator = component.getPropertyIterator();
        boolean bl = true;
        HashMap<String, Ejb3JoinColumn> hashMap = new HashMap<String, Ejb3JoinColumn>(this.joinColumns.length);
        Ejb3JoinColumn[] ejb3JoinColumnArray = this.joinColumns;
        int n = ejb3JoinColumnArray.length;
        for (int i = 0; i < n && (object22 = ((Ejb3JoinColumn)(object = ejb3JoinColumnArray[i])).getReferencedColumn()) != null && !BinderHelper.isEmptyAnnotationValue(object22); ++i) {
            hashMap.put(object22.toLowerCase(), (Ejb3JoinColumn)object);
        }
        int n2 = 0;
        if (hashMap.isEmpty()) {
            bl = false;
            for (Ejb3JoinColumn ejb3JoinColumn : this.joinColumns) {
                hashMap.put("" + n2, ejb3JoinColumn);
                ++n2;
            }
            n2 = 0;
        }
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (property.isComposite()) {
                throw new AssertionFailure("Unexpected nested component on the referenced entity when mapping a @MapsId: " + this.referencedEntityName);
            }
            Property property2 = new Property();
            property2.setName(property.getName());
            property2.setNodeName(property.getNodeName());
            property2.setPersistentClass(this.component.getOwner());
            property2.setPropertyAccessorName(property.getPropertyAccessorName());
            object = new SimpleValue(this.mappings, this.component.getTable());
            property2.setValue((Value)object);
            SimpleValue simpleValue = (SimpleValue)property.getValue();
            ((SimpleValue)object).setTypeName(simpleValue.getTypeName());
            ((SimpleValue)object).setTypeParameters(simpleValue.getTypeParameters());
            Iterator iterator2 = simpleValue.getColumnIterator();
            if (this.joinColumns[0].isNameDeferred()) {
                this.joinColumns[0].copyReferencedStructureAndCreateDefaultJoinColumns(persistentClass, iterator2, (SimpleValue)object);
            } else {
                while (iterator2.hasNext()) {
                    Ejb3JoinColumn ejb3JoinColumn;
                    String string;
                    Column column = (Column)iterator2.next();
                    String string2 = null;
                    if (bl) {
                        string = column.getName();
                        string2 = this.mappings.getLogicalColumnName(string, persistentClass.getTable());
                        ejb3JoinColumn = (Ejb3JoinColumn)hashMap.get(string2.toLowerCase());
                    } else {
                        ejb3JoinColumn = (Ejb3JoinColumn)hashMap.get("" + n2);
                        ++n2;
                    }
                    if (ejb3JoinColumn == null && !this.joinColumns[0].isNameDeferred()) {
                        throw new AnnotationException(bl ? "Unable to find column reference in the @MapsId mapping: " + string2 : "Implicit column reference in the @MapsId mapping fails, try to use explicit referenceColumnNames: " + this.referencedEntityName);
                    }
                    string = ejb3JoinColumn == null || ejb3JoinColumn.isNameDeferred() ? "tata_" + column.getName() : ejb3JoinColumn.getName();
                    ((SimpleValue)object).addColumn(new Column(string));
                    column.setValue((Value)object);
                }
            }
            this.component.addProperty(property2);
        }
    }
}

