/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import org.hibernate.cfg.NamingStrategy;
import org.hibernate.util.StringHelper;

public abstract class ObjectNameNormalizer {
    public String normalizeDatabaseIdentifier(String string, NamingStrategyHelper namingStrategyHelper) {
        if (StringHelper.isEmpty(string)) {
            String string2 = namingStrategyHelper.determineImplicitName(this.getNamingStrategy());
            return this.normalizeIdentifierQuoting(string2);
        }
        String string3 = this.normalizeIdentifierQuoting(string);
        string3 = namingStrategyHelper.handleExplicitName(this.getNamingStrategy(), string3);
        return this.normalizeIdentifierQuoting(string3);
    }

    public String normalizeIdentifierQuoting(String string) {
        if (StringHelper.isEmpty(string)) {
            return null;
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return '`' + string.substring(1, string.length() - 1) + '`';
        }
        if (!(!this.isUseQuotedIdentifiersGlobally() || string.startsWith("`") && string.endsWith("`"))) {
            return '`' + string + '`';
        }
        return string;
    }

    protected abstract boolean isUseQuotedIdentifiersGlobally();

    protected abstract NamingStrategy getNamingStrategy();

    public static interface NamingStrategyHelper {
        public String determineImplicitName(NamingStrategy var1);

        public String handleExplicitName(NamingStrategy var1, String var2);
    }
}

