/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import javax.persistence.Access;
import org.hibernate.MappingException;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.AccessType;
import org.hibernate.cfg.PropertyData;

public class PropertyInferredData
implements PropertyData {
    private final AccessType defaultAccess;
    private final XProperty property;
    private final ReflectionManager reflectionManager;
    private final XClass declaringClass;

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PropertyInferredData");
        stringBuilder.append("{property=").append(this.property);
        stringBuilder.append(", declaringClass=").append(this.declaringClass);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public PropertyInferredData(XClass xClass, XProperty xProperty, String string, ReflectionManager reflectionManager) {
        this.declaringClass = xClass;
        this.property = xProperty;
        this.defaultAccess = AccessType.getAccessStrategy(string);
        this.reflectionManager = reflectionManager;
    }

    public AccessType getDefaultAccess() throws MappingException {
        Access access;
        AccessType accessType = this.defaultAccess;
        AccessType accessType2 = AccessType.DEFAULT;
        AccessType accessType3 = AccessType.DEFAULT;
        org.hibernate.annotations.AccessType accessType4 = this.property.getAnnotation(org.hibernate.annotations.AccessType.class);
        if (accessType4 != null) {
            accessType2 = AccessType.getAccessStrategy(accessType4.value());
        }
        if ((access = this.property.getAnnotation(Access.class)) != null) {
            accessType3 = AccessType.getAccessStrategy(access.value());
        }
        if (accessType2 != AccessType.DEFAULT && accessType3 != AccessType.DEFAULT && accessType2 != accessType3) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.property.toString());
            stringBuilder.append(" defines @AccessType and @Access with contradicting values. Use of @Access only is recommended.");
            throw new MappingException(stringBuilder.toString());
        }
        if (accessType2 != AccessType.DEFAULT) {
            accessType = accessType2;
        } else if (accessType3 != AccessType.DEFAULT) {
            accessType = accessType3;
        }
        return accessType;
    }

    public String getPropertyName() throws MappingException {
        return this.property.getName();
    }

    public XClass getPropertyClass() throws MappingException {
        if (this.property.isAnnotationPresent(Target.class)) {
            return this.reflectionManager.toXClass(this.property.getAnnotation(Target.class).value());
        }
        return this.property.getType();
    }

    public XClass getClassOrElement() throws MappingException {
        if (this.property.isAnnotationPresent(Target.class)) {
            return this.reflectionManager.toXClass(this.property.getAnnotation(Target.class).value());
        }
        return this.property.getClassOrElementClass();
    }

    public String getClassOrElementName() throws MappingException {
        return this.getClassOrElement().getName();
    }

    public String getTypeName() throws MappingException {
        return this.getPropertyClass().getName();
    }

    public XProperty getProperty() {
        return this.property;
    }

    public XClass getDeclaringClass() {
        return this.declaringClass;
    }
}

