/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.cfg.HbmBinder;
import org.hibernate.cfg.Mappings;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.query.sql.NativeSQLQueryCollectionReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryJoinReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryRootReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryScalarReturn;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ToOne;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.StringHelper;

public abstract class ResultSetMappingBinder {
    protected static ResultSetMappingDefinition buildResultSetMappingDefinition(Element element, String string, Mappings mappings) {
        String string2 = element.attribute("name").getValue();
        if (string != null) {
            string2 = string + '.' + string2;
        }
        ResultSetMappingDefinition resultSetMappingDefinition = new ResultSetMappingDefinition(string2);
        int n = 0;
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            ++n;
            Element element2 = (Element)iterator.next();
            String string3 = element2.getName();
            if ("return-scalar".equals(string3)) {
                String string4 = element2.attributeValue("column");
                String string5 = HbmBinder.getTypeFromXML(element2);
                Type type = null;
                if (string5 != null && (type = mappings.getTypeResolver().heuristicType(string5)) == null) {
                    throw new MappingException("could not determine type " + type);
                }
                resultSetMappingDefinition.addQueryReturn(new NativeSQLQueryScalarReturn(string4, type));
                continue;
            }
            if ("return".equals(string3)) {
                resultSetMappingDefinition.addQueryReturn(ResultSetMappingBinder.bindReturn(element2, mappings, n));
                continue;
            }
            if ("return-join".equals(string3)) {
                resultSetMappingDefinition.addQueryReturn(ResultSetMappingBinder.bindReturnJoin(element2, mappings));
                continue;
            }
            if (!"load-collection".equals(string3)) continue;
            resultSetMappingDefinition.addQueryReturn(ResultSetMappingBinder.bindLoadCollection(element2, mappings));
        }
        return resultSetMappingDefinition;
    }

    private static NativeSQLQueryRootReturn bindReturn(Element element, Mappings mappings, int n) {
        String string;
        String string2 = element.attributeValue("alias");
        if (StringHelper.isEmpty(string2)) {
            string2 = "alias_" + n;
        }
        if ((string = HbmBinder.getEntityName(element, mappings)) == null) {
            throw new MappingException("<return alias='" + string2 + "'> must specify either a class or entity-name");
        }
        LockMode lockMode = ResultSetMappingBinder.getLockMode(element.attributeValue("lock-mode"));
        PersistentClass persistentClass = mappings.getClass(string);
        Map map = ResultSetMappingBinder.bindPropertyResults(string2, element, persistentClass, mappings);
        return new NativeSQLQueryRootReturn(string2, string, map, lockMode);
    }

    private static NativeSQLQueryJoinReturn bindReturnJoin(Element element, Mappings mappings) {
        String string = element.attributeValue("alias");
        String string2 = element.attributeValue("property");
        LockMode lockMode = ResultSetMappingBinder.getLockMode(element.attributeValue("lock-mode"));
        int n = string2.lastIndexOf(46);
        if (n == -1) {
            throw new MappingException("Role attribute for sql query return [alias=" + string + "] not formatted correctly {owningAlias.propertyName}");
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        Map map = ResultSetMappingBinder.bindPropertyResults(string, element, null, mappings);
        return new NativeSQLQueryJoinReturn(string, string3, string4, map, lockMode);
    }

    private static NativeSQLQueryCollectionReturn bindLoadCollection(Element element, Mappings mappings) {
        String string = element.attributeValue("alias");
        String string2 = element.attributeValue("role");
        LockMode lockMode = ResultSetMappingBinder.getLockMode(element.attributeValue("lock-mode"));
        int n = string2.lastIndexOf(46);
        if (n == -1) {
            throw new MappingException("Collection attribute for sql query return [alias=" + string + "] not formatted correctly {OwnerClassName.propertyName}");
        }
        String string3 = HbmBinder.getClassName(string2.substring(0, n), mappings);
        String string4 = string2.substring(n + 1);
        Map map = ResultSetMappingBinder.bindPropertyResults(string, element, null, mappings);
        return new NativeSQLQueryCollectionReturn(string, string3, string4, map, lockMode);
    }

    private static Map bindPropertyResults(String string, Element element, PersistentClass persistentClass, Mappings mappings) {
        Object object;
        Object object2;
        Object object3;
        Cloneable cloneable;
        Iterator iterator;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Element element2 = element.element("return-discriminator");
        if (element2 != null) {
            iterator = ResultSetMappingBinder.getResultColumns(element2);
            hashMap.put("class", ArrayHelper.toStringArray((Collection)((Object)iterator)));
        }
        iterator = element.elementIterator("return-property");
        ArrayList<Cloneable> arrayList = new ArrayList<Cloneable>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (iterator.hasNext()) {
            Serializable serializable;
            SimpleValue simpleValue;
            cloneable = (Element)iterator.next();
            String object4 = cloneable.attributeValue("name");
            if (persistentClass == null || object4.indexOf(46) == -1) {
                arrayList.add(cloneable);
                arrayList2.add(object4);
                continue;
            }
            if (persistentClass == null) {
                throw new MappingException("dotted notation in <return-join> or <load_collection> not yet supported");
            }
            int n = object4.lastIndexOf(46);
            object3 = object4.substring(0, n);
            object2 = persistentClass.getRecursiveProperty((String)object3).getValue();
            if (object2 instanceof Component) {
                simpleValue = (Component)object2;
                object = ((Component)simpleValue).getPropertyIterator();
            } else if (object2 instanceof ToOne) {
                simpleValue = (ToOne)object2;
                serializable = mappings.getClass(((ToOne)simpleValue).getReferencedEntityName());
                if (((ToOne)simpleValue).getReferencedPropertyName() != null) {
                    try {
                        object = ((Component)((PersistentClass)serializable).getRecursiveProperty(((ToOne)simpleValue).getReferencedPropertyName()).getValue()).getPropertyIterator();
                    }
                    catch (ClassCastException classCastException) {
                        throw new MappingException("dotted notation reference neither a component nor a many/one to one", classCastException);
                    }
                } else {
                    try {
                        if (((PersistentClass)serializable).getIdentifierMapper() == null) {
                            object = ((Component)((PersistentClass)serializable).getIdentifierProperty().getValue()).getPropertyIterator();
                        }
                        object = ((PersistentClass)serializable).getIdentifierMapper().getPropertyIterator();
                    }
                    catch (ClassCastException classCastException) {
                        throw new MappingException("dotted notation reference neither a component nor a many/one to one", classCastException);
                    }
                }
            } else {
                throw new MappingException("dotted notation reference neither a component nor a many/one to one");
            }
            boolean bl = false;
            serializable = new ArrayList();
            while (object.hasNext()) {
                String string2 = ((Property)object.next()).getName();
                String string3 = (String)object3 + '.' + string2;
                if (bl) {
                    serializable.add(string3);
                }
                if (!object4.equals(string3)) continue;
                bl = true;
            }
            int string2 = arrayList2.size();
            int n2 = serializable.size();
            for (int i = 0; i < n2; ++i) {
                String string4 = (String)serializable.get(i);
                int n3 = ResultSetMappingBinder.getIndexOfFirstMatchingProperty(arrayList2, string4);
                string2 = n3 != -1 && n3 < string2 ? n3 : string2;
            }
            arrayList2.add(string2, object4);
            arrayList.add(string2, cloneable);
        }
        cloneable = new HashSet();
        for (Element element3 : arrayList) {
            String string5 = element3.attributeValue("name");
            if ("class".equals(string5)) {
                throw new MappingException("class is not a valid property name to use in a <return-property>, use <return-discriminator> instead");
            }
            object3 = ResultSetMappingBinder.getResultColumns(element3);
            if (((ArrayList)object3).isEmpty()) {
                throw new MappingException("return-property for alias " + string + " must specify at least one column or return-column name");
            }
            if (cloneable.contains(string5)) {
                throw new MappingException("duplicate return-property for property " + string5 + " on alias " + string);
            }
            cloneable.add(string5);
            object2 = string5;
            object = (ArrayList)hashMap.get(object2);
            if (object == null) {
                hashMap.put(object2, object3);
                continue;
            }
            ((ArrayList)object).addAll(object3);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            if (!(entry.getValue() instanceof ArrayList)) continue;
            object3 = (ArrayList)entry.getValue();
            entry.setValue(((ArrayList)object3).toArray(new String[((ArrayList)object3).size()]));
        }
        return hashMap.isEmpty() ? CollectionHelper.EMPTY_MAP : hashMap;
    }

    private static int getIndexOfFirstMatchingProperty(List list, String string) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!((String)list.get(i)).startsWith(string)) continue;
            return i;
        }
        return -1;
    }

    private static ArrayList getResultColumns(Element element) {
        String string = ResultSetMappingBinder.unquote(element.attributeValue("column"));
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            arrayList.add(string);
        }
        Iterator iterator = element.elementIterator("return-column");
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            arrayList.add(ResultSetMappingBinder.unquote(element2.attributeValue("name")));
        }
        return arrayList;
    }

    private static String unquote(String string) {
        if (string != null && string.charAt(0) == '`') {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    private static LockMode getLockMode(String string) {
        if (string == null || "read".equals(string)) {
            return LockMode.READ;
        }
        if ("none".equals(string)) {
            return LockMode.NONE;
        }
        if ("upgrade".equals(string)) {
            return LockMode.UPGRADE;
        }
        if ("upgrade-nowait".equals(string)) {
            return LockMode.UPGRADE_NOWAIT;
        }
        if ("write".equals(string)) {
            return LockMode.WRITE;
        }
        if ("force".equals(string)) {
            return LockMode.FORCE;
        }
        if ("optimistic".equals(string)) {
            return LockMode.OPTIMISTIC;
        }
        if ("optimistic_force_increment".equals(string)) {
            return LockMode.OPTIMISTIC_FORCE_INCREMENT;
        }
        if ("pessimistic_read".equals(string)) {
            return LockMode.PESSIMISTIC_READ;
        }
        if ("pessimistic_write".equals(string)) {
            return LockMode.PESSIMISTIC_WRITE;
        }
        if ("pessimistic_force_increment".equals(string)) {
            return LockMode.PESSIMISTIC_FORCE_INCREMENT;
        }
        throw new MappingException("unknown lockmode");
    }
}

