/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.BytecodeProvider;
import org.hibernate.bytecode.cglib.BytecodeProviderImpl;
import org.hibernate.cache.QueryCacheFactory;
import org.hibernate.cache.RegionFactory;
import org.hibernate.cache.impl.NoCachingRegionFactory;
import org.hibernate.cache.impl.bridge.RegionFactoryCacheProviderBridge;
import org.hibernate.cfg.Settings;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.resolver.DialectFactory;
import org.hibernate.engine.jdbc.JdbcSupport;
import org.hibernate.engine.jdbc.JdbcSupportLoader;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.exception.SQLExceptionConverterFactory;
import org.hibernate.hql.QueryTranslatorFactory;
import org.hibernate.jdbc.BatcherFactory;
import org.hibernate.jdbc.BatchingBatcherFactory;
import org.hibernate.jdbc.NonBatchingBatcherFactory;
import org.hibernate.jdbc.util.SQLStatementLogger;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.transaction.TransactionFactoryFactory;
import org.hibernate.transaction.TransactionManagerLookup;
import org.hibernate.transaction.TransactionManagerLookupFactory;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsFactory
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(SettingsFactory.class);
    private static final long serialVersionUID = -1194386144994524825L;
    public static final String DEF_CACHE_REG_FACTORY = NoCachingRegionFactory.class.getName();

    protected SettingsFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Settings buildSettings(Properties properties) {
        SQLExceptionConverter sQLExceptionConverter;
        ConnectionReleaseMode connectionReleaseMode;
        Object object;
        Object object2;
        Settings settings = new Settings();
        String string = properties.getProperty("hibernate.session_factory_name");
        settings.setSessionFactoryName(string);
        ConnectionProvider connectionProvider = this.createConnectionProvider(properties);
        settings.setConnectionProvider(connectionProvider);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        Dialect dialect = null;
        JdbcSupport jdbcSupport = null;
        boolean bl6 = PropertiesHelper.getBoolean("hibernate.temp.use_jdbc_metadata_defaults", properties, true);
        if (bl6) {
            try {
                object2 = connectionProvider.getConnection();
                try {
                    object = object2.getMetaData();
                    log.info("Database ->\n       name : " + object.getDatabaseProductName() + '\n' + "    version : " + object.getDatabaseProductVersion() + '\n' + "      major : " + object.getDatabaseMajorVersion() + '\n' + "      minor : " + object.getDatabaseMinorVersion());
                    log.info("Driver ->\n       name : " + object.getDriverName() + '\n' + "    version : " + object.getDriverVersion() + '\n' + "      major : " + object.getDriverMajorVersion() + '\n' + "      minor : " + object.getDriverMinorVersion());
                    dialect = DialectFactory.buildDialect(properties, (Connection)object2);
                    jdbcSupport = JdbcSupportLoader.loadJdbcSupport((Connection)object2);
                    bl = object.supportsResultSetType(1004);
                    bl3 = object.supportsBatchUpdates();
                    bl4 = object.dataDefinitionCausesTransactionCommit();
                    bl5 = !object.dataDefinitionIgnoredInTransactions();
                    bl2 = object.supportsGetGeneratedKeys();
                }
                catch (SQLException sQLException) {
                    log.warn("Could not obtain connection metadata", sQLException);
                }
                finally {
                    connectionProvider.closeConnection((Connection)object2);
                }
            }
            catch (SQLException sQLException) {
                log.warn("Could not obtain connection to query metadata", sQLException);
                dialect = DialectFactory.buildDialect(properties);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                dialect = DialectFactory.buildDialect(properties);
            }
        } else {
            dialect = DialectFactory.buildDialect(properties);
        }
        settings.setDataDefinitionImplicitCommit(bl4);
        settings.setDataDefinitionInTransactionSupported(bl5);
        settings.setDialect(dialect);
        if (jdbcSupport == null) {
            jdbcSupport = JdbcSupportLoader.loadJdbcSupport(null);
        }
        settings.setJdbcSupport(jdbcSupport);
        object2 = new Properties();
        ((Properties)object2).putAll((Map<?, ?>)dialect.getDefaultProperties());
        ((Properties)object2).putAll((Map<?, ?>)properties);
        object = this.createTransactionFactory((Properties)object2);
        settings.setTransactionFactory((TransactionFactory)object);
        settings.setTransactionManagerLookup(this.createTransactionManagerLookup((Properties)object2));
        boolean bl7 = PropertiesHelper.getBoolean("hibernate.transaction.flush_before_completion", (Properties)object2);
        log.info("Automatic flush during beforeCompletion(): " + SettingsFactory.enabledDisabled(bl7));
        settings.setFlushBeforeCompletionEnabled(bl7);
        boolean bl8 = PropertiesHelper.getBoolean("hibernate.transaction.auto_close_session", (Properties)object2);
        log.info("Automatic session close at end of transaction: " + SettingsFactory.enabledDisabled(bl8));
        settings.setAutoCloseSessionEnabled(bl8);
        int n = PropertiesHelper.getInt("hibernate.jdbc.batch_size", (Properties)object2, 0);
        if (!bl3) {
            n = 0;
        }
        if (n > 0) {
            log.info("JDBC batch size: " + n);
        }
        settings.setJdbcBatchSize(n);
        boolean bl9 = PropertiesHelper.getBoolean("hibernate.jdbc.batch_versioned_data", (Properties)object2, false);
        if (n > 0) {
            log.info("JDBC batch updates for versioned data: " + SettingsFactory.enabledDisabled(bl9));
        }
        settings.setJdbcBatchVersionedData(bl9);
        settings.setBatcherFactory(this.createBatcherFactory((Properties)object2, n));
        boolean bl10 = PropertiesHelper.getBoolean("hibernate.jdbc.use_scrollable_resultset", (Properties)object2, bl);
        log.info("Scrollable result sets: " + SettingsFactory.enabledDisabled(bl10));
        settings.setScrollableResultSetsEnabled(bl10);
        boolean bl11 = PropertiesHelper.getBoolean("hibernate.jdbc.wrap_result_sets", (Properties)object2, false);
        log.debug("Wrap result sets: " + SettingsFactory.enabledDisabled(bl11));
        settings.setWrapResultSetsEnabled(bl11);
        boolean bl12 = PropertiesHelper.getBoolean("hibernate.jdbc.use_get_generated_keys", (Properties)object2, bl2);
        log.info("JDBC3 getGeneratedKeys(): " + SettingsFactory.enabledDisabled(bl12));
        settings.setGetGeneratedKeysEnabled(bl12);
        Integer n2 = PropertiesHelper.getInteger("hibernate.jdbc.fetch_size", (Properties)object2);
        if (n2 != null) {
            log.info("JDBC result set fetch size: " + n2);
        }
        settings.setJdbcFetchSize(n2);
        String string2 = PropertiesHelper.getString("hibernate.connection.release_mode", (Properties)object2, "auto");
        log.info("Connection release mode: " + string2);
        if ("auto".equals(string2)) {
            connectionReleaseMode = object.getDefaultReleaseMode();
        } else {
            connectionReleaseMode = ConnectionReleaseMode.parse(string2);
            if (connectionReleaseMode == ConnectionReleaseMode.AFTER_STATEMENT && !connectionProvider.supportsAggressiveRelease()) {
                log.warn("Overriding release mode as connection provider does not support 'after_statement'");
                connectionReleaseMode = ConnectionReleaseMode.AFTER_TRANSACTION;
            }
        }
        settings.setConnectionReleaseMode(connectionReleaseMode);
        String string3 = ((Properties)object2).getProperty("hibernate.default_schema");
        String string4 = ((Properties)object2).getProperty("hibernate.default_catalog");
        if (string3 != null) {
            log.info("Default schema: " + string3);
        }
        if (string4 != null) {
            log.info("Default catalog: " + string4);
        }
        settings.setDefaultSchemaName(string3);
        settings.setDefaultCatalogName(string4);
        Integer n3 = PropertiesHelper.getInteger("hibernate.max_fetch_depth", (Properties)object2);
        if (n3 != null) {
            log.info("Maximum outer join fetch depth: " + n3);
        }
        settings.setMaximumFetchDepth(n3);
        int n4 = PropertiesHelper.getInt("hibernate.default_batch_fetch_size", (Properties)object2, 1);
        log.info("Default batch fetch size: " + n4);
        settings.setDefaultBatchFetchSize(n4);
        boolean bl13 = PropertiesHelper.getBoolean("hibernate.use_sql_comments", (Properties)object2);
        log.info("Generate SQL with comments: " + SettingsFactory.enabledDisabled(bl13));
        settings.setCommentsEnabled(bl13);
        boolean bl14 = PropertiesHelper.getBoolean("hibernate.order_updates", (Properties)object2);
        log.info("Order SQL updates by primary key: " + SettingsFactory.enabledDisabled(bl14));
        settings.setOrderUpdatesEnabled(bl14);
        boolean bl15 = PropertiesHelper.getBoolean("hibernate.order_inserts", (Properties)object2);
        log.info("Order SQL inserts for batching: " + SettingsFactory.enabledDisabled(bl15));
        settings.setOrderInsertsEnabled(bl15);
        settings.setQueryTranslatorFactory(this.createQueryTranslatorFactory((Properties)object2));
        Map map = PropertiesHelper.toMap("hibernate.query.substitutions", " ,=;:\n\t\r\f", (Properties)object2);
        log.info("Query language substitutions: " + map);
        settings.setQuerySubstitutions(map);
        boolean bl16 = PropertiesHelper.getBoolean("hibernate.query.jpaql_strict_compliance", (Properties)object2, false);
        settings.setStrictJPAQLCompliance(bl16);
        log.info("JPA-QL strict compliance: " + SettingsFactory.enabledDisabled(bl16));
        boolean bl17 = PropertiesHelper.getBoolean("hibernate.cache.use_second_level_cache", (Properties)object2, true);
        log.info("Second-level cache: " + SettingsFactory.enabledDisabled(bl17));
        settings.setSecondLevelCacheEnabled(bl17);
        boolean bl18 = PropertiesHelper.getBoolean("hibernate.cache.use_query_cache", (Properties)object2);
        log.info("Query cache: " + SettingsFactory.enabledDisabled(bl18));
        settings.setQueryCacheEnabled(bl18);
        settings.setRegionFactory(SettingsFactory.createRegionFactory((Properties)object2, bl17 || bl18));
        boolean bl19 = PropertiesHelper.getBoolean("hibernate.cache.use_minimal_puts", (Properties)object2, settings.getRegionFactory().isMinimalPutsEnabledByDefault());
        log.info("Optimize cache for minimal puts: " + SettingsFactory.enabledDisabled(bl19));
        settings.setMinimalPutsEnabled(bl19);
        String string5 = ((Properties)object2).getProperty("hibernate.cache.region_prefix");
        if (StringHelper.isEmpty(string5)) {
            string5 = null;
        }
        if (string5 != null) {
            log.info("Cache region prefix: " + string5);
        }
        settings.setCacheRegionPrefix(string5);
        boolean bl20 = PropertiesHelper.getBoolean("hibernate.cache.use_structured_entries", (Properties)object2, false);
        log.info("Structured second-level cache entries: " + SettingsFactory.enabledDisabled(bl20));
        settings.setStructuredCacheEntriesEnabled(bl20);
        if (bl18) {
            settings.setQueryCacheFactory(this.createQueryCacheFactory((Properties)object2));
        }
        try {
            sQLExceptionConverter = SQLExceptionConverterFactory.buildSQLExceptionConverter(dialect, (Properties)object2);
        }
        catch (HibernateException hibernateException) {
            log.warn("Error building SQLExceptionConverter; using minimal converter");
            sQLExceptionConverter = SQLExceptionConverterFactory.buildMinimalSQLExceptionConverter();
        }
        settings.setSQLExceptionConverter(sQLExceptionConverter);
        boolean bl21 = PropertiesHelper.getBoolean("hibernate.show_sql", (Properties)object2);
        if (bl21) {
            log.info("Echoing all SQL to stdout");
        }
        boolean bl22 = PropertiesHelper.getBoolean("hibernate.format_sql", (Properties)object2);
        settings.setSqlStatementLogger(new SQLStatementLogger(bl21, bl22));
        boolean bl23 = PropertiesHelper.getBoolean("hibernate.generate_statistics", (Properties)object2);
        log.info("Statistics: " + SettingsFactory.enabledDisabled(bl23));
        settings.setStatisticsEnabled(bl23);
        boolean bl24 = PropertiesHelper.getBoolean("hibernate.use_identifier_rollback", (Properties)object2);
        log.info("Deleted entity synthetic identifier rollback: " + SettingsFactory.enabledDisabled(bl24));
        settings.setIdentifierRollbackEnabled(bl24);
        String string6 = ((Properties)object2).getProperty("hibernate.hbm2ddl.auto");
        if ("validate".equals(string6)) {
            settings.setAutoValidateSchema(true);
        }
        if ("update".equals(string6)) {
            settings.setAutoUpdateSchema(true);
        }
        if ("create".equals(string6)) {
            settings.setAutoCreateSchema(true);
        }
        if ("create-drop".equals(string6)) {
            settings.setAutoCreateSchema(true);
            settings.setAutoDropSchema(true);
        }
        settings.setImportFiles(((Properties)object2).getProperty("hibernate.hbm2ddl.import_files"));
        EntityMode entityMode = EntityMode.parse(((Properties)object2).getProperty("hibernate.default_entity_mode"));
        log.info("Default entity-mode: " + entityMode);
        settings.setDefaultEntityMode(entityMode);
        boolean bl25 = PropertiesHelper.getBoolean("hibernate.query.startup_check", (Properties)object2, true);
        log.info("Named query checking : " + SettingsFactory.enabledDisabled(bl25));
        settings.setNamedQueryStartupCheckingEnabled(bl25);
        boolean bl26 = PropertiesHelper.getBoolean("hibernate.check_nullability", (Properties)object2, true);
        log.info("Check Nullability in Core (should be disabled when Bean Validation is on): " + SettingsFactory.enabledDisabled(bl26));
        settings.setCheckNullability(bl26);
        return settings;
    }

    protected BytecodeProvider buildBytecodeProvider(String string) {
        if ("javassist".equals(string)) {
            return new org.hibernate.bytecode.javassist.BytecodeProviderImpl();
        }
        if ("cglib".equals(string)) {
            return new BytecodeProviderImpl();
        }
        log.debug("using javassist as bytecode provider by default");
        return new org.hibernate.bytecode.javassist.BytecodeProviderImpl();
    }

    private static String enabledDisabled(boolean bl) {
        return bl ? "enabled" : "disabled";
    }

    protected QueryCacheFactory createQueryCacheFactory(Properties properties) {
        String string = PropertiesHelper.getString("hibernate.cache.query_cache_factory", properties, "org.hibernate.cache.StandardQueryCacheFactory");
        log.info("Query cache factory: " + string);
        try {
            return (QueryCacheFactory)ReflectHelper.classForName(string).newInstance();
        }
        catch (Exception exception) {
            throw new HibernateException("could not instantiate QueryCacheFactory: " + string, exception);
        }
    }

    public static RegionFactory createRegionFactory(Properties properties, boolean bl) {
        String string;
        String string2 = PropertiesHelper.getString("hibernate.cache.region.factory_class", properties, null);
        if (string2 == null && bl && (string = PropertiesHelper.getString("hibernate.cache.provider_class", properties, null)) != null) {
            string2 = RegionFactoryCacheProviderBridge.class.getName();
        }
        if (string2 == null) {
            string2 = DEF_CACHE_REG_FACTORY;
        }
        log.info("Cache region factory : " + string2);
        try {
            try {
                return (RegionFactory)ReflectHelper.classForName(string2).getConstructor(Properties.class).newInstance(properties);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                log.debug(string2 + " did not provide constructor accepting java.util.Properties; " + "attempting no-arg constructor.");
                return (RegionFactory)ReflectHelper.classForName(string2).newInstance();
            }
        }
        catch (Exception exception) {
            throw new HibernateException("could not instantiate RegionFactory [" + string2 + "]", exception);
        }
    }

    protected QueryTranslatorFactory createQueryTranslatorFactory(Properties properties) {
        String string = PropertiesHelper.getString("hibernate.query.factory_class", properties, "org.hibernate.hql.ast.ASTQueryTranslatorFactory");
        log.info("Query translator: " + string);
        try {
            return (QueryTranslatorFactory)ReflectHelper.classForName(string).newInstance();
        }
        catch (Exception exception) {
            throw new HibernateException("could not instantiate QueryTranslatorFactory: " + string, exception);
        }
    }

    protected BatcherFactory createBatcherFactory(Properties properties, int n) {
        String string = properties.getProperty("hibernate.jdbc.factory_class");
        if (string == null) {
            return n == 0 ? new NonBatchingBatcherFactory() : new BatchingBatcherFactory();
        }
        log.info("Batcher factory: " + string);
        try {
            return (BatcherFactory)ReflectHelper.classForName(string).newInstance();
        }
        catch (Exception exception) {
            throw new HibernateException("could not instantiate BatcherFactory: " + string, exception);
        }
    }

    protected ConnectionProvider createConnectionProvider(Properties properties) {
        return ConnectionProviderFactory.newConnectionProvider(properties);
    }

    protected TransactionFactory createTransactionFactory(Properties properties) {
        return TransactionFactoryFactory.buildTransactionFactory(properties);
    }

    protected TransactionManagerLookup createTransactionManagerLookup(Properties properties) {
        return TransactionManagerLookupFactory.getTransactionManagerLookup(properties);
    }
}

