/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.PropertyData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToOneBinder {
    public static String getReferenceEntityName(PropertyData propertyData, XClass xClass, Mappings mappings) {
        if (AnnotationBinder.isDefault(xClass, mappings)) {
            return propertyData.getClassOrElementName();
        }
        return xClass.getName();
    }

    public static String getReferenceEntityName(PropertyData propertyData, Mappings mappings) {
        XClass xClass = ToOneBinder.getTargetEntity(propertyData, mappings);
        if (AnnotationBinder.isDefault(xClass, mappings)) {
            return propertyData.getClassOrElementName();
        }
        return xClass.getName();
    }

    public static XClass getTargetEntity(PropertyData propertyData, Mappings mappings) {
        XProperty xProperty = propertyData.getProperty();
        return mappings.getReflectionManager().toXClass(ToOneBinder.getTargetEntityClass(xProperty));
    }

    private static Class<?> getTargetEntityClass(XProperty xProperty) {
        ManyToOne manyToOne = xProperty.getAnnotation(ManyToOne.class);
        if (manyToOne != null) {
            return manyToOne.targetEntity();
        }
        OneToOne oneToOne = xProperty.getAnnotation(OneToOne.class);
        if (oneToOne != null) {
            return oneToOne.targetEntity();
        }
        throw new AssertionFailure("Unexpected discovery of a targetEntity: " + xProperty.getName());
    }
}

