/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Iterator;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.FkSecondPass;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.ToOne;
import org.hibernate.util.StringHelper;

public class ToOneFkSecondPass
extends FkSecondPass {
    private boolean unique;
    private Mappings mappings;
    private String path;
    private String entityClassName;

    public ToOneFkSecondPass(ToOne toOne, Ejb3JoinColumn[] ejb3JoinColumnArray, boolean bl, String string, String string2, Mappings mappings) {
        super(toOne, ejb3JoinColumnArray);
        this.mappings = mappings;
        this.unique = bl;
        this.entityClassName = string;
        this.path = string != null ? string2.substring(string.length() + 1) : string2;
    }

    public String getReferencedEntityName() {
        return ((ToOne)this.value).getReferencedEntityName();
    }

    public boolean isInPrimaryKey() {
        if (this.entityClassName == null) {
            return false;
        }
        PersistentClass persistentClass = this.mappings.getClass(this.entityClassName);
        Property property = persistentClass.getIdentifierProperty();
        if (this.path == null) {
            return false;
        }
        if (property != null) {
            return this.path.startsWith(property.getName() + ".");
        }
        if (this.path.startsWith("id.")) {
            KeyValue keyValue = persistentClass.getIdentifier();
            String string = this.path.substring(3);
            if (keyValue instanceof Component) {
                Iterator iterator = ((Component)keyValue).getPropertyIterator();
                while (iterator.hasNext()) {
                    Property property2 = (Property)iterator.next();
                    if (!string.startsWith(property2.getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void doSecondPass(Map map) throws MappingException {
        if (this.value instanceof ManyToOne) {
            ManyToOne manyToOne = (ManyToOne)this.value;
            PersistentClass persistentClass = (PersistentClass)map.get(manyToOne.getReferencedEntityName());
            if (persistentClass == null) {
                throw new AnnotationException("@OneToOne or @ManyToOne on " + StringHelper.qualify(this.entityClassName, this.path) + " references an unknown entity: " + manyToOne.getReferencedEntityName());
            }
            BinderHelper.createSyntheticPropertyReference(this.columns, persistentClass, null, manyToOne, false, this.mappings);
            TableBinder.bindFk(persistentClass, null, this.columns, manyToOne, this.unique, this.mappings);
            if (!manyToOne.isIgnoreNotFound()) {
                manyToOne.createPropertyRefConstraints(map);
            }
        } else if (this.value instanceof OneToOne) {
            ((OneToOne)this.value).createForeignKey();
        } else {
            throw new AssertionFailure("FkSecondPass for a wrong value type: " + this.value.getClass().getName());
        }
    }
}

