/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.annotations.FetchProfile;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.SecondPass;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.MetadataSource;
import org.hibernate.mapping.PersistentClass;

public class VerifyFetchProfileReferenceSecondPass
implements SecondPass {
    private String fetchProfileName;
    private FetchProfile.FetchOverride fetch;
    private Mappings mappings;

    public VerifyFetchProfileReferenceSecondPass(String string, FetchProfile.FetchOverride fetchOverride, Mappings mappings) {
        this.fetchProfileName = string;
        this.fetch = fetchOverride;
        this.mappings = mappings;
    }

    public void doSecondPass(Map map) throws MappingException {
        FetchProfile fetchProfile = this.mappings.findOrCreateFetchProfile(this.fetchProfileName, MetadataSource.ANNOTATIONS);
        if (MetadataSource.ANNOTATIONS != fetchProfile.getSource()) {
            return;
        }
        PersistentClass persistentClass = this.mappings.getClass(this.fetch.entity().getName());
        persistentClass.getProperty(this.fetch.association());
        fetchProfile.addFetch(this.fetch.entity().getName(), this.fetch.association(), this.fetch.mode().toString().toLowerCase());
    }
}

