/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToMany;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import org.hibernate.AnnotationException;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CollectionId;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterJoinTable;
import org.hibernate.annotations.FilterJoinTables;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.hibernate.annotations.Loader;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.MapKey;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLDeleteAll;
import org.hibernate.annotations.SQLInsert;
import org.hibernate.annotations.SQLUpdate;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.SortType;
import org.hibernate.annotations.Where;
import org.hibernate.annotations.WhereJoinTable;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.AccessType;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.CollectionSecondPass;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.IndexColumn;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.PropertyInferredData;
import org.hibernate.cfg.PropertyPreloadedData;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.annotations.ArrayBinder;
import org.hibernate.cfg.annotations.BagBinder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.IdBagBinder;
import org.hibernate.cfg.annotations.ListBinder;
import org.hibernate.cfg.annotations.MapBinder;
import org.hibernate.cfg.annotations.Nullability;
import org.hibernate.cfg.annotations.PrimitiveArrayBinder;
import org.hibernate.cfg.annotations.PropertyBinder;
import org.hibernate.cfg.annotations.SetBinder;
import org.hibernate.cfg.annotations.SimpleValueBinder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.engine.ExecuteUpdateResultCheckStyle;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Backref;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.IdGenerator;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionBinder {
    private Logger log = LoggerFactory.getLogger(CollectionBinder.class);
    protected org.hibernate.mapping.Collection collection;
    protected String propertyName;
    PropertyHolder propertyHolder;
    int batchSize;
    private String mappedBy;
    private XClass collectionType;
    private XClass targetEntity;
    private Mappings mappings;
    private Ejb3JoinColumn[] inverseJoinColumns;
    private String cascadeStrategy;
    String cacheConcurrencyStrategy;
    String cacheRegionName;
    private boolean oneToMany;
    protected IndexColumn indexColumn;
    private String orderBy;
    protected String hqlOrderBy;
    private boolean isSorted;
    private Class comparator;
    private boolean hasToBeSorted;
    protected boolean cascadeDeleteEnabled;
    protected String mapKeyPropertyName;
    private boolean insertable = true;
    private boolean updatable = true;
    private Ejb3JoinColumn[] fkJoinColumns;
    private boolean isExplicitAssociationTable;
    private Ejb3Column[] elementColumns;
    private boolean isEmbedded;
    private XProperty property;
    private boolean ignoreNotFound;
    private TableBinder tableBinder;
    private Ejb3Column[] mapKeyColumns;
    private Ejb3JoinColumn[] mapKeyManyToManyColumns;
    protected HashMap<String, IdGenerator> localGenerators;
    protected Map<XClass, InheritanceState> inheritanceStatePerClass;
    private XClass declaringClass;
    private boolean declaringClassSet;
    private AccessType accessType;
    private boolean hibernateExtensionMapping;
    private Ejb3JoinColumn[] joinColumns;

    protected Mappings getMappings() {
        return this.mappings;
    }

    public boolean isMap() {
        return false;
    }

    public void setIsHibernateExtensionMapping(boolean bl) {
        this.hibernateExtensionMapping = bl;
    }

    protected boolean isHibernateExtensionMapping() {
        return this.hibernateExtensionMapping;
    }

    public void setUpdatable(boolean bl) {
        this.updatable = bl;
    }

    public void setInheritanceStatePerClass(Map<XClass, InheritanceState> map) {
        this.inheritanceStatePerClass = map;
    }

    public void setInsertable(boolean bl) {
        this.insertable = bl;
    }

    public void setCascadeStrategy(String string) {
        this.cascadeStrategy = string;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public void setInverseJoinColumns(Ejb3JoinColumn[] ejb3JoinColumnArray) {
        this.inverseJoinColumns = ejb3JoinColumnArray;
    }

    public void setJoinColumns(Ejb3JoinColumn[] ejb3JoinColumnArray) {
        this.joinColumns = ejb3JoinColumnArray;
    }

    public void setPropertyHolder(PropertyHolder propertyHolder) {
        this.propertyHolder = propertyHolder;
    }

    public void setBatchSize(BatchSize batchSize) {
        this.batchSize = batchSize == null ? -1 : batchSize.size();
    }

    public void setEjb3OrderBy(OrderBy orderBy) {
        if (orderBy != null) {
            this.hqlOrderBy = orderBy.value();
        }
    }

    public void setSqlOrderBy(org.hibernate.annotations.OrderBy orderBy) {
        if (orderBy != null && !BinderHelper.isEmptyAnnotationValue(orderBy.clause())) {
            this.orderBy = orderBy.clause();
        }
    }

    public void setSort(Sort sort) {
        if (sort != null) {
            boolean bl = this.isSorted = !SortType.UNSORTED.equals((Object)sort.type());
            if (this.isSorted && SortType.COMPARATOR.equals((Object)sort.type())) {
                this.comparator = sort.comparator();
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CollectionBinder getCollectionBinder(String string, XProperty xProperty, boolean bl, boolean bl2) {
        void var4_16;
        if (xProperty.isArray()) {
            if (xProperty.getElementClass().isPrimitive()) {
                PrimitiveArrayBinder primitiveArrayBinder = new PrimitiveArrayBinder();
            } else {
                ArrayBinder arrayBinder = new ArrayBinder();
            }
        } else {
            if (!xProperty.isCollection()) throw new AnnotationException("Illegal attempt to map a non collection as a @OneToMany, @ManyToMany or @CollectionOfElements: " + StringHelper.qualify(string, xProperty.getName()));
            Class<? extends Collection> clazz = xProperty.getCollectionClass();
            if (Set.class.equals(clazz)) {
                if (xProperty.isAnnotationPresent(CollectionId.class)) {
                    throw new AnnotationException("Set do not support @CollectionId: " + StringHelper.qualify(string, xProperty.getName()));
                }
                SetBinder setBinder = new SetBinder();
            } else if (SortedSet.class.equals(clazz)) {
                if (xProperty.isAnnotationPresent(CollectionId.class)) {
                    throw new AnnotationException("Set do not support @CollectionId: " + StringHelper.qualify(string, xProperty.getName()));
                }
                SetBinder setBinder = new SetBinder(true);
            } else if (Map.class.equals(clazz)) {
                if (xProperty.isAnnotationPresent(CollectionId.class)) {
                    throw new AnnotationException("Map do not support @CollectionId: " + StringHelper.qualify(string, xProperty.getName()));
                }
                MapBinder mapBinder = new MapBinder();
            } else if (SortedMap.class.equals(clazz)) {
                if (xProperty.isAnnotationPresent(CollectionId.class)) {
                    throw new AnnotationException("Map do not support @CollectionId: " + StringHelper.qualify(string, xProperty.getName()));
                }
                MapBinder mapBinder = new MapBinder(true);
            } else if (Collection.class.equals(clazz)) {
                if (xProperty.isAnnotationPresent(CollectionId.class)) {
                    IdBagBinder idBagBinder = new IdBagBinder();
                } else {
                    BagBinder bagBinder = new BagBinder();
                }
            } else {
                if (!List.class.equals(clazz)) throw new AnnotationException(clazz.getName() + " collection not yet supported: " + StringHelper.qualify(string, xProperty.getName()));
                if (bl) {
                    if (xProperty.isAnnotationPresent(CollectionId.class)) {
                        throw new AnnotationException("List do not support @CollectionId and @OrderColumn (or @IndexColumn) at the same time: " + StringHelper.qualify(string, xProperty.getName()));
                    }
                    ListBinder listBinder = new ListBinder();
                } else if (xProperty.isAnnotationPresent(CollectionId.class)) {
                    IdBagBinder idBagBinder = new IdBagBinder();
                } else {
                    BagBinder bagBinder = new BagBinder();
                }
            }
        }
        var4_16.setIsHibernateExtensionMapping(bl2);
        return var4_16;
    }

    protected CollectionBinder() {
    }

    protected CollectionBinder(boolean bl) {
        this.hasToBeSorted = bl;
    }

    public void setMappedBy(String string) {
        this.mappedBy = string;
    }

    public void setTableBinder(TableBinder tableBinder) {
        this.tableBinder = tableBinder;
    }

    public void setCollectionType(XClass xClass) {
        this.collectionType = xClass;
    }

    public void setTargetEntity(XClass xClass) {
        this.targetEntity = xClass;
    }

    public void setMappings(Mappings mappings) {
        this.mappings = mappings;
    }

    protected abstract org.hibernate.mapping.Collection createCollection(PersistentClass var1);

    public org.hibernate.mapping.Collection getCollection() {
        return this.collection;
    }

    public void setPropertyName(String string) {
        this.propertyName = string;
    }

    public void setDeclaringClass(XClass xClass) {
        this.declaringClass = xClass;
        this.declaringClassSet = true;
    }

    public void bind() {
        boolean bl;
        Persister persister;
        this.collection = this.createCollection(this.propertyHolder.getPersistentClass());
        this.log.debug("Collection role: {}", (Object)StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName));
        this.collection.setRole(StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName));
        this.collection.setNodeName(this.propertyName);
        if ((this.property.isAnnotationPresent(MapKey.class) || this.property.isAnnotationPresent(MapKeyColumn.class)) && this.mapKeyPropertyName != null) {
            throw new AnnotationException("Cannot mix @javax.persistence.MapKey and @MapKeyColumn or @org.hibernate.annotations.MapKey on the same collection: " + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName));
        }
        this.defineFetchingStrategy();
        this.collection.setBatchSize(this.batchSize);
        if (this.orderBy != null && this.hqlOrderBy != null) {
            throw new AnnotationException("Cannot use sql order by clause in conjunction of EJB3 order by clause: " + this.safeCollectionRole());
        }
        this.collection.setMutable(!this.property.isAnnotationPresent(Immutable.class));
        OptimisticLock optimisticLock = this.property.getAnnotation(OptimisticLock.class);
        if (optimisticLock != null) {
            this.collection.setOptimisticLocked(!optimisticLock.excluded());
        }
        if ((persister = this.property.getAnnotation(Persister.class)) != null) {
            this.collection.setCollectionPersisterClass(persister.impl());
        }
        if (this.orderBy != null) {
            this.collection.setOrderBy(this.orderBy);
        }
        if (this.isSorted) {
            this.collection.setSorted(true);
            if (this.comparator != null) {
                try {
                    this.collection.setComparator((Comparator)this.comparator.newInstance());
                }
                catch (ClassCastException classCastException) {
                    throw new AnnotationException("Comparator not implementing java.util.Comparator class: " + this.comparator.getName() + "(" + this.safeCollectionRole() + ")");
                }
                catch (Exception exception) {
                    throw new AnnotationException("Could not instantiate comparator class: " + this.comparator.getName() + "(" + this.safeCollectionRole() + ")");
                }
            }
        } else if (this.hasToBeSorted) {
            throw new AnnotationException("A sorted collection has to define @Sort: " + this.safeCollectionRole());
        }
        if (StringHelper.isNotEmpty(this.cacheConcurrencyStrategy)) {
            this.collection.setCacheConcurrencyStrategy(this.cacheConcurrencyStrategy);
            this.collection.setCacheRegionName(this.cacheRegionName);
        }
        SQLInsert sQLInsert = this.property.getAnnotation(SQLInsert.class);
        SQLUpdate sQLUpdate = this.property.getAnnotation(SQLUpdate.class);
        SQLDelete sQLDelete = this.property.getAnnotation(SQLDelete.class);
        SQLDeleteAll sQLDeleteAll = this.property.getAnnotation(SQLDeleteAll.class);
        Loader loader = this.property.getAnnotation(Loader.class);
        if (sQLInsert != null) {
            this.collection.setCustomSQLInsert(sQLInsert.sql().trim(), sQLInsert.callable(), ExecuteUpdateResultCheckStyle.parse(sQLInsert.check().toString().toLowerCase()));
        }
        if (sQLUpdate != null) {
            this.collection.setCustomSQLUpdate(sQLUpdate.sql(), sQLUpdate.callable(), ExecuteUpdateResultCheckStyle.parse(sQLUpdate.check().toString().toLowerCase()));
        }
        if (sQLDelete != null) {
            this.collection.setCustomSQLDelete(sQLDelete.sql(), sQLDelete.callable(), ExecuteUpdateResultCheckStyle.parse(sQLDelete.check().toString().toLowerCase()));
        }
        if (sQLDeleteAll != null) {
            this.collection.setCustomSQLDeleteAll(sQLDeleteAll.sql(), sQLDeleteAll.callable(), ExecuteUpdateResultCheckStyle.parse(sQLDeleteAll.check().toString().toLowerCase()));
        }
        if (loader != null) {
            this.collection.setLoaderName(loader.namedQuery());
        }
        boolean bl2 = bl = !BinderHelper.isEmptyAnnotationValue(this.mappedBy);
        if (bl && (this.property.isAnnotationPresent(JoinColumn.class) || this.property.isAnnotationPresent(JoinColumns.class) || this.propertyHolder.getJoinTable(this.property) != null)) {
            String string = "Associations marked as mappedBy must not define database mappings like @JoinTable or @JoinColumn: ";
            string = string + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName);
            throw new AnnotationException(string);
        }
        this.collection.setInverse(bl);
        if (!this.oneToMany && bl) {
            this.mappings.addMappedBy(this.getCollectionType().getName(), this.mappedBy, this.propertyName);
        }
        XClass xClass = this.getCollectionType();
        if (this.inheritanceStatePerClass == null) {
            throw new AssertionFailure("inheritanceStatePerClass not set");
        }
        SecondPass secondPass = this.getSecondPass(this.fkJoinColumns, this.joinColumns, this.inverseJoinColumns, this.elementColumns, this.mapKeyColumns, this.mapKeyManyToManyColumns, this.isEmbedded, this.property, xClass, this.ignoreNotFound, this.oneToMany, this.tableBinder, this.mappings);
        if (xClass.isAnnotationPresent(Embeddable.class) || this.property.isAnnotationPresent(CollectionOfElements.class) || this.property.isAnnotationPresent(ElementCollection.class)) {
            this.mappings.addSecondPass(secondPass, !bl);
        } else {
            this.mappings.addSecondPass(secondPass, !bl);
        }
        this.mappings.addCollection(this.collection);
        PropertyBinder propertyBinder = new PropertyBinder();
        propertyBinder.setName(this.propertyName);
        propertyBinder.setValue(this.collection);
        propertyBinder.setCascade(this.cascadeStrategy);
        if (this.cascadeStrategy != null && this.cascadeStrategy.indexOf("delete-orphan") >= 0) {
            this.collection.setOrphanDelete(true);
        }
        propertyBinder.setAccessType(this.accessType);
        propertyBinder.setProperty(this.property);
        propertyBinder.setInsertable(this.insertable);
        propertyBinder.setUpdatable(this.updatable);
        Property property = propertyBinder.makeProperty();
        if (!this.declaringClassSet) {
            throw new AssertionFailure("DeclaringClass is not set in CollectionBinder while binding");
        }
        this.propertyHolder.addProperty(property, this.declaringClass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void defineFetchingStrategy() {
        FetchType fetchType;
        LazyCollection lazyCollection = this.property.getAnnotation(LazyCollection.class);
        Fetch fetch = this.property.getAnnotation(Fetch.class);
        OneToMany oneToMany = this.property.getAnnotation(OneToMany.class);
        ManyToMany manyToMany = this.property.getAnnotation(ManyToMany.class);
        CollectionOfElements collectionOfElements = this.property.getAnnotation(CollectionOfElements.class);
        ElementCollection elementCollection = this.property.getAnnotation(ElementCollection.class);
        ManyToAny manyToAny = this.property.getAnnotation(ManyToAny.class);
        if (oneToMany != null) {
            fetchType = oneToMany.fetch();
        } else if (manyToMany != null) {
            fetchType = manyToMany.fetch();
        } else if (elementCollection != null) {
            fetchType = elementCollection.fetch();
        } else if (collectionOfElements != null) {
            fetchType = collectionOfElements.fetch();
        } else {
            if (manyToAny == null) throw new AssertionFailure("Define fetch strategy on a property not annotated with @ManyToOne nor @OneToMany nor @CollectionOfElements");
            fetchType = FetchType.LAZY;
        }
        if (lazyCollection != null) {
            this.collection.setLazy(lazyCollection.value() != LazyCollectionOption.FALSE);
            this.collection.setExtraLazy(lazyCollection.value() == LazyCollectionOption.EXTRA);
        } else {
            this.collection.setLazy(fetchType == FetchType.LAZY);
            this.collection.setExtraLazy(false);
        }
        if (fetch != null) {
            if (fetch.value() == org.hibernate.annotations.FetchMode.JOIN) {
                this.collection.setFetchMode(FetchMode.JOIN);
                this.collection.setLazy(false);
                return;
            } else if (fetch.value() == org.hibernate.annotations.FetchMode.SELECT) {
                this.collection.setFetchMode(FetchMode.SELECT);
                return;
            } else {
                if (fetch.value() != org.hibernate.annotations.FetchMode.SUBSELECT) throw new AssertionFailure("Unknown FetchMode: " + (Object)((Object)fetch.value()));
                this.collection.setFetchMode(FetchMode.SELECT);
                this.collection.setSubselectLoadable(true);
                this.collection.getOwner().setSubselectLoadableCollections(true);
            }
            return;
        } else {
            this.collection.setFetchMode(AnnotationBinder.getFetchMode(fetchType));
        }
    }

    private XClass getCollectionType() {
        if (AnnotationBinder.isDefault(this.targetEntity, this.mappings)) {
            if (this.collectionType != null) {
                return this.collectionType;
            }
            String string = "Collection has neither generic type or OneToMany.targetEntity() defined: " + this.safeCollectionRole();
            throw new AnnotationException(string);
        }
        return this.targetEntity;
    }

    public SecondPass getSecondPass(final Ejb3JoinColumn[] ejb3JoinColumnArray, final Ejb3JoinColumn[] ejb3JoinColumnArray2, final Ejb3JoinColumn[] ejb3JoinColumnArray3, final Ejb3Column[] ejb3ColumnArray, Ejb3Column[] ejb3ColumnArray2, Ejb3JoinColumn[] ejb3JoinColumnArray4, final boolean bl, final XProperty xProperty, final XClass xClass, final boolean bl2, final boolean bl3, final TableBinder tableBinder, final Mappings mappings) {
        return new CollectionSecondPass(mappings, this.collection){

            public void secondPass(Map map, Map map2) throws MappingException {
                CollectionBinder.this.bindStarToManySecondPass(map, xClass, ejb3JoinColumnArray, ejb3JoinColumnArray2, ejb3JoinColumnArray3, ejb3ColumnArray, bl, xProperty, bl3, tableBinder, bl2, mappings);
            }
        };
    }

    protected boolean bindStarToManySecondPass(Map map, XClass xClass, Ejb3JoinColumn[] ejb3JoinColumnArray, Ejb3JoinColumn[] ejb3JoinColumnArray2, Ejb3JoinColumn[] ejb3JoinColumnArray3, Ejb3Column[] ejb3ColumnArray, boolean bl, XProperty xProperty, boolean bl2, TableBinder tableBinder, boolean bl3, Mappings mappings) {
        PersistentClass persistentClass = (PersistentClass)map.get(xClass.getName());
        boolean bl4 = false;
        if (persistentClass != null && StringHelper.isNotEmpty(this.mappedBy)) {
            try {
                bl4 = 0 != persistentClass.getJoinNumber(persistentClass.getRecursiveProperty(this.mappedBy));
            }
            catch (MappingException mappingException) {
                StringBuilder stringBuilder = new StringBuilder(80);
                stringBuilder.append("mappedBy reference an unknown target entity property: ").append(xClass).append(".").append(this.mappedBy).append(" in ").append(this.collection.getOwnerEntityName()).append(".").append(xProperty.getName());
                throw new AnnotationException(stringBuilder.toString());
            }
        }
        if (persistentClass != null && !bl4 && this.oneToMany && !this.isExplicitAssociationTable && (this.joinColumns[0].isImplicit() && !BinderHelper.isEmptyAnnotationValue(this.mappedBy) || !ejb3JoinColumnArray[0].isImplicit())) {
            this.bindOneToManySecondPass(this.getCollection(), map, ejb3JoinColumnArray, xClass, this.cascadeDeleteEnabled, bl3, this.hqlOrderBy, mappings, this.inheritanceStatePerClass);
            return true;
        }
        this.bindManyToManySecondPass(this.collection, map, ejb3JoinColumnArray2, ejb3JoinColumnArray3, ejb3ColumnArray, bl, xClass, bl3, bl2, this.cascadeDeleteEnabled, tableBinder, xProperty, this.propertyHolder, this.hqlOrderBy, mappings);
        return false;
    }

    protected void bindOneToManySecondPass(org.hibernate.mapping.Collection collection, Map map, Ejb3JoinColumn[] ejb3JoinColumnArray, XClass xClass, boolean bl, boolean bl2, String string, Mappings mappings, Map<XClass, InheritanceState> map2) {
        this.log.debug("Binding a OneToMany: {}.{} through a foreign key", (Object)this.propertyHolder.getEntityName(), (Object)this.propertyName);
        org.hibernate.mapping.OneToMany oneToMany = new org.hibernate.mapping.OneToMany(mappings, collection.getOwner());
        collection.setElement(oneToMany);
        oneToMany.setReferencedEntityName(xClass.getName());
        oneToMany.setIgnoreNotFound(bl2);
        String string2 = oneToMany.getReferencedEntityName();
        PersistentClass persistentClass = (PersistentClass)map.get(string2);
        String string3 = CollectionBinder.buildOrderByClauseFromHql(string, persistentClass, collection.getRole());
        if (string3 != null) {
            collection.setOrderBy(string3);
        }
        if (mappings == null) {
            throw new AssertionFailure("CollectionSecondPass for oneToMany should not be called with null mappings");
        }
        Map<String, Join> map3 = mappings.getJoins(string2);
        if (persistentClass == null) {
            throw new MappingException("Association references unmapped class: " + string2);
        }
        oneToMany.setAssociatedClass(persistentClass);
        for (Ejb3JoinColumn ejb3JoinColumn : ejb3JoinColumnArray) {
            ejb3JoinColumn.setPersistentClass(persistentClass, map3, map2);
            ejb3JoinColumn.setJoins(map3);
            collection.setCollectionTable(ejb3JoinColumn.getTable());
        }
        this.log.info("Mapping collection: " + collection.getRole() + " -> " + collection.getCollectionTable().getName());
        this.bindFilters(false);
        CollectionBinder.bindCollectionSecondPass(collection, null, ejb3JoinColumnArray, bl, this.property, mappings);
        if (!collection.isInverse() && !collection.getKey().isNullable()) {
            String string4 = oneToMany.getReferencedEntityName();
            PersistentClass persistentClass2 = mappings.getClass(string4);
            Backref backref = new Backref();
            backref.setName('_' + ejb3JoinColumnArray[0].getPropertyName() + "Backref");
            backref.setUpdateable(false);
            backref.setSelectable(false);
            backref.setCollectionRole(collection.getRole());
            backref.setEntityName(collection.getOwner().getEntityName());
            backref.setValue(collection.getKey());
            persistentClass2.addProperty(backref);
        }
    }

    private void bindFilters(boolean bl) {
        WhereJoinTable whereJoinTable;
        String string;
        Where where;
        String string2;
        FilterJoinTables filterJoinTables;
        Object object2;
        Filters filters;
        Filter filter = this.property.getAnnotation(Filter.class);
        if (filter != null) {
            if (bl) {
                this.collection.addManyToManyFilter(filter.name(), this.getCondition(filter));
            } else {
                this.collection.addFilter(filter.name(), this.getCondition(filter));
            }
        }
        if ((filters = this.property.getAnnotation(Filters.class)) != null) {
            object2 = filters.value();
            int n = ((Filter[])object2).length;
            for (int i = 0; i < n; ++i) {
                Filter filter2 = object2[i];
                if (bl) {
                    this.collection.addManyToManyFilter(filter2.name(), this.getCondition(filter2));
                    continue;
                }
                this.collection.addFilter(filter2.name(), this.getCondition(filter2));
            }
        }
        if ((object2 = this.property.getAnnotation(FilterJoinTable.class)) != null) {
            if (bl) {
                this.collection.addFilter(object2.name(), this.getCondition((FilterJoinTable)object2));
            } else {
                throw new AnnotationException("Illegal use of @FilterJoinTable on an association without join table:" + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName));
            }
        }
        if ((filterJoinTables = this.property.getAnnotation(FilterJoinTables.class)) != null) {
            for (FilterJoinTable object3 : filterJoinTables.value()) {
                if (!bl) {
                    throw new AnnotationException("Illegal use of @FilterJoinTable on an association without join table:" + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName));
                }
                this.collection.addFilter(object3.name(), this.getCondition(object3));
            }
        }
        String string3 = string2 = (where = this.property.getAnnotation(Where.class)) == null ? null : where.clause();
        if (StringHelper.isNotEmpty(string2)) {
            if (bl) {
                this.collection.setManyToManyWhere(string2);
            } else {
                this.collection.setWhere(string2);
            }
        }
        String string4 = string = (whereJoinTable = this.property.getAnnotation(WhereJoinTable.class)) == null ? null : whereJoinTable.clause();
        if (StringHelper.isNotEmpty(string)) {
            if (bl) {
                this.collection.setWhere(string);
            } else {
                throw new AnnotationException("Illegal use of @WhereJoinTable on an association without join table:" + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName));
            }
        }
    }

    private String getCondition(FilterJoinTable filterJoinTable) {
        String string = filterJoinTable.name();
        String string2 = filterJoinTable.condition();
        return this.getCondition(string2, string);
    }

    private String getCondition(Filter filter) {
        String string = filter.name();
        String string2 = filter.condition();
        return this.getCondition(string2, string);
    }

    private String getCondition(String string, String string2) {
        if (BinderHelper.isEmptyAnnotationValue(string) && StringHelper.isEmpty(string = this.mappings.getFilterDefinition(string2).getDefaultFilterCondition())) {
            throw new AnnotationException("no filter condition found for filter " + string2 + " in " + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName));
        }
        return string;
    }

    public void setCache(Cache cache) {
        if (cache != null) {
            this.cacheRegionName = BinderHelper.isEmptyAnnotationValue(cache.region()) ? null : cache.region();
            this.cacheConcurrencyStrategy = EntityBinder.getCacheConcurrencyStrategy(cache.usage());
        } else {
            this.cacheConcurrencyStrategy = null;
            this.cacheRegionName = null;
        }
    }

    public void setOneToMany(boolean bl) {
        this.oneToMany = bl;
    }

    public void setIndexColumn(IndexColumn indexColumn) {
        this.indexColumn = indexColumn;
    }

    public void setMapKey(javax.persistence.MapKey mapKey) {
        if (mapKey != null) {
            this.mapKeyPropertyName = mapKey.name();
        }
    }

    private static String buildOrderByClauseFromHql(String string, PersistentClass persistentClass, String string2) {
        String string3 = null;
        if (string != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            StringBuilder stringBuilder = new StringBuilder();
            if (string.length() == 0) {
                Iterator iterator = persistentClass.getIdentifier().getColumnIterator();
                while (iterator.hasNext()) {
                    Selectable selectable = (Selectable)iterator.next();
                    stringBuilder.append(selectable.getText()).append(" asc").append(", ");
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ,", false);
                String string4 = null;
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    if (CollectionBinder.isNonPropertyToken(string5)) {
                        if (string4 != null) {
                            throw new AnnotationException("Error while parsing HQL orderBy clause: " + string + " (" + string2 + ")");
                        }
                        string4 = string5;
                        continue;
                    }
                    if (string4 == null) {
                        arrayList2.add("asc");
                    } else {
                        arrayList2.add(string4);
                        string4 = null;
                    }
                    arrayList.add(string5);
                }
                arrayList2.remove(0);
                if (string4 == null) {
                    arrayList2.add("asc");
                } else {
                    arrayList2.add(string4);
                    string4 = null;
                }
                int n = 0;
                for (String string6 : arrayList) {
                    Property property = BinderHelper.findPropertyByName(persistentClass, string6);
                    if (property == null) {
                        throw new AnnotationException("property from @OrderBy clause not found: " + persistentClass.getEntityName() + "." + string6);
                    }
                    PersistentClass persistentClass2 = property.getPersistentClass();
                    String string7 = persistentClass2 == null ? "" : (persistentClass2 == persistentClass || persistentClass instanceof SingleTableSubclass && persistentClass2.getMappedClass().isAssignableFrom(persistentClass.getMappedClass()) ? "" : persistentClass2.getTable().getQuotedName() + ".");
                    Iterator iterator = property.getColumnIterator();
                    while (iterator.hasNext()) {
                        Selectable selectable = (Selectable)iterator.next();
                        stringBuilder.append(string7).append(selectable.getText()).append(" ").append((String)arrayList2.get(n)).append(", ");
                    }
                    ++n;
                }
            }
            string3 = stringBuilder.substring(0, stringBuilder.length() - 2);
        }
        return string3;
    }

    private static String buildOrderByClauseFromHql(String string, Component component, String string2) {
        String string3 = null;
        if (string != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            StringBuilder stringBuilder = new StringBuilder();
            if (string.length() != 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ,", false);
                String string4 = null;
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    if (CollectionBinder.isNonPropertyToken(string5)) {
                        if (string4 != null) {
                            throw new AnnotationException("Error while parsing HQL orderBy clause: " + string + " (" + string2 + ")");
                        }
                        string4 = string5;
                        continue;
                    }
                    if (string4 == null) {
                        arrayList2.add("asc");
                    } else {
                        arrayList2.add(string4);
                        string4 = null;
                    }
                    arrayList.add(string5);
                }
                arrayList2.remove(0);
                if (string4 == null) {
                    arrayList2.add("asc");
                } else {
                    arrayList2.add(string4);
                    string4 = null;
                }
                int n = 0;
                for (String string6 : arrayList) {
                    Property property = BinderHelper.findPropertyByName(component, string6);
                    if (property == null) {
                        throw new AnnotationException("property from @OrderBy clause not found: " + string2 + "." + string6);
                    }
                    Iterator iterator = property.getColumnIterator();
                    while (iterator.hasNext()) {
                        Selectable selectable = (Selectable)iterator.next();
                        stringBuilder.append(selectable.getText()).append(" ").append((String)arrayList2.get(n)).append(", ");
                    }
                    ++n;
                }
                if (stringBuilder.length() >= 2) {
                    string3 = stringBuilder.substring(0, stringBuilder.length() - 2);
                }
            }
        }
        return string3;
    }

    private static boolean isNonPropertyToken(String string) {
        if (" ".equals(string)) {
            return true;
        }
        if (",".equals(string)) {
            return true;
        }
        if (string.equalsIgnoreCase("desc")) {
            return true;
        }
        return string.equalsIgnoreCase("asc");
    }

    private static SimpleValue buildCollectionKey(org.hibernate.mapping.Collection collection, Ejb3JoinColumn[] ejb3JoinColumnArray, boolean bl, XProperty xProperty, Mappings mappings) {
        String string;
        String string2;
        Object object;
        if (ejb3JoinColumnArray.length > 0 && StringHelper.isNotEmpty(ejb3JoinColumnArray[0].getMappedBy()) && (object = mappings.getPropertyReferencedAssociation(string2 = ejb3JoinColumnArray[0].getManyToManyOwnerSideEntityName() != null ? "inverse__" + ejb3JoinColumnArray[0].getManyToManyOwnerSideEntityName() : ejb3JoinColumnArray[0].getPropertyHolder().getEntityName(), ejb3JoinColumnArray[0].getMappedBy())) != null) {
            collection.setReferencedPropertyName((String)object);
            mappings.addPropertyReference(collection.getOwnerEntityName(), (String)object);
        }
        KeyValue keyValue = (string2 = collection.getReferencedPropertyName()) == null ? collection.getOwner().getIdentifier() : (KeyValue)collection.getOwner().getRecursiveProperty(string2).getValue();
        object = new DependantValue(mappings, collection.getCollectionTable(), keyValue);
        ((SimpleValue)object).setTypeName(null);
        Ejb3Column.checkPropertyConsistency(ejb3JoinColumnArray, collection.getOwnerEntityName());
        ((DependantValue)object).setNullable(ejb3JoinColumnArray.length == 0 || ejb3JoinColumnArray[0].isNullable());
        ((DependantValue)object).setUpdateable(ejb3JoinColumnArray.length == 0 || ejb3JoinColumnArray[0].isUpdatable());
        ((SimpleValue)object).setCascadeDeleteEnabled(bl);
        collection.setKey((KeyValue)object);
        ForeignKey foreignKey = xProperty != null ? xProperty.getAnnotation(ForeignKey.class) : null;
        String string3 = string = foreignKey != null ? foreignKey.name() : "";
        if (!BinderHelper.isEmptyAnnotationValue(string)) {
            ((SimpleValue)object).setForeignKeyName(string);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected void bindManyToManySecondPass(org.hibernate.mapping.Collection collection, Map map, Ejb3JoinColumn[] ejb3JoinColumnArray, Ejb3JoinColumn[] ejb3JoinColumnArray2, Ejb3Column[] ejb3ColumnArray, boolean bl, XClass xClass, boolean bl2, boolean bl3, boolean bl4, TableBinder tableBinder, XProperty xProperty, PropertyHolder propertyHolder, String string, Mappings mappings) throws MappingException {
        int n;
        Object object2;
        boolean bl5;
        Object object3;
        PersistentClass persistentClass = (PersistentClass)map.get(xClass.getName());
        boolean bl6 = persistentClass != null;
        ManyToAny manyToAny = xProperty.getAnnotation(ManyToAny.class);
        if (this.log.isDebugEnabled()) {
            object3 = collection.getOwnerEntityName() + "." + ejb3JoinColumnArray[0].getPropertyName();
            if (bl6 && bl3) {
                this.log.debug("Binding a OneToMany: {} through an association table", object3);
            } else if (bl6) {
                this.log.debug("Binding as ManyToMany: {}", object3);
            } else if (manyToAny != null) {
                this.log.debug("Binding a ManyToAny: {}", object3);
            } else {
                this.log.debug("Binding a collection of element: {}", object3);
            }
        }
        if (!bl6) {
            if (xProperty.isAnnotationPresent(ManyToMany.class) || xProperty.isAnnotationPresent(OneToMany.class)) {
                object3 = collection.getOwnerEntityName() + "." + ejb3JoinColumnArray[0].getPropertyName();
                throw new AnnotationException("Use of @OneToMany or @ManyToMany targeting an unmapped class: " + (String)object3 + "[" + xClass + "]");
            }
            if (manyToAny != null) {
                if (propertyHolder.getJoinTable(xProperty) == null) {
                    object3 = collection.getOwnerEntityName() + "." + ejb3JoinColumnArray[0].getPropertyName();
                    throw new AnnotationException("@JoinTable is mandatory when @ManyToAny is used: " + (String)object3);
                }
            } else {
                object3 = propertyHolder.getJoinTable(xProperty);
                if (object3 != null && object3.inverseJoinColumns().length > 0) {
                    String string2 = collection.getOwnerEntityName() + "." + ejb3JoinColumnArray[0].getPropertyName();
                    throw new AnnotationException("Use of @JoinTable.inverseJoinColumns targeting an unmapped class: " + string2 + "[" + xClass + "]");
                }
            }
        }
        boolean bl7 = bl5 = !BinderHelper.isEmptyAnnotationValue(ejb3JoinColumnArray[0].getMappedBy());
        if (bl5) {
            if (!bl6) {
                StringBuilder stringBuilder = new StringBuilder(80).append("Collection of elements must not have mappedBy or association reference an unmapped entity: ").append(collection.getOwnerEntityName()).append(".").append(ejb3JoinColumnArray[0].getPropertyName());
                throw new AnnotationException(stringBuilder.toString());
            }
            try {
                object2 = persistentClass.getRecursiveProperty(ejb3JoinColumnArray[0].getMappedBy());
            }
            catch (MappingException mappingException) {
                StringBuilder stringBuilder = new StringBuilder(80);
                stringBuilder.append("mappedBy reference an unknown target entity property: ").append(xClass).append(".").append(ejb3JoinColumnArray[0].getMappedBy()).append(" in ").append(collection.getOwnerEntityName()).append(".").append(ejb3JoinColumnArray[0].getPropertyName());
                throw new AnnotationException(stringBuilder.toString());
            }
            Table table = ((Property)object2).getValue() instanceof org.hibernate.mapping.Collection ? ((org.hibernate.mapping.Collection)((Property)object2).getValue()).getCollectionTable() : ((Property)object2).getValue().getTable();
            collection.setCollectionTable(table);
            String string3 = persistentClass.getEntityName();
            Ejb3JoinColumn[] ejb3JoinColumnArray3 = ejb3JoinColumnArray;
            n = ejb3JoinColumnArray3.length;
            for (int i = 0; i < n; ++i) {
                Ejb3JoinColumn ejb3JoinColumn = ejb3JoinColumnArray3[i];
                ejb3JoinColumn.setManyToManyOwnerSideEntityName(string3);
            }
        } else {
            void string5;
            object2 = ejb3JoinColumnArray;
            int n2 = ((Ejb3JoinColumn[])object2).length;
            boolean bl8 = false;
            while (string5 < n2) {
                Object object = object2[string5];
                String string2 = mappings.getFromMappedBy(collection.getOwnerEntityName(), ((Ejb3Column)object).getPropertyName());
                Table table = collection.getOwner().getTable();
                ((Ejb3JoinColumn)object).setMappedBy(collection.getOwner().getEntityName(), mappings.getLogicalTableName(table), string2);
                ++string5;
            }
            if (StringHelper.isEmpty(tableBinder.getName())) {
                tableBinder.setDefaultName(collection.getOwner().getEntityName(), mappings.getLogicalTableName(collection.getOwner().getTable()), persistentClass != null ? persistentClass.getEntityName() : null, persistentClass != null ? mappings.getLogicalTableName(persistentClass.getTable()) : null, ejb3JoinColumnArray[0].getPropertyName());
            }
            tableBinder.setJPA2ElementCollection(!bl6 && xProperty.isAnnotationPresent(ElementCollection.class));
            collection.setCollectionTable(tableBinder.bind());
        }
        this.bindFilters(bl6);
        CollectionBinder.bindCollectionSecondPass(collection, persistentClass, ejb3JoinColumnArray, bl4, xProperty, mappings);
        object2 = null;
        if (bl6) {
            String object5;
            object2 = new ManyToOne(mappings, collection.getCollectionTable());
            collection.setElement((Value)object2);
            ((ToOne)object2).setReferencedEntityName(xClass.getName());
            ((ToOne)object2).setFetchMode(FetchMode.JOIN);
            ((ToOne)object2).setLazy(false);
            ((ManyToOne)object2).setIgnoreNotFound(bl2);
            if (string != null) {
                collection.setManyToManyOrdering(CollectionBinder.buildOrderByClauseFromHql(string, persistentClass, collection.getRole()));
            }
            ForeignKey foreignKey = xProperty != null ? xProperty.getAnnotation(ForeignKey.class) : null;
            String string3 = object5 = foreignKey != null ? foreignKey.inverseName() : "";
            if (!BinderHelper.isEmptyAnnotationValue(object5)) {
                ((SimpleValue)object2).setForeignKeyName(object5);
            }
        } else if (manyToAny != null) {
            PropertyInferredData propertyInferredData = new PropertyInferredData(null, xProperty, "unsupported", mappings.getReflectionManager());
            for (Ejb3JoinColumn ejb3JoinColumn : ejb3JoinColumnArray2) {
                ejb3JoinColumn.setTable(collection.getCollectionTable());
            }
            Any any = BinderHelper.buildAnyValue(manyToAny.metaDef(), ejb3JoinColumnArray2, manyToAny.metaColumn(), propertyInferredData, bl4, Nullability.NO_CONSTRAINT, this.propertyHolder, new EntityBinder(), true, mappings);
            collection.setElement(any);
        } else {
            void var22_41;
            XClass xClass2;
            Object var23_46 = null;
            if (BinderHelper.PRIMITIVE_NAMES.contains(xClass.getName())) {
                AnnotatedClassType annotatedClassType = AnnotatedClassType.NONE;
                xClass2 = null;
            } else {
                xClass2 = xClass;
                AnnotatedClassType annotatedClassType = mappings.getClassType(xClass2);
                PropertyHolder propertyHolder2 = PropertyHolderBuilder.buildPropertyHolder(collection, collection.getRole(), xClass2, xProperty, propertyHolder, mappings);
                int n3 = n = xProperty.isAnnotationPresent(AttributeOverride.class) || xProperty.isAnnotationPresent(AttributeOverrides.class) ? 1 : 0;
                if (bl || n != 0) {
                    AnnotatedClassType annotatedClassType2 = AnnotatedClassType.EMBEDDABLE;
                }
            }
            if (AnnotatedClassType.EMBEDDABLE.equals(var22_41)) {
                String string4;
                String string5;
                void var23_48;
                Object object;
                boolean bl9;
                EntityBinder entityBinder = new EntityBinder();
                PersistentClass persistentClass2 = collection.getOwner();
                if (persistentClass2.getIdentifierProperty() != null) {
                    bl9 = persistentClass2.getIdentifierProperty().getPropertyAccessorName().equals("property");
                } else if (persistentClass2.getIdentifierMapper() != null && persistentClass2.getIdentifierMapper().getPropertySpan() > 0) {
                    object = (Property)persistentClass2.getIdentifierMapper().getPropertyIterator().next();
                    bl9 = ((Property)object).getPropertyAccessorName().equals("property");
                } else {
                    throw new AssertionFailure("Unable to guess collection property accessor name");
                }
                object = this.isMap() ? (this.isHibernateExtensionMapping() ? new PropertyPreloadedData(AccessType.PROPERTY, "element", xClass2) : new PropertyPreloadedData(AccessType.PROPERTY, "value", xClass2)) : (this.isHibernateExtensionMapping() ? new PropertyPreloadedData(AccessType.PROPERTY, "element", xClass2) : new PropertyPreloadedData(AccessType.PROPERTY, "collection&&element", xClass2));
                Component component = AnnotationBinder.fillComponent((PropertyHolder)var23_48, (PropertyData)object, bl9 ? AccessType.PROPERTY : AccessType.FIELD, true, entityBinder, false, false, true, mappings, this.inheritanceStatePerClass);
                collection.setElement(component);
                if (StringHelper.isNotEmpty(string) && (string5 = CollectionBinder.buildOrderByClauseFromHql(string, component, string4 = collection.getOwnerEntityName() + "." + ejb3JoinColumnArray[0].getPropertyName())) != null) {
                    collection.setOrderBy(string5);
                }
            } else {
                SimpleValueBinder simpleValueBinder = new SimpleValueBinder();
                simpleValueBinder.setMappings(mappings);
                simpleValueBinder.setReturnedClassName(xClass.getName());
                if (ejb3ColumnArray == null || ejb3ColumnArray.length == 0) {
                    ejb3ColumnArray = new Ejb3Column[1];
                    Ejb3Column ejb3Column = new Ejb3Column();
                    ejb3Column.setImplicit(false);
                    ejb3Column.setNullable(true);
                    ejb3Column.setLength(255);
                    ejb3Column.setLogicalColumnName("elt");
                    ejb3Column.setJoins(new HashMap<String, Join>());
                    ejb3Column.setMappings(mappings);
                    ejb3Column.bind();
                    ejb3ColumnArray[0] = ejb3Column;
                }
                for (Ejb3Column ejb3Column : ejb3ColumnArray) {
                    ejb3Column.setTable(collection.getCollectionTable());
                }
                simpleValueBinder.setColumns(ejb3ColumnArray);
                simpleValueBinder.setType(xProperty, xClass2);
                collection.setElement(simpleValueBinder.make());
            }
        }
        CollectionBinder.checkFilterConditions(collection);
        if (bl6) {
            CollectionBinder.bindManytoManyInverseFk(persistentClass, ejb3JoinColumnArray2, (SimpleValue)object2, bl3, mappings);
        }
    }

    private static void checkFilterConditions(org.hibernate.mapping.Collection collection) {
        if ((collection.getFilterMap().size() != 0 || StringHelper.isNotEmpty(collection.getWhere())) && collection.getFetchMode() == FetchMode.JOIN && !(collection.getElement() instanceof SimpleValue) && collection.getElement().getFetchMode() != FetchMode.JOIN) {
            throw new MappingException("@ManyToMany or @CollectionOfElements defining filter or where without join fetching not valid within collection using join fetching[" + collection.getRole() + "]");
        }
    }

    private static void bindCollectionSecondPass(org.hibernate.mapping.Collection collection, PersistentClass persistentClass, Ejb3JoinColumn[] ejb3JoinColumnArray, boolean bl, XProperty xProperty, Mappings mappings) {
        BinderHelper.createSyntheticPropertyReference(ejb3JoinColumnArray, collection.getOwner(), persistentClass, collection, false, mappings);
        SimpleValue simpleValue = CollectionBinder.buildCollectionKey(collection, ejb3JoinColumnArray, bl, xProperty, mappings);
        if (xProperty.isAnnotationPresent(ElementCollection.class) && ejb3JoinColumnArray.length > 0) {
            ejb3JoinColumnArray[0].setJPA2ElementCollection(true);
        }
        TableBinder.bindFk(collection.getOwner(), persistentClass, ejb3JoinColumnArray, simpleValue, false, mappings);
    }

    public void setCascadeDeleteEnabled(boolean bl) {
        this.cascadeDeleteEnabled = bl;
    }

    private String safeCollectionRole() {
        if (this.propertyHolder != null) {
            return this.propertyHolder.getEntityName() + "." + this.propertyName;
        }
        return "";
    }

    public static void bindManytoManyInverseFk(PersistentClass persistentClass, Ejb3JoinColumn[] ejb3JoinColumnArray, SimpleValue simpleValue, boolean bl, Mappings mappings) {
        String string = ejb3JoinColumnArray[0].getMappedBy();
        if (StringHelper.isNotEmpty(string)) {
            Object object;
            Iterator iterator;
            Property property = persistentClass.getRecursiveProperty(string);
            if (property.getValue() instanceof org.hibernate.mapping.Collection) {
                iterator = ((org.hibernate.mapping.Collection)property.getValue()).getKey().getColumnIterator();
            } else {
                object = persistentClass.getJoinIterator();
                Value value = null;
                while (object.hasNext()) {
                    Join join = (Join)object.next();
                    if (!join.containsProperty(property)) continue;
                    value = join.getKey();
                    break;
                }
                if (value == null) {
                    value = property.getPersistentClass().getIdentifier();
                }
                iterator = value.getColumnIterator();
            }
            while (iterator.hasNext()) {
                object = (Column)iterator.next();
                ejb3JoinColumnArray[0].linkValueUsingAColumnCopy((Column)object, simpleValue);
            }
            object = mappings.getPropertyReferencedAssociation("inverse__" + persistentClass.getEntityName(), string);
            if (object != null) {
                ((ManyToOne)simpleValue).setReferencedPropertyName((String)object);
                mappings.addUniquePropertyReference(persistentClass.getEntityName(), (String)object);
            }
            simpleValue.createForeignKey();
        } else {
            BinderHelper.createSyntheticPropertyReference(ejb3JoinColumnArray, persistentClass, null, simpleValue, true, mappings);
            TableBinder.bindFk(persistentClass, null, ejb3JoinColumnArray, simpleValue, bl, mappings);
        }
    }

    public void setFkJoinColumns(Ejb3JoinColumn[] ejb3JoinColumnArray) {
        this.fkJoinColumns = ejb3JoinColumnArray;
    }

    public void setExplicitAssociationTable(boolean bl) {
        this.isExplicitAssociationTable = bl;
    }

    public void setElementColumns(Ejb3Column[] ejb3ColumnArray) {
        this.elementColumns = ejb3ColumnArray;
    }

    public void setEmbedded(boolean bl) {
        this.isEmbedded = bl;
    }

    public void setProperty(XProperty xProperty) {
        this.property = xProperty;
    }

    public void setIgnoreNotFound(boolean bl) {
        this.ignoreNotFound = bl;
    }

    public void setMapKeyColumns(Ejb3Column[] ejb3ColumnArray) {
        this.mapKeyColumns = ejb3ColumnArray;
    }

    public void setMapKeyManyToManyColumns(Ejb3JoinColumn[] ejb3JoinColumnArray) {
        this.mapKeyManyToManyColumns = ejb3JoinColumnArray;
    }

    public void setLocalGenerators(HashMap<String, IdGenerator> hashMap) {
        this.localGenerators = hashMap;
    }
}

