/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.HashMap;
import javax.persistence.QueryHint;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.annotations.CacheModeType;
import org.hibernate.annotations.FlushModeType;
import org.hibernate.annotations.NamedNativeQueries;
import org.hibernate.annotations.NamedNativeQuery;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.cfg.annotations.ResultsetMappingSecondPass;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.query.sql.NativeSQLQueryReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryRootReturn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryBinder {
    private static final Logger log = LoggerFactory.getLogger(QueryBinder.class);

    public static void bindQuery(javax.persistence.NamedQuery namedQuery, Mappings mappings, boolean bl) {
        if (namedQuery == null) {
            return;
        }
        if (BinderHelper.isEmptyAnnotationValue(namedQuery.name())) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        QueryHint[] queryHintArray = namedQuery.hints();
        String string = namedQuery.query();
        NamedQueryDefinition namedQueryDefinition = new NamedQueryDefinition(string, QueryBinder.getBoolean(string, "org.hibernate.cacheable", queryHintArray), QueryBinder.getString(string, "org.hibernate.cacheRegion", queryHintArray), QueryBinder.getTimeout(string, queryHintArray), QueryBinder.getInteger(string, "org.hibernate.fetchSize", queryHintArray), QueryBinder.getFlushMode(string, queryHintArray), QueryBinder.getCacheMode(string, queryHintArray), QueryBinder.getBoolean(string, "org.hibernate.readOnly", queryHintArray), QueryBinder.getString(string, "org.hibernate.comment", queryHintArray), null);
        if (bl) {
            mappings.addDefaultQuery(namedQuery.name(), namedQueryDefinition);
        } else {
            mappings.addQuery(namedQuery.name(), namedQueryDefinition);
        }
        log.info("Binding Named query: {} => {}", (Object)namedQuery.name(), (Object)namedQuery.query());
    }

    public static void bindNativeQuery(javax.persistence.NamedNativeQuery namedNativeQuery, Mappings mappings, boolean bl) {
        NamedSQLQueryDefinition namedSQLQueryDefinition;
        if (namedNativeQuery == null) {
            return;
        }
        if (BinderHelper.isEmptyAnnotationValue(namedNativeQuery.name())) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        String string = namedNativeQuery.resultSetMapping();
        QueryHint[] queryHintArray = namedNativeQuery.hints();
        String string2 = namedNativeQuery.query();
        if (!BinderHelper.isEmptyAnnotationValue(string)) {
            namedSQLQueryDefinition = new NamedSQLQueryDefinition(string2, string, null, QueryBinder.getBoolean(string2, "org.hibernate.cacheable", queryHintArray), QueryBinder.getString(string2, "org.hibernate.cacheRegion", queryHintArray), QueryBinder.getTimeout(string2, queryHintArray), QueryBinder.getInteger(string2, "org.hibernate.fetchSize", queryHintArray), QueryBinder.getFlushMode(string2, queryHintArray), QueryBinder.getCacheMode(string2, queryHintArray), QueryBinder.getBoolean(string2, "org.hibernate.readOnly", queryHintArray), QueryBinder.getString(string2, "org.hibernate.comment", queryHintArray), null, QueryBinder.getBoolean(string2, "org.hibernate.callable", queryHintArray));
        } else if (!Void.TYPE.equals(namedNativeQuery.resultClass())) {
            NativeSQLQueryRootReturn nativeSQLQueryRootReturn = new NativeSQLQueryRootReturn("alias1", namedNativeQuery.resultClass().getName(), new HashMap(), LockMode.READ);
            namedSQLQueryDefinition = new NamedSQLQueryDefinition(string2, new NativeSQLQueryReturn[]{nativeSQLQueryRootReturn}, null, QueryBinder.getBoolean(string2, "org.hibernate.cacheable", queryHintArray), QueryBinder.getString(string2, "org.hibernate.cacheRegion", queryHintArray), QueryBinder.getTimeout(string2, queryHintArray), QueryBinder.getInteger(string2, "org.hibernate.fetchSize", queryHintArray), QueryBinder.getFlushMode(string2, queryHintArray), QueryBinder.getCacheMode(string2, queryHintArray), QueryBinder.getBoolean(string2, "org.hibernate.readOnly", queryHintArray), QueryBinder.getString(string2, "org.hibernate.comment", queryHintArray), null, QueryBinder.getBoolean(string2, "org.hibernate.callable", queryHintArray));
        } else {
            throw new NotYetImplementedException("Pure native scalar queries are not yet supported");
        }
        if (bl) {
            mappings.addDefaultSQLQuery(namedNativeQuery.name(), namedSQLQueryDefinition);
        } else {
            mappings.addSQLQuery(namedNativeQuery.name(), namedSQLQueryDefinition);
        }
        log.info("Binding named native query: {} => {}", (Object)namedNativeQuery.name(), (Object)namedNativeQuery.query());
    }

    public static void bindNativeQuery(NamedNativeQuery namedNativeQuery, Mappings mappings) {
        NamedSQLQueryDefinition namedSQLQueryDefinition;
        if (namedNativeQuery == null) {
            return;
        }
        if (BinderHelper.isEmptyAnnotationValue(namedNativeQuery.name())) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        String string = namedNativeQuery.resultSetMapping();
        if (!BinderHelper.isEmptyAnnotationValue(string)) {
            namedSQLQueryDefinition = new NamedSQLQueryDefinition(namedNativeQuery.query(), string, null, namedNativeQuery.cacheable(), BinderHelper.isEmptyAnnotationValue(namedNativeQuery.cacheRegion()) ? null : namedNativeQuery.cacheRegion(), namedNativeQuery.timeout() < 0 ? null : Integer.valueOf(namedNativeQuery.timeout()), namedNativeQuery.fetchSize() < 0 ? null : Integer.valueOf(namedNativeQuery.fetchSize()), QueryBinder.getFlushMode(namedNativeQuery.flushMode()), QueryBinder.getCacheMode(namedNativeQuery.cacheMode()), namedNativeQuery.readOnly(), BinderHelper.isEmptyAnnotationValue(namedNativeQuery.comment()) ? null : namedNativeQuery.comment(), null, namedNativeQuery.callable());
        } else if (!Void.TYPE.equals(namedNativeQuery.resultClass())) {
            NativeSQLQueryRootReturn nativeSQLQueryRootReturn = new NativeSQLQueryRootReturn("alias1", namedNativeQuery.resultClass().getName(), new HashMap(), LockMode.READ);
            namedSQLQueryDefinition = new NamedSQLQueryDefinition(namedNativeQuery.query(), new NativeSQLQueryReturn[]{nativeSQLQueryRootReturn}, null, namedNativeQuery.cacheable(), BinderHelper.isEmptyAnnotationValue(namedNativeQuery.cacheRegion()) ? null : namedNativeQuery.cacheRegion(), namedNativeQuery.timeout() < 0 ? null : Integer.valueOf(namedNativeQuery.timeout()), namedNativeQuery.fetchSize() < 0 ? null : Integer.valueOf(namedNativeQuery.fetchSize()), QueryBinder.getFlushMode(namedNativeQuery.flushMode()), QueryBinder.getCacheMode(namedNativeQuery.cacheMode()), namedNativeQuery.readOnly(), BinderHelper.isEmptyAnnotationValue(namedNativeQuery.comment()) ? null : namedNativeQuery.comment(), null, namedNativeQuery.callable());
        } else {
            throw new NotYetImplementedException("Pure native scalar queries are not yet supported");
        }
        mappings.addSQLQuery(namedNativeQuery.name(), namedSQLQueryDefinition);
        log.info("Binding named native query: {} => {}", (Object)namedNativeQuery.name(), (Object)namedNativeQuery.query());
    }

    public static void bindQueries(javax.persistence.NamedQueries namedQueries, Mappings mappings, boolean bl) {
        if (namedQueries == null) {
            return;
        }
        for (javax.persistence.NamedQuery namedQuery : namedQueries.value()) {
            QueryBinder.bindQuery(namedQuery, mappings, bl);
        }
    }

    public static void bindNativeQueries(javax.persistence.NamedNativeQueries namedNativeQueries, Mappings mappings, boolean bl) {
        if (namedNativeQueries == null) {
            return;
        }
        for (javax.persistence.NamedNativeQuery namedNativeQuery : namedNativeQueries.value()) {
            QueryBinder.bindNativeQuery(namedNativeQuery, mappings, bl);
        }
    }

    public static void bindNativeQueries(NamedNativeQueries namedNativeQueries, Mappings mappings) {
        if (namedNativeQueries == null) {
            return;
        }
        for (NamedNativeQuery namedNativeQuery : namedNativeQueries.value()) {
            QueryBinder.bindNativeQuery(namedNativeQuery, mappings);
        }
    }

    public static void bindQuery(NamedQuery namedQuery, Mappings mappings) {
        if (namedQuery == null) {
            return;
        }
        if (BinderHelper.isEmptyAnnotationValue(namedQuery.name())) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        FlushMode flushMode = QueryBinder.getFlushMode(namedQuery.flushMode());
        NamedQueryDefinition namedQueryDefinition = new NamedQueryDefinition(namedQuery.query(), namedQuery.cacheable(), BinderHelper.isEmptyAnnotationValue(namedQuery.cacheRegion()) ? null : namedQuery.cacheRegion(), namedQuery.timeout() < 0 ? null : Integer.valueOf(namedQuery.timeout()), namedQuery.fetchSize() < 0 ? null : Integer.valueOf(namedQuery.fetchSize()), flushMode, QueryBinder.getCacheMode(namedQuery.cacheMode()), namedQuery.readOnly(), BinderHelper.isEmptyAnnotationValue(namedQuery.comment()) ? null : namedQuery.comment(), null);
        mappings.addQuery(namedQuery.name(), namedQueryDefinition);
        if (log.isInfoEnabled()) {
            log.info("Binding named query: " + namedQuery.name() + " => " + namedQuery.query());
        }
    }

    private static FlushMode getFlushMode(FlushModeType flushModeType) {
        FlushMode flushMode;
        switch (flushModeType) {
            case ALWAYS: {
                flushMode = FlushMode.ALWAYS;
                break;
            }
            case AUTO: {
                flushMode = FlushMode.AUTO;
                break;
            }
            case COMMIT: {
                flushMode = FlushMode.COMMIT;
                break;
            }
            case NEVER: {
                flushMode = FlushMode.MANUAL;
                break;
            }
            case MANUAL: {
                flushMode = FlushMode.MANUAL;
                break;
            }
            case PERSISTENCE_CONTEXT: {
                flushMode = null;
                break;
            }
            default: {
                throw new AssertionFailure("Unknown flushModeType: " + (Object)((Object)flushModeType));
            }
        }
        return flushMode;
    }

    private static CacheMode getCacheMode(CacheModeType cacheModeType) {
        switch (cacheModeType) {
            case GET: {
                return CacheMode.GET;
            }
            case IGNORE: {
                return CacheMode.IGNORE;
            }
            case NORMAL: {
                return CacheMode.NORMAL;
            }
            case PUT: {
                return CacheMode.PUT;
            }
            case REFRESH: {
                return CacheMode.REFRESH;
            }
        }
        throw new AssertionFailure("Unknown cacheModeType: " + (Object)((Object)cacheModeType));
    }

    public static void bindQueries(NamedQueries namedQueries, Mappings mappings) {
        if (namedQueries == null) {
            return;
        }
        for (NamedQuery namedQuery : namedQueries.value()) {
            QueryBinder.bindQuery(namedQuery, mappings);
        }
    }

    public static void bindSqlResultsetMappings(SqlResultSetMappings sqlResultSetMappings, Mappings mappings, boolean bl) {
        if (sqlResultSetMappings == null) {
            return;
        }
        for (SqlResultSetMapping sqlResultSetMapping : sqlResultSetMappings.value()) {
            mappings.addSecondPass(new ResultsetMappingSecondPass(sqlResultSetMapping, mappings, true));
        }
    }

    public static void bindSqlResultsetMapping(SqlResultSetMapping sqlResultSetMapping, Mappings mappings, boolean bl) {
        mappings.addSecondPass(new ResultsetMappingSecondPass(sqlResultSetMapping, mappings, bl));
    }

    private static CacheMode getCacheMode(String string, QueryHint[] queryHintArray) {
        for (QueryHint queryHint : queryHintArray) {
            if (!"org.hibernate.cacheMode".equals(queryHint.name())) continue;
            if (queryHint.value().equalsIgnoreCase(CacheMode.GET.toString())) {
                return CacheMode.GET;
            }
            if (queryHint.value().equalsIgnoreCase(CacheMode.IGNORE.toString())) {
                return CacheMode.IGNORE;
            }
            if (queryHint.value().equalsIgnoreCase(CacheMode.NORMAL.toString())) {
                return CacheMode.NORMAL;
            }
            if (queryHint.value().equalsIgnoreCase(CacheMode.PUT.toString())) {
                return CacheMode.PUT;
            }
            if (queryHint.value().equalsIgnoreCase(CacheMode.REFRESH.toString())) {
                return CacheMode.REFRESH;
            }
            throw new AnnotationException("Unknown CacheMode in hint: " + string + ":" + queryHint.name());
        }
        return null;
    }

    private static FlushMode getFlushMode(String string, QueryHint[] queryHintArray) {
        for (QueryHint queryHint : queryHintArray) {
            if (!"org.hibernate.flushMode".equals(queryHint.name())) continue;
            if (queryHint.value().equalsIgnoreCase(FlushMode.ALWAYS.toString())) {
                return FlushMode.ALWAYS;
            }
            if (queryHint.value().equalsIgnoreCase(FlushMode.AUTO.toString())) {
                return FlushMode.AUTO;
            }
            if (queryHint.value().equalsIgnoreCase(FlushMode.COMMIT.toString())) {
                return FlushMode.COMMIT;
            }
            if (queryHint.value().equalsIgnoreCase(FlushMode.NEVER.toString())) {
                return FlushMode.MANUAL;
            }
            if (queryHint.value().equalsIgnoreCase(FlushMode.MANUAL.toString())) {
                return FlushMode.MANUAL;
            }
            throw new AnnotationException("Unknown FlushMode in hint: " + string + ":" + queryHint.name());
        }
        return null;
    }

    private static boolean getBoolean(String string, String string2, QueryHint[] queryHintArray) {
        for (QueryHint queryHint : queryHintArray) {
            if (!string2.equals(queryHint.name())) continue;
            if (queryHint.value().equalsIgnoreCase("true")) {
                return true;
            }
            if (queryHint.value().equalsIgnoreCase("false")) {
                return false;
            }
            throw new AnnotationException("Not a boolean in hint: " + string + ":" + queryHint.name());
        }
        return false;
    }

    private static String getString(String string, String string2, QueryHint[] queryHintArray) {
        for (QueryHint queryHint : queryHintArray) {
            if (!string2.equals(queryHint.name())) continue;
            return queryHint.value();
        }
        return null;
    }

    private static Integer getInteger(String string, String string2, QueryHint[] queryHintArray) {
        for (QueryHint queryHint : queryHintArray) {
            if (!string2.equals(queryHint.name())) continue;
            try {
                return Integer.decode(queryHint.value());
            }
            catch (NumberFormatException numberFormatException) {
                throw new AnnotationException("Not an integer in hint: " + string + ":" + queryHint.name(), numberFormatException);
            }
        }
        return null;
    }

    private static Integer getTimeout(String string, QueryHint[] queryHintArray) {
        Integer n = QueryBinder.getInteger(string, "javax.persistence.query.timeout", queryHintArray);
        n = n != null ? new Integer((int)Math.round(n.doubleValue() / 1000.0)) : QueryBinder.getInteger(string, "org.hibernate.timeout", queryHintArray);
        return n;
    }
}

