/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.MapKeyTemporal;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.cfg.PkDrivenByDefaultMapsIdSecondPass;
import org.hibernate.cfg.SetSimpleValueTypeSecondPass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.TypeDef;
import org.hibernate.type.CharacterArrayClobType;
import org.hibernate.type.PrimitiveCharacterArrayClobType;
import org.hibernate.type.SerializableToBlobType;
import org.hibernate.type.WrappedMaterializedBlobType;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleValueBinder {
    private Logger log = LoggerFactory.getLogger(SimpleValueBinder.class);
    private String propertyName;
    private String returnedClassName;
    private Ejb3Column[] columns;
    private String persistentClassName;
    private String explicitType = "";
    private Properties typeParameters = new Properties();
    private Mappings mappings;
    private Table table;
    private SimpleValue simpleValue;
    private boolean isVersion;
    private String timeStampVersionType;
    private boolean key;
    private String referencedEntityName;

    public void setReferencedEntityName(String string) {
        this.referencedEntityName = string;
    }

    public boolean isVersion() {
        return this.isVersion;
    }

    public void setVersion(boolean bl) {
        this.isVersion = bl;
    }

    public void setTimestampVersionType(String string) {
        this.timeStampVersionType = string;
    }

    public void setPropertyName(String string) {
        this.propertyName = string;
    }

    public void setReturnedClassName(String string) {
        this.returnedClassName = string;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Ejb3Column[] ejb3ColumnArray) {
        this.columns = ejb3ColumnArray;
    }

    public void setPersistentClassName(String string) {
        this.persistentClassName = string;
    }

    public void setType(XProperty xProperty, XClass xClass) {
        Object object;
        String string;
        Properties properties;
        XClass xClass2;
        block37: {
            boolean bl;
            block36: {
                boolean bl2;
                if (xClass == null) {
                    return;
                }
                xClass2 = xClass;
                bl = false;
                if (xProperty.isArray()) {
                    xClass2 = xProperty.getElementClass();
                    bl = true;
                }
                properties = this.typeParameters;
                properties.clear();
                string = "";
                if ((this.key || !xProperty.isAnnotationPresent(Temporal.class)) && (!this.key || !xProperty.isAnnotationPresent(MapKeyTemporal.class))) break block36;
                if (this.mappings.getReflectionManager().equals(xClass2, Date.class)) {
                    bl2 = true;
                } else if (this.mappings.getReflectionManager().equals(xClass2, Calendar.class)) {
                    bl2 = false;
                } else {
                    throw new AnnotationException("@Temporal should only be set on a java.util.Date or java.util.Calendar property: " + StringHelper.qualify(this.persistentClassName, this.propertyName));
                }
                object = this.getTemporalType(xProperty);
                switch (object) {
                    case DATE: {
                        string = bl2 ? "date" : "calendar_date";
                        break;
                    }
                    case TIME: {
                        string = "time";
                        if (!bl2) {
                            throw new NotYetImplementedException("Calendar cannot persist TIME only" + StringHelper.qualify(this.persistentClassName, this.propertyName));
                        }
                        break block37;
                    }
                    case TIMESTAMP: {
                        string = bl2 ? "timestamp" : "calendar";
                        break;
                    }
                    default: {
                        throw new AssertionFailure("Unknown temporal type: " + (Object)object);
                    }
                }
                break block37;
            }
            if (xProperty.isAnnotationPresent(Lob.class)) {
                if (this.mappings.getReflectionManager().equals(xClass2, Clob.class)) {
                    string = "clob";
                } else if (this.mappings.getReflectionManager().equals(xClass2, Blob.class)) {
                    string = "blob";
                } else if (this.mappings.getReflectionManager().equals(xClass2, String.class)) {
                    string = Hibernate.MATERIALIZED_CLOB.getName();
                } else if (this.mappings.getReflectionManager().equals(xClass2, Character.class) && bl) {
                    string = CharacterArrayClobType.class.getName();
                } else if (this.mappings.getReflectionManager().equals(xClass2, Character.TYPE) && bl) {
                    string = PrimitiveCharacterArrayClobType.class.getName();
                } else if (this.mappings.getReflectionManager().equals(xClass2, Byte.class) && bl) {
                    string = WrappedMaterializedBlobType.class.getName();
                } else if (this.mappings.getReflectionManager().equals(xClass2, Byte.TYPE) && bl) {
                    string = Hibernate.MATERIALIZED_BLOB.getName();
                } else if (this.mappings.getReflectionManager().toXClass(Serializable.class).isAssignableFrom(xClass2)) {
                    string = SerializableToBlobType.class.getName();
                    properties.setProperty("classname", xClass2.getName());
                } else {
                    string = "blob";
                }
            }
        }
        if (this.columns == null) {
            throw new AssertionFailure("SimpleValueBinder.setColumns should be set before SimpleValueBinder.setType");
        }
        if ("".equals(string) && xClass2.isEnum()) {
            string = org.hibernate.type.EnumType.class.getName();
            properties = new Properties();
            properties.setProperty("enumClass", xClass2.getName());
            String string2 = this.columns[0].getTable().getSchema();
            string2 = string2 == null ? "" : string2;
            object = this.columns[0].getTable().getCatalog();
            object = object == null ? "" : object;
            properties.setProperty("schema", string2);
            properties.setProperty("catalog", (String)object);
            properties.setProperty("table", this.columns[0].getTable().getName());
            properties.setProperty("column", this.columns[0].getName());
            EnumType enumType = this.getEnumType(xProperty);
            if (enumType != null) {
                if (EnumType.ORDINAL.equals((Object)enumType)) {
                    properties.setProperty("type", String.valueOf(4));
                } else if (EnumType.STRING.equals((Object)enumType)) {
                    properties.setProperty("type", String.valueOf(12));
                } else {
                    throw new AssertionFailure("Unknown EnumType: " + (Object)((Object)enumType));
                }
            }
        }
        this.explicitType = string;
        this.typeParameters = properties;
        Type type = xProperty.getAnnotation(Type.class);
        this.setExplicitType(type);
    }

    private EnumType getEnumType(XProperty xProperty) {
        EnumType enumType = null;
        if (this.key) {
            MapKeyEnumerated mapKeyEnumerated = xProperty.getAnnotation(MapKeyEnumerated.class);
            if (mapKeyEnumerated != null) {
                enumType = mapKeyEnumerated.value();
            }
        } else {
            Enumerated enumerated = xProperty.getAnnotation(Enumerated.class);
            if (enumerated != null) {
                enumType = enumerated.value();
            }
        }
        return enumType;
    }

    private TemporalType getTemporalType(XProperty xProperty) {
        if (this.key) {
            MapKeyTemporal mapKeyTemporal = xProperty.getAnnotation(MapKeyTemporal.class);
            return mapKeyTemporal.value();
        }
        Temporal temporal = xProperty.getAnnotation(Temporal.class);
        return temporal.value();
    }

    public void setExplicitType(String string) {
        this.explicitType = string;
    }

    public void setExplicitType(Type type) {
        if (type != null) {
            this.explicitType = type.type();
            this.typeParameters.clear();
            for (Parameter parameter : type.parameters()) {
                this.typeParameters.setProperty(parameter.name(), parameter.value());
            }
        }
    }

    public void setMappings(Mappings mappings) {
        this.mappings = mappings;
    }

    private void validate() {
        Ejb3Column.checkPropertyConsistency(this.columns, this.propertyName);
    }

    public SimpleValue make() {
        this.validate();
        this.log.debug("building SimpleValue for {}", (Object)this.propertyName);
        if (this.table == null) {
            this.table = this.columns[0].getTable();
        }
        this.simpleValue = new SimpleValue(this.mappings, this.table);
        this.linkWithValue();
        boolean bl = this.mappings.isInSecondPass();
        SetSimpleValueTypeSecondPass setSimpleValueTypeSecondPass = new SetSimpleValueTypeSecondPass(this);
        if (!bl) {
            this.mappings.addSecondPass(setSimpleValueTypeSecondPass);
        } else {
            this.fillSimpleValue();
        }
        return this.simpleValue;
    }

    public void linkWithValue() {
        if (this.columns[0].isNameDeferred() && !this.mappings.isInSecondPass() && this.referencedEntityName != null) {
            this.mappings.addSecondPass(new PkDrivenByDefaultMapsIdSecondPass(this.referencedEntityName, (Ejb3JoinColumn[])this.columns, this.simpleValue));
        } else {
            for (Ejb3Column ejb3Column : this.columns) {
                ejb3Column.linkWithValue(this.simpleValue);
            }
        }
    }

    public void fillSimpleValue() {
        this.log.debug("Setting SimpleValue typeName for {}", (Object)this.propertyName);
        String string = BinderHelper.isEmptyAnnotationValue(this.explicitType) ? this.returnedClassName : this.explicitType;
        TypeDef typeDef = this.mappings.getTypeDef(string);
        if (typeDef != null) {
            string = typeDef.getTypeClass();
            this.simpleValue.setTypeParameters(typeDef.getParameters());
        }
        if (this.typeParameters != null && this.typeParameters.size() != 0) {
            this.simpleValue.setTypeParameters(this.typeParameters);
        }
        this.simpleValue.setTypeName(string);
        if (this.persistentClassName != null) {
            this.simpleValue.setTypeUsingReflection(this.persistentClassName, this.propertyName);
        }
        if (!this.simpleValue.isTypeSpecified() && this.isVersion()) {
            this.simpleValue.setTypeName("integer");
        }
        if (this.timeStampVersionType != null) {
            this.simpleValue.setTypeName(this.timeStampVersionType);
        }
    }

    public void setKey(boolean bl) {
        this.key = bl;
    }
}

