/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations.reflection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityListeners;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.TableGenerator;
import org.dom4j.Element;
import org.hibernate.annotations.common.reflection.AnnotationReader;
import org.hibernate.annotations.common.reflection.MetadataProvider;
import org.hibernate.annotations.common.reflection.java.JavaMetadataProvider;
import org.hibernate.cfg.annotations.reflection.JPAOverridenAnnotationReader;
import org.hibernate.cfg.annotations.reflection.XMLContext;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAMetadataProvider
implements MetadataProvider,
Serializable {
    private transient MetadataProvider delegate = new JavaMetadataProvider();
    private transient Map<Object, Object> defaults;
    private transient Map<AnnotatedElement, AnnotationReader> cache = new HashMap<AnnotatedElement, AnnotationReader>(100);
    private XMLContext xmlContext = new XMLContext();

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.delegate = new JavaMetadataProvider();
        this.cache = new HashMap<AnnotatedElement, AnnotationReader>(100);
    }

    @Override
    public AnnotationReader getAnnotationReader(AnnotatedElement annotatedElement) {
        AnnotationReader annotationReader = this.cache.get(annotatedElement);
        if (annotationReader == null) {
            annotationReader = this.xmlContext.hasContext() ? new JPAOverridenAnnotationReader(annotatedElement, this.xmlContext) : this.delegate.getAnnotationReader(annotatedElement);
            this.cache.put(annotatedElement, annotationReader);
        }
        return annotationReader;
    }

    @Override
    public Map<Object, Object> getDefaults() {
        if (this.defaults == null) {
            this.defaults = new HashMap<Object, Object>();
            XMLContext.Default default_ = this.xmlContext.getDefault(null);
            this.defaults.put("delimited-identifier", default_.getDelimitedIdentifier());
            ArrayList<Class> arrayList = new ArrayList<Class>();
            for (String object : this.xmlContext.getDefaultEntityListeners()) {
                try {
                    arrayList.add(ReflectHelper.classForName(object, this.getClass()));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalStateException("Default entity listener class not found: " + object);
                }
            }
            this.defaults.put(EntityListeners.class, arrayList);
            for (Element element : this.xmlContext.getAllDocuments()) {
                Object object2;
                List list3;
                List list2 = element.elements("sequence-generator");
                ArrayList<SequenceGenerator> arrayList2 = (ArrayList<SequenceGenerator>)this.defaults.get(SequenceGenerator.class);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<SequenceGenerator>();
                    this.defaults.put(SequenceGenerator.class, arrayList2);
                }
                for (List list3 : list2) {
                    arrayList2.add(JPAOverridenAnnotationReader.buildSequenceGeneratorAnnotation((Element)((Object)list3)));
                }
                list2 = element.elements("table-generator");
                List<TableGenerator> list4 = (List)this.defaults.get(TableGenerator.class);
                if (list4 == null) {
                    list4 = new ArrayList<TableGenerator>();
                    this.defaults.put(TableGenerator.class, list4);
                }
                for (Object object2 : list2) {
                    list4.add(JPAOverridenAnnotationReader.buildTableGeneratorAnnotation((Element)object2, default_));
                }
                list3 = (List)this.defaults.get(NamedQuery.class);
                if (list3 == null) {
                    list3 = new ArrayList();
                    this.defaults.put(NamedQuery.class, list3);
                }
                object2 = JPAOverridenAnnotationReader.buildNamedQueries(element, false, default_);
                list3.addAll(object2);
                ArrayList arrayList3 = (ArrayList)this.defaults.get(NamedNativeQuery.class);
                if (arrayList3 == null) {
                    arrayList3 = new ArrayList();
                    this.defaults.put(NamedNativeQuery.class, arrayList3);
                }
                List list5 = JPAOverridenAnnotationReader.buildNamedQueries(element, true, default_);
                arrayList3.addAll(list5);
                ArrayList<SqlResultSetMapping> arrayList4 = (ArrayList<SqlResultSetMapping>)this.defaults.get(SqlResultSetMapping.class);
                if (arrayList4 == null) {
                    arrayList4 = new ArrayList<SqlResultSetMapping>();
                    this.defaults.put(SqlResultSetMapping.class, arrayList4);
                }
                List<SqlResultSetMapping> list6 = JPAOverridenAnnotationReader.buildSqlResultsetMappings(element, default_);
                arrayList4.addAll(list6);
            }
        }
        return this.defaults;
    }

    public XMLContext getXMLContext() {
        return this.xmlContext;
    }
}

