/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations.reflection;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ColumnResult;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EntityResult;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.ExcludeDefaultListeners;
import javax.persistence.ExcludeSuperclassListeners;
import javax.persistence.FetchType;
import javax.persistence.FieldResult;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.MappedSuperclass;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.QueryHint;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.common.annotationfactory.AnnotationDescriptor;
import org.hibernate.annotations.common.annotationfactory.AnnotationFactory;
import org.hibernate.annotations.common.reflection.AnnotationReader;
import org.hibernate.annotations.common.reflection.Filter;
import org.hibernate.annotations.common.reflection.ReflectionUtil;
import org.hibernate.cfg.annotations.reflection.XMLContext;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAOverridenAnnotationReader
implements AnnotationReader {
    private Logger log = LoggerFactory.getLogger(JPAOverridenAnnotationReader.class);
    private static final Map<Class, String> annotationToXml;
    private static final String SCHEMA_VALIDATION = "Activate schema validation for more information";
    private static final Filter FILTER;
    private XMLContext xmlContext;
    private String className;
    private String propertyName;
    private PropertyType propertyType;
    private transient Annotation[] annotations;
    private transient Map<Class, Annotation> annotationsMap;
    private static final String WORD_SEPARATOR = "-";
    private transient List<Element> elementsForProperty;
    private AccessibleObject mirroredAttribute;
    private final AnnotatedElement element;

    public JPAOverridenAnnotationReader(AnnotatedElement annotatedElement, XMLContext xMLContext) {
        this.element = annotatedElement;
        this.xmlContext = xMLContext;
        if (annotatedElement instanceof Class) {
            Class clazz = (Class)annotatedElement;
            this.className = clazz.getName();
        } else if (annotatedElement instanceof Field) {
            Field field = (Field)annotatedElement;
            this.className = field.getDeclaringClass().getName();
            this.propertyName = field.getName();
            this.propertyType = PropertyType.FIELD;
            String string = "get" + Character.toUpperCase(this.propertyName.charAt(0)) + this.propertyName.substring(1);
            try {
                this.mirroredAttribute = field.getDeclaringClass().getDeclaredMethod(string, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        } else if (annotatedElement instanceof Method) {
            Method method = (Method)annotatedElement;
            this.className = method.getDeclaringClass().getName();
            this.propertyName = method.getName();
            if (ReflectionUtil.isProperty(method, null, FILTER)) {
                if (this.propertyName.startsWith("get")) {
                    this.propertyName = Introspector.decapitalize(this.propertyName.substring("get".length()));
                } else if (this.propertyName.startsWith("is")) {
                    this.propertyName = Introspector.decapitalize(this.propertyName.substring("is".length()));
                } else {
                    throw new RuntimeException("Method " + this.propertyName + " is not a property getter");
                }
                this.propertyType = PropertyType.PROPERTY;
                try {
                    this.mirroredAttribute = method.getDeclaringClass().getDeclaredField(this.propertyName);
                }
                catch (NoSuchFieldException noSuchFieldException) {}
            } else {
                this.propertyType = PropertyType.METHOD;
            }
        } else {
            this.className = null;
            this.propertyName = null;
        }
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        this.initAnnotations();
        return (T)this.annotationsMap.get(clazz);
    }

    @Override
    public <T extends Annotation> boolean isAnnotationPresent(Class<T> clazz) {
        this.initAnnotations();
        return this.annotationsMap.get(clazz) != null;
    }

    @Override
    public Annotation[] getAnnotations() {
        this.initAnnotations();
        return this.annotations;
    }

    private void initAnnotations() {
        block12: {
            if (this.annotations != null) break block12;
            XMLContext.Default default_ = this.xmlContext.getDefault(this.className);
            if (this.className != null && this.propertyName == null) {
                Element element = this.xmlContext.getXMLTree(this.className);
                Annotation[] annotationArray = this.getJavaAnnotations();
                ArrayList<Annotation> arrayList = new ArrayList<Annotation>(annotationArray.length + 5);
                this.annotationsMap = new HashMap<Class, Annotation>(annotationArray.length + 5);
                for (Annotation annotation : annotationArray) {
                    if (annotationToXml.containsKey(annotation.annotationType())) continue;
                    arrayList.add(annotation);
                }
                this.addIfNotNull(arrayList, this.getEntity(element, default_));
                this.addIfNotNull(arrayList, this.getMappedSuperclass(element, default_));
                this.addIfNotNull(arrayList, this.getEmbeddable(element, default_));
                this.addIfNotNull(arrayList, this.getTable(element, default_));
                this.addIfNotNull(arrayList, this.getSecondaryTables(element, default_));
                this.addIfNotNull(arrayList, this.getPrimaryKeyJoinColumns(element, default_));
                this.addIfNotNull(arrayList, this.getIdClass(element, default_));
                this.addIfNotNull(arrayList, this.getInheritance(element, default_));
                this.addIfNotNull(arrayList, this.getDiscriminatorValue(element, default_));
                this.addIfNotNull(arrayList, this.getDiscriminatorColumn(element, default_));
                this.addIfNotNull(arrayList, this.getSequenceGenerator(element, default_));
                this.addIfNotNull(arrayList, this.getTableGenerator(element, default_));
                this.addIfNotNull(arrayList, this.getNamedQueries(element, default_));
                this.addIfNotNull(arrayList, this.getNamedNativeQueries(element, default_));
                this.addIfNotNull(arrayList, this.getSqlResultSetMappings(element, default_));
                this.addIfNotNull(arrayList, this.getExcludeDefaultListeners(element, default_));
                this.addIfNotNull(arrayList, this.getExcludeSuperclassListeners(element, default_));
                this.addIfNotNull(arrayList, this.getAccessType(element, default_));
                this.addIfNotNull(arrayList, this.getAttributeOverrides(element, default_));
                this.addIfNotNull(arrayList, this.getAssociationOverrides(element, default_));
                this.addIfNotNull(arrayList, this.getEntityListeners(element, default_));
                for (Annotation annotation : this.annotations = arrayList.toArray(new Annotation[arrayList.size()])) {
                    this.annotationsMap.put(annotation.annotationType(), annotation);
                }
                this.checkForOrphanProperties(element);
            } else if (this.className != null) {
                Element element = this.xmlContext.getXMLTree(this.className);
                Annotation[] annotationArray = this.getJavaAnnotations();
                ArrayList<Annotation> arrayList = new ArrayList<Annotation>(annotationArray.length + 5);
                this.annotationsMap = new HashMap<Class, Annotation>(annotationArray.length + 5);
                for (Annotation annotation : annotationArray) {
                    if (annotationToXml.containsKey(annotation.annotationType())) continue;
                    arrayList.add(annotation);
                }
                this.preCalculateElementsForProperty(element);
                Transient transient_ = this.getTransient(default_);
                if (transient_ != null) {
                    arrayList.add(transient_);
                } else {
                    if (default_.canUseJavaAnnotations()) {
                        Access access = this.getJavaAnnotation(Access.class);
                        this.addIfNotNull(arrayList, access);
                    }
                    this.getId(arrayList, default_);
                    this.getEmbeddedId(arrayList, default_);
                    this.getEmbedded(arrayList, default_);
                    this.getBasic(arrayList, default_);
                    this.getVersion(arrayList, default_);
                    this.getAssociation(ManyToOne.class, arrayList, default_);
                    this.getAssociation(OneToOne.class, arrayList, default_);
                    this.getAssociation(OneToMany.class, arrayList, default_);
                    this.getAssociation(ManyToMany.class, arrayList, default_);
                    this.getElementCollection(arrayList, default_);
                    this.addIfNotNull(arrayList, this.getSequenceGenerator(this.elementsForProperty, default_));
                    this.addIfNotNull(arrayList, this.getTableGenerator(this.elementsForProperty, default_));
                    this.addIfNotNull(arrayList, this.getAttributeOverrides(this.elementsForProperty, default_));
                }
                this.processEventAnnotations(arrayList, default_);
                for (Annotation annotation : this.annotations = arrayList.toArray(new Annotation[arrayList.size()])) {
                    this.annotationsMap.put(annotation.annotationType(), annotation);
                }
            } else {
                this.annotations = this.getJavaAnnotations();
                this.annotationsMap = new HashMap<Class, Annotation>(this.annotations.length + 5);
                for (Annotation annotation : this.annotations) {
                    this.annotationsMap.put(annotation.annotationType(), annotation);
                }
            }
        }
    }

    private void checkForOrphanProperties(Element element) {
        Element element2;
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(this.className, this.getClass());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
        Element element3 = element2 = element != null ? element.element("attributes") : null;
        if (element2 != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (Field accessibleObject : clazz.getFields()) {
                hashSet.add(accessibleObject.getName());
            }
            for (AccessibleObject accessibleObject : clazz.getMethods()) {
                String string = ((Method)accessibleObject).getName();
                if (string.startsWith("get")) {
                    hashSet.add(Introspector.decapitalize(string.substring("get".length())));
                    continue;
                }
                if (!string.startsWith("is")) continue;
                hashSet.add(Introspector.decapitalize(string.substring("is".length())));
            }
            for (Element element4 : element2.elements()) {
                String string = element4.attributeValue("name");
                if (hashSet.contains(string)) continue;
                this.log.warn("Property {} not found in class but described in <mapping-file/> (possible typo error)", (Object)StringHelper.qualify(this.className, string));
            }
        }
    }

    private Annotation addIfNotNull(List<Annotation> list, Annotation annotation) {
        if (annotation != null) {
            list.add(annotation);
        }
        return annotation;
    }

    private Annotation getTableGenerator(List<Element> list, XMLContext.Default default_) {
        for (Element element : list) {
            Element element2 = element != null ? element.element(annotationToXml.get(TableGenerator.class)) : null;
            if (element2 == null) continue;
            return JPAOverridenAnnotationReader.buildTableGeneratorAnnotation(element2, default_);
        }
        if (list.size() == 0 && default_.canUseJavaAnnotations()) {
            return this.getJavaAnnotation(TableGenerator.class);
        }
        return null;
    }

    private Annotation getSequenceGenerator(List<Element> list, XMLContext.Default default_) {
        for (Element element : list) {
            Element element2 = element != null ? element.element(annotationToXml.get(SequenceGenerator.class)) : null;
            if (element2 == null) continue;
            return JPAOverridenAnnotationReader.buildSequenceGeneratorAnnotation(element2);
        }
        if (list.size() == 0 && default_.canUseJavaAnnotations()) {
            return this.getJavaAnnotation(SequenceGenerator.class);
        }
        return null;
    }

    private void processEventAnnotations(List<Annotation> list, XMLContext.Default default_) {
        boolean bl = false;
        for (Element element : this.elementsForProperty) {
            AnnotationDescriptor annotationDescriptor;
            String string = element.getName();
            if ("pre-persist".equals(string)) {
                annotationDescriptor = new AnnotationDescriptor(PrePersist.class);
                list.add((Annotation)AnnotationFactory.create(annotationDescriptor));
                bl = true;
                continue;
            }
            if ("pre-remove".equals(string)) {
                annotationDescriptor = new AnnotationDescriptor(PreRemove.class);
                list.add((Annotation)AnnotationFactory.create(annotationDescriptor));
                bl = true;
                continue;
            }
            if ("pre-update".equals(string)) {
                annotationDescriptor = new AnnotationDescriptor(PreUpdate.class);
                list.add((Annotation)AnnotationFactory.create(annotationDescriptor));
                bl = true;
                continue;
            }
            if ("post-persist".equals(string)) {
                annotationDescriptor = new AnnotationDescriptor(PostPersist.class);
                list.add((Annotation)AnnotationFactory.create(annotationDescriptor));
                bl = true;
                continue;
            }
            if ("post-remove".equals(string)) {
                annotationDescriptor = new AnnotationDescriptor(PostRemove.class);
                list.add((Annotation)AnnotationFactory.create(annotationDescriptor));
                bl = true;
                continue;
            }
            if ("post-update".equals(string)) {
                annotationDescriptor = new AnnotationDescriptor(PostUpdate.class);
                list.add((Annotation)AnnotationFactory.create(annotationDescriptor));
                bl = true;
                continue;
            }
            if (!"post-load".equals(string)) continue;
            annotationDescriptor = new AnnotationDescriptor(PostLoad.class);
            list.add((Annotation)AnnotationFactory.create(annotationDescriptor));
            bl = true;
        }
        if (!bl && default_.canUseJavaAnnotations()) {
            Object object = this.getJavaAnnotation(PrePersist.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(PreRemove.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(PreUpdate.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(PostPersist.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(PostRemove.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(PostUpdate.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(PostLoad.class);
            this.addIfNotNull(list, (Annotation)object);
        }
    }

    private EntityListeners getEntityListeners(Element element, XMLContext.Default default_) {
        Element element2;
        Element element3 = element2 = element != null ? element.element("entity-listeners") : null;
        if (element2 != null) {
            ArrayList<Class> arrayList = new ArrayList<Class>();
            for (Element element4 : element2.elements("entity-listener")) {
                String string = element4.attributeValue("class");
                try {
                    arrayList.add(ReflectHelper.classForName(XMLContext.buildSafeClassName(string, default_), this.getClass()));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AnnotationException("Unable to find " + element2.getPath() + ".class: " + string, classNotFoundException);
                }
            }
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(EntityListeners.class);
            annotationDescriptor.setValue("value", arrayList.toArray(new Class[arrayList.size()]));
            return (EntityListeners)AnnotationFactory.create(annotationDescriptor);
        }
        if (default_.canUseJavaAnnotations()) {
            return this.getJavaAnnotation(EntityListeners.class);
        }
        return null;
    }

    private JoinTable overridesDefaultsInJoinTable(Annotation annotation, XMLContext.Default default_) {
        boolean bl = !this.isJavaAnnotationPresent(JoinColumn.class) && !this.isJavaAnnotationPresent(JoinColumns.class);
        Class<? extends Annotation> clazz = annotation.annotationType();
        bl = bl && (clazz == ManyToMany.class && StringHelper.isEmpty(((ManyToMany)annotation).mappedBy()) || clazz == OneToMany.class && StringHelper.isEmpty(((OneToMany)annotation).mappedBy()) || clazz == CollectionOfElements.class || clazz == ElementCollection.class);
        Class<JoinTable> clazz2 = JoinTable.class;
        if (bl && (StringHelper.isNotEmpty(default_.getCatalog()) || StringHelper.isNotEmpty(default_.getSchema()))) {
            JoinTable joinTable;
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(clazz2);
            if (default_.canUseJavaAnnotations() && (joinTable = this.getJavaAnnotation(clazz2)) != null) {
                annotationDescriptor.setValue("name", joinTable.name());
                annotationDescriptor.setValue("schema", joinTable.schema());
                annotationDescriptor.setValue("catalog", joinTable.catalog());
                annotationDescriptor.setValue("uniqueConstraints", joinTable.uniqueConstraints());
                annotationDescriptor.setValue("joinColumns", joinTable.joinColumns());
                annotationDescriptor.setValue("inverseJoinColumns", joinTable.inverseJoinColumns());
            }
            if (StringHelper.isEmpty((String)annotationDescriptor.valueOf("schema")) && StringHelper.isNotEmpty(default_.getSchema())) {
                annotationDescriptor.setValue("schema", default_.getSchema());
            }
            if (StringHelper.isEmpty((String)annotationDescriptor.valueOf("catalog")) && StringHelper.isNotEmpty(default_.getCatalog())) {
                annotationDescriptor.setValue("catalog", default_.getCatalog());
            }
            return (JoinTable)AnnotationFactory.create(annotationDescriptor);
        }
        if (default_.canUseJavaAnnotations()) {
            return this.getJavaAnnotation(clazz2);
        }
        return null;
    }

    private void getJoinTable(List<Annotation> list, Element element, XMLContext.Default default_) {
        Element element2 = element == null ? null : element.element("join-table");
        Class<JoinTable> clazz = JoinTable.class;
        if (element2 != null) {
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(clazz);
            JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element2, "name", false);
            JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element2, "catalog", false);
            if (StringHelper.isNotEmpty(default_.getCatalog()) && StringHelper.isEmpty((String)annotationDescriptor.valueOf("catalog"))) {
                annotationDescriptor.setValue("catalog", default_.getCatalog());
            }
            JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element2, "schema", false);
            if (StringHelper.isNotEmpty(default_.getSchema()) && StringHelper.isEmpty((String)annotationDescriptor.valueOf("schema"))) {
                annotationDescriptor.setValue("schema", default_.getSchema());
            }
            JPAOverridenAnnotationReader.buildUniqueConstraints(annotationDescriptor, element2);
            annotationDescriptor.setValue("joinColumns", this.getJoinColumns(element2, false));
            annotationDescriptor.setValue("inverseJoinColumns", this.getJoinColumns(element2, true));
            list.add((Annotation)AnnotationFactory.create(annotationDescriptor));
        }
    }

    private void getAssociation(Class<? extends Annotation> clazz, List<Annotation> list, XMLContext.Default default_) {
        String string = annotationToXml.get(clazz);
        for (Element element : this.elementsForProperty) {
            if (!string.equals(element.getName())) continue;
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(clazz);
            this.addTargetClass(element, annotationDescriptor, "target-entity", default_);
            this.getFetchType(annotationDescriptor, element);
            this.getCascades(annotationDescriptor, element, default_);
            this.getJoinTable(list, element, default_);
            this.buildJoinColumns(list, element);
            PrimaryKeyJoinColumns primaryKeyJoinColumns = this.getPrimaryKeyJoinColumns(element, default_);
            this.addIfNotNull(list, primaryKeyJoinColumns);
            JPAOverridenAnnotationReader.copyBooleanAttribute(annotationDescriptor, element, "optional");
            JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element, "mapped-by", false);
            this.getOrderBy(list, element);
            this.getMapKey(list, element);
            list.add((Annotation)AnnotationFactory.create(annotationDescriptor));
            this.getAccessType(list, element);
        }
        if (this.elementsForProperty.size() == 0 && default_.canUseJavaAnnotations()) {
            Object object = this.getJavaAnnotation(clazz);
            if (object != null) {
                list.add((Annotation)object);
                object = this.overridesDefaultsInJoinTable((Annotation)object, default_);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(JoinColumn.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(JoinColumns.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(PrimaryKeyJoinColumn.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(PrimaryKeyJoinColumns.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(MapKey.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(OrderBy.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(AttributeOverride.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(AttributeOverrides.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(AssociationOverride.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(AssociationOverrides.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(Lob.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(Enumerated.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(Temporal.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(Column.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(Columns.class);
                this.addIfNotNull(list, (Annotation)object);
            } else if (this.isJavaAnnotationPresent(ElementCollection.class)) {
                object = this.overridesDefaultsInJoinTable(this.getJavaAnnotation(ElementCollection.class), default_);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(JoinColumn.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(JoinColumns.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(PrimaryKeyJoinColumn.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(PrimaryKeyJoinColumns.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(MapKey.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(OrderBy.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(AttributeOverride.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(AttributeOverrides.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(AssociationOverride.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(AssociationOverrides.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(Lob.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(Enumerated.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(Temporal.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(Column.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(Columns.class);
                this.addIfNotNull(list, (Annotation)object);
            } else if (this.isJavaAnnotationPresent(CollectionOfElements.class)) {
                object = this.overridesDefaultsInJoinTable(this.getJavaAnnotation(CollectionOfElements.class), default_);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(JoinColumn.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(JoinColumns.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(PrimaryKeyJoinColumn.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(PrimaryKeyJoinColumns.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(MapKey.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(OrderBy.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(AttributeOverride.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(AttributeOverrides.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(AssociationOverride.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(AssociationOverrides.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(Lob.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(Enumerated.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(Temporal.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(Column.class);
                this.addIfNotNull(list, (Annotation)object);
                object = this.getJavaAnnotation(Columns.class);
                this.addIfNotNull(list, (Annotation)object);
            }
        }
    }

    private void addTargetClass(Element element, AnnotationDescriptor annotationDescriptor, String string, XMLContext.Default default_) {
        String string2 = element.attributeValue(string);
        if (string2 != null) {
            Class clazz;
            try {
                clazz = ReflectHelper.classForName(XMLContext.buildSafeClassName(string2, default_), this.getClass());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AnnotationException("Unable to find " + element.getPath() + " " + string + ": " + string2, classNotFoundException);
            }
            annotationDescriptor.setValue(JPAOverridenAnnotationReader.getJavaAttributeNameFromXMLOne(string), clazz);
        }
    }

    private void getElementCollection(List<Annotation> list, XMLContext.Default default_) {
        for (Element element : this.elementsForProperty) {
            if (!"element-collection".equals(element.getName())) continue;
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(ElementCollection.class);
            this.addTargetClass(element, annotationDescriptor, "target-class", default_);
            list.add((Annotation)AnnotationFactory.create(annotationDescriptor));
            this.getAccessType(list, element);
        }
    }

    private void getOrderBy(List<Annotation> list, Element element) {
        Element element2;
        Element element3 = element2 = element != null ? element.element("order-by") : null;
        if (element2 != null) {
            String string = element2.getTextTrim();
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(OrderBy.class);
            if (StringHelper.isNotEmpty(string)) {
                annotationDescriptor.setValue("value", string);
            }
            list.add((Annotation)AnnotationFactory.create(annotationDescriptor));
        }
    }

    private void getMapKey(List<Annotation> list, Element element) {
        Element element2;
        Element element3 = element2 = element != null ? element.element("map-key") : null;
        if (element2 != null) {
            String string = element2.attributeValue("name");
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(MapKey.class);
            if (StringHelper.isNotEmpty(string)) {
                annotationDescriptor.setValue("name", string);
            }
            list.add((Annotation)AnnotationFactory.create(annotationDescriptor));
        }
    }

    private void buildJoinColumns(List<Annotation> list, Element element) {
        JoinColumn[] joinColumnArray = this.getJoinColumns(element, false);
        if (joinColumnArray.length > 0) {
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(JoinColumns.class);
            annotationDescriptor.setValue("value", joinColumnArray);
            list.add((Annotation)AnnotationFactory.create(annotationDescriptor));
        }
    }

    private void getCascades(AnnotationDescriptor annotationDescriptor, Element element, XMLContext.Default default_) {
        List list = element != null ? element.elements("cascade") : new ArrayList(0);
        ArrayList<CascadeType> arrayList = new ArrayList<CascadeType>();
        for (Element element2 : list) {
            if (element2.element("cascade-all") != null) {
                arrayList.add(CascadeType.ALL);
            }
            if (element2.element("cascade-persist") != null) {
                arrayList.add(CascadeType.PERSIST);
            }
            if (element2.element("cascade-merge") != null) {
                arrayList.add(CascadeType.MERGE);
            }
            if (element2.element("cascade-remove") != null) {
                arrayList.add(CascadeType.REMOVE);
            }
            if (element2.element("cascade-refresh") != null) {
                arrayList.add(CascadeType.REFRESH);
            }
            if (element2.element("cascade-detach") == null) continue;
            arrayList.add(CascadeType.DETACH);
        }
        if (Boolean.TRUE.equals(default_.getCascadePersist()) && !arrayList.contains((Object)CascadeType.ALL) && !arrayList.contains((Object)CascadeType.PERSIST)) {
            arrayList.add(CascadeType.PERSIST);
        }
        if (arrayList.size() > 0) {
            annotationDescriptor.setValue("cascade", arrayList.toArray(new CascadeType[arrayList.size()]));
        }
    }

    private void getEmbedded(List<Annotation> list, XMLContext.Default default_) {
        Object object = this.elementsForProperty.iterator();
        while (object.hasNext()) {
            Element element = object.next();
            if (!"embedded".equals(element.getName())) continue;
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(Embedded.class);
            list.add((Annotation)AnnotationFactory.create(annotationDescriptor));
            this.getAccessType(list, element);
        }
        if (this.elementsForProperty.size() == 0 && default_.canUseJavaAnnotations() && (object = this.getJavaAnnotation(Embedded.class)) != null) {
            list.add((Annotation)object);
            object = this.getJavaAnnotation(AttributeOverride.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(AttributeOverrides.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(AssociationOverride.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(AssociationOverrides.class);
            this.addIfNotNull(list, (Annotation)object);
        }
    }

    private Transient getTransient(XMLContext.Default default_) {
        for (Element element : this.elementsForProperty) {
            if (!"transient".equals(element.getName())) continue;
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(Transient.class);
            return (Transient)AnnotationFactory.create(annotationDescriptor);
        }
        if (this.elementsForProperty.size() == 0 && default_.canUseJavaAnnotations()) {
            return this.getJavaAnnotation(Transient.class);
        }
        return null;
    }

    private void getVersion(List<Annotation> list, XMLContext.Default default_) {
        Object object = this.elementsForProperty.iterator();
        while (object.hasNext()) {
            Element element = object.next();
            if (!"version".equals(element.getName())) continue;
            Columns columns = this.buildColumns(element);
            this.addIfNotNull(list, columns);
            this.getTemporal(list, element);
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(Version.class);
            list.add((Annotation)AnnotationFactory.create(annotationDescriptor));
            this.getAccessType(list, element);
        }
        if (this.elementsForProperty.size() == 0 && default_.canUseJavaAnnotations() && (object = this.getJavaAnnotation(Version.class)) != null) {
            list.add((Annotation)object);
            object = this.getJavaAnnotation(Column.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(Columns.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(Temporal.class);
            this.addIfNotNull(list, (Annotation)object);
        }
    }

    private void getBasic(List<Annotation> list, XMLContext.Default default_) {
        for (Element element : this.elementsForProperty) {
            if (!"basic".equals(element.getName())) continue;
            Columns columns = this.buildColumns(element);
            this.addIfNotNull(list, columns);
            this.getAccessType(list, element);
            this.getTemporal(list, element);
            this.getLob(list, element);
            this.getEnumerated(list, element);
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(Basic.class);
            this.getFetchType(annotationDescriptor, element);
            JPAOverridenAnnotationReader.copyBooleanAttribute(annotationDescriptor, element, "optional");
            list.add((Annotation)AnnotationFactory.create(annotationDescriptor));
        }
        if (this.elementsForProperty.size() == 0 && default_.canUseJavaAnnotations()) {
            Object object = this.getJavaAnnotation(Basic.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(Lob.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(Enumerated.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(Temporal.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(Column.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(Columns.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(AttributeOverride.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(AttributeOverrides.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(AssociationOverride.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(AssociationOverrides.class);
            this.addIfNotNull(list, (Annotation)object);
        }
    }

    private void getEnumerated(List<Annotation> list, Element element) {
        Element element2;
        Element element3 = element2 = element != null ? element.element("enumerated") : null;
        if (element2 != null) {
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(Enumerated.class);
            String string = element2.getTextTrim();
            if ("ORDINAL".equalsIgnoreCase(string)) {
                annotationDescriptor.setValue("value", (Object)EnumType.ORDINAL);
            } else if ("STRING".equalsIgnoreCase(string)) {
                annotationDescriptor.setValue("value", (Object)EnumType.STRING);
            } else if (StringHelper.isNotEmpty(string)) {
                throw new AnnotationException("Unknown EnumType: " + string + ". " + SCHEMA_VALIDATION);
            }
            list.add((Annotation)AnnotationFactory.create(annotationDescriptor));
        }
    }

    private void getLob(List<Annotation> list, Element element) {
        Element element2;
        Element element3 = element2 = element != null ? element.element("lob") : null;
        if (element2 != null) {
            list.add((Annotation)AnnotationFactory.create(new AnnotationDescriptor(Lob.class)));
        }
    }

    private void getFetchType(AnnotationDescriptor annotationDescriptor, Element element) {
        String string;
        String string2 = string = element != null ? element.attributeValue("fetch") : null;
        if (string != null) {
            if ("eager".equalsIgnoreCase(string)) {
                annotationDescriptor.setValue("fetch", (Object)FetchType.EAGER);
            } else if ("lazy".equalsIgnoreCase(string)) {
                annotationDescriptor.setValue("fetch", (Object)FetchType.LAZY);
            }
        }
    }

    private void getEmbeddedId(List<Annotation> list, XMLContext.Default default_) {
        Object object = this.elementsForProperty.iterator();
        while (object.hasNext()) {
            Element element = object.next();
            if (!"embedded-id".equals(element.getName()) || !this.isProcessingId(default_)) continue;
            Annotation annotation = this.getAttributeOverrides(element, default_);
            this.addIfNotNull(list, annotation);
            annotation = this.getAssociationOverrides(element, default_);
            this.addIfNotNull(list, annotation);
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(EmbeddedId.class);
            list.add((Annotation)AnnotationFactory.create(annotationDescriptor));
            this.getAccessType(list, element);
        }
        if (this.elementsForProperty.size() == 0 && default_.canUseJavaAnnotations() && (object = this.getJavaAnnotation(EmbeddedId.class)) != null) {
            list.add((Annotation)object);
            object = this.getJavaAnnotation(Column.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(Columns.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(GeneratedValue.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(Temporal.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(TableGenerator.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(SequenceGenerator.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(AttributeOverride.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(AttributeOverrides.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(AssociationOverride.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(AssociationOverrides.class);
            this.addIfNotNull(list, (Annotation)object);
        }
    }

    private void preCalculateElementsForProperty(Element element) {
        Element element2;
        this.elementsForProperty = new ArrayList<Element>();
        Element element3 = element2 = element != null ? element.element("attributes") : null;
        if (element2 != null) {
            for (Element element4 : element2.elements()) {
                if (!this.propertyName.equals(element4.attributeValue("name"))) continue;
                this.elementsForProperty.add(element4);
            }
        }
        if (element != null) {
            for (Element element4 : element.elements()) {
                if (!this.propertyName.equals(element4.attributeValue("method-name"))) continue;
                this.elementsForProperty.add(element4);
            }
        }
    }

    private void getId(List<Annotation> list, XMLContext.Default default_) {
        Object object = this.elementsForProperty.iterator();
        while (object.hasNext()) {
            boolean bl;
            Element element = object.next();
            if (!"id".equals(element.getName()) || !(bl = this.isProcessingId(default_))) continue;
            Annotation annotation = this.buildColumns(element);
            this.addIfNotNull(list, annotation);
            annotation = this.buildGeneratedValue(element);
            this.addIfNotNull(list, annotation);
            this.getTemporal(list, element);
            annotation = this.getTableGenerator(element, default_);
            this.addIfNotNull(list, annotation);
            annotation = this.getSequenceGenerator(element, default_);
            this.addIfNotNull(list, annotation);
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(Id.class);
            list.add((Annotation)AnnotationFactory.create(annotationDescriptor));
            this.getAccessType(list, element);
        }
        if (this.elementsForProperty.size() == 0 && default_.canUseJavaAnnotations() && (object = this.getJavaAnnotation(Id.class)) != null) {
            list.add((Annotation)object);
            object = this.getJavaAnnotation(Column.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(Columns.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(GeneratedValue.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(Temporal.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(TableGenerator.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(SequenceGenerator.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(AttributeOverride.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(AttributeOverrides.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(AssociationOverride.class);
            this.addIfNotNull(list, (Annotation)object);
            object = this.getJavaAnnotation(AssociationOverrides.class);
            this.addIfNotNull(list, (Annotation)object);
        }
    }

    private boolean isProcessingId(XMLContext.Default default_) {
        boolean bl = default_.getAccess() != null;
        boolean bl2 = PropertyType.PROPERTY.equals((Object)this.propertyType) && AccessType.PROPERTY.equals((Object)default_.getAccess()) || PropertyType.FIELD.equals((Object)this.propertyType) && AccessType.FIELD.equals((Object)default_.getAccess());
        boolean bl3 = default_.canUseJavaAnnotations() && (this.isJavaAnnotationPresent(Id.class) || this.isJavaAnnotationPresent(EmbeddedId.class));
        boolean bl4 = default_.canUseJavaAnnotations() && this.mirroredAttribute != null && (this.mirroredAttribute.isAnnotationPresent(Id.class) || this.mirroredAttribute.isAnnotationPresent(EmbeddedId.class));
        boolean bl5 = PropertyType.PROPERTY.equals((Object)this.propertyType) && !bl4;
        return bl2 || !bl && bl3 || !bl && bl5;
    }

    private Columns buildColumns(Element element) {
        List list = element.elements("column");
        ArrayList<Column> arrayList = new ArrayList<Column>(list.size());
        for (Element element2 : list) {
            arrayList.add(this.getColumn(element2, false, element));
        }
        if (arrayList.size() > 0) {
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(Columns.class);
            annotationDescriptor.setValue("columns", arrayList.toArray(new Column[arrayList.size()]));
            return (Columns)AnnotationFactory.create(annotationDescriptor);
        }
        return null;
    }

    private GeneratedValue buildGeneratedValue(Element element) {
        Element element2;
        Element element3 = element2 = element != null ? element.element("generated-value") : null;
        if (element2 != null) {
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(GeneratedValue.class);
            String string = element2.attributeValue("strategy");
            if ("TABLE".equalsIgnoreCase(string)) {
                annotationDescriptor.setValue("strategy", (Object)GenerationType.TABLE);
            } else if ("SEQUENCE".equalsIgnoreCase(string)) {
                annotationDescriptor.setValue("strategy", (Object)GenerationType.SEQUENCE);
            } else if ("IDENTITY".equalsIgnoreCase(string)) {
                annotationDescriptor.setValue("strategy", (Object)GenerationType.IDENTITY);
            } else if ("AUTO".equalsIgnoreCase(string)) {
                annotationDescriptor.setValue("strategy", (Object)GenerationType.AUTO);
            } else if (StringHelper.isNotEmpty(string)) {
                throw new AnnotationException("Unknown GenerationType: " + string + ". " + SCHEMA_VALIDATION);
            }
            JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element2, "generator", false);
            return (GeneratedValue)AnnotationFactory.create(annotationDescriptor);
        }
        return null;
    }

    private void getTemporal(List<Annotation> list, Element element) {
        Element element2;
        Element element3 = element2 = element != null ? element.element("temporal") : null;
        if (element2 != null) {
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(Temporal.class);
            String string = element2.getTextTrim();
            if ("DATE".equalsIgnoreCase(string)) {
                annotationDescriptor.setValue("value", (Object)TemporalType.DATE);
            } else if ("TIME".equalsIgnoreCase(string)) {
                annotationDescriptor.setValue("value", (Object)TemporalType.TIME);
            } else if ("TIMESTAMP".equalsIgnoreCase(string)) {
                annotationDescriptor.setValue("value", (Object)TemporalType.TIMESTAMP);
            } else if (StringHelper.isNotEmpty(string)) {
                throw new AnnotationException("Unknown TemporalType: " + string + ". " + SCHEMA_VALIDATION);
            }
            list.add((Annotation)AnnotationFactory.create(annotationDescriptor));
        }
    }

    private void getAccessType(List<Annotation> list, Element element) {
        if (element == null) {
            return;
        }
        String string = element.attributeValue("access");
        if (string != null) {
            AccessType accessType;
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(Access.class);
            try {
                accessType = AccessType.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new AnnotationException(string + " is not a valid access type. Check you xml confguration.");
            }
            if (AccessType.PROPERTY.equals((Object)accessType) && this.element instanceof Method || AccessType.FIELD.equals((Object)accessType) && this.element instanceof Field) {
                return;
            }
            annotationDescriptor.setValue("value", (Object)accessType);
            list.add((Annotation)AnnotationFactory.create(annotationDescriptor));
        }
    }

    private AssociationOverrides getAssociationOverrides(Element element, XMLContext.Default default_) {
        Object object;
        List<AssociationOverride> list = this.buildAssociationOverrides(element);
        if (default_.canUseJavaAnnotations()) {
            object = this.getJavaAnnotation(AssociationOverride.class);
            this.addAssociationOverrideIfNeeded((AssociationOverride)object, list);
            AssociationOverrides associationOverrides = this.getJavaAnnotation(AssociationOverrides.class);
            if (associationOverrides != null) {
                for (AssociationOverride associationOverride : associationOverrides.value()) {
                    this.addAssociationOverrideIfNeeded(associationOverride, list);
                }
            }
        }
        if (list.size() > 0) {
            object = new AnnotationDescriptor(AssociationOverrides.class);
            ((AnnotationDescriptor)object).setValue("value", list.toArray(new AssociationOverride[list.size()]));
            return (AssociationOverrides)AnnotationFactory.create((AnnotationDescriptor)object);
        }
        return null;
    }

    private List<AssociationOverride> buildAssociationOverrides(Element element) {
        List list = element == null ? null : element.elements("association-override");
        ArrayList<AssociationOverride> arrayList = new ArrayList<AssociationOverride>();
        if (list != null && list.size() > 0) {
            for (Element element2 : list) {
                AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(AssociationOverride.class);
                JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element2, "name", true);
                annotationDescriptor.setValue("joinColumns", this.getJoinColumns(element2, false));
                arrayList.add((AssociationOverride)AnnotationFactory.create(annotationDescriptor));
            }
        }
        return arrayList;
    }

    private JoinColumn[] getJoinColumns(Element element, boolean bl) {
        List list = element != null ? element.elements(bl ? "inverse-join-column" : "join-column") : null;
        ArrayList<JoinColumn> arrayList = new ArrayList<JoinColumn>();
        if (list != null) {
            for (Element element2 : list) {
                AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(JoinColumn.class);
                JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element2, "name", false);
                JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element2, "referenced-column-name", false);
                JPAOverridenAnnotationReader.copyBooleanAttribute(annotationDescriptor, element2, "unique");
                JPAOverridenAnnotationReader.copyBooleanAttribute(annotationDescriptor, element2, "nullable");
                JPAOverridenAnnotationReader.copyBooleanAttribute(annotationDescriptor, element2, "insertable");
                JPAOverridenAnnotationReader.copyBooleanAttribute(annotationDescriptor, element2, "updatable");
                JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element2, "column-definition", false);
                JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element2, "table", false);
                arrayList.add((JoinColumn)AnnotationFactory.create(annotationDescriptor));
            }
        }
        return arrayList.toArray(new JoinColumn[arrayList.size()]);
    }

    private void addAssociationOverrideIfNeeded(AssociationOverride associationOverride, List<AssociationOverride> list) {
        if (associationOverride != null) {
            String string = associationOverride.name();
            boolean bl = false;
            for (AssociationOverride associationOverride2 : list) {
                if (!associationOverride2.name().equals(string)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                list.add(associationOverride);
            }
        }
    }

    private AttributeOverrides getAttributeOverrides(Element element, XMLContext.Default default_) {
        List<AttributeOverride> list = this.buildAttributeOverrides(element);
        return this.mergeAttributeOverrides(default_, list);
    }

    private AttributeOverrides getAttributeOverrides(List<Element> list, XMLContext.Default default_) {
        ArrayList<AttributeOverride> arrayList = new ArrayList<AttributeOverride>();
        for (Element element : list) {
            arrayList.addAll(this.buildAttributeOverrides(element));
        }
        return this.mergeAttributeOverrides(default_, arrayList);
    }

    private AttributeOverrides mergeAttributeOverrides(XMLContext.Default default_, List<AttributeOverride> list) {
        Object object;
        if (default_.canUseJavaAnnotations()) {
            object = this.getJavaAnnotation(AttributeOverride.class);
            this.addAttributeOverrideIfNeeded((AttributeOverride)object, list);
            AttributeOverrides attributeOverrides = this.getJavaAnnotation(AttributeOverrides.class);
            if (attributeOverrides != null) {
                for (AttributeOverride attributeOverride : attributeOverrides.value()) {
                    this.addAttributeOverrideIfNeeded(attributeOverride, list);
                }
            }
        }
        if (list.size() > 0) {
            object = new AnnotationDescriptor(AttributeOverrides.class);
            ((AnnotationDescriptor)object).setValue("value", list.toArray(new AttributeOverride[list.size()]));
            return (AttributeOverrides)AnnotationFactory.create((AnnotationDescriptor)object);
        }
        return null;
    }

    private List<AttributeOverride> buildAttributeOverrides(Element element) {
        List list = element == null ? null : element.elements("attribute-override");
        return this.buildAttributeOverrides(list);
    }

    private List<AttributeOverride> buildAttributeOverrides(List<Element> list) {
        ArrayList<AttributeOverride> arrayList = new ArrayList<AttributeOverride>();
        if (list != null && list.size() > 0) {
            for (Element element : list) {
                if (!element.getName().equals("attribute-override")) continue;
                AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(AttributeOverride.class);
                JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element, "name", true);
                Element element2 = element.element("column");
                annotationDescriptor.setValue("column", this.getColumn(element2, true, element));
                arrayList.add((AttributeOverride)AnnotationFactory.create(annotationDescriptor));
            }
        }
        return arrayList;
    }

    private Column getColumn(Element element, boolean bl, Element element2) {
        if (element != null) {
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(Column.class);
            JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element, "name", false);
            JPAOverridenAnnotationReader.copyBooleanAttribute(annotationDescriptor, element, "unique");
            JPAOverridenAnnotationReader.copyBooleanAttribute(annotationDescriptor, element, "nullable");
            JPAOverridenAnnotationReader.copyBooleanAttribute(annotationDescriptor, element, "insertable");
            JPAOverridenAnnotationReader.copyBooleanAttribute(annotationDescriptor, element, "updatable");
            JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element, "column-definition", false);
            JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element, "table", false);
            JPAOverridenAnnotationReader.copyIntegerAttribute(annotationDescriptor, element, "length");
            JPAOverridenAnnotationReader.copyIntegerAttribute(annotationDescriptor, element, "precision");
            JPAOverridenAnnotationReader.copyIntegerAttribute(annotationDescriptor, element, "scale");
            return (Column)AnnotationFactory.create(annotationDescriptor);
        }
        if (bl) {
            throw new AnnotationException(element2.getPath() + ".column is mandatory. " + SCHEMA_VALIDATION);
        }
        return null;
    }

    private void addAttributeOverrideIfNeeded(AttributeOverride attributeOverride, List<AttributeOverride> list) {
        if (attributeOverride != null) {
            String string = attributeOverride.name();
            boolean bl = false;
            for (AttributeOverride attributeOverride2 : list) {
                if (!attributeOverride2.name().equals(string)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                list.add(attributeOverride);
            }
        }
    }

    private Access getAccessType(Element element, XMLContext.Default default_) {
        String string;
        String string2 = string = element == null ? null : element.attributeValue("access");
        if (string != null) {
            AccessType accessType;
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(Access.class);
            try {
                accessType = AccessType.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new AnnotationException(string + " is not a valid access type. Check you xml confguration.");
            }
            annotationDescriptor.setValue("value", (Object)accessType);
            return (Access)AnnotationFactory.create(annotationDescriptor);
        }
        if (default_.canUseJavaAnnotations() && this.isJavaAnnotationPresent(Access.class)) {
            return this.getJavaAnnotation(Access.class);
        }
        if (default_.getAccess() != null) {
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(Access.class);
            annotationDescriptor.setValue("value", (Object)default_.getAccess());
            return (Access)AnnotationFactory.create(annotationDescriptor);
        }
        return null;
    }

    private ExcludeSuperclassListeners getExcludeSuperclassListeners(Element element, XMLContext.Default default_) {
        return (ExcludeSuperclassListeners)this.getMarkerAnnotation(ExcludeSuperclassListeners.class, element, default_);
    }

    private ExcludeDefaultListeners getExcludeDefaultListeners(Element element, XMLContext.Default default_) {
        return (ExcludeDefaultListeners)this.getMarkerAnnotation(ExcludeDefaultListeners.class, element, default_);
    }

    private Annotation getMarkerAnnotation(Class<? extends Annotation> clazz, Element element, XMLContext.Default default_) {
        Element element2;
        Element element3 = element2 = element == null ? null : element.element(annotationToXml.get(clazz));
        if (element2 != null) {
            return AnnotationFactory.create(new AnnotationDescriptor(clazz));
        }
        if (default_.canUseJavaAnnotations()) {
            return this.getJavaAnnotation(clazz);
        }
        return null;
    }

    private SqlResultSetMappings getSqlResultSetMappings(Element element, XMLContext.Default default_) {
        Object object;
        List<SqlResultSetMapping> list = JPAOverridenAnnotationReader.buildSqlResultsetMappings(element, default_);
        if (default_.canUseJavaAnnotations()) {
            object = this.getJavaAnnotation(SqlResultSetMapping.class);
            this.addSqlResultsetMappingIfNeeded((SqlResultSetMapping)object, list);
            SqlResultSetMappings sqlResultSetMappings = this.getJavaAnnotation(SqlResultSetMappings.class);
            if (sqlResultSetMappings != null) {
                for (SqlResultSetMapping sqlResultSetMapping : sqlResultSetMappings.value()) {
                    this.addSqlResultsetMappingIfNeeded(sqlResultSetMapping, list);
                }
            }
        }
        if (list.size() > 0) {
            object = new AnnotationDescriptor(SqlResultSetMappings.class);
            ((AnnotationDescriptor)object).setValue("value", list.toArray(new SqlResultSetMapping[list.size()]));
            return (SqlResultSetMappings)AnnotationFactory.create((AnnotationDescriptor)object);
        }
        return null;
    }

    public static List<SqlResultSetMapping> buildSqlResultsetMappings(Element element, XMLContext.Default default_) {
        if (element == null) {
            return new ArrayList<SqlResultSetMapping>();
        }
        List list = element.elements("sql-result-set-mapping");
        ArrayList<SqlResultSetMapping> arrayList = new ArrayList<SqlResultSetMapping>();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Object object;
            Object object22;
            Object object32;
            Element element2 = (Element)listIterator.next();
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(SqlResultSetMapping.class);
            JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element2, "name", true);
            List list2 = element2.elements("entity-result");
            ArrayList<EntityResult> arrayList2 = new ArrayList<EntityResult>(list2.size());
            for (Object object32 : list2) {
                Class clazz;
                object22 = new AnnotationDescriptor(EntityResult.class);
                object = object32.attributeValue("entity-class");
                if (object == null) {
                    throw new AnnotationException("<entity-result> without entity-class. Activate schema validation for more information");
                }
                try {
                    clazz = ReflectHelper.classForName(XMLContext.buildSafeClassName((String)object, default_), JPAOverridenAnnotationReader.class);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AnnotationException("Unable to find entity-class: " + (String)object, classNotFoundException);
                }
                ((AnnotationDescriptor)object22).setValue("entityClass", clazz);
                JPAOverridenAnnotationReader.copyStringAttribute((AnnotationDescriptor)object22, (Element)object32, "discriminator-column", false);
                ArrayList<FieldResult> arrayList3 = new ArrayList<FieldResult>();
                for (Element element3 : object32.elements("field-result")) {
                    AnnotationDescriptor annotationDescriptor2 = new AnnotationDescriptor(FieldResult.class);
                    JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor2, element3, "name", true);
                    JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor2, element3, "column", true);
                    arrayList3.add((FieldResult)AnnotationFactory.create(annotationDescriptor2));
                }
                ((AnnotationDescriptor)object22).setValue("fields", arrayList3.toArray(new FieldResult[arrayList3.size()]));
                arrayList2.add((EntityResult)AnnotationFactory.create((AnnotationDescriptor)object22));
            }
            annotationDescriptor.setValue("entities", arrayList2.toArray(new EntityResult[arrayList2.size()]));
            list2 = element2.elements("column-result");
            ArrayList arrayList4 = new ArrayList(list2.size());
            for (Object object22 : list2) {
                object = new AnnotationDescriptor(ColumnResult.class);
                JPAOverridenAnnotationReader.copyStringAttribute((AnnotationDescriptor)object, (Element)object22, "name", true);
                arrayList4.add((ColumnResult)AnnotationFactory.create((AnnotationDescriptor)object));
            }
            annotationDescriptor.setValue("columns", arrayList4.toArray(new ColumnResult[arrayList4.size()]));
            object32 = element2.attributeValue("result-class");
            if (StringHelper.isNotEmpty((String)object32)) {
                try {
                    object22 = ReflectHelper.classForName(XMLContext.buildSafeClassName((String)object32, default_), JPAOverridenAnnotationReader.class);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AnnotationException("Unable to find entity-class: " + (String)object32, classNotFoundException);
                }
                annotationDescriptor.setValue("resultClass", object22);
            }
            JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element2, "result-set-mapping", false);
            arrayList.add((SqlResultSetMapping)AnnotationFactory.create(annotationDescriptor));
        }
        return arrayList;
    }

    private void addSqlResultsetMappingIfNeeded(SqlResultSetMapping sqlResultSetMapping, List<SqlResultSetMapping> list) {
        if (sqlResultSetMapping != null) {
            String string = sqlResultSetMapping.name();
            boolean bl = false;
            for (SqlResultSetMapping sqlResultSetMapping2 : list) {
                if (!sqlResultSetMapping2.name().equals(string)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                list.add(sqlResultSetMapping);
            }
        }
    }

    private NamedQueries getNamedQueries(Element element, XMLContext.Default default_) {
        Object object;
        List list = JPAOverridenAnnotationReader.buildNamedQueries(element, false, default_);
        if (default_.canUseJavaAnnotations()) {
            object = this.getJavaAnnotation(NamedQuery.class);
            this.addNamedQueryIfNeeded((NamedQuery)object, list);
            NamedQueries namedQueries = this.getJavaAnnotation(NamedQueries.class);
            if (namedQueries != null) {
                for (NamedQuery namedQuery : namedQueries.value()) {
                    this.addNamedQueryIfNeeded(namedQuery, list);
                }
            }
        }
        if (list.size() > 0) {
            object = new AnnotationDescriptor(NamedQueries.class);
            ((AnnotationDescriptor)object).setValue("value", list.toArray(new NamedQuery[list.size()]));
            return (NamedQueries)AnnotationFactory.create((AnnotationDescriptor)object);
        }
        return null;
    }

    private void addNamedQueryIfNeeded(NamedQuery namedQuery, List<NamedQuery> list) {
        if (namedQuery != null) {
            String string = namedQuery.name();
            boolean bl = false;
            for (NamedQuery namedQuery2 : list) {
                if (!namedQuery2.name().equals(string)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                list.add(namedQuery);
            }
        }
    }

    private NamedNativeQueries getNamedNativeQueries(Element element, XMLContext.Default default_) {
        Object object;
        List list = JPAOverridenAnnotationReader.buildNamedQueries(element, true, default_);
        if (default_.canUseJavaAnnotations()) {
            object = this.getJavaAnnotation(NamedNativeQuery.class);
            this.addNamedNativeQueryIfNeeded((NamedNativeQuery)object, list);
            NamedNativeQueries namedNativeQueries = this.getJavaAnnotation(NamedNativeQueries.class);
            if (namedNativeQueries != null) {
                for (NamedNativeQuery namedNativeQuery : namedNativeQueries.value()) {
                    this.addNamedNativeQueryIfNeeded(namedNativeQuery, list);
                }
            }
        }
        if (list.size() > 0) {
            object = new AnnotationDescriptor(NamedNativeQueries.class);
            ((AnnotationDescriptor)object).setValue("value", list.toArray(new NamedNativeQuery[list.size()]));
            return (NamedNativeQueries)AnnotationFactory.create((AnnotationDescriptor)object);
        }
        return null;
    }

    private void addNamedNativeQueryIfNeeded(NamedNativeQuery namedNativeQuery, List<NamedNativeQuery> list) {
        if (namedNativeQuery != null) {
            String string = namedNativeQuery.name();
            boolean bl = false;
            for (NamedNativeQuery namedNativeQuery2 : list) {
                if (!namedNativeQuery2.name().equals(string)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                list.add(namedNativeQuery);
            }
        }
    }

    public static List buildNamedQueries(Element element, boolean bl, XMLContext.Default default_) {
        if (element == null) {
            return new ArrayList();
        }
        List list = bl ? element.elements("named-native-query") : element.elements("named-query");
        ArrayList arrayList = new ArrayList();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Element element2 = (Element)listIterator.next();
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(bl ? NamedNativeQuery.class : NamedQuery.class);
            JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element2, "name", false);
            Element element3 = element2.element("query");
            if (element3 == null) {
                throw new AnnotationException("No <query> element found.Activate schema validation for more information");
            }
            annotationDescriptor.setValue("query", element3.getTextTrim());
            List list2 = element2.elements("hint");
            ArrayList<QueryHint> arrayList2 = new ArrayList<QueryHint>(list2.size());
            for (Object object : list2) {
                AnnotationDescriptor annotationDescriptor2 = new AnnotationDescriptor(QueryHint.class);
                String string = object.attributeValue("name");
                if (string == null) {
                    throw new AnnotationException("<hint> without name. Activate schema validation for more information");
                }
                annotationDescriptor2.setValue("name", string);
                string = object.attributeValue("value");
                if (string == null) {
                    throw new AnnotationException("<hint> without value. Activate schema validation for more information");
                }
                annotationDescriptor2.setValue("value", string);
                arrayList2.add((QueryHint)AnnotationFactory.create(annotationDescriptor2));
            }
            annotationDescriptor.setValue("hints", arrayList2.toArray(new QueryHint[arrayList2.size()]));
            String string = element2.attributeValue("result-class");
            if (StringHelper.isNotEmpty(string)) {
                Object object;
                try {
                    object = ReflectHelper.classForName(XMLContext.buildSafeClassName(string, default_), JPAOverridenAnnotationReader.class);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AnnotationException("Unable to find entity-class: " + (String)string, classNotFoundException);
                }
                annotationDescriptor.setValue("resultClass", object);
            }
            JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element2, "result-set-mapping", false);
            arrayList.add(AnnotationFactory.create(annotationDescriptor));
        }
        return arrayList;
    }

    private TableGenerator getTableGenerator(Element element, XMLContext.Default default_) {
        Element element2;
        Element element3 = element2 = element != null ? element.element(annotationToXml.get(TableGenerator.class)) : null;
        if (element2 != null) {
            return JPAOverridenAnnotationReader.buildTableGeneratorAnnotation(element2, default_);
        }
        if (default_.canUseJavaAnnotations() && this.isJavaAnnotationPresent(TableGenerator.class)) {
            TableGenerator tableGenerator = this.getJavaAnnotation(TableGenerator.class);
            if (StringHelper.isNotEmpty(default_.getSchema()) || StringHelper.isNotEmpty(default_.getCatalog())) {
                AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(TableGenerator.class);
                annotationDescriptor.setValue("name", tableGenerator.name());
                annotationDescriptor.setValue("table", tableGenerator.table());
                annotationDescriptor.setValue("catalog", tableGenerator.table());
                if (StringHelper.isEmpty((String)annotationDescriptor.valueOf("catalog")) && StringHelper.isNotEmpty(default_.getCatalog())) {
                    annotationDescriptor.setValue("catalog", default_.getCatalog());
                }
                annotationDescriptor.setValue("schema", tableGenerator.table());
                if (StringHelper.isEmpty((String)annotationDescriptor.valueOf("schema")) && StringHelper.isNotEmpty(default_.getSchema())) {
                    annotationDescriptor.setValue("catalog", default_.getSchema());
                }
                annotationDescriptor.setValue("pkColumnName", tableGenerator.pkColumnName());
                annotationDescriptor.setValue("valueColumnName", tableGenerator.valueColumnName());
                annotationDescriptor.setValue("pkColumnValue", tableGenerator.pkColumnValue());
                annotationDescriptor.setValue("initialValue", tableGenerator.initialValue());
                annotationDescriptor.setValue("allocationSize", tableGenerator.allocationSize());
                annotationDescriptor.setValue("uniqueConstraints", tableGenerator.uniqueConstraints());
                return (TableGenerator)AnnotationFactory.create(annotationDescriptor);
            }
            return tableGenerator;
        }
        return null;
    }

    public static TableGenerator buildTableGeneratorAnnotation(Element element, XMLContext.Default default_) {
        AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(TableGenerator.class);
        JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element, "name", false);
        JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element, "table", false);
        JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element, "catalog", false);
        JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element, "schema", false);
        JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element, "pk-column-name", false);
        JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element, "value-column-name", false);
        JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element, "pk-column-value", false);
        JPAOverridenAnnotationReader.copyIntegerAttribute(annotationDescriptor, element, "initial-value");
        JPAOverridenAnnotationReader.copyIntegerAttribute(annotationDescriptor, element, "allocation-size");
        JPAOverridenAnnotationReader.buildUniqueConstraints(annotationDescriptor, element);
        if (StringHelper.isEmpty((String)annotationDescriptor.valueOf("schema")) && StringHelper.isNotEmpty(default_.getSchema())) {
            annotationDescriptor.setValue("schema", default_.getSchema());
        }
        if (StringHelper.isEmpty((String)annotationDescriptor.valueOf("catalog")) && StringHelper.isNotEmpty(default_.getCatalog())) {
            annotationDescriptor.setValue("catalog", default_.getCatalog());
        }
        return (TableGenerator)AnnotationFactory.create(annotationDescriptor);
    }

    private SequenceGenerator getSequenceGenerator(Element element, XMLContext.Default default_) {
        Element element2;
        Element element3 = element2 = element != null ? element.element(annotationToXml.get(SequenceGenerator.class)) : null;
        if (element2 != null) {
            return JPAOverridenAnnotationReader.buildSequenceGeneratorAnnotation(element2);
        }
        if (default_.canUseJavaAnnotations()) {
            return this.getJavaAnnotation(SequenceGenerator.class);
        }
        return null;
    }

    public static SequenceGenerator buildSequenceGeneratorAnnotation(Element element) {
        if (element != null) {
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(SequenceGenerator.class);
            JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element, "name", false);
            JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element, "sequence-name", false);
            JPAOverridenAnnotationReader.copyIntegerAttribute(annotationDescriptor, element, "initial-value");
            JPAOverridenAnnotationReader.copyIntegerAttribute(annotationDescriptor, element, "allocation-size");
            return (SequenceGenerator)AnnotationFactory.create(annotationDescriptor);
        }
        return null;
    }

    private DiscriminatorColumn getDiscriminatorColumn(Element element, XMLContext.Default default_) {
        Element element2;
        Element element3 = element2 = element != null ? element.element("discriminator-column") : null;
        if (element2 != null) {
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(DiscriminatorColumn.class);
            JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element2, "name", false);
            JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element2, "column-definition", false);
            String string = element2.attributeValue("discriminator-type");
            DiscriminatorType discriminatorType = DiscriminatorType.STRING;
            if (string != null) {
                if ("STRING".equals(string)) {
                    discriminatorType = DiscriminatorType.STRING;
                } else if ("CHAR".equals(string)) {
                    discriminatorType = DiscriminatorType.CHAR;
                } else if ("INTEGER".equals(string)) {
                    discriminatorType = DiscriminatorType.INTEGER;
                } else {
                    throw new AnnotationException("Unknown DiscrimiatorType in XML: " + string + " (" + SCHEMA_VALIDATION + ")");
                }
            }
            annotationDescriptor.setValue("discriminatorType", (Object)discriminatorType);
            JPAOverridenAnnotationReader.copyIntegerAttribute(annotationDescriptor, element2, "length");
            return (DiscriminatorColumn)AnnotationFactory.create(annotationDescriptor);
        }
        if (default_.canUseJavaAnnotations()) {
            return this.getJavaAnnotation(DiscriminatorColumn.class);
        }
        return null;
    }

    private DiscriminatorValue getDiscriminatorValue(Element element, XMLContext.Default default_) {
        Element element2;
        Element element3 = element2 = element != null ? element.element("discriminator-value") : null;
        if (element2 != null) {
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(DiscriminatorValue.class);
            JPAOverridenAnnotationReader.copyStringElement(element2, annotationDescriptor, "value");
            return (DiscriminatorValue)AnnotationFactory.create(annotationDescriptor);
        }
        if (default_.canUseJavaAnnotations()) {
            return this.getJavaAnnotation(DiscriminatorValue.class);
        }
        return null;
    }

    private Inheritance getInheritance(Element element, XMLContext.Default default_) {
        Element element2;
        Element element3 = element2 = element != null ? element.element("inheritance") : null;
        if (element2 != null) {
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(Inheritance.class);
            Attribute attribute = element2.attribute("strategy");
            InheritanceType inheritanceType = InheritanceType.SINGLE_TABLE;
            if (attribute != null) {
                String string = attribute.getValue();
                if ("SINGLE_TABLE".equals(string)) {
                    inheritanceType = InheritanceType.SINGLE_TABLE;
                } else if ("JOINED".equals(string)) {
                    inheritanceType = InheritanceType.JOINED;
                } else if ("TABLE_PER_CLASS".equals(string)) {
                    inheritanceType = InheritanceType.TABLE_PER_CLASS;
                } else {
                    throw new AnnotationException("Unknown InheritanceType in XML: " + string + " (" + SCHEMA_VALIDATION + ")");
                }
            }
            annotationDescriptor.setValue("strategy", (Object)inheritanceType);
            return (Inheritance)AnnotationFactory.create(annotationDescriptor);
        }
        if (default_.canUseJavaAnnotations()) {
            return this.getJavaAnnotation(Inheritance.class);
        }
        return null;
    }

    private IdClass getIdClass(Element element, XMLContext.Default default_) {
        Element element2;
        Element element3 = element2 = element == null ? null : element.element("id-class");
        if (element2 != null) {
            Attribute attribute = element2.attribute("class");
            if (attribute != null) {
                Class clazz;
                AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(IdClass.class);
                try {
                    clazz = ReflectHelper.classForName(XMLContext.buildSafeClassName(attribute.getValue(), default_), this.getClass());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AnnotationException("Unable to find id-class: " + attribute.getValue(), classNotFoundException);
                }
                annotationDescriptor.setValue("value", clazz);
                return (IdClass)AnnotationFactory.create(annotationDescriptor);
            }
            throw new AnnotationException("id-class without class. Activate schema validation for more information");
        }
        if (default_.canUseJavaAnnotations()) {
            return this.getJavaAnnotation(IdClass.class);
        }
        return null;
    }

    private PrimaryKeyJoinColumns getPrimaryKeyJoinColumns(Element element, XMLContext.Default default_) {
        Object object;
        PrimaryKeyJoinColumn[] primaryKeyJoinColumnArray = this.buildPrimaryKeyJoinColumns(element);
        if (primaryKeyJoinColumnArray.length == 0 && default_.canUseJavaAnnotations()) {
            object = this.getJavaAnnotation(PrimaryKeyJoinColumn.class);
            if (object != null) {
                primaryKeyJoinColumnArray = new PrimaryKeyJoinColumn[]{object};
            } else {
                PrimaryKeyJoinColumns primaryKeyJoinColumns = this.getJavaAnnotation(PrimaryKeyJoinColumns.class);
                PrimaryKeyJoinColumn[] primaryKeyJoinColumnArray2 = primaryKeyJoinColumnArray = primaryKeyJoinColumns != null ? primaryKeyJoinColumns.value() : primaryKeyJoinColumnArray;
            }
        }
        if (primaryKeyJoinColumnArray.length > 0) {
            object = new AnnotationDescriptor(PrimaryKeyJoinColumns.class);
            ((AnnotationDescriptor)object).setValue("value", primaryKeyJoinColumnArray);
            return (PrimaryKeyJoinColumns)AnnotationFactory.create((AnnotationDescriptor)object);
        }
        return null;
    }

    private Entity getEntity(Element element, XMLContext.Default default_) {
        if (element == null) {
            return default_.canUseJavaAnnotations() ? this.getJavaAnnotation(Entity.class) : null;
        }
        if ("entity".equals(element.getName())) {
            Entity entity;
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(Entity.class);
            JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element, "name", false);
            if (default_.canUseJavaAnnotations() && StringHelper.isEmpty((String)annotationDescriptor.valueOf("name")) && (entity = this.getJavaAnnotation(Entity.class)) != null) {
                annotationDescriptor.setValue("name", entity.name());
            }
            return (Entity)AnnotationFactory.create(annotationDescriptor);
        }
        return null;
    }

    private MappedSuperclass getMappedSuperclass(Element element, XMLContext.Default default_) {
        if (element == null) {
            return default_.canUseJavaAnnotations() ? this.getJavaAnnotation(MappedSuperclass.class) : null;
        }
        if ("mapped-superclass".equals(element.getName())) {
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(MappedSuperclass.class);
            return (MappedSuperclass)AnnotationFactory.create(annotationDescriptor);
        }
        return null;
    }

    private Embeddable getEmbeddable(Element element, XMLContext.Default default_) {
        if (element == null) {
            return default_.canUseJavaAnnotations() ? this.getJavaAnnotation(Embeddable.class) : null;
        }
        if ("embeddable".equals(element.getName())) {
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(Embeddable.class);
            return (Embeddable)AnnotationFactory.create(annotationDescriptor);
        }
        return null;
    }

    private Table getTable(Element element, XMLContext.Default default_) {
        Element element2;
        Element element3 = element2 = element == null ? null : element.element("table");
        if (element2 == null) {
            if (StringHelper.isNotEmpty(default_.getCatalog()) || StringHelper.isNotEmpty(default_.getSchema())) {
                Table table;
                AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(Table.class);
                if (default_.canUseJavaAnnotations() && (table = this.getJavaAnnotation(Table.class)) != null) {
                    annotationDescriptor.setValue("name", table.name());
                    annotationDescriptor.setValue("schema", table.schema());
                    annotationDescriptor.setValue("catalog", table.catalog());
                    annotationDescriptor.setValue("uniqueConstraints", table.uniqueConstraints());
                }
                if (StringHelper.isEmpty((String)annotationDescriptor.valueOf("schema")) && StringHelper.isNotEmpty(default_.getSchema())) {
                    annotationDescriptor.setValue("schema", default_.getSchema());
                }
                if (StringHelper.isEmpty((String)annotationDescriptor.valueOf("catalog")) && StringHelper.isNotEmpty(default_.getCatalog())) {
                    annotationDescriptor.setValue("catalog", default_.getCatalog());
                }
                return (Table)AnnotationFactory.create(annotationDescriptor);
            }
            if (default_.canUseJavaAnnotations()) {
                return this.getJavaAnnotation(Table.class);
            }
            return null;
        }
        AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(Table.class);
        JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element2, "name", false);
        JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element2, "catalog", false);
        if (StringHelper.isNotEmpty(default_.getCatalog()) && StringHelper.isEmpty((String)annotationDescriptor.valueOf("catalog"))) {
            annotationDescriptor.setValue("catalog", default_.getCatalog());
        }
        JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element2, "schema", false);
        if (StringHelper.isNotEmpty(default_.getSchema()) && StringHelper.isEmpty((String)annotationDescriptor.valueOf("schema"))) {
            annotationDescriptor.setValue("schema", default_.getSchema());
        }
        JPAOverridenAnnotationReader.buildUniqueConstraints(annotationDescriptor, element2);
        return (Table)AnnotationFactory.create(annotationDescriptor);
    }

    private SecondaryTables getSecondaryTables(Element element, XMLContext.Default default_) {
        Object object;
        List list = element == null ? new ArrayList() : element.elements("secondary-table");
        ArrayList<SecondaryTable> arrayList = new ArrayList<SecondaryTable>(3);
        for (Object object2 : list) {
            SecondaryTable[] secondaryTableArray = new AnnotationDescriptor(SecondaryTable.class);
            JPAOverridenAnnotationReader.copyStringAttribute((AnnotationDescriptor)secondaryTableArray, (Element)object2, "name", false);
            JPAOverridenAnnotationReader.copyStringAttribute((AnnotationDescriptor)secondaryTableArray, (Element)object2, "catalog", false);
            if (StringHelper.isNotEmpty(default_.getCatalog()) && StringHelper.isEmpty((String)secondaryTableArray.valueOf("catalog"))) {
                secondaryTableArray.setValue("catalog", default_.getCatalog());
            }
            JPAOverridenAnnotationReader.copyStringAttribute((AnnotationDescriptor)secondaryTableArray, (Element)object2, "schema", false);
            if (StringHelper.isNotEmpty(default_.getSchema()) && StringHelper.isEmpty((String)secondaryTableArray.valueOf("schema"))) {
                secondaryTableArray.setValue("schema", default_.getSchema());
            }
            JPAOverridenAnnotationReader.buildUniqueConstraints((AnnotationDescriptor)secondaryTableArray, (Element)object2);
            secondaryTableArray.setValue("pkJoinColumns", this.buildPrimaryKeyJoinColumns((Element)object2));
            arrayList.add((SecondaryTable)AnnotationFactory.create((AnnotationDescriptor)secondaryTableArray));
        }
        if (arrayList.size() == 0 && default_.canUseJavaAnnotations()) {
            Object object2;
            object = this.getJavaAnnotation(SecondaryTable.class);
            this.overridesDefaultInSecondaryTable((SecondaryTable)object, default_, arrayList);
            object2 = this.getJavaAnnotation(SecondaryTables.class);
            if (object2 != null) {
                for (SecondaryTable secondaryTable : object2.value()) {
                    this.overridesDefaultInSecondaryTable(secondaryTable, default_, arrayList);
                }
            }
        }
        if (arrayList.size() > 0) {
            object = new AnnotationDescriptor(SecondaryTables.class);
            ((AnnotationDescriptor)object).setValue("value", arrayList.toArray(new SecondaryTable[arrayList.size()]));
            return (SecondaryTables)AnnotationFactory.create((AnnotationDescriptor)object);
        }
        return null;
    }

    private void overridesDefaultInSecondaryTable(SecondaryTable secondaryTable, XMLContext.Default default_, List<SecondaryTable> list) {
        if (secondaryTable != null) {
            if (StringHelper.isNotEmpty(default_.getCatalog()) || StringHelper.isNotEmpty(default_.getSchema())) {
                AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(SecondaryTable.class);
                annotationDescriptor.setValue("name", secondaryTable.name());
                annotationDescriptor.setValue("schema", secondaryTable.schema());
                annotationDescriptor.setValue("catalog", secondaryTable.catalog());
                annotationDescriptor.setValue("uniqueConstraints", secondaryTable.uniqueConstraints());
                annotationDescriptor.setValue("pkJoinColumns", secondaryTable.pkJoinColumns());
                if (StringHelper.isEmpty((String)annotationDescriptor.valueOf("schema")) && StringHelper.isNotEmpty(default_.getSchema())) {
                    annotationDescriptor.setValue("schema", default_.getSchema());
                }
                if (StringHelper.isEmpty((String)annotationDescriptor.valueOf("catalog")) && StringHelper.isNotEmpty(default_.getCatalog())) {
                    annotationDescriptor.setValue("catalog", default_.getCatalog());
                }
                list.add((SecondaryTable)AnnotationFactory.create(annotationDescriptor));
            } else {
                list.add(secondaryTable);
            }
        }
    }

    private static void buildUniqueConstraints(AnnotationDescriptor annotationDescriptor, Element element) {
        List list = element.elements("unique-constraint");
        UniqueConstraint[] uniqueConstraintArray = new UniqueConstraint[list.size()];
        int n = 0;
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Object object;
            Element element2 = (Element)listIterator.next();
            List list2 = element2.elements("column-name");
            String[] stringArray = new String[list2.size()];
            int n2 = 0;
            ListIterator listIterator2 = list2.listIterator();
            while (listIterator2.hasNext()) {
                object = (Element)listIterator2.next();
                stringArray[n2++] = object.getTextTrim();
            }
            object = new AnnotationDescriptor(UniqueConstraint.class);
            ((AnnotationDescriptor)object).setValue("columnNames", stringArray);
            uniqueConstraintArray[n++] = (UniqueConstraint)AnnotationFactory.create((AnnotationDescriptor)object);
        }
        annotationDescriptor.setValue("uniqueConstraints", uniqueConstraintArray);
    }

    private PrimaryKeyJoinColumn[] buildPrimaryKeyJoinColumns(Element element) {
        if (element == null) {
            return new PrimaryKeyJoinColumn[0];
        }
        List list = element.elements("primary-key-join-column");
        PrimaryKeyJoinColumn[] primaryKeyJoinColumnArray = new PrimaryKeyJoinColumn[list.size()];
        int n = 0;
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Element element2 = (Element)listIterator.next();
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(PrimaryKeyJoinColumn.class);
            JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element2, "name", false);
            JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element2, "referenced-column-name", false);
            JPAOverridenAnnotationReader.copyStringAttribute(annotationDescriptor, element2, "column-definition", false);
            primaryKeyJoinColumnArray[n++] = (PrimaryKeyJoinColumn)AnnotationFactory.create(annotationDescriptor);
        }
        return primaryKeyJoinColumnArray;
    }

    private static void copyStringAttribute(AnnotationDescriptor annotationDescriptor, Element element, String string, boolean bl) {
        String string2 = element.attributeValue(string);
        if (string2 != null) {
            String string3 = JPAOverridenAnnotationReader.getJavaAttributeNameFromXMLOne(string);
            annotationDescriptor.setValue(string3, string2);
        } else if (bl) {
            throw new AnnotationException(element.getName() + "." + string + " is mandatory in XML overring. " + SCHEMA_VALIDATION);
        }
    }

    private static void copyIntegerAttribute(AnnotationDescriptor annotationDescriptor, Element element, String string) {
        String string2 = element.attributeValue(string);
        if (string2 != null) {
            String string3 = JPAOverridenAnnotationReader.getJavaAttributeNameFromXMLOne(string);
            annotationDescriptor.setValue(string3, string2);
            try {
                int n = Integer.parseInt(string2);
                annotationDescriptor.setValue(string3, n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AnnotationException(element.getPath() + string + " not parseable: " + string2 + " (" + SCHEMA_VALIDATION + ")");
            }
        }
    }

    private static String getJavaAttributeNameFromXMLOne(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = stringBuilder.indexOf(WORD_SEPARATOR);
        while (n != -1) {
            stringBuilder.deleteCharAt(n);
            stringBuilder.setCharAt(n, Character.toUpperCase(stringBuilder.charAt(n)));
            n = stringBuilder.indexOf(WORD_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    private static void copyStringElement(Element element, AnnotationDescriptor annotationDescriptor, String string) {
        String string2 = element.getTextTrim();
        annotationDescriptor.setValue(string, string2);
    }

    private static void copyBooleanAttribute(AnnotationDescriptor annotationDescriptor, Element element, String string) {
        String string2 = element.attributeValue(string);
        if (StringHelper.isNotEmpty(string2)) {
            String string3 = JPAOverridenAnnotationReader.getJavaAttributeNameFromXMLOne(string);
            annotationDescriptor.setValue(string3, Boolean.parseBoolean(string2));
        }
    }

    private <T extends Annotation> T getJavaAnnotation(Class<T> clazz) {
        return this.element.getAnnotation(clazz);
    }

    private <T extends Annotation> boolean isJavaAnnotationPresent(Class<T> clazz) {
        return this.element.isAnnotationPresent(clazz);
    }

    private Annotation[] getJavaAnnotations() {
        return this.element.getAnnotations();
    }

    static {
        FILTER = new Filter(){

            public boolean returnStatic() {
                return false;
            }

            public boolean returnTransient() {
                return false;
            }
        };
        annotationToXml = new HashMap<Class, String>();
        annotationToXml.put(Entity.class, "entity");
        annotationToXml.put(MappedSuperclass.class, "mapped-superclass");
        annotationToXml.put(Embeddable.class, "embeddable");
        annotationToXml.put(Table.class, "table");
        annotationToXml.put(SecondaryTable.class, "secondary-table");
        annotationToXml.put(SecondaryTables.class, "secondary-table");
        annotationToXml.put(PrimaryKeyJoinColumn.class, "primary-key-join-column");
        annotationToXml.put(PrimaryKeyJoinColumns.class, "primary-key-join-column");
        annotationToXml.put(IdClass.class, "id-class");
        annotationToXml.put(Inheritance.class, "inheritance");
        annotationToXml.put(DiscriminatorValue.class, "discriminator-value");
        annotationToXml.put(DiscriminatorColumn.class, "discriminator-column");
        annotationToXml.put(SequenceGenerator.class, "sequence-generator");
        annotationToXml.put(TableGenerator.class, "table-generator");
        annotationToXml.put(NamedQuery.class, "named-query");
        annotationToXml.put(NamedQueries.class, "named-query");
        annotationToXml.put(NamedNativeQuery.class, "named-native-query");
        annotationToXml.put(NamedNativeQueries.class, "named-native-query");
        annotationToXml.put(SqlResultSetMapping.class, "sql-result-set-mapping");
        annotationToXml.put(SqlResultSetMappings.class, "sql-result-set-mapping");
        annotationToXml.put(ExcludeDefaultListeners.class, "exclude-default-listeners");
        annotationToXml.put(ExcludeSuperclassListeners.class, "exclude-superclass-listeners");
        annotationToXml.put(AccessType.class, "access");
        annotationToXml.put(AttributeOverride.class, "attribute-override");
        annotationToXml.put(AttributeOverrides.class, "attribute-override");
        annotationToXml.put(AttributeOverride.class, "association-override");
        annotationToXml.put(AttributeOverrides.class, "association-override");
        annotationToXml.put(Id.class, "id");
        annotationToXml.put(EmbeddedId.class, "embedded-id");
        annotationToXml.put(GeneratedValue.class, "generated-value");
        annotationToXml.put(Column.class, "column");
        annotationToXml.put(Columns.class, "column");
        annotationToXml.put(Temporal.class, "temporal");
        annotationToXml.put(Lob.class, "lob");
        annotationToXml.put(Enumerated.class, "enumerated");
        annotationToXml.put(Version.class, "version");
        annotationToXml.put(Transient.class, "transient");
        annotationToXml.put(Basic.class, "basic");
        annotationToXml.put(Embedded.class, "embedded");
        annotationToXml.put(ManyToOne.class, "many-to-one");
        annotationToXml.put(OneToOne.class, "one-to-one");
        annotationToXml.put(OneToMany.class, "one-to-many");
        annotationToXml.put(ManyToMany.class, "many-to-many");
        annotationToXml.put(JoinTable.class, "join-table");
        annotationToXml.put(JoinColumn.class, "join-column");
        annotationToXml.put(JoinColumns.class, "join-column");
        annotationToXml.put(MapKey.class, "map-key");
        annotationToXml.put(OrderBy.class, "order-by");
        annotationToXml.put(EntityListeners.class, "entity-listeners");
        annotationToXml.put(PrePersist.class, "pre-persist");
        annotationToXml.put(PreRemove.class, "pre-remove");
        annotationToXml.put(PreUpdate.class, "pre-update");
        annotationToXml.put(PostPersist.class, "post-persist");
        annotationToXml.put(PostRemove.class, "post-remove");
        annotationToXml.put(PostUpdate.class, "post-update");
        annotationToXml.put(PostLoad.class, "post-load");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PropertyType {
        PROPERTY,
        FIELD,
        METHOD;

    }
}

