/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations.reflection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.AccessType;
import org.dom4j.Document;
import org.dom4j.Element;
import org.hibernate.AnnotationException;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLContext
implements Serializable {
    private Logger log = LoggerFactory.getLogger(XMLContext.class);
    private Default globalDefaults;
    private Map<String, Element> classOverriding = new HashMap<String, Element>();
    private Map<String, Default> defaultsOverriding = new HashMap<String, Default>();
    private List<Element> defaultElements = new ArrayList<Element>();
    private List<String> defaultEntityListeners = new ArrayList<String>();
    private boolean hasContext = false;

    public List<String> addDocument(Document document) {
        Element element;
        Object object;
        this.hasContext = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        Element element2 = document.getRootElement();
        Element element3 = element2.element("persistence-unit-metadata");
        if (element3 != null) {
            if (this.globalDefaults == null) {
                this.globalDefaults = new Default();
                this.globalDefaults.setMetadataComplete(element3.element("xml-mapping-metadata-complete") != null ? Boolean.TRUE : null);
                object = element3.element("persistence-unit-defaults");
                if (object != null) {
                    element = object.element("schema");
                    this.globalDefaults.setSchema(element != null ? element.getTextTrim() : null);
                    element = object.element("catalog");
                    this.globalDefaults.setCatalog(element != null ? element.getTextTrim() : null);
                    element = object.element("access");
                    this.setAccess(element, this.globalDefaults);
                    element = object.element("cascade-persist");
                    this.globalDefaults.setCascadePersist(element != null ? Boolean.TRUE : null);
                    element = object.element("delimited-identifiers");
                    this.globalDefaults.setDelimitedIdentifiers(element != null ? Boolean.TRUE : null);
                    this.defaultEntityListeners.addAll(this.addEntityListenerClasses((Element)object, null, arrayList));
                }
            } else {
                this.log.warn("Found more than one <persistence-unit-metadata>, subsequent ignored");
            }
        }
        object = new Default();
        element = element2.element("package");
        String string = element != null ? element.getTextTrim() : null;
        ((Default)object).setPackageName(string);
        element = element2.element("schema");
        ((Default)object).setSchema(element != null ? element.getTextTrim() : null);
        element = element2.element("catalog");
        ((Default)object).setCatalog(element != null ? element.getTextTrim() : null);
        element = element2.element("access");
        this.setAccess(element, (Default)object);
        this.defaultElements.add(element2);
        List list = element2.elements("entity");
        this.addClass(list, string, (Default)object, arrayList);
        list = element2.elements("mapped-superclass");
        this.addClass(list, string, (Default)object, arrayList);
        list = element2.elements("embeddable");
        this.addClass(list, string, (Default)object, arrayList);
        return arrayList;
    }

    private void setAccess(Element element, Default default_) {
        if (element != null) {
            String string = element.getTextTrim();
            this.setAccess(string, default_);
        }
    }

    private void setAccess(String string, Default default_) {
        if (string != null) {
            AccessType accessType;
            try {
                accessType = AccessType.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new AnnotationException("Invalid access type " + string + " (check your xml configuration)");
            }
            default_.setAccess(accessType);
        }
    }

    private void addClass(List<Element> list, String string, Default default_, List<String> list2) {
        for (Element element : list) {
            String string2 = XMLContext.buildSafeClassName(element.attributeValue("class"), string);
            if (this.classOverriding.containsKey(string2)) {
                throw new IllegalStateException("Duplicate XML entry for " + string2);
            }
            list2.add(string2);
            this.classOverriding.put(string2, element);
            Default default_2 = new Default();
            default_2.override(default_);
            String string3 = element.attributeValue("metadata-complete");
            if (string3 != null) {
                default_2.setMetadataComplete(Boolean.parseBoolean(string3));
            }
            String string4 = element.attributeValue("access");
            this.setAccess(string4, default_2);
            this.defaultsOverriding.put(string2, default_2);
            this.log.debug("Adding XML overriding information for {}", (Object)string2);
            this.addEntityListenerClasses(element, string, list2);
        }
    }

    private List<String> addEntityListenerClasses(Element element, String string, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Element element2 = element.element("entity-listeners");
        if (element2 != null) {
            List list2 = element2.elements("entity-listener");
            for (Element element3 : list2) {
                String string2 = XMLContext.buildSafeClassName(element3.attributeValue("class"), string);
                if (this.classOverriding.containsKey(string2)) {
                    if ("entity-listener".equals(this.classOverriding.get(string2).getName())) {
                        this.log.info("entity-listener duplication, first event definition will be used: {}", (Object)string2);
                        continue;
                    }
                    throw new IllegalStateException("Duplicate XML entry for " + string2);
                }
                arrayList.add(string2);
                this.classOverriding.put(string2, element3);
            }
        }
        this.log.debug("Adding XML overriding information for listener: {}", arrayList);
        list.addAll(arrayList);
        return arrayList;
    }

    public static String buildSafeClassName(String string, String string2) {
        if (string.indexOf(46) < 0 && StringHelper.isNotEmpty(string2)) {
            string = StringHelper.qualify(string2, string);
        }
        return string;
    }

    public static String buildSafeClassName(String string, Default default_) {
        return XMLContext.buildSafeClassName(string, default_.getPackageName());
    }

    public Default getDefault(String string) {
        Default default_ = new Default();
        default_.override(this.globalDefaults);
        if (string != null) {
            Default default_2 = this.defaultsOverriding.get(string);
            default_.override(default_2);
        }
        return default_;
    }

    public Element getXMLTree(String string) {
        return this.classOverriding.get(string);
    }

    public List<Element> getAllDocuments() {
        return this.defaultElements;
    }

    public boolean hasContext() {
        return this.hasContext;
    }

    public List<String> getDefaultEntityListeners() {
        return this.defaultEntityListeners;
    }

    public static class Default
    implements Serializable {
        private AccessType access;
        private String packageName;
        private String schema;
        private String catalog;
        private Boolean metadataComplete;
        private Boolean cascadePersist;
        private Boolean delimitedIdentifier;

        public AccessType getAccess() {
            return this.access;
        }

        protected void setAccess(AccessType accessType) {
            this.access = accessType;
        }

        public String getCatalog() {
            return this.catalog;
        }

        protected void setCatalog(String string) {
            this.catalog = string;
        }

        public String getPackageName() {
            return this.packageName;
        }

        protected void setPackageName(String string) {
            this.packageName = string;
        }

        public String getSchema() {
            return this.schema;
        }

        protected void setSchema(String string) {
            this.schema = string;
        }

        public Boolean getMetadataComplete() {
            return this.metadataComplete;
        }

        public boolean canUseJavaAnnotations() {
            return this.metadataComplete == null || this.metadataComplete == false;
        }

        protected void setMetadataComplete(Boolean bl) {
            this.metadataComplete = bl;
        }

        public Boolean getCascadePersist() {
            return this.cascadePersist;
        }

        void setCascadePersist(Boolean bl) {
            this.cascadePersist = bl;
        }

        public void override(Default default_) {
            if (default_ != null) {
                if (default_.getAccess() != null) {
                    this.access = default_.getAccess();
                }
                if (default_.getPackageName() != null) {
                    this.packageName = default_.getPackageName();
                }
                if (default_.getSchema() != null) {
                    this.schema = default_.getSchema();
                }
                if (default_.getCatalog() != null) {
                    this.catalog = default_.getCatalog();
                }
                if (default_.getDelimitedIdentifier() != null) {
                    this.delimitedIdentifier = default_.getDelimitedIdentifier();
                }
                if (default_.getMetadataComplete() != null) {
                    this.metadataComplete = default_.getMetadataComplete();
                }
                if (default_.getCascadePersist() != null) {
                    this.cascadePersist = default_.getCascadePersist();
                }
            }
        }

        public void setDelimitedIdentifiers(Boolean bl) {
            this.delimitedIdentifier = bl;
        }

        public Boolean getDelimitedIdentifier() {
            return this.delimitedIdentifier;
        }
    }
}

