/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.beanvalidation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.event.EventListeners;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidationActivator {
    private static final String BV_DISCOVERY_CLASS = "javax.validation.Validation";
    private static final String TYPE_SAFE_ACTIVATOR_CLASS = "org.hibernate.cfg.beanvalidation.TypeSafeActivator";
    private static final String TYPE_SAFE_DDL_METHOD = "applyDDL";
    private static final String TYPE_SAFE_ACTIVATOR_METHOD = "activateBeanValidation";
    private static final String MODE_PROPERTY = "javax.persistence.validation.mode";

    public static void activateBeanValidation(EventListeners eventListeners, Properties properties) {
        Set<ValidationMode> set;
        block10: {
            set = ValidationMode.getModes(properties.get(MODE_PROPERTY));
            try {
                ReflectHelper.classForName(BV_DISCOVERY_CLASS, BeanValidationActivator.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (set.contains((Object)ValidationMode.CALLBACK)) {
                    throw new HibernateException("Bean Validation not available in the class path but required in javax.persistence.validation.mode");
                }
                if (!set.contains((Object)ValidationMode.AUTO)) break block10;
                return;
            }
        }
        if (properties.getProperty("hibernate.check_nullability") == null) {
            properties.setProperty("hibernate.check_nullability", "false");
        }
        if (!set.contains((Object)ValidationMode.CALLBACK) && !set.contains((Object)ValidationMode.AUTO)) {
            return;
        }
        try {
            Class clazz = ReflectHelper.classForName(TYPE_SAFE_ACTIVATOR_CLASS, BeanValidationActivator.class);
            Method method = clazz.getMethod(TYPE_SAFE_ACTIVATOR_METHOD, EventListeners.class, Properties.class);
            method.invoke(null, eventListeners, properties);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new HibernateException("Unable to get the default Bean Validation factory", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new HibernateException("Unable to get the default Bean Validation factory", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new HibernateException("Unable to get the default Bean Validation factory", invocationTargetException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HibernateException("Unable to get the default Bean Validation factory", classNotFoundException);
        }
    }

    public static void applyDDL(Collection<PersistentClass> collection, Properties properties) {
        block9: {
            Set<ValidationMode> set = ValidationMode.getModes(properties.get(MODE_PROPERTY));
            if (!set.contains((Object)ValidationMode.DDL) && !set.contains((Object)ValidationMode.AUTO)) {
                return;
            }
            try {
                ReflectHelper.classForName(BV_DISCOVERY_CLASS, BeanValidationActivator.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (set.contains((Object)ValidationMode.DDL)) {
                    throw new HibernateException("Bean Validation not available in the class path but required in javax.persistence.validation.mode");
                }
                if (!set.contains((Object)ValidationMode.AUTO)) break block9;
                return;
            }
        }
        try {
            Class clazz = ReflectHelper.classForName(TYPE_SAFE_ACTIVATOR_CLASS, BeanValidationActivator.class);
            Method method = clazz.getMethod(TYPE_SAFE_DDL_METHOD, Collection.class, Properties.class);
            method.invoke(null, collection, properties);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new HibernateException("Unable to get the default Bean Validation factory", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new HibernateException("Unable to get the default Bean Validation factory", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new HibernateException("Unable to get the default Bean Validation factory", invocationTargetException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HibernateException("Unable to get the default Bean Validation factory", classNotFoundException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ValidationMode {
        AUTO,
        CALLBACK,
        NONE,
        DDL;


        public static Set<ValidationMode> getModes(Object object) {
            Object object2;
            HashSet<ValidationMode> hashSet = new HashSet<ValidationMode>(3);
            if (object == null) {
                hashSet.add(AUTO);
            } else {
                for (String string : object2 = object.toString().split(",")) {
                    hashSet.add(ValidationMode.getMode(string));
                }
            }
            if (hashSet.size() > 1 && (hashSet.contains((Object)AUTO) || hashSet.contains((Object)NONE))) {
                object2 = new StringBuilder("Incompatible validation modes mixed: ");
                for (ValidationMode validationMode : hashSet) {
                    ((StringBuilder)object2).append((Object)validationMode).append(", ");
                }
                throw new HibernateException(((StringBuilder)object2).substring(0, ((StringBuilder)object2).length() - 2));
            }
            return hashSet;
        }

        private static ValidationMode getMode(String string) {
            if (string == null || string.length() == 0) {
                return AUTO;
            }
            try {
                return ValidationMode.valueOf(string.trim().toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new HibernateException("Unknown validation mode in javax.persistence.validation.mode: " + string.toString());
            }
        }
    }
}

