/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.beanvalidation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.validation.groups.Default;
import org.hibernate.HibernateException;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupsPerOperation {
    private static final String JPA_GROUP_PREFIX = "javax.persistence.validation.group.";
    private static final String HIBERNATE_GROUP_PREFIX = "org.hibernate.validator.group.";
    private static final Class<?>[] DEFAULT_GROUPS = new Class[]{Default.class};
    private static final Class<?>[] EMPTY_GROUPS = new Class[0];
    private Map<Operation, Class<?>[]> groupsPerOperation = new HashMap<Operation, Class<?>[]>(4);

    public GroupsPerOperation(Properties properties) {
        this.setGroupsForOperation(Operation.INSERT, properties);
        this.setGroupsForOperation(Operation.UPDATE, properties);
        this.setGroupsForOperation(Operation.DELETE, properties);
        this.setGroupsForOperation(Operation.DDL, properties);
    }

    private void setGroupsForOperation(Operation operation, Properties properties) {
        Class<?>[] classArray;
        Object object = properties.get(operation.getGroupPropertyName());
        if (object == null) {
            classArray = operation == Operation.DELETE ? EMPTY_GROUPS : DEFAULT_GROUPS;
        } else if (object instanceof String) {
            String string = (String)object;
            String[] stringArray = string.split(",");
            if (stringArray.length == 1 && stringArray[0].equals("")) {
                classArray = EMPTY_GROUPS;
            } else {
                ArrayList<Class> arrayList = new ArrayList<Class>(stringArray.length);
                for (String string2 : stringArray) {
                    String string3 = string2.trim();
                    if (string3.length() <= 0) continue;
                    try {
                        arrayList.add(ReflectHelper.classForName(string3));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new HibernateException("Unable to load class " + string3, classNotFoundException);
                    }
                }
                classArray = arrayList.toArray(new Class[arrayList.size()]);
            }
        } else if (object instanceof Class[]) {
            classArray = (Class[])object;
        } else {
            throw new HibernateException(JPA_GROUP_PREFIX + operation.getGroupPropertyName() + " is of unknown type: String or Class<?>[] only");
        }
        this.groupsPerOperation.put(operation, classArray);
    }

    public Class<?>[] get(Operation operation) {
        return this.groupsPerOperation.get((Object)operation);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        INSERT("persist", "javax.persistence.validation.group.pre-persist"),
        UPDATE("update", "javax.persistence.validation.group.pre-update"),
        DELETE("remove", "javax.persistence.validation.group.pre-remove"),
        DDL("ddl", "org.hibernate.validator.group.ddl");

        private String exposedName;
        private String groupPropertyName;

        private Operation(String string2, String string3) {
            this.exposedName = string2;
            this.groupPropertyName = string3;
        }

        public String getName() {
            return this.exposedName;
        }

        public String getGroupPropertyName() {
            return this.groupPropertyName;
        }
    }
}

